package com.yeejoin.amos.api.openapi.enums;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@Getter
public enum CylinderTypeFieldValidation {
    // 车用气瓶（CNG/LNG/氢气）特殊要求
    carNumber(CylinderType.VEHICLE_CNG_LNG_H2, "carNumber", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "车牌号码"),
    isCylinderGasConsistent(CylinderType.VEHICLE_CNG_LNG_H2, "isCylinderGasConsistent", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "充装气体与气瓶允许充装气体一致"),
    fillingMedium(CylinderType.VEHICLE_CNG_LNG_H2, "fillingMedium", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "充装介质"),
    hasSevereExternalDamage(CylinderType.VEHICLE_CNG_LNG_H2, "hasSevereExternalDamage", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面有划伤、裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷"),
    hasResidualPressure(CylinderType.VEHICLE_CNG_LNG_H2, "hasResidualPressure", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶内有剩余压力"),
    isGasLeak(CylinderType.VEHICLE_CNG_LNG_H2, "isGasLeak", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "无气体泄漏"),
    areAccessoriesCompleteAndSafe(CylinderType.VEHICLE_CNG_LNG_H2, "areAccessoriesCompleteAndSafe", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶附件齐全并符合安全要求"),

    fillingAmount(CylinderType.VEHICLE_CNG_LNG_H2, "fillingAmount", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装量"),
    pressure(CylinderType.VEHICLE_CNG_LNG_H2, "pressure", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "压力"),
    ambientTemperature(CylinderType.VEHICLE_CNG_LNG_H2, "ambientTemperature", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "室温"),
    isNoAbnormalTemperatureRise(CylinderType.VEHICLE_CNG_LNG_H2, "isNoAbnormalTemperatureRise", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "瓶体温度无异常升高"),
    abnormalConditions(CylinderType.VEHICLE_CNG_LNG_H2, "abnormalConditions", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "异常情况"),

    isNoBulgingOrLeakage(CylinderType.VEHICLE_CNG_LNG_H2, "isNoBulgingOrLeakage", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶体未出现鼓包变形或泄漏等严重缺陷"),
    isPressureNormal(CylinderType.VEHICLE_CNG_LNG_H2, "isPressureNormal", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶内压力正常"),
    isTemperatureNormal(CylinderType.VEHICLE_CNG_LNG_H2, "isTemperatureNormal", false, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "温度正常"),


    // 液化石油气瓶
    excludeOverdueRefurbishedScrappedCylinders(CylinderType.LIQUEFIED_GAS_LPG, "excludeOverdueRefurbishedScrappedCylinders", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "排除超期未检气瓶、非法改装或翻新及报废气瓶"),
    isWarningLabelGasNameConsistentWithStamp(CylinderType.LIQUEFIED_GAS_LPG, "isWarningLabelGasNameConsistentWithStamp", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致"),
    isColorMarkingCompliant(CylinderType.LIQUEFIED_GAS_LPG, "isColorMarkingCompliant", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面的颜色标志是否符合规定"),
    valveCompliesGB7512(CylinderType.LIQUEFIED_GAS_LPG, "valveCompliesGB7512", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶阀符合GB7512规定"),
    hasResidualPressure2(CylinderType.LIQUEFIED_GAS_LPG, "hasResidualPressure", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶内有剩余压力"),
    hasNoSevereExternalDamage(CylinderType.LIQUEFIED_GAS_LPG, "hasNoSevereExternalDamage", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷"),
    areAccessoriesCompleteAndSafe2(CylinderType.LIQUEFIED_GAS_LPG, "areAccessoriesCompleteAndSafe", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶附件齐全并符合安全要求"),
    isNewOrInspectedOk(CylinderType.LIQUEFIED_GAS_LPG, "isNewOrInspectedOk", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "新投入使用气瓶或经检验后首次投入使用气瓶，充装前按照规定先置换瓶内空气，并经分析合格后方可充气"),

    fillingAmount2(CylinderType.LIQUEFIED_GAS_LPG, "fillingAmount", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装量"),
    abnormalConditions2(CylinderType.LIQUEFIED_GAS_LPG, "abnormalConditions", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "异常情况"),

    valveSealIsGood(CylinderType.LIQUEFIED_GAS_LPG, "valveSealIsGood", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶阀及其与瓶口连接的密封良好"),
    isNoBulgingOrLeakage2(CylinderType.LIQUEFIED_GAS_LPG, "isNoBulgingOrLeakage", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶体未出现鼓包变形或泄漏等严重缺陷"),
    isTemperatureNormal2(CylinderType.LIQUEFIED_GAS_LPG, "isTemperatureNormal", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶体温度没有异常升高的迹象"),
    hasWarningAndFillingLabels(CylinderType.LIQUEFIED_GAS_LPG, "hasWarningAndFillingLabels", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "气瓶粘贴警示标签和充装标签)"),
    reweighedWithinLimit(CylinderType.LIQUEFIED_GAS_LPG, "hasWarningAndFillingLabels", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "充装量复秤未超重"),


    // 压缩气体气瓶 COMPRESSED_GAS
    isFillingMediumConsistentWithStamp(CylinderType.COMPRESSED_GAS, "isFillingMediumConsistentWithStamp", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "充装介质与气瓶钢印标志气体名称是否一致"),
    outletThreadTypeCompliesGB15383(CylinderType.COMPRESSED_GAS, "outletThreadTypeCompliesGB15383", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶瓶阀的出气口螺纹型式是符合GB/T15383的规定"),
    isNewOrInspectedOk3(CylinderType.COMPRESSED_GAS, "isNewOrInspectedOk", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "新投入使用气瓶或经检验后首次投入使用气瓶，充装前按照规定先抽真空或置换瓶内空气"),
    isVacuumProcessed(CylinderType.COMPRESSED_GAS, "isVacuumProcessed", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "充装可燃、氧化性气体，如无余压保持阀，重复充装前应先进行抽真空处理"),
    hasNoSevereCorrosion(CylinderType.COMPRESSED_GAS, "hasNoSevereCorrosion", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面无严重腐蚀"),
    hasNoSurfaceDefects(CylinderType.COMPRESSED_GAS, "hasNoSurfaceDefects", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面无损伤缺陷"),
    hasResidualPressure3(CylinderType.COMPRESSED_GAS, "hasResidualPressure", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶内有剩余压力"),
    isWarningLabelGasNameConsistentWithStamp3(CylinderType.COMPRESSED_GAS, "isWarningLabelGasNameConsistentWithStamp", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "警示标签上的气体名称与气瓶钢印标志一致"),
    colorMeetsGB7144(CylinderType.COMPRESSED_GAS, "colorMeetsGB7144", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面的颜色标志符合GB/T 7144的规定、且清晰易认"),
    hasNoCracks(CylinderType.COMPRESSED_GAS, "hasNoCracks", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面无裂纹"),
    hasNoObviousDeformation(CylinderType.COMPRESSED_GAS, "hasNoObviousDeformation", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面无明显变形"),
    noOilOrFlammableSubstances(CylinderType.COMPRESSED_GAS, "noOilOrFlammableSubstances", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶体、瓶阀无沾染油脂或其他可燃物"),
    areAccessoriesCompleteAndSafe3(CylinderType.COMPRESSED_GAS, "areAccessoriesCompleteAndSafe", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶附件齐全并符合安全要求"),

    fillingPressure(CylinderType.COMPRESSED_GAS, "fillingPressure", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装压力"),
    ambientTemperature3(CylinderType.COMPRESSED_GAS, "ambientTemperature", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "室温"),
    temperatureConsistent(CylinderType.COMPRESSED_GAS, "temperatureConsistent", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "瓶体温度一致"),
    noAbnormalSoundInside(CylinderType.COMPRESSED_GAS, "noAbnormalSoundInside", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "瓶内无异常音响"),
    valveSealedWell(CylinderType.COMPRESSED_GAS, "valveSealedWell", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "瓶阀及各连接部位的密封良好"),
    abnormalConditions3(CylinderType.COMPRESSED_GAS, "abnormalConditions", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "异常情况"),

    pressureAndMassMeetRegulations(CylinderType.COMPRESSED_GAS, "pressureAndMassMeetRegulations", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶内压力(充装量)及质量符合安全技术规范及相关标准的要求"),
    isNoBulgingOrLeakage3(CylinderType.COMPRESSED_GAS, "isNoBulgingOrLeakage", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "未出现鼓包变形或泄漏等严重缺陷"),
    capsAndLabelsAreIntact(CylinderType.COMPRESSED_GAS, "capsAndLabelsAreIntact", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶帽、充装标签、警示标签完整"),
    valveSealedWell2(CylinderType.COMPRESSED_GAS, "valveSealedWell", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶阀出气口螺纹及其密封面良好"),
    isTemperatureNormal3(CylinderType.COMPRESSED_GAS, "isTemperatureNormal", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶体的温度无异常升高的迹象"),


    // 溶解乙炔气瓶 DISSOLVED_ACETYLENE
    meetsGB13076AndMechanicalDamage(CylinderType.DISSOLVED_ACETYLENE, "meetsGB13076AndMechanicalDamage", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶体无腐蚀、机械损伤等表面缺陷、是否满足GB13076 标准报废"),
    fusiblePlugUndamaged(CylinderType.DISSOLVED_ACETYLENE, "fusiblePlugUndamaged", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "易熔合金无融熔、流失、损伤的"),
    colorMeetsGB71444(CylinderType.DISSOLVED_ACETYLENE, "colorMeetsGB7144", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "颜色标记符合GB7144规定或不存在表面漆色脱落严重的"),
    stampMarkingsClearAndComplete(CylinderType.DISSOLVED_ACETYLENE, "stampMarkingsClearAndComplete", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "钢印标记完整且能够识别"),
    accessoriesCompleteAndConforming(CylinderType.DISSOLVED_ACETYLENE, "accessoriesCompleteAndConforming", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "附件完整且符合规定"),
    noCarbonBlackOrTarAtValvePort(CylinderType.DISSOLVED_ACETYLENE, "noCarbonBlackOrTarAtValvePort", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶阀侧接嘴处积无炭黑或焦油等异物"),
    fillerAndSolventQualityOK(CylinderType.DISSOLVED_ACETYLENE, "fillerAndSolventQualityOK", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶内的填料、溶剂的质量没有问题"),
    noOtherSafetyAffectingDefects(CylinderType.DISSOLVED_ACETYLENE, "noOtherSafetyAffectingDefects", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "无其他影响安全使用缺陷的"),
    fillingRoomTemperature(CylinderType.DISSOLVED_ACETYLENE, "fillingRoomTemperature", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "充装间温度"),
    residualPressure(CylinderType.DISSOLVED_ACETYLENE, "residualPressure", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "剩余压力"),
    acetoneSupplementAmount(CylinderType.DISSOLVED_ACETYLENE, "acetoneSupplementAmount", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "丙酮补加量"),

    fillingPressureLessThan(CylinderType.DISSOLVED_ACETYLENE, "fillingPressureLessThan", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装压力≤2.5 MPa"),
    acetyleneFillingAmount(CylinderType.DISSOLVED_ACETYLENE, "acetyleneFillingAmount", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "乙炔充装量"),

    pressureAfterRestingComplies(CylinderType.DISSOLVED_ACETYLENE, "pressureAfterRestingComplies", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "静置后压力符合规定"),
    noLeakageIssuesDetected(CylinderType.DISSOLVED_ACETYLENE, "noLeakageIssuesDetected", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "气瓶未发生泄漏等问题"),
    isTreatmentResultQualified(CylinderType.DISSOLVED_ACETYLENE, "isTreatmentResultQualified", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "处理结果是否合格"),

    // 混合气体气瓶 MIXED_GAS
    isStampAndLabelConsistentWithMedium(CylinderType.MIXED_GAS, "isStampAndLabelConsistentWithMedium", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "钢印、警示标签与待充介质名称一致"),
    externalColorMarkingCompliant(CylinderType.MIXED_GAS, "externalColorMarkingCompliant", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "外表面颜色标志符合规定"),
    valveOutletThreadComplies(CylinderType.MIXED_GAS, "valveOutletThreadComplies", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶阀出气口螺纹符合要求"),
    hasNoSevereSurfaceDefects(CylinderType.MIXED_GAS, "hasNoSevereSurfaceDefects", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "外表面无严重损伤缺陷"),
    cylinderAccessoriesMeetRequirements(CylinderType.MIXED_GAS, "cylinderAccessoriesMeetRequirements", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶附件符合要求"),
    oxidizingGasCylinderFreeOfOil(CylinderType.MIXED_GAS, "oxidizingGasCylinderFreeOfOil", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "氧化性混合气体的瓶体、瓶阀未沾染油脂"),
    preTreatedSuccessfully(CylinderType.MIXED_GAS, "preTreatedSuccessfully", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶经预处理（抽真空、烘干、置换或组合）合格"),

    fillingPressure5(CylinderType.MIXED_GAS, "fillingPressureLessThan", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装压力"),
    fillingAmount5(CylinderType.MIXED_GAS, "fillingAmount", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装量"),
    componentContents(CylinderType.MIXED_GAS, "componentContents", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "各组分含量"),
    abnormalConditions5(CylinderType.MIXED_GAS, "abnormalConditions", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "异常情况"),

    fillingAmountMeetsRequirement(CylinderType.MIXED_GAS, "fillingAmountMeetsRequirement", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "充装量（压力或质量）符合要求"),
    sealsIntactNoLeakage(CylinderType.MIXED_GAS, "sealsIntactNoLeakage", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "密封良好无泄漏"),
    noDeformationOrDefects(CylinderType.MIXED_GAS, "noDeformationOrDefects", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "气瓶无变形等缺陷"),
    temperatureRiseNormal(CylinderType.MIXED_GAS, "temperatureRiseNormal", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶体温升无异常"),
    cylinderAccessoriesComplete(CylinderType.MIXED_GAS, "cylinderAccessoriesComplete", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "气瓶附件完整齐全"),


    // 低温气体气瓶 CRYOGENIC_INSULATED
    isStampAndLabelConsistentWithMedium6(CylinderType.CRYOGENIC_INSULATED, "isStampAndLabelConsistentWithMedium", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "钢印、警示标签与待充介质名称一致"),
    surfaceFreeOfOilAndDamage(CylinderType.CRYOGENIC_INSULATED, "surfaceFreeOfOilAndDamage", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶表面无油污、无严重损伤"),
    valveInGoodConditionCleanConnection(CylinderType.CRYOGENIC_INSULATED, "valveInGoodConditionCleanConnection", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶阀完好、接头洁净无水或冰"),
    emptyPressureCylinderPurgedWithCleanGas(CylinderType.CRYOGENIC_INSULATED, "emptyPressureCylinderPurgedWithCleanGas", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "无余压的瓶用洁净的待充气体吹扫（易燃的先用液氮置换）"),

    tareWeightNominal(CylinderType.CRYOGENIC_INSULATED, "tareWeightNominal", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "标称皮重"),
    filledWeight(CylinderType.CRYOGENIC_INSULATED, "filledWeight", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装后质量"),
    actualFillingAmount(CylinderType.CRYOGENIC_INSULATED, "actualFillingAmount", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "实际充装量"),
    abnormalConditions6(CylinderType.CRYOGENIC_INSULATED, "abnormalConditions", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "异常情况"),

    reweighedWithinLimit6(CylinderType.CRYOGENIC_INSULATED, "reweighedWithinLimit", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "复秤未超重"),
    valveClosedNoLeakageInPipingAndAccessories(CylinderType.CRYOGENIC_INSULATED, "valveClosedNoLeakageInPipingAndAccessories", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "阀门已关闭,管路及各附件无漏气"),
    noFrostOrCondensationOnCylinder(CylinderType.CRYOGENIC_INSULATED, "noFrostOrCondensationOnCylinder", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "气瓶外观无结霜、结露"),


    // 液化气体（LPG除外）气瓶 LIQUEFIED_GAS_EXCLUDING_LPG
    isStampAndLabelConsistentWithMedium7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "isStampAndLabelConsistentWithMedium", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "钢印、警示标签与待充介质名称一致"),
    externalColorMarkingCompliant7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "externalColorMarkingCompliant", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面颜色标志符合规定"),
    valveOutletInternalThreadLeftHanded(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "valveOutletInternalThreadLeftHanded", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "瓶阀出气口为内螺纹(左旋) "),
    qualitativeTestPassedForResidualGas(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "qualitativeTestPassedForResidualGas", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "有余压的经定性鉴别且与待充介质一致"),
    internalValveInspectionPassed(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "internalValveInspectionPassed", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "无余压的经卸阀内检合格"),
    hasNoSevereSurfaceDefects7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "hasNoSevereSurfaceDefects", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶外表面无严重损伤缺陷"),
    safetyAccessoriesCompleteAndSafe(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "safetyAccessoriesCompleteAndSafe", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "气瓶安全附件齐全并符合安全要求"),
    newCylinderAirReplacedBeforeFirstUse(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "newCylinderAirReplacedBeforeFirstUse", true, false, new String[]{CylinderField.FillStage.BEFORE.getCode()}, "首充气瓶已置换瓶内空气"),

    tareWeightIncludingResidualGas(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "tareWeightIncludingResidualGas", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "含余气皮重"),
    filledWeight7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "filledWeight", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "充装后质量"),
    actualFillingAmount7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "actualFillingAmount", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "实际充装量"),
    abnormalConditions7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "abnormalConditions", true, false, new String[]{CylinderField.FillStage.FILLING.getCode()}, "异常情况"),

    reweighedWithinLimit7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "reweighedWithinLimit", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "复秤未超重"),
    sealsIntactNoLeakage7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "sealsIntactNoLeakage", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "密封良好无泄漏"),
    noDeformationOrDefects7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "noDeformationOrDefects", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "气瓶无变形等缺陷"),
    temperatureRiseNormal7(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, "temperatureRiseNormal", true, false, new String[]{CylinderField.FillStage.AFTER.getCode()}, "瓶体温升无异常"),

    ;

    private final CylinderType cylinderType;
    private final String fieldName;
    private final boolean required;
    private final boolean unique;

    // 阶段（充装前、中、后）
    private final String[] stage;

    // 描述
    private final String desc;


    CylinderTypeFieldValidation(CylinderType cylinderType, String fieldName, boolean required, boolean unique, String[] stage, String desc) {
        this.cylinderType = cylinderType;
        this.fieldName = fieldName;
        this.required = required;
        this.unique = unique;
        this.stage = stage;
        this.desc = desc;
    }

    /**
     * 获取指定气瓶类型的所有必填字段
     * @param type 气瓶类型
     * @return 必填字段列表
     */
    public static List<String> getRequiredFieldsForType(CylinderType type, String stage) {
        // 先获取通用必填字段
        List<String> requiredFields = CylinderField.getRequiredFields(stage);

        // 再添加特定类型必填字段
        requiredFields.addAll(Arrays.stream(values())
                .filter(validation -> validation.cylinderType == type)
                .filter(validation -> Arrays.asList(validation.stage).contains(stage))
                .filter(CylinderTypeFieldValidation::isRequired)
                .map(CylinderTypeFieldValidation::getFieldName)
                .collect(Collectors.toList()));

        return requiredFields;
    }

    /**
     * 获取指定气瓶类型的所有唯一字段
     * @param type 气瓶类型
     * @return 唯一字段列表
     */
    public static List<String> getUniqueFieldsForType(CylinderType type, String stage) {
        // 先获取通用唯一字段
        List<String> uniqueFields = CylinderField.getUniqueFields();

        // 再添加特定类型唯一字段
        uniqueFields.addAll(Arrays.stream(values())
                .filter(validation -> validation.cylinderType == type)
                .filter(validation -> Arrays.asList(validation.stage).contains(stage))
                .filter(CylinderTypeFieldValidation::isUnique)
                .map(CylinderTypeFieldValidation::getFieldName)
                .collect(Collectors.toList()));

        return uniqueFields;
    }
    
    public static void main(String[] args) {
        System.out.println(getRequiredFieldsForType(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, CylinderField.FillStage.FILLING.getCode()));
        System.out.println(getUniqueFieldsForType(CylinderType.LIQUEFIED_GAS_EXCLUDING_LPG, CylinderField.FillStage.FILLING.getCode()));
    }
}
