package com.yeejoin.amos.boot.module.common.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum UnitTypeNewEnum {

    /**
     * *注册单位类型
     */

    sydw("企业","使用单位", "1232", "use"),
    czdw("充装单位", "充装单位", "1231", "license"),
    jyjg("检验机构", "检验机构","1233-1", "license"),
    jcjg("检测机构", "检测机构", "1233-2", "license"),
    azgzwxdw("安装改造维修单位", "安装改造维修单位","1234", "license"),
    zzdw("制造单位", "制造单位", "1236", "license"),
    sjdw("设计单位", "设计单位", "1235", "license"),
    grzt("个人主体", "个人主体", "6599", "use");

    private String label;
    private String value;
    private String code;
    private String type;

    public static Map<String, String> getValue = new HashMap<>();
    public static Map<String, String> getCode = new HashMap<>();


    static {
        for (UnitTypeNewEnum e : UnitTypeNewEnum.values()) {
            getValue.put(e.code, e.value);
            getCode.put(e.value, e.code);
        }
    }

    public static JSONArray getAll() {
        JSONArray jsonArray = new JSONArray();
        for (UnitTypeNewEnum e : UnitTypeNewEnum.values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", e.label);
            jsonObject.put("value", e.value);
            jsonObject.put("key", e.code);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static JSONArray getUnitTypeByType(String category) {
        if (ObjectUtils.isEmpty(category) || category.equals("all")) {
            return getAll();
        }
        JSONArray jsonArray = new JSONArray();
        for (UnitTypeNewEnum e : UnitTypeNewEnum.values()) {
            if (e.type.equals(category)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("label", e.label);
                jsonObject.put("value", e.value);
                jsonObject.put("key", e.code);
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }

    public static JSONArray getUnitTypeByLabel(String label) {
        JSONArray jsonArray = new JSONArray();
        for (UnitTypeNewEnum e : UnitTypeNewEnum.values()) {
            if (e.label.equals(label)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("label", e.label);
                jsonObject.put("value", e.value);
                jsonObject.put("key", e.code);
                jsonArray.add(jsonObject);
                return jsonArray;
            }
        }
        return jsonArray;
    }
}