package com.yeejoin.amos.boot.module.ymt.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


@AllArgsConstructor
@Getter
public enum ImageSizeEnums {

    /**
     * 导出监管码、96333码尺寸
     */
    // 监管码-大
    JG_BIG("JG_BIG", "bigBg.png", 368, 362, 70, 705, 178, 0, 0, 720, 680),
    // 监管码-中
    JG_MID("JG_MID", "centreBg.png", 263, 267, 50, 460, 133, 0, 0, 480, 518),
    // 监管码-小
    JG_MIN("JG_MIN", "smallBg.png", 197, 200, 35, 350, 85, 0, 0, 365, 350),
    // 96333电梯码
    DT("DT", "dt.png", 170, 170, 40, 25, 105, 0, 0, 260, 350);

    String code;
    String bgPath;
    Integer with;
    Integer height;
    Integer size;
    Integer imagesX;
    Integer imagesY;
    Integer text1X;
    Integer text1Y;
    Integer text2X;
    Integer text2Y;


    public static ImageSizeEnums getEnumByCode(String code) {
        for (ImageSizeEnums value : ImageSizeEnums.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

}
