package com.yeejoin.amos.patrol.business.bo;

import lombok.Data;


/**
 * The persistent class for the p_plan_task database table.
 */
@Data
public class PlanTaskSyncBo extends BasicEntityBo {

    /**
     * 批次号(该字段暂时无效，取值为表id)
     */
    private long batchNo;

    /**
     * 开始时间
     */
    private String beginTime;
    /**
     * 巡检日期
     */
    private String checkDate;

    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 已完成数量
     */
    private int finishNum;
    /**
     * 完成状态：0-尚未开始；1-正在进行;2-已经结束；3-超时漏检；4-已完成
     */
    private int finishStatus;
    /**
     * 公司Id
     */
    private String orgCode;
    /**
     * 计划编号
     */
    private long planId;
    /**
     * 计划巡检点数
     */
    private int pointNum;

    /**
     * 路线编号
     */
    private long routeId;
    /**
     * 状态：0-有效；1-无效
     */
    private int status;

    /**
     * 可执行人，一个或多个，多个用,隔开
     */
    private String userId;


    /**
     * 是否按排序0-否；1-是
     */
    private String inOrder;

    /**
     * 用户部门
     */
    private String userDept;

    /**
     * 用户姓名
     */
    private String userName;

}