package com.yeejoin.precontrol.common.service.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.boot.module.common.api.dto.CreatExamDto;
import com.yeejoin.amos.boot.module.common.api.feign.AmosTrainingFeignClient;
import com.yeejoin.amos.boot.module.common.api.feign.KnowledgebaseFeignClient;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.precontrol.common.constant.Constant;
import com.yeejoin.precontrol.common.dto.BadManangerDto;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.FileDto;
import com.yeejoin.precontrol.common.dto.InputItemDto;
import com.yeejoin.precontrol.common.dto.JobDisclosureDto;
import com.yeejoin.precontrol.common.dto.SafeConstructionDto;
import com.yeejoin.precontrol.common.dto.SafeOperationStatisticsDto;
import com.yeejoin.precontrol.common.dto.SingBadManagementDto;
import com.yeejoin.precontrol.common.dto.SingJobDisclosureDto;
import com.yeejoin.precontrol.common.dto.SingTaskPayCheckDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.dto.TaskPageDto;
import com.yeejoin.precontrol.common.dto.TaskPaycheckDto;
import com.yeejoin.precontrol.common.dto.TaskPersonDto;
import com.yeejoin.precontrol.common.dto.feign.CreateIntegralDto;
import com.yeejoin.precontrol.common.entity.BadManagement;
import com.yeejoin.precontrol.common.entity.BadManagementPerson;
import com.yeejoin.precontrol.common.entity.Company;
import com.yeejoin.precontrol.common.entity.Districts;
import com.yeejoin.precontrol.common.entity.HazardousWorkResult;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.entity.PersonCondition;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.entity.Task;
import com.yeejoin.precontrol.common.entity.TaskPaycheck;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskPersonFile;
import com.yeejoin.precontrol.common.entity.TaskRiskControl;
import com.yeejoin.precontrol.common.entity.TaskTechDocument;
import com.yeejoin.precontrol.common.enums.MessageAttributeEnum;
import com.yeejoin.precontrol.common.enums.MessageSubTypeEnum;
import com.yeejoin.precontrol.common.enums.MessageTypeEnum;
import com.yeejoin.precontrol.common.enums.QualifiedStageEnum;
import com.yeejoin.precontrol.common.enums.SmallProQrColorEum;
import com.yeejoin.precontrol.common.enums.StatusEnum;
import com.yeejoin.precontrol.common.enums.TaskPersonFileEnum;
import com.yeejoin.precontrol.common.enums.TaskPersonTypeEnum;
import com.yeejoin.precontrol.common.enums.TaskStatusEnum;
import com.yeejoin.precontrol.common.enums.TaskTypeEnum;
import com.yeejoin.precontrol.common.enums.WeChatMsgTemplateTypeEum;
import com.yeejoin.precontrol.common.enums.WordTemplateTypeEum;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.exception.errorEnum.BaseExceptionEnum;
import com.yeejoin.precontrol.common.feign.IntegralFeign;
import com.yeejoin.precontrol.common.mapper.TaskMapper;
import com.yeejoin.precontrol.common.publish.MessageEventPublish;
import com.yeejoin.precontrol.common.publish.StatusEventPublish;
import com.yeejoin.precontrol.common.publish.TranslateEventPublish;
import com.yeejoin.precontrol.common.service.FileService;
import com.yeejoin.precontrol.common.service.IBadManagementPersonService;
import com.yeejoin.precontrol.common.service.IBadManagementService;
import com.yeejoin.precontrol.common.service.ICompanyService;
import com.yeejoin.precontrol.common.service.IDistrictsService;
import com.yeejoin.precontrol.common.service.IHazardousWorkResultService;
import com.yeejoin.precontrol.common.service.IHazardousWorkService;
import com.yeejoin.precontrol.common.service.IPersonAscriptionService;
import com.yeejoin.precontrol.common.service.IPersonConditionService;
import com.yeejoin.precontrol.common.service.IPersonService;
import com.yeejoin.precontrol.common.service.IProjectService;
import com.yeejoin.precontrol.common.service.IStatisticsService;
import com.yeejoin.precontrol.common.service.ITaskPaycheckService;
import com.yeejoin.precontrol.common.service.ITaskPersonFeedbackService;
import com.yeejoin.precontrol.common.service.ITaskPersonFileService;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
import com.yeejoin.precontrol.common.service.ITaskRiskControlService;
import com.yeejoin.precontrol.common.service.ITaskSalaryConfirmAttachmentService;
import com.yeejoin.precontrol.common.service.ITaskSalaryConfirmService;
import com.yeejoin.precontrol.common.service.ITaskService;
import com.yeejoin.precontrol.common.service.ITaskTechDocumentService;
import com.yeejoin.precontrol.common.service.ITechDocumentAttachmentService;
import com.yeejoin.precontrol.common.service.ITechDocumentAttachmentTemplateService;
import com.yeejoin.precontrol.common.service.ITechDocumentService;
import com.yeejoin.precontrol.common.service.PdfService;
import com.yeejoin.precontrol.common.service.SmallProService;
import com.yeejoin.precontrol.common.utils.DateTools;
import com.yeejoin.precontrol.common.utils.DateUtils;
import com.yeejoin.precontrol.common.utils.FileHelper;
import com.yeejoin.precontrol.common.utils.PersonUtils;
import com.yeejoin.precontrol.common.utils.QRCodeUtil;
import com.yeejoin.precontrol.common.utils.StringUtil;
import com.yeejoin.precontrol.common.utils.WordTemplateUtils;
import com.yeejoin.precontrol.common.vo.BadCompanyVo;
import com.yeejoin.precontrol.common.vo.HazardousWorkVo;
import com.yeejoin.precontrol.common.vo.ReginParams;
import com.yeejoin.precontrol.common.vo.RewardAndRetributionListVo;
import com.yeejoin.precontrol.common.vo.SingJobDisclosureVo;
import com.yeejoin.precontrol.common.vo.SingTaskBadManagementVo;
import com.yeejoin.precontrol.common.vo.SingTaskPayCheckVo;
import com.yeejoin.precontrol.common.vo.TaskFileVo;
import com.yeejoin.precontrol.common.vo.TaskPageVo;
import com.yeejoin.precontrol.common.vo.TaskPersonAndImageInfo;
import com.yeejoin.precontrol.common.vo.TaskRiskControlVo;
import com.yeejoin.precontrol.common.vo.TaskVo;
import com.yeejoin.precontrol.common.vo.visual.BadVisualVo;
import com.yeejoin.precontrol.common.vo.visual.JobDisclosureVisualVo;
import com.yeejoin.precontrol.common.vo.visual.TaskPayCheckVisualVo;
import com.yeejoin.precontrol.common.vo.visual.TaskPersonAndImageInfoVo;
import com.yeejoin.precontrol.common.vo.visual.TaskPersonProcessInfo;
import com.yeejoin.precontrol.common.vo.visual.TaskProcessInfo;

/**
 * 作业活动 服务实现类
 *
 * @author duanwei
 * @date 2020-06-30
 */
@Service
public class TaskServiceImpl extends ServiceImpl<TaskMapper, Task> implements ITaskService {

	@Autowired
	TaskMapper taskMapper;

	@Autowired
	IDistrictsService iDistrictsService;

	@Autowired
	IPersonService iPersonService;

	@Autowired
	ITaskPaycheckService iTaskPaycheckService;

	@Autowired
	IPersonAscriptionService iPersonAscriptionService;

	@Autowired
	ICompanyService iCompanyService;

	@Autowired
	ITaskService iTaskService;

	@Autowired
	ITaskPersonFileService iTaskPersonFileService;

	@Autowired
	ITaskPersonService iTaskPersonService;

	@Autowired
	IBadManagementService iBadManagementService;

	@Autowired
	IProjectService iProjectService;

	@Autowired
	ITechDocumentService iTechDocumentService;

	@Autowired
	ITechDocumentAttachmentService iTechDocumentAttachmentService;

	@Autowired
	ITaskTechDocumentService iTaskTechDocumentService;

	@Autowired
	PdfService pdfService;

	@Autowired
	ITechDocumentAttachmentTemplateService iTechDocumentAttachmentTemplateService;

	@Autowired
	IHazardousWorkService iHazardousWorkService;

	@Autowired
	IHazardousWorkResultService iHazardousWorkResultService;

	@Autowired
	ITaskRiskControlService iTaskRiskControlService;

	@Value("${fileserver.domain}")
	String fileServerUrl;

	@Value("${project.ip}")
	private String projectIp;

	@Value("${server.servlet.context-path}")
	private String apiContext;

	@Value("${server.port}")
	private String apiPort;

	@Autowired
	IBadManagementPersonService ibadManagementPersonService;

	@Autowired
	FileService fileService;

	@Autowired
	TranslateEventPublish translateEventPublish;

	@Autowired
	StatusEventPublish statusEventPublish;

	@Autowired
	MessageEventPublish messageEventPublish;

	@Autowired
	KnowledgebaseFeignClient knowledgeBaseFeign;

	@Autowired
	ITaskSalaryConfirmService iTaskSalaryConfirmService;

	@Autowired
	ITaskPersonFeedbackService iTaskPersonFeedbackService;

	@Autowired
	ITaskSalaryConfirmAttachmentService iTaskSalaryConfirmAttachmentService;

	@Autowired
	IPersonConditionService iPersonConditionService;

	@Autowired
	AmosTrainingFeignClient examFeign;

	@Autowired
	RuleTrigger ruleTrigger;

	@Autowired
	IStatisticsService statisticsService;

	@Value("${rule.award}")
	private String ruleAward;

	@Autowired
	IntegralFeign integralFeign;

	@Autowired
	PersonUtils personUtils;

	@Autowired
	SmallProService smallProService;

	@Override
	public IPage<TaskPageVo> listByPage(CommonPageableDto pageable, TaskPageDto taskPageDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<TaskPageVo> iPageData = taskMapper.listByPage(page, taskPageDto);
		List<TaskPageVo> taskPageVos = iPageData.getRecords();
		taskPageVos.forEach(taskPageVo -> {
			taskPageVo.setStatusName(TaskStatusEnum.getNameByType(taskPageVo.getStatus()));
		});
		return iPageData;
	}

	@Override
	public IPage<TaskPageVo> myToDoListByPage(CommonPageableDto pageable, TaskPageDto taskPageDto, Long personId) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<TaskPageVo> iPageData = taskMapper.myToDoListByPage(page, taskPageDto);
		List<TaskPageVo> taskPageVos = iPageData.getRecords();
		taskPageVos.forEach(taskPageVo -> {
			taskPageVo.setStatusName(TaskStatusEnum.getNameByType(taskPageVo.getStatus()));
			// 转换地区
			if (StringUtils.isNotBlank(taskPageVo.getRegion())) {
				String[] split = taskPageVo.getRegion().split(",");
				LinkedList<Long> collect = Arrays.stream(split).map(Long::parseLong)
						.collect(Collectors.toCollection(LinkedList::new));
				Collection<Districts> districts = iDistrictsService.listByIds(collect);
				StringBuffer districtsName = new StringBuffer();
				districts.forEach(districts1 -> districtsName.append(districts1.getExtName()).append(","));
				districtsName.deleteCharAt(districtsName.length() - 1);
				taskPageVo.setRegionName(districtsName.toString());
			}
			Long createPersonId = taskPageVo.getCreatePersonId();
			Person person = iPersonService.getById(createPersonId);
			if (person != null) {
				taskPageVo.setCreatePersonName(person.getName());
			}
			List<TaskPerson> taskpersons = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
					.eq(TaskPerson::getTaskId, taskPageVo.getId()).eq(TaskPerson::getPersonId, personId));
			TaskPerson exectueTaskPerson = getExecuteTaskPerson(taskpersons);
			taskPageVo.setExecuteUserId(exectueTaskPerson != null ? exectueTaskPerson.getPersonId() : null);
			taskPageVo.setExecuteUserName(exectueTaskPerson != null ? exectueTaskPerson.getPersonName() : null);
			taskPageVo.setReadStatus(exectueTaskPerson != null ? exectueTaskPerson.getReadStatus().intValue() : 1);
			//taskPageVo.setTaskPersonRoleType(exectueTaskPerson != null ? exectueTaskPerson.getType() : null);
			//taskPageVo.setTaskPersonId(exectueTaskPerson != null ? exectueTaskPerson.getId() : null);\
			taskPageVo.setTaskPersonRoleTypeName(TaskPersonTypeEnum.getLabelByValue(taskPageVo.getTaskPersonRoleType()));
		});

		return iPageData;
	}

	private TaskPerson getExecuteTaskPerson(List<TaskPerson> taskpersons) {
		if (StringUtil.isEmpty(taskpersons)) {
			return null;
		}
		TaskPerson taskPerson = taskpersons.get(0);
		for (TaskPerson t : taskpersons) {
			if (t.getReadStatus() == StatusEnum.SUCCESS.getValue()) {
				continue;
			} else {
				return t;
			}
		}
		return taskPerson;
	}

	@Override
	public IPage<TaskPageVo> safeConstructionTaskStatusList(CommonPageableDto pageable,
			SafeConstructionDto safeConstructionDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<TaskPageVo> iPageData = new Page<TaskPageVo>();
		// 如果是未完成走之前mapper 进行中和风险走新mapper
		if (safeConstructionDto.getCurrentStatus() == 2L) {
			iPageData = taskMapper.safeConstructionTaskStatusList(page, safeConstructionDto);
		} else {
			iPageData = taskMapper.safeRiskTaskStatusList(page, safeConstructionDto);
		}

		return iPageData;
	}

	@Override
	public IPage<TaskPageVo> riskWork(CommonPageableDto pageable, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		if (safeOperationStatisticsDto.getStartDate() == null) {
			safeOperationStatisticsDto.setStartDate(startTime);
		}
		if (safeOperationStatisticsDto.getEndDate() == null) {
			safeOperationStatisticsDto.setEndDate(endTime);
		}
		return taskMapper.riskWork(page, null, null, safeOperationStatisticsDto);
	}

	@Override
	public IPage<TaskPageVo> jobTicket(CommonPageableDto pageable, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		if (safeOperationStatisticsDto.getStartDate() == null) {
			safeOperationStatisticsDto.setStartDate(startTime);
		}
		if (safeOperationStatisticsDto.getEndDate() == null) {
			safeOperationStatisticsDto.setEndDate(endTime);
		}
		return taskMapper.jobTicket(page, null, null, safeOperationStatisticsDto);
	}

	@Override
	public IPage<TaskPageVo> taskList(CommonPageableDto pageable, String type, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		if (safeOperationStatisticsDto.getStartDate() == null) {
			safeOperationStatisticsDto.setStartDate(startTime);
		}
		if (safeOperationStatisticsDto.getEndDate() == null) {
			safeOperationStatisticsDto.setEndDate(endTime);
		}
		return taskMapper.taskList(page, type, null, null, safeOperationStatisticsDto);
	}

	@Override
	public IPage<TaskPageVo> taskPay(CommonPageableDto pageable, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		if (safeOperationStatisticsDto.getStartDate() == null) {
			safeOperationStatisticsDto.setStartDate(startTime);
		}
		if (safeOperationStatisticsDto.getEndDate() == null) {
			safeOperationStatisticsDto.setEndDate(endTime);
		}
		return taskMapper.taskPay(page, null, null, safeOperationStatisticsDto);
	}

	@Override
	public IPage<TaskPageVo> bad(CommonPageableDto pageable, String startTime, String endTime,
			SafeOperationStatisticsDto safeOperationStatisticsDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		if (safeOperationStatisticsDto.getStartDate() == null) {
			safeOperationStatisticsDto.setStartDate(startTime);
		}
		if (safeOperationStatisticsDto.getEndDate() == null) {
			safeOperationStatisticsDto.setEndDate(endTime);
		}
		return taskMapper.bad(page, null, null, safeOperationStatisticsDto);
	}

	@Override
	public Task saveJobDisclosure(SingJobDisclosureDto singJobDisclosureDto, Person person) {
		List<Long> hostPersonId = singJobDisclosureDto.getHostPersonId();
		// List<Long> disclosurePersonId = singJobDisclosureDto.getDisclosurePersonId();
		List<Long> constructionDirectorId = singJobDisclosureDto.getConstructionDirectorId();
		List<Long> safetyOfficerId = singJobDisclosureDto.getSafetyOfficerId();
		List<Long> noteTakerId = singJobDisclosureDto.getNoteTakerId();
		List<Long> participateDisclosureId = singJobDisclosureDto.getParticipateDisclosureId();
		List<Long> platformSafetyOfficerId = singJobDisclosureDto.getPlatformSafetyOfficerId();

		Task task = new Task();
		task.setType(TaskTypeEnum.JOBDISCLOSURE.getValue());
		task.setName(singJobDisclosureDto.getName());
		task.setCode(singJobDisclosureDto.getCode());
		task.setNumber(singJobDisclosureDto.getNumber());
		task.setCreatePersonId(person.getId());
		Long projectId = singJobDisclosureDto.getProjectId();
		task.setProjectId(projectId);
		Project project = iProjectService.getById(projectId);
		if (project != null) {
			task.setProjectName(project.getName());
		}
		task.setStatus(Long.valueOf(TaskStatusEnum.UNCOMPLETED.getType()));
		task.setTaskNo(DateUtils.getTimeStamp());
		task.setOrgCode(singJobDisclosureDto.getOrgCode());
		iTaskService.save(task);

		Long taskId = task.getId();

		saveTaskPersonByType(person.getId(), TaskPersonTypeEnum.CREATEPERSON.getValue(), taskId,
				StatusEnum.SUCCESS.getValue());
		savePersonByIds(hostPersonId, taskId, TaskPersonTypeEnum.HOSTPERSON);
		// savePersonByIds(disclosurePersonId,
		// taskId,TaskPersonTypeEnum.DISCLOSUREPERSON);
		savePersonByIds(constructionDirectorId, taskId, TaskPersonTypeEnum.CONSTRUCTIONDIRECTOR);
		savePersonByIds(platformSafetyOfficerId, taskId, TaskPersonTypeEnum.PLATFORMSAFETYOFFICER);
		savePersonByIds(safetyOfficerId, taskId, TaskPersonTypeEnum.SAFETYOFFICER);
		savePersonByIds(noteTakerId, taskId, TaskPersonTypeEnum.NOTETAKER);
		savePersonByIds(participateDisclosureId, taskId, TaskPersonTypeEnum.PARTICIPATEDISCLOSURE);

		// 存储附件
		saveAttachmentFileName(person, taskId, singJobDisclosureDto.getAttachment());

		// 存储对应的文档 现在只考虑选择一个文件
		Long documentId = singJobDisclosureDto.getDocumentId();
		TaskTechDocument taskTechDocument = new TaskTechDocument();
		taskTechDocument.setTaskId(taskId);
		taskTechDocument.setTechDocumentId(documentId);
		taskTechDocument.setTechDocumentName(singJobDisclosureDto.getDocumentName());
		iTaskTechDocumentService.save(taskTechDocument);

		// 更新推送
		String orgCode = person.getOrgCode();
		statisticsService.initWs(orgCode, Constant.WS_COMPOSITESUM);

		// 微信服务通知
		List<Long> personIds = new ArrayList<Long>();
		personIds.addAll(hostPersonId);
		personIds.addAll(constructionDirectorId);
		personIds.addAll(safetyOfficerId);
		personIds.addAll(noteTakerId);
		personIds.addAll(participateDisclosureId);
		List<Person> persons = iPersonService
				.list(new LambdaQueryWrapper<Person>().in(Person::getId, personIds).isNotNull(Person::getOpenId));
		List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
		List<String> messages = new ArrayList<>();
		messages.add(smallProService.getName());
		messages.add(TaskTypeEnum.JOBDISCLOSURE.getLabel());
		messages.add("您有待办理的技术交底管控任务流程");
		messages.add(DateUtils.getDateNowString());
		smallProService.sendWeChatUpcomingMessage(openIds, WeChatMsgTemplateTypeEum.TODO.getValue(), messages);
		return task;
	}

	@Override
	@Transactional
	public Task saveTaskPayCheck(SingTaskPayCheckDto singTaskPayCheckDto, Person person) {
		List<Long> technicianId = singTaskPayCheckDto.getTechnicianId();
		List<Long> engineeringStaffId = singTaskPayCheckDto.getEngineeringStaffId();
		Long safetyOfficerId = singTaskPayCheckDto.getSafetyOfficerId();
		List<Long> builderId = singTaskPayCheckDto.getBuilderId();

		if (StringUtil.isNotEmpty(technicianId)) {
			Set<Long> collect = technicianId.stream().collect(Collectors.toSet());
			if (collect.size() != technicianId.size()) {
				throw new BaseException("单个人员不允许选择多次");
			}
		}
		if (StringUtil.isNotEmpty(engineeringStaffId)) {
			Set<Long> collect = engineeringStaffId.stream().collect(Collectors.toSet());
			if (collect.size() != engineeringStaffId.size()) {
				throw new BaseException("单个人员不允许选择多次");
			}
		}
		if (StringUtil.isNotEmpty(builderId)) {
			Set<Long> collect = builderId.stream().collect(Collectors.toSet());
			if (collect.size() != builderId.size()) {
				throw new BaseException("单个人员不允许选择多次");
			}
		}

		Task task = new Task();
		task.setType(TaskTypeEnum.TASKPAYCHECK.getValue());
		task.setCreatePersonId(person.getId());
		task.setWeather(singTaskPayCheckDto.getWeather());
		Long projectId = singTaskPayCheckDto.getProjectId();
		task.setProjectId(projectId);
		Project project = iProjectService.getById(projectId);
		if (project == null) {
			throw new BaseException("所选项目不存在");
		}
		task.setProjectName(project.getName());
		task.setStatus(StatusEnum.UNFINISHED.getValue());
		task.setTaskNo(DateUtils.getTimeStamp());
		task.setOrgCode(singTaskPayCheckDto.getOrgCode());
		iTaskService.save(task);

		Long taskId = task.getId();
		TaskPaycheck taskPaycheck = new TaskPaycheck();
		taskPaycheck.setConstructionTask(singTaskPayCheckDto.getConstructionTask());
		taskPaycheck.setTechnicalRequire(singTaskPayCheckDto.getTechnicalRequire());
		taskPaycheck.setEnvironmentProtect(singTaskPayCheckDto.getEnvironmentProtect());
		taskPaycheck.setDress(singTaskPayCheckDto.getDress());
		taskPaycheck.setSaftTreasure(singTaskPayCheckDto.getSaftTreasure());
		taskPaycheck.setMentalState(singTaskPayCheckDto.getMentalState());
		taskPaycheck.setTaskId(taskId);
		taskPaycheck.setRiskOperation(singTaskPayCheckDto.getRiskOperation());
		taskPaycheck.setRiskTypeId(singTaskPayCheckDto.getRiskTypeId());
		taskPaycheck.setRiskType(singTaskPayCheckDto.getRiskType());
		taskPaycheck.setWorkTicketId(singTaskPayCheckDto.getWorkTicketId());
		taskPaycheck.setWorkTicketName(singTaskPayCheckDto.getWorkTicketName());
		iTaskPaycheckService.save(taskPaycheck);

		// 存储对应的人 0主持人，1交底人，2施工负责人，3安全员，4交底人员，5记录人，6技术员，7工程人员，8施工人员，9违章人员 10 分包商负责人
		// 11审核人 12违规发起人 13平台分包商安全员（项目安全员） 99 发布人
		saveTaskPersonByType(person.getId(), TaskPersonTypeEnum.CREATEPERSON.getValue(), taskId,
				StatusEnum.SUCCESS.getValue());
		if (StringUtil.isNotEmpty(singTaskPayCheckDto.getTechnicianId())) {
			savePersonByIds(singTaskPayCheckDto.getTechnicianId(), taskId, TaskPersonTypeEnum.TECHNICIAN);
		}
		if (StringUtil.isNotEmpty(singTaskPayCheckDto.getEngineeringStaffId())) {
			savePersonByIds(singTaskPayCheckDto.getEngineeringStaffId(), taskId, TaskPersonTypeEnum.ENGINEERINGSTAFF);
		}
		if (StringUtil.isNotEmpty(singTaskPayCheckDto.getBuilderId())) {
			savePersonByIds(singTaskPayCheckDto.getBuilderId(), taskId, TaskPersonTypeEnum.BUILDER);
		}

		if (null != safetyOfficerId) {
			saveTaskPersonByType(safetyOfficerId, TaskPersonTypeEnum.SAFETYOFFICER.getValue(), taskId,
					StatusEnum.UNFINISHED.getValue());
		}
		if (null != singTaskPayCheckDto.getPlatformSafetyOfficerId()) {
			saveTaskPersonByType(singTaskPayCheckDto.getPlatformSafetyOfficerId(),
					TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue(), taskId, StatusEnum.UNFINISHED.getValue());
		}

		// 作业票图片附件
		saveAttachment(person, taskId, singTaskPayCheckDto.getWorkTicketFilePath(), TaskPersonFileEnum.JOBTICKET);

		Long riskTypeId = singTaskPayCheckDto.getRiskTypeId();
		if (riskTypeId != null) {
			// 新增检查项
			HazardousWorkVo hazardousWorkVo = iHazardousWorkService.getHazardousWorkVo(riskTypeId);
			List<InputItemDto> inputItemDtos = hazardousWorkVo.getInputItemDtos();
			if (StringUtil.isNotEmpty(inputItemDtos)) {
				// 多个安全员 各自都有自己的检查项
				inputItemDtos.forEach(inputItemDto -> {
					insertHazardousWorkResult(singTaskPayCheckDto, taskId, inputItemDto,
							singTaskPayCheckDto.getSafetyOfficerId(), 0L);
					insertHazardousWorkResult(singTaskPayCheckDto, taskId, inputItemDto,
							singTaskPayCheckDto.getPlatformSafetyOfficerId(), 1L);
				});
			}
		}

		// 附件
		saveAttachment(person, taskId, singTaskPayCheckDto.getAttachment(), TaskPersonFileEnum.FILE);

		// 推送状态更改消息
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("name", "task_job");
		jsonObject.put("projectId", projectId);
		jsonObject.put("taskId", taskId);
		List<PersonAscription> list = iPersonAscriptionService
				.list(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, person.getId()));
		if (StringUtil.isNotEmpty(list)) {
			jsonObject.put("companyId", list.get(0).getCompanyId());
		}
		statusEventPublish.publish(jsonObject);
		translateEventPublish.publish(task);

		// 更新推送
		String orgCode = person.getOrgCode();
		statisticsService.initWs(orgCode, Constant.WS_COMPOSITESUM);

		// 微信服务通知
//		List<Long> personIds = new ArrayList<Long>();
//		personIds.addAll(singTaskPayCheckDto.getTechnicianId());
//		personIds.addAll(singTaskPayCheckDto.getEngineeringStaffId());
//		personIds.addAll(singTaskPayCheckDto.getBuilderId());
//		personIds.add(safetyOfficerId);
//		personIds.add(singTaskPayCheckDto.getPlatformSafetyOfficerId());
//		List<Person> persons = iPersonService.list(new LambdaQueryWrapper<Person>()
//				.in(Person::getId, personIds).isNotNull(Person::getOpenId));
//		List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
//		List<String> messages = new ArrayList<>();
//		messages.add(smallProService.getName());
//		messages.add(TaskTypeEnum.TASKPAYCHECK.getLabel());  
//		messages.add("您有待办理的三交三查管控任务流程");
//		messages.add(DateUtils.getDateNowString());
//		smallProService.sendWeChatUpcomingMessage(openIds, WeChatMsgTemplateTypeEum.TODO.getValue(),
//				messages);
		return task;
	}

	@Override
	public void updatePayCheck(SingTaskPayCheckDto singTaskPayCheckDto, Person person) {
		Long id = singTaskPayCheckDto.getId();
		Task task = iTaskService.getById(id);
		if (task == null) {
			throw new BaseException("任务不存在");
		}

		TaskPerson taskPerson = null;
		try {
			taskPerson = iTaskPersonService
					.getOne(new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getTaskId, singTaskPayCheckDto.getId())
							.eq(TaskPerson::getPersonId, person.getId()));
		} catch (Exception e) {
			throw new BaseException("当前任务用户数据存在多份,请检查是否选择同一个人");
		}
		if (taskPerson == null) {
			throw new BaseException("上传图片失败,角色信息错误,任务指定角色中不存在当前用户");
		}

		// 更新阅读状态
		taskPerson.setReadStatus(StatusEnum.SUCCESS.getValue());
		iTaskPersonService.updateById(taskPerson);

		List<String> filePath = singTaskPayCheckDto.getFilePath();
		if (StringUtil.isNotEmpty(filePath)) {
			for (String file : filePath) {
				TaskPersonFile taskPersonFile = new TaskPersonFile();
				taskPersonFile.setTaskId(id);
				taskPersonFile.setPersonId(person.getId());
				taskPersonFile.setPersonType(TaskPersonFileEnum.IMAGE.getValue());
				taskPersonFile.setFilePath(file.replace(fileServerUrl, ""));
				iTaskPersonFileService.save(taskPersonFile);
			}
		}

		List<HazardousWorkResult> hazardousWorkResultList = singTaskPayCheckDto.getHazardousWorkResultList();
		if (StringUtil.isNotEmpty(hazardousWorkResultList)) {
			hazardousWorkResultList.forEach(hazardousWorkResult -> {
				iHazardousWorkResultService.updateById(hazardousWorkResult);
			});
		}
		AtomicBoolean isOk = new AtomicBoolean(true);
		List<HazardousWorkResult> platformHazardousWorkResultList = singTaskPayCheckDto
				.getPlatformHazardousWorkResultList();
		if (StringUtil.isNotEmpty(platformHazardousWorkResultList)) {
			platformHazardousWorkResultList.forEach(hazardousWorkResult -> {
				// 任何一项不合格
				if (hazardousWorkResult.getIsOk() == 2L) {
					isOk.set(false);
				}
				iHazardousWorkResultService.updateById(hazardousWorkResult);
			});
		}
		// 不合格打回给创建人
		if (!isOk.get()) {
			TaskPerson createPerson = new TaskPerson();
			createPerson.setReadStatus(StatusEnum.UNFINISHED.getValue());
			iTaskPersonService.update(createPerson,
					new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getPersonId, task.getCreatePersonId())
							.eq(TaskPerson::getTaskId, task.getId())
							.eq(TaskPerson::getType, TaskPersonTypeEnum.CREATEPERSON.getValue()));
		}
		translateEventPublish.publish(task);
	}

	@Override
	@Transactional
	public void saveBadManagement(SingBadManagementDto singBadManagementDto, Person curPerson) {
		Task task = new Task();
		task.setType(TaskTypeEnum.BAD.getValue());
		task.setCreatePersonId(curPerson.getId());
		Long projectId = singBadManagementDto.getProjectId();
		task.setProjectId(projectId);
		Project project = iProjectService.getById(singBadManagementDto.getProjectId());
		if (project == null) {
			throw new BaseException("所选项目不存在");
		}
		task.setProjectName(project.getName());
		task.setStatus(Long.valueOf(TaskStatusEnum.TOAUDIT.getType()));
		task.setTaskNo(DateUtils.getTimeStamp());
		task.setOrgCode(singBadManagementDto.getOrgCode());
		iTaskService.save(task);

		Long taskId = task.getId();
		BadManagement badMananger = new BadManagement();
		badMananger.setBody(singBadManagementDto.getBody());
		badMananger.setTaskId(taskId);
		badMananger.setCompanyId(singBadManagementDto.getCompanyId());
		badMananger.setPersonLiable(singBadManagementDto.getPersonLiableId());
		badMananger.setType(singBadManagementDto.getType());
		badMananger.setNature(singBadManagementDto.getNature());
		iBadManagementService.save(badMananger);

		// 保存发起人
		TaskPerson createTaskPerson = new TaskPerson();
		createTaskPerson.setTaskId(taskId);
		createTaskPerson.setPersonId(curPerson.getId());
		Person createPerson = iPersonService.getById(curPerson.getId());
		createTaskPerson.setPersonName(createPerson.getName());
		createTaskPerson.setType(TaskPersonTypeEnum.SPONSORVIOLATION.getValue());
		createTaskPerson.setReadStatus(StatusEnum.SUCCESS.getValue());
		PersonAscription createPersonAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId,
						singBadManagementDto.getAuditPersonId()));
		createTaskPerson.setCompanyId(createPersonAscription.getCompanyId());
		iTaskPersonService.save(createTaskPerson);

		// 保存审核人
		TaskPerson auditTaskPerson = new TaskPerson();
		auditTaskPerson.setTaskId(taskId);
		auditTaskPerson.setPersonId(singBadManagementDto.getAuditPersonId());
		Person auditPerson = iPersonService.getById(singBadManagementDto.getAuditPersonId());
		auditTaskPerson.setPersonName(auditPerson.getName());
		auditTaskPerson.setType(TaskPersonTypeEnum.REVIEWER.getValue());
		auditTaskPerson.setReadStatus(StatusEnum.UNFINISHED.getValue());
		PersonAscription auditPersonAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId,
						singBadManagementDto.getAuditPersonId()));
		auditTaskPerson.setCompanyId(auditPersonAscription.getCompanyId());
		iTaskPersonService.save(auditTaskPerson);
		// 发送违章检查审核消息：分包商负责人和审核人员
		JSONArray jsonArray = new JSONArray();
		// 审核人员
		JSONObject auditMsg = new JSONObject();
		auditMsg.put(MessageAttributeEnum.MSG_TYPE.getName(), MessageTypeEnum.VIOLATION_INSPECTION.getType());
		auditMsg.put(MessageAttributeEnum.MSG_SUB_TYPE.getName(),
				MessageSubTypeEnum.VIOLATION_INSPECTION_TODO.getType());
		auditMsg.put(MessageAttributeEnum.CONTENT.getName(), MessageSubTypeEnum.VIOLATION_INSPECTION_TODO.getTip());
		auditMsg.put(MessageAttributeEnum.PERSON_ID.getName(), auditPerson.getId());
		auditMsg.put(MessageAttributeEnum.TASK_ID.getName(), taskId);
		jsonArray.add(auditMsg);
		JSONObject obj = new JSONObject();
		obj.put("param", jsonArray);
		messageEventPublish.publish(obj);

		// 保存附件
		saveAttachment(curPerson, taskId, singBadManagementDto.getFilePath(), TaskPersonFileEnum.CREATEPERSONFILE);
		translateEventPublish.publish(task);

		// 更新推送
		String orgCode = curPerson.getOrgCode();
		statisticsService.initWs(orgCode, Constant.WS_VIOLATIONSUM);
		statisticsService.initWs(orgCode, Constant.WS_COMPOSITESUM);

		// 微信服务通知
		List<Person> persons = iPersonService.list(new LambdaQueryWrapper<Person>()
				.in(Person::getId, Arrays.asList(singBadManagementDto.getAuditPersonId()))
				.isNotNull(Person::getOpenId));
		List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
		List<String> messages = new ArrayList<>();
		messages.add(smallProService.getName());
		messages.add(badMananger.getNature());
		messages.add(badMananger.getType());
		messages.add(DateUtils.getDateNowString());
		smallProService.sendWeChatUpcomingMessage(openIds, WeChatMsgTemplateTypeEum.TODO.getValue(), messages);
	}

	@Override
	@Transactional
	public void updateBadManagement(SingBadManagementDto singBadManagementDto, Person curPerson) {
		Long id = singBadManagementDto.getId();
		Task task = iTaskService.getById(id);
		if (task == null) {
			throw new BaseException("任务不存在");
		}
		BadManagement badManagement = iBadManagementService
				.getOne(new LambdaQueryWrapper<BadManagement>().eq(BadManagement::getTaskId, id));
		Project project = iProjectService.getById(task.getProjectId());
		List<Long> badManagementId = singBadManagementDto.getBadManagementId();
		List<BadManagementPerson> badManagementPersonList = new ArrayList<>();
		if (StringUtil.isNotEmpty(badManagementId)) {
			JSONArray jsonArray = new JSONArray();
			for (Long personId : badManagementId) {
				Person person = iPersonService.getById(personId);
				BadManagementPerson badManagementPerson = new BadManagementPerson();
				badManagementPerson.setTaskId(id);
				badManagementPerson.setPersonId(personId);
				PersonAscription personAscription = iPersonAscriptionService
						.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, personId));
				if (personAscription != null) {
					badManagementPerson.setProjectId(personAscription.getProjectId());
					badManagementPerson.setCompanyId(personAscription.getCompanyId());
					Company company = iCompanyService.getById(personAscription.getCompanyId());
					if (company != null) {
						badManagementPerson.setCompanyName(company.getName());
					}
				}
				badManagementPerson.setPersonName(person.getName());
				badManagementPerson.setValid(true);
				ibadManagementPersonService.save(badManagementPerson);
				// 更新二维码状态
				int count = ibadManagementPersonService.count(new LambdaQueryWrapper<BadManagementPerson>()
						.eq(BadManagementPerson::getPersonId, personId).eq(BadManagementPerson::getValid, true));
				// Less than or equal to 1 = 绿码 Green code =2 黄码 >=3 =红码
				if (count <= 1) {
					// person.setColor(SmallProQrColorEum.green.getSqlCode());
				} else if (count == 2) {
					if (SmallProQrColorEum.green.getSqlCode() == person.getColor()) {
						person.setColor(SmallProQrColorEum.yellow.getSqlCode());

						// 微信服务通知
						Set<Long> set = personUtils.getDefaultPerson(task.getProjectId());
						List<Person> persons = iPersonService.list(
								new LambdaQueryWrapper<Person>().in(Person::getId, set).isNotNull(Person::getOpenId));
						List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
						List<String> messages = new ArrayList<>();
						messages.add(project.getName());
						messages.add("人员黄码安全预警");
						messages.add("具有２次违章行为，详情请查看人员履历");
						messages.add(person.getName());
						smallProService.sendWeChatUpcomingMessage(openIds,
								WeChatMsgTemplateTypeEum.PROJECT_WARN.getValue(), messages);

					}
				} else if (count == 3) {
					person.setColor(SmallProQrColorEum.red.getSqlCode());
					person.setRedCount(person.getRedCount() + 1);
					// 第一次违章3次后改变 考试选项
					person.setQualifiedStage(QualifiedStageEnum.THREE_LEVEL_QULIFIED.getValue());
					// 违章导致的红码第二次以上则记录黑名单
					if (person.getRedCount() >= 2) {
						person.setIsBlack(1L);
						JSONObject jsonObject = new JSONObject();
						jsonObject.put("name", "black_list");
						jsonObject.put("data", person);
						statusEventPublish.publish(jsonObject);

						// 微信服务通知
						Set<Long> set = personUtils.getDefaultPerson(task.getProjectId());
						List<Person> persons = iPersonService.list(new LambdaQueryWrapper<Person>()
								.in(Person::getUserId, Arrays.asList(set)).isNotNull(Person::getOpenId));
						List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
						List<String> messages = new ArrayList<>();
						messages.add(project.getName());
						messages.add("人员黑名单安全预警");
						messages.add("违反2次安全红码，详情请查看人员履历");
						messages.add(person.getName());
						smallProService.sendWeChatUpcomingMessage(openIds,
								WeChatMsgTemplateTypeEum.PROJECT_WARN.getValue(), messages);
					}

					// 微信服务通知
					Set<Long> set = personUtils.getDefaultPerson(task.getProjectId());
					List<Person> persons = iPersonService.list(new LambdaQueryWrapper<Person>()
							.in(Person::getUserId, Arrays.asList(set)).isNotNull(Person::getOpenId));
					List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
					List<String> messages = new ArrayList<>();
					messages.add(project.getName());
					messages.add("人员红码安全预警");
					messages.add("具有3次违章行为，详情请查看人员履历");
					messages.add(person.getName());
					smallProService.sendWeChatUpcomingMessage(openIds, WeChatMsgTemplateTypeEum.PROJECT_WARN.getValue(),
							messages);
				}
				iPersonService.updateById(person);
				badManagementPersonList.add(badManagementPerson);
				JSONObject msg = new JSONObject();
				msg.put(MessageAttributeEnum.MSG_TYPE.getName(), MessageTypeEnum.SERVICE_REMINDER.getType());
				msg.put(MessageAttributeEnum.MSG_SUB_TYPE.getName(),
						MessageSubTypeEnum.SERVICE_REMINDER_NEW_VIOLATION.getType());
				msg.put(MessageAttributeEnum.CONTENT.getName(),
						MessageSubTypeEnum.SERVICE_REMINDER_NEW_VIOLATION.getTip());
				msg.put(MessageAttributeEnum.PERSON_ID.getName(), personId);
				msg.put(MessageAttributeEnum.PROJECT_ID.getName(), badManagementPerson.getProjectId());
				msg.put(MessageAttributeEnum.TASK_ID.getName(), task.getId());
				jsonArray.add(msg);
			}
			// 分包商服务提醒：自己被指定为违章人员之后
			JSONObject obj = new JSONObject();
			obj.put("param", jsonArray);
			messageEventPublish.publish(obj);
			iBadManagementService.updateById(badManagement);
		}

		// 触发积分
		Person creator = iPersonService.getById(task.getCreatePersonId());
		String createName = creator != null ? creator.getName() : "";
		integralFeign.save(new CreateIntegralDto("FIND_VIOLATION", task.getId(), task.getCreatePersonId(), createName));
		// 触发规则
		try {
			singBadManagementDto.setNature(badManagement.getNature());
			singBadManagementDto.setCompanyId(badManagement.getCompanyId());
			log.error("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			System.out.println("========================param: " + JSONObject.toJSONString(singBadManagementDto));
			ruleTrigger.publish(singBadManagementDto, "施工安全预控/award", new String[0]);
		} catch (Exception e) {
			throw new BaseException(e.getMessage());
		}

		JSONObject jsonObject = new JSONObject();
		jsonObject.put("name", "bad_person");
		jsonObject.put("projectId", task.getProjectId());
		jsonObject.put("badPerson", badManagementPersonList);

		statusEventPublish.publish(jsonObject);
		translateEventPublish.publish(task);

		task.setStatus(TaskStatusEnum.COMPLETED.getLongType());
		task.setEndTime(new Date());
		this.updateById(task);

		// 更新推送
		String orgCode = curPerson.getOrgCode();
		statisticsService.initWs(orgCode, Constant.WS_VIOLATIONRANK);
		statisticsService.initWs(orgCode, Constant.WS_FBSVIOLATIONRANK);
		statisticsService.initWs(orgCode, Constant.WS_DAYVIOLATION);
		statisticsService.initWs(orgCode, Constant.WS_REDORGREENCODE);

		// 微信服务通知
		Set<Long> set = personUtils.getDefaultPerson(task.getProjectId());
		if (!StringUtil.isEmpty(badManagementId)) {
			set.addAll(badManagementId);
		}
		set.add(badManagement.getPersonLiable());

		List<Person> persons = iPersonService.list(new LambdaQueryWrapper<Person>()
				.in(Person::getUserId, Arrays.asList(set)).isNotNull(Person::getOpenId));
		List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
		List<String> messages = new ArrayList<>();
		messages.add(project.getName());
		messages.add(badManagement.getType());
		messages.add(badManagement.getNature());
		messages.add(DateUtils.getDateNowString());
		messages.add("反违章管控任务完成消息通知");
		smallProService.sendWeChatUpcomingMessage(openIds, WeChatMsgTemplateTypeEum.SERVICE_COMPLETE.getValue(),
				messages);

	}

	@Override
	public Object getJobDisclosure(Long taskId,Long taskPersonId) {

		Task task = iTaskService.getById(taskId);
		if (task == null) {
			throw new BaseException(BaseExceptionEnum.DATA_NOT_EXISTS);
		}
		if (!task.getType().equals(TaskTypeEnum.JOBDISCLOSURE.getValue())) {
			throw new BaseException("此任务不属于技术交底");
		}

		SingJobDisclosureVo singJobDisclosureVo = new SingJobDisclosureVo();
		BeanUtils.copyProperties(task, singJobDisclosureVo);
		singJobDisclosureVo.setStatusName(TaskStatusEnum.getNameByType(task.getStatus()));
		Person person = iPersonService.getById(task.getCreatePersonId());
		singJobDisclosureVo.setCreatePersonName(person != null ? person.getName() : "");
		singJobDisclosureVo.setQrCode(QRCodeUtil
				.generateQrCodeImageByteData(projectIp + ":" + apiPort + apiContext + "/task/" + taskId, 100, 100));
		// 人员拷贝
		List<TaskPerson> taskPeopleList = iTaskPersonService
				.list(new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getTaskId, taskId));

		List<TaskPerson> hostPersonList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.HOSTPERSON.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(hostPersonList)) {
			singJobDisclosureVo.setHostPersonObject(hostPersonList);
		}
		List<TaskPerson> disclosurePersonList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.DISCLOSUREPERSON.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(disclosurePersonList)) {
			singJobDisclosureVo.setDisclosurePersonObject(disclosurePersonList);
		}
		List<TaskPerson> constructionDirectorList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.CONSTRUCTIONDIRECTOR.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(constructionDirectorList)) {
			singJobDisclosureVo.setConstructionDirectorObject(constructionDirectorList);
		}
		List<TaskPerson> safetyOfficerList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.SAFETYOFFICER.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(safetyOfficerList)) {
			singJobDisclosureVo.setSafetyOfficerObject(safetyOfficerList);
		}
		
		List<TaskPerson> platSafetyOfficerList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(platSafetyOfficerList)) {
			if (StringUtil.isNotEmpty(safetyOfficerList)) {
				safetyOfficerList.addAll(platSafetyOfficerList);
				singJobDisclosureVo.setSafetyOfficerObject(safetyOfficerList);
			}else 
			{
				singJobDisclosureVo.setSafetyOfficerObject(platSafetyOfficerList);
			}
		}
		

		List<TaskPerson> noteTakerList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.NOTETAKER.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(noteTakerList)) {
			singJobDisclosureVo.setNoteTakerObject(noteTakerList);
		}
		// 交底人员比较多
		List<TaskPerson> participateDisclosureList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.PARTICIPATEDISCLOSURE.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(participateDisclosureList)) {
			singJobDisclosureVo.setParticipateDisclosureObject(participateDisclosureList);
		}
		// 附件
		TaskTechDocument taskTechDocument = iTaskTechDocumentService
				.getOne(new LambdaQueryWrapper<TaskTechDocument>().eq(TaskTechDocument::getTaskId, taskId));
		if (taskTechDocument != null) {
			singJobDisclosureVo.setDocumentId(taskTechDocument.getTechDocumentId());
			singJobDisclosureVo.setDocumentName(taskTechDocument.getTechDocumentName());
			// 调用知识库feign获取html
			ResponseModel<List<Map<String, Object>>> result = knowledgeBaseFeign
					.getDocById(taskTechDocument.getTechDocumentId());
			if (result.getResult() != null) {
				List<Map<String, Object>> doclist = result.getResult();
				if (doclist.get(0) != null && doclist.get(0).get("htmlContent") != null) {
					singJobDisclosureVo.setDocContent(String.valueOf(doclist.get(0).get("htmlContent")));
				}
			}
		} else {
			log.error("任务对应的文档的附件不存在");
		}
		// 获取附件
		LambdaQueryWrapper<TaskPersonFile> taskPersonFileLambdaQueryWrapper = new LambdaQueryWrapper<>();
		taskPersonFileLambdaQueryWrapper.eq(TaskPersonFile::getTaskId, taskId);
		taskPersonFileLambdaQueryWrapper.and(wapper -> {
			wapper.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.FILE.getValue()).or()
					.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.IMAGE.getValue());
		});
		List<TaskPersonFile> attachment = iTaskPersonFileService.list(taskPersonFileLambdaQueryWrapper);
		if (StringUtil.isNotEmpty(attachment)) {
			List<FileDto> fileDto = new ArrayList<>();
			for (TaskPersonFile taskPersonFile : attachment) {
				FileDto file = new FileDto();
				BeanUtils.copyProperties(taskPersonFile, file);
				fileDto.add(file);
			}
			singJobDisclosureVo.setAttachment(fileDto);
		}
		singJobDisclosureVo.setCreateTime(task.getCreateDate());
		
		if(taskPersonId!=null) 
		{
			TaskPerson taskPerson = iTaskPersonService.getById(taskPersonId);
			singJobDisclosureVo.setTaskPerson(taskPerson);
		}
		return singJobDisclosureVo;
	}

	@Override
	public Object getTaskPayCheck(Long taskId,Long taskPersonId) {
		Task task = iTaskService.getById(taskId);
		if (task == null) {
			throw new BaseException(BaseExceptionEnum.DATA_NOT_EXISTS);
		}
		if (task.getType() != 1) {
			throw new BaseException("此任务不属于三交三查");
		}
		TaskPaycheck taskPaycheck = iTaskPaycheckService
				.getOne(new LambdaQueryWrapper<TaskPaycheck>().eq(TaskPaycheck::getTaskId, taskId));
		if (taskPaycheck == null) {
			throw new BaseException("三交三查数据不存在");
		}
		SingTaskPayCheckVo singTaskPayCheckVo = new SingTaskPayCheckVo();
		BeanUtils.copyProperties(task, singTaskPayCheckVo);
		BeanUtils.copyProperties(taskPaycheck, singTaskPayCheckVo);

		List<TaskPerson> taskPeopleList = iTaskPersonService
				.list(new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getTaskId, taskId));

		// 安全员
		List<TaskPerson> safetyOfficerList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.SAFETYOFFICER.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(safetyOfficerList)) {
			TaskPerson taskPerson = safetyOfficerList.get(0);
			TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
			taskPersonAndImageInfo.setTaskId(taskId);
			taskPersonAndImageInfo.setPersonId(taskPerson.getPersonId());
			taskPersonAndImageInfo.setPersonName(taskPerson.getPersonName());
			taskPersonAndImageInfo.setType(taskPerson.getType());
			taskPersonAndImageInfo.setReadStatus(taskPerson.getReadStatus());
			// 根据对应的人查询文件
			getFileByUserId(taskId, taskPerson, taskPersonAndImageInfo, false);
			singTaskPayCheckVo.setSafetyOfficerObject(taskPersonAndImageInfo);
		}

		// 项目安全员
		List<TaskPerson> platformSafetyOfficerList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(platformSafetyOfficerList)) {
			TaskPerson taskPerson = platformSafetyOfficerList.get(0);
			TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
			taskPersonAndImageInfo.setTaskId(taskId);
			taskPersonAndImageInfo.setPersonId(taskPerson.getPersonId());
			taskPersonAndImageInfo.setPersonName(taskPerson.getPersonName());
			taskPersonAndImageInfo.setType(taskPerson.getType());
			taskPersonAndImageInfo.setReadStatus(taskPerson.getReadStatus());
			// 根据对应的人查询文件
			getFileByUserId(taskId, taskPerson, taskPersonAndImageInfo, false);
			singTaskPayCheckVo.setPlatformSafetyOfficerObject(taskPersonAndImageInfo);
		}

		// 发起人
		List<TaskPerson> createPersonList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.CREATEPERSON.getValue()))
				.collect(Collectors.toList());

		if (StringUtil.isNotEmpty(createPersonList)) {
			TaskPerson taskPerson = createPersonList.get(0);
			TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
			taskPersonAndImageInfo.setTaskId(taskId);
			taskPersonAndImageInfo.setPersonId(taskPerson.getPersonId());
			taskPersonAndImageInfo.setPersonName(taskPerson.getPersonName());
			taskPersonAndImageInfo.setType(taskPerson.getType());
			taskPersonAndImageInfo.setReadStatus(taskPerson.getReadStatus());
			taskPersonAndImageInfo.setCreatePersonName(taskPersonAndImageInfo.getPersonName());
			// 根据对应的人查询文件
			getFileByUserId(taskId, taskPerson, taskPersonAndImageInfo, false);
			singTaskPayCheckVo.setCreatePersonObject(taskPersonAndImageInfo);
		}

		// 技术员
		List<TaskPerson> technicianList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.TECHNICIAN.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(technicianList)) {
			List<TaskPersonAndImageInfo> list = new ArrayList<>();
			for (TaskPerson taskPerson : technicianList) {
				TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
				taskPersonAndImageInfo.setTaskId(taskId);
				taskPersonAndImageInfo.setPersonId(taskPerson.getPersonId());
				taskPersonAndImageInfo.setPersonName(taskPerson.getPersonName());
				taskPersonAndImageInfo.setType(taskPerson.getType());
				taskPersonAndImageInfo.setReadStatus(taskPerson.getReadStatus());
				// 根据对应的人查询文件
				getFileByUserId(taskId, taskPerson, taskPersonAndImageInfo, false);
				list.add(taskPersonAndImageInfo);
			}
			singTaskPayCheckVo.setTechnicianObject(list);
		}

		// 工程人员
		List<TaskPerson> engineeringStaffList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.ENGINEERINGSTAFF.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(engineeringStaffList)) {
			List<TaskPersonAndImageInfo> list = new ArrayList<>();
			for (TaskPerson taskPerson : engineeringStaffList) {
				TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
				taskPersonAndImageInfo.setTaskId(taskId);
				taskPersonAndImageInfo.setPersonId(taskPerson.getPersonId());
				taskPersonAndImageInfo.setPersonName(taskPerson.getPersonName());
				taskPersonAndImageInfo.setType(taskPerson.getType());
				taskPersonAndImageInfo.setReadStatus(taskPerson.getReadStatus());
				// 根据对应的人查询文件
				getFileByUserId(taskId, taskPerson, taskPersonAndImageInfo, false);
				list.add(taskPersonAndImageInfo);
			}
			singTaskPayCheckVo.setEngineeringStaffObject(list);
		}

		// 施工人员
		List<TaskPerson> builderList = taskPeopleList.stream()
				.filter(taskPerson -> taskPerson.getType().equals(TaskPersonTypeEnum.BUILDER.getValue()))
				.collect(Collectors.toList());
		if (StringUtil.isNotEmpty(builderList)) {
			List<TaskPersonAndImageInfo> taskPersonAndImageInfos = new ArrayList<>();
			for (TaskPerson taskPerson : builderList) {
				TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
				taskPersonAndImageInfo.setTaskId(taskId);
				taskPersonAndImageInfo.setPersonId(taskPerson.getPersonId());
				taskPersonAndImageInfo.setPersonName(taskPerson.getPersonName());
				taskPersonAndImageInfo.setType(taskPerson.getType());
				taskPersonAndImageInfo.setReadStatus(taskPerson.getReadStatus());
				// 根据对应的人查询文件
				getFileByUserId(taskId, taskPerson, taskPersonAndImageInfo, false);
				taskPersonAndImageInfos.add(taskPersonAndImageInfo);
			}
			singTaskPayCheckVo.setBuilderObject(taskPersonAndImageInfos);
		}

		// 获取安全作业票相关信息 已经copy 作业票属性
		List<TaskPersonFile> workTicket = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
				.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.JOBTICKET.getValue())
				.eq(TaskPersonFile::getTaskId, taskId));
		if (StringUtil.isNotEmpty(workTicket)) {
			List<String> collect = workTicket.stream().map(work -> work.getFilePath()).collect(Collectors.toList());
			singTaskPayCheckVo.setWorkTicketFilePath(collect);
		}
		singTaskPayCheckVo.setWorkTicketName(taskPaycheck.getWorkTicketName());

		// 获取附件
		List<TaskPersonFile> attachment = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
				.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.FILE.getValue())
				.eq(TaskPersonFile::getTaskId, taskId));
		if (StringUtil.isNotEmpty(attachment)) {
			List<String> collect = attachment.stream().map(a -> a.getFilePath()).collect(Collectors.toList());
			singTaskPayCheckVo.setAttachment(collect);
		}

		// 业务系统检查项项目
		List<HazardousWorkResult> data = new ArrayList<>();
		if (StringUtil.isNotEmpty(safetyOfficerList)) {
			TaskPerson taskPerson = safetyOfficerList.get(0);
			Long personId1 = taskPerson.getPersonId();
			data = iHazardousWorkResultService.list(new LambdaQueryWrapper<HazardousWorkResult>()
					.eq(HazardousWorkResult::getHazardousWorkId, singTaskPayCheckVo.getRiskTypeId())
					.eq(HazardousWorkResult::getTaskId, taskId).eq(HazardousWorkResult::getCpersonId, personId1)
					.eq(HazardousWorkResult::getWeight, 0L));
		}
		singTaskPayCheckVo.setHazardousWorkResultList(data);
		// 平台检查项项目
		List<HazardousWorkResult> platformList = iHazardousWorkResultService
				.list(new LambdaQueryWrapper<HazardousWorkResult>()
						.eq(HazardousWorkResult::getHazardousWorkId, singTaskPayCheckVo.getRiskTypeId())
						.eq(HazardousWorkResult::getTaskId, taskId).eq(HazardousWorkResult::getWeight, 1L));
		singTaskPayCheckVo.setPlatformHazardousWorkResultList(platformList);
		singTaskPayCheckVo.setCreatePersonId(task.getCreatePersonId());
		singTaskPayCheckVo.setCreateTime(task.getCreateDate());
		
		if(taskPersonId!=null) 
		{
			TaskPerson taskPerson = iTaskPersonService.getById(taskPersonId);
			singTaskPayCheckVo.setTaskPerson(taskPerson);
		}
		return singTaskPayCheckVo;
	}

	@Override
	public Object getBadManagement(Long taskId, Long personId,Long taskPersonId) {
		Task task = iTaskService.getById(taskId);
		if (task == null) {
			throw new BaseException(BaseExceptionEnum.DATA_NOT_EXISTS);
		}
		if (!task.getType().equals(TaskTypeEnum.BAD.getValue())) {
			throw new BaseException("此任务不属于违规管理");
		}
		BadManagement badManagement = iBadManagementService
				.getOne(new LambdaQueryWrapper<BadManagement>().eq(BadManagement::getTaskId, taskId));
		if (badManagement == null) {
			throw new BaseException("违规管理数据不存在");
		}
		SingTaskBadManagementVo singTaskBadManagementVo = new SingTaskBadManagementVo();
		BeanUtils.copyProperties(task, singTaskBadManagementVo);
		BeanUtils.copyProperties(badManagement, singTaskBadManagementVo);

		Long createPersonId = task.getCreatePersonId();
		Person createPerson = iPersonService.getById(createPersonId);
		singTaskBadManagementVo.setCreatePersonName(createPerson != null ? createPerson.getName() : null);

		singTaskBadManagementVo.setId(task.getId());
		if (0 == singTaskBadManagementVo.getStatus()) {
			singTaskBadManagementVo.setStatusName("未完成");
		} else if (1 == singTaskBadManagementVo.getStatus()) {
			singTaskBadManagementVo.setStatusName("已完成");
		} else if (2 == singTaskBadManagementVo.getStatus()) {
			singTaskBadManagementVo.setStatusName("待审核");
		} else if (3 == singTaskBadManagementVo.getStatus()) {
			singTaskBadManagementVo.setStatusName("驳回");
		}
		// 审核人
		TaskPerson taskPerson = iTaskPersonService.getOne(new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, taskId).eq(TaskPerson::getType, TaskPersonTypeEnum.REVIEWER.getValue()));
		singTaskBadManagementVo.setAuditPersonId(taskPerson.getPersonId());

		// 违章人员
		List<BadManagementPerson> badManagementPersonList = ibadManagementPersonService
				.list(new LambdaQueryWrapper<BadManagementPerson>().eq(BadManagementPerson::getTaskId, taskId));
		List<TaskPersonAndImageInfo> badObject = new ArrayList<>();
		if (StringUtil.isNotEmpty(badManagementPersonList)) {
			for (BadManagementPerson badManagementPerson : badManagementPersonList) {
				TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
				taskPersonAndImageInfo.setTaskId(taskId);
				taskPersonAndImageInfo.setPersonId(badManagementPerson.getPersonId());
				taskPersonAndImageInfo.setPersonName(badManagementPerson.getPersonName());
				badObject.add(taskPersonAndImageInfo);
			}
		}
		singTaskBadManagementVo.setBadManagementObject(badObject);

		singTaskBadManagementVo.setCreateTime(badManagement.getCreateDate());
		singTaskBadManagementVo.setStartTime(badManagement.getCreateDate());
		List<TaskPersonFile> taskPersonFiles = iTaskPersonFileService
				.list(new LambdaQueryWrapper<TaskPersonFile>().eq(TaskPersonFile::getTaskId, taskId)
						.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.CREATEPERSONFILE.getValue()));
		if (StringUtil.isNotEmpty(taskPersonFiles)) {
			List<String> filePath = new ArrayList<>();
			for (TaskPersonFile taskPersonFile : taskPersonFiles) {
				filePath.add(taskPersonFile.getFilePath().replace(fileServerUrl, ""));
			}
			singTaskBadManagementVo.setFilePath(filePath);
		}

		// 获取执行人
		if (personId != null) {
			List<TaskPerson> taskPerson1 = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
					.eq(TaskPerson::getTaskId, taskId).eq(TaskPerson::getPersonId, personId));
			singTaskBadManagementVo.setTaskPersonList(taskPerson1);
		}
		singTaskBadManagementVo.setTaskType(task.getType());
		if(taskPersonId!=null) 
		{
			TaskPerson taskPerson2 = iTaskPersonService.getById(taskPersonId);
			singTaskBadManagementVo.setTaskPerson(taskPerson2);	
		}
		return singTaskBadManagementVo;
	}

	@Override
	public Object selectById(Long id,Long taskPersonId) {
		Task task = iTaskService.getById(id);
		if (task == null) {
			throw new BaseException(BaseExceptionEnum.DATA_NOT_EXISTS);
		}
		Project project = iProjectService
				.getOne(new LambdaQueryWrapper<Project>().eq(Project::getId, task.getProjectId()));
		TaskVo taskVo = new TaskVo();
		BeanUtils.copyProperties(task, taskVo);
		if (0 == taskVo.getStatus()) {
			taskVo.setStatusName("未完成");
		} else if (1 == taskVo.getStatus()) {
			taskVo.setStatusName("已完成");
		}
		taskVo.setProjectName(project.getName());
		// 查询人 赋值
		List<TaskPerson> taskPeopleList = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, task.getId()).orderByAsc(TaskPerson::getType));

		Long createPersonId = taskVo.getCreatePersonId();
		Person person = iPersonService.getById(createPersonId);
		if (person != null) {
			taskVo.setCreatePersonName(person.getName());
		}
		List<TaskPersonDto> taskPersonDtos = new ArrayList();
		taskPeopleList.forEach(taskPerson -> {
			TaskPersonDto taskPersonDto = new TaskPersonDto();
			BeanUtils.copyProperties(taskPerson, taskPersonDto);
			taskPersonDtos.add(taskPersonDto);
		});

		// 查询文件 赋值
		List<TaskPersonFile> taskFileList = iTaskPersonFileService
				.list(new LambdaQueryWrapper<TaskPersonFile>().eq(TaskPersonFile::getTaskId, task.getId()));
		List<FileDto> fileDtos = new ArrayList();
		taskFileList.forEach(taskPersonFile -> {
			FileDto fileDto = new FileDto();
			BeanUtils.copyProperties(taskPersonFile, fileDto);
			fileDtos.add(fileDto);
		});

		if (Constant.JOB_TYPE.equals(task.getType())) {
			JobDisclosureDto jobDisclosureVo = new JobDisclosureDto();
			// 查询出任务对应的文档
			List<TaskTechDocument> taskTechDocuments = iTaskTechDocumentService
					.list(new LambdaQueryWrapper<TaskTechDocument>().select(TaskTechDocument::getTechDocumentId)
							.eq(TaskTechDocument::getTaskId, task.getId()));
			Long techDocumentId = taskTechDocuments.stream().map(t -> t.getTechDocumentId())
					.collect(Collectors.toList()).get(0);

			// 公共参数赋值
			BeanUtils.copyProperties(task, jobDisclosureVo);
			// 返回人
			jobDisclosureVo.setTaskPerson(taskPersonDtos);
			// 返回具体的内容
			taskVo.setJobDisclosure(jobDisclosureVo);
			// 判断要展示的文件是不是doc 是就考虑渲染到内容中
			List<String> content = new ArrayList<>();
			// 调用知识库feign获取html
			ResponseModel<List<Map<String, Object>>> response = knowledgeBaseFeign.getDocById(techDocumentId);
			if (response.getResult() != null) {
				List<Map<String, Object>> list = response.getResult();
				if (list.get(0) != null && list.get(0).get("htmlContent") != null) {
					content.add(String.valueOf(list.get(0).get("htmlContent")));
					taskVo.setDocContent(content);
				}
			}
		} else if (Constant.HAND_QUERY.equals(task.getType())) {
			taskVo.setFile(fileDtos);
			TaskPaycheckDto taskPaycheckDto = new TaskPaycheckDto();
			TaskPaycheck taskPaycheck1 = iTaskPaycheckService
					.getOne(new LambdaQueryWrapper<TaskPaycheck>().eq(TaskPaycheck::getTaskId, task.getId()));
			BeanUtils.copyProperties(taskPaycheck1, taskPaycheckDto);
			taskPaycheckDto.setWeatherName(task.getWeather());
			taskPaycheckDto.setRiskType(taskPaycheck1.getRiskType());
			taskPaycheckDto.setTaskPerson(taskPersonDtos);
			taskPaycheckDto.setWorkTicketName(taskPaycheck1.getWorkTicketName());
			taskVo.setTaskPaycheck(taskPaycheckDto);
			// 获取安全作业票相关信息 已经copy 作业票属性
			List<TaskPersonFile> workTicket = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
					.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.JOBTICKET.getValue())
					.eq(TaskPersonFile::getTaskId, taskVo.getId()));
			if (StringUtil.isNotEmpty(workTicket)) {
				List<String> collect = workTicket.stream().map(work -> work.getFilePath()).collect(Collectors.toList());
				taskPaycheckDto.setWorkTicketFilePath(collect);
			}

			// 检查项项目
			List<HazardousWorkResult> list = iHazardousWorkResultService
					.list(new LambdaQueryWrapper<HazardousWorkResult>()
							.eq(HazardousWorkResult::getHazardousWorkId, taskPaycheckDto.getRiskTypeId())
							.eq(HazardousWorkResult::getTaskId, taskVo.getId()));
			taskPaycheckDto.setHazardousWorkResultList(list);

			// 三交三查附件
			List<TaskPersonFile> attachment = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
					.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.FILE.getValue())
					.eq(TaskPersonFile::getTaskId, taskVo.getId()));
			if (StringUtil.isNotEmpty(workTicket)) {
				List<String> collect = attachment.stream().map(e -> e.getFilePath()).collect(Collectors.toList());
				taskPaycheckDto.setAttachment(collect);
			}
		} else if (Constant.BAD_MANAGEMENT.equals(task.getType())) {
			taskVo.setFile(fileDtos);
			BadManangerDto badManangerDto = new BadManangerDto();
			BadManagement badMananger1 = iBadManagementService
					.getOne(new LambdaQueryWrapper<BadManagement>().eq(BadManagement::getTaskId, task.getId()));
			BeanUtils.copyProperties(badMananger1, badManangerDto);
			// 名称format
			Company company = iCompanyService.getById(badManangerDto.getCompanyId());
			if (company != null) {
				badManangerDto.setCompanyName(company.getName());
			}
			Person person1 = iPersonService.getById(badManangerDto.getPersonLiable());
			if (person1 != null) {
				badManangerDto.setPersonLiableName(person1.getName());
			}
			badManangerDto.setBadText(badMananger1.getBody());

			List<BadManagementPerson> badManagementPersonList = ibadManagementPersonService
					.list(new LambdaQueryWrapper<BadManagementPerson>().eq(BadManagementPerson::getTaskId, id));
			if (StringUtil.isNotEmpty(badManagementPersonList)) {
				for (BadManagementPerson badManagementPerson : badManagementPersonList) {
					TaskPersonDto taskPerson = new TaskPersonDto();
					taskPerson.setTaskId(task.getId());
					taskPerson.setPersonId(badManagementPerson.getPersonId());
					taskPerson.setPersonName(badManagementPerson.getPersonName());
					taskPerson.setType(TaskPersonTypeEnum.ILLEGAL.getValue());
					taskPersonDtos.add(taskPerson);
				}
			}
			badManangerDto.setTaskPerson(taskPersonDtos);
			taskVo.setBadMananger(badManangerDto);
		}
		TaskVo qrCodeTaskVo = new TaskVo();
		qrCodeTaskVo.setId(id);
		qrCodeTaskVo.setType(task.getType());
		taskVo.setQrCode(QRCodeUtil.generateQrCodeImageByteData(JSONObject.toJSONString(qrCodeTaskVo)));
		return taskVo;
	}

	@Override
	public String exportDoc(Long id, HttpServletRequest request, HttpServletResponse response) throws IOException {
		Task task = iTaskService.getById(id);
		if (task == null) {
			log.error("========================" + BaseExceptionEnum.DATA_NOT_EXISTS.getMsg());
			return BaseExceptionEnum.DATA_NOT_EXISTS.getMsg();
		}
		TaskVo taskVo = new TaskVo();
		BeanUtils.copyProperties(task, taskVo);
		taskVo.setQrCode(QRCodeUtil.generateQrCodeImageByteData(projectIp + ":" + apiPort + apiContext + "/task/" + id,
				100, 100));
		if (StatusEnum.UNFINISHED.getValue().equals(taskVo.getStatus())) {
			taskVo.setStatusName("未完成");
		} else if (StatusEnum.SUCCESS.getValue().equals(taskVo.getStatus())) {
			taskVo.setStatusName("已完成");
		}
		Project project = iProjectService
				.getOne(new LambdaQueryWrapper<Project>().eq(Project::getId, task.getProjectId()));
		taskVo.setProjectName(project.getName());
		// 查询人 赋值
		List<TaskPerson> taskPeopleList = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, task.getId()).orderByAsc(TaskPerson::getType));

		Long createPersonId = taskVo.getCreatePersonId();
		Person person = iPersonService.getById(createPersonId);
		if (person != null) {
			taskVo.setCreatePersonName(person.getName());
		}

		List<TaskPersonDto> taskPersonDtos = new ArrayList();
		taskPeopleList.forEach(taskPerson -> {
			TaskPersonDto taskPersonDto = new TaskPersonDto();
			BeanUtils.copyProperties(taskPerson, taskPersonDto);
			taskPersonDtos.add(taskPersonDto);
		});

		// 查询文件 赋值
		List<TaskPersonFile> taskFileList = iTaskPersonFileService
				.list(new LambdaQueryWrapper<TaskPersonFile>().eq(TaskPersonFile::getTaskId, task.getId()));
		List<FileDto> fileDtos = new ArrayList();
		taskFileList.forEach(taskPersonFile -> {
			FileDto fileDto = new FileDto();
			BeanUtils.copyProperties(taskPersonFile, fileDto);
			fileDtos.add(fileDto);
		});

		Long type = task.getType();
		WordTemplateUtils instance = WordTemplateUtils.getInstance();
		Map<String, Object> map = new HashMap<>();

		if (Constant.JOB_TYPE.equals(type)) {
			List<TaskTechDocument> taskTechDocumentList = iTaskTechDocumentService
					.list(new LambdaQueryWrapper<TaskTechDocument>().select(TaskTechDocument::getTechDocumentId)
							.eq(TaskTechDocument::getTaskId, id));
			List<Long> documentIds = new ArrayList<>();
			taskTechDocumentList.forEach(taskTechDocument -> documentIds.add(taskTechDocument.getTechDocumentId()));
			List<String> content = new ArrayList<>();
			// 因为不支持从html的base64 所以需要发网络请求
			byte[] qrCode = taskVo.getQrCode();
			MultipartFile file = new MockMultipartFile("tempFile", "tempQr.png",
					ContentType.APPLICATION_OCTET_STREAM.toString(), qrCode);
			String uploadfile = fileService.uploadfile(file);
			JobDisclosureDto jobDisclosureVo = new JobDisclosureDto();
			// 查询出任务对应的文档
			List<TaskTechDocument> taskTechDocuments = iTaskTechDocumentService
					.list(new LambdaQueryWrapper<TaskTechDocument>().select(TaskTechDocument::getTechDocumentId)
							.eq(TaskTechDocument::getTaskId, task.getId()));
			if (StringUtil.isNotEmpty(taskTechDocuments)) {
				Long techDocumentId = taskTechDocuments.stream().map(t -> t.getTechDocumentId())
						.collect(Collectors.toList()).get(0);
				// 调用知识库feign获取html
				ResponseModel<List<Map<String, Object>>> result = knowledgeBaseFeign.getDocById(techDocumentId);
				if (result.getResult() != null) {
					List<Map<String, Object>> doclist = result.getResult();
					if (doclist.get(0) != null && doclist.get(0).get("htmlContent") != null) {
						content.add(String.valueOf(doclist.get(0).get("htmlContent")));
						taskVo.setDocContent(content);
					}
				}
			}
			// 公共参数赋值
			BeanUtils.copyProperties(task, jobDisclosureVo);
			// 返回人
			jobDisclosureVo.setTaskPerson(taskPersonDtos);
			// 返回具体的内容
			taskVo.setJobDisclosure(jobDisclosureVo);
			map.put("code", taskVo.getJobDisclosure().getCode());

			map.put("qrCode", fileServerUrl + uploadfile);
			map.put("number", taskVo.getJobDisclosure().getNumber());
			map.put("projectName", taskVo.getProjectName());
			map.put("name", taskVo.getJobDisclosure().getName());
			map.put("createDate", taskVo.getCreateDate());
			map.put("fileList", content);

			// 主持人
			List<TaskPersonAndImageInfo> hostPersonObject = new ArrayList<>();
//			//交底人
//			List<TaskPersonAndImageInfo> disclosurePersonObject = new ArrayList<>();
			// 施工负责人
			List<TaskPersonAndImageInfo> constructionDirectorObject = new ArrayList<>();
			// 安全员
			List<TaskPersonAndImageInfo> safetyOfficerrObject = new ArrayList<>();
			// 交底人员
			List<TaskPersonAndImageInfo> participateDisclosureObject = new ArrayList<>();
			// 记录人
			List<TaskPersonAndImageInfo> noteTakerObject = new ArrayList<>();

			if (StringUtil.isNotEmpty(taskPersonDtos)) {
				taskPersonDtos.forEach(taskPersonDto -> {
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.HOSTPERSON.getValue())) {
						getTaskPersonAndImage(hostPersonObject, taskPersonDto);
					}
//					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.DISCLOSUREPERSON.getValue())) {
//						getTaskPersonAndImage(disclosurePersonObject, taskPersonDto);
//					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.CONSTRUCTIONDIRECTOR.getValue())) {
						getTaskPersonAndImage(constructionDirectorObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.SAFETYOFFICER.getValue())) {
						getTaskPersonAndImage(safetyOfficerrObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.PARTICIPATEDISCLOSURE.getValue())) {
						getTaskPersonAndImage(participateDisclosureObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.NOTETAKER.getValue())) {
						getTaskPersonAndImage(noteTakerObject, taskPersonDto);
					}
				});
				map.put("hostPersonObject", hostPersonObject);
				// map.put("disclosurePerson", disclosurePersonObject);
				map.put("constructionDirectorObject", constructionDirectorObject);
				map.put("safetyOfficerrObject", safetyOfficerrObject);
				map.put("participateDisclosureObject", participateDisclosureObject);
				map.put("noteTakerObject", noteTakerObject);
			}

			List<TaskPersonFile> attachment = iTaskPersonFileService
					.list(new LambdaQueryWrapper<TaskPersonFile>().eq(TaskPersonFile::getTaskId, taskVo.getId()));
			if (StringUtil.isNotEmpty(attachment)) {
				attachment.forEach(item -> {
					if (item.getFilePath().contains("pdf")) {
						// 此处借用personType属性 作为文件类型字段 用去模板区分文件是否pdf
						item.setPersonType("pdf");
					}
				});
				map.put("fileServerUrl", fileServerUrl);
				map.put("attachment", attachment);
			}
			// 导出技术交底的模板
			instance.exportMillCertificateWord(request, response, map, WordTemplateTypeEum.job_type.getLabel(),
					WordTemplateTypeEum.job_type.getTemplateFile());
		} else if (Constant.HAND_QUERY.equals(type)) {
			TaskPaycheckDto taskPaycheckDto = new TaskPaycheckDto();
			TaskPaycheck taskPaycheck1 = iTaskPaycheckService
					.getOne(new LambdaQueryWrapper<TaskPaycheck>().eq(TaskPaycheck::getTaskId, task.getId()));
			BeanUtils.copyProperties(taskPaycheck1, taskPaycheckDto);
			taskPaycheckDto.setWeatherName(task.getWeather());
			taskPaycheckDto.setRiskType(taskPaycheck1.getRiskType());
			taskPaycheckDto.setTaskPerson(taskPersonDtos);
			taskPaycheckDto.setRiskOperation(taskPaycheck1.getRiskOperation());
			taskVo.setTaskPaycheck(taskPaycheckDto);

			// 存储对应的人 0主持人，1交底人，2施工负责人，3安全员，4交底人员，5记录人，6技术员，7工程人员，8施工人员，9违章人员 10 分包商负责人
			// 11审核人 12违规发起人 13平台分包商安全员（项目安全员） 99 发布人
			List<TaskPersonDto> taskPerson = taskVo.getTaskPaycheck().getTaskPerson();

			map.put("projectName", taskVo.getProjectName());
			map.put("createDate", taskVo.getCreateDate());
			map.put("weatherName", taskPaycheckDto.getWeatherName());
			map.put("Week", DateTools.dateToWeek(taskVo.getCreateDate()));
			map.put("createPersonName", taskVo.getCreatePersonName());
			map.put("workTicketName", taskPaycheckDto.getWorkTicketName());
			map.put("riskJob", "1".equals(taskPaycheckDto.getRiskOperation() + "") ? "是" : "否");
			map.put("riskOperation", taskPaycheckDto.getRiskOperation());
			if (StringUtil.isNotEmpty(taskPerson)) {
				List<TaskPersonAndImageInfo> builderObject = new ArrayList<>();
				List<TaskPersonAndImageInfo> safetyofficerObject = new ArrayList<>();
				List<TaskPersonAndImageInfo> platFormSafetyofficerObject = new ArrayList<>();
				List<TaskPersonAndImageInfo> technicianObject = new ArrayList<>();
				List<TaskPersonAndImageInfo> engineeringstaffObject = new ArrayList<>();
				taskPerson.forEach(taskPersonDto -> {
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.BUILDER.getValue())) {
						getTaskPersonAndImage(builderObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.SAFETYOFFICER.getValue())) {
						getTaskPersonAndImage(safetyofficerObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue())) {
						getTaskPersonAndImage(platFormSafetyofficerObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.TECHNICIAN.getValue())) {
						getTaskPersonAndImage(technicianObject, taskPersonDto);
					}
					if (taskPersonDto.getType().equals(TaskPersonTypeEnum.ENGINEERINGSTAFF.getValue())) {
						getTaskPersonAndImage(engineeringstaffObject, taskPersonDto);
					}
				});
				map.put("engineeringStaff", engineeringstaffObject);
				map.put("technician", technicianObject);
				map.put("safetyOfficer", safetyofficerObject);
				map.put("platformSafetyOfficer", platFormSafetyofficerObject);
				map.put("builderPerson", builderObject);
			}
			// 施工任务 技术要求 安全环保措施
			map.put("constructionTask", taskPaycheckDto.getConstructionTask().intValue() == 1 ? "已下发" : "未下发");
			map.put("technicalRequire", taskPaycheckDto.getTechnicalRequire().intValue() == 1 ? "已下发" : "未下发");
			map.put("environmentProtect", taskPaycheckDto.getEnvironmentProtect().intValue() == 1 ? "已下发" : "未下发");

			// 着装 三宝(安全帽、安全带、安全鞋) 精神状态
			map.put("dress", taskPaycheckDto.getDress().intValue() == 1 ? "合格" : "不合格");
			map.put("saftTreasure", taskPaycheckDto.getSaftTreasure().intValue() == 1 ? "合格" : "不合格");
			map.put("mentalState", taskPaycheckDto.getMentalState().intValue() == 1 ? "合格" : "不合格");

			// 获取安全作业票相关信息 已经copy 作业票属性
			List<TaskPersonFile> workTicket = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
					.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.JOBTICKET.getValue())
					.eq(TaskPersonFile::getTaskId, taskVo.getId()));
			if (StringUtil.isNotEmpty(workTicket)) {
				List<String> collect = workTicket.stream().map(work -> fileServerUrl + work.getFilePath())
						.collect(Collectors.toList());
				map.put("workTicketFile", collect);
			}
			// 检查项项目
			List<HazardousWorkResult> list = iHazardousWorkResultService
					.list(new LambdaQueryWrapper<HazardousWorkResult>()
							.eq(HazardousWorkResult::getHazardousWorkId, taskPaycheckDto.getRiskTypeId())
							.eq(HazardousWorkResult::getTaskId, taskVo.getId()).eq(HazardousWorkResult::getWeight, 1));
			if (null != list && list.size() > 0) {
				// 检查项结果默认为null doc中显示，将null值替换为具体值
				list.forEach(item -> {
					if (null == item.getIsOk()) {
						item.setIsOk(3L);
					}
				});
			}
			map.put("riskType", taskPaycheckDto.getRiskType());
			map.put("hazardousWorkList", list);
			map.put("hazardousWorkSize",
					list.size() + list.stream().filter(res -> res.getIsOk() != 1).collect(Collectors.toList()).size());
			// 三交三查附件
			List<TaskPersonFile> attachment = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
					.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.FILE.getValue())
					.eq(TaskPersonFile::getTaskId, taskVo.getId()));
			if (StringUtil.isNotEmpty(attachment)) {
				List<String> collect = attachment.stream().map(e -> fileServerUrl + e.getFilePath())
						.collect(Collectors.toList());
				map.put("attachment", collect);
			}
			// 导出三交三查的模板
			instance.exportMillCertificateWord(request, response, map, WordTemplateTypeEum.hand_query.getLabel(),
					WordTemplateTypeEum.hand_query.getTemplateFile());

		} else if (Constant.BAD_MANAGEMENT.equals(task.getType())) {
			// 导出违规管理的模板
			BadManangerDto badManangerDto = new BadManangerDto();
			BadManagement badMananger1 = iBadManagementService
					.getOne(new LambdaQueryWrapper<BadManagement>().eq(BadManagement::getTaskId, task.getId()));
			BeanUtils.copyProperties(badMananger1, badManangerDto);
			badManangerDto.setBadText(badMananger1.getBody());
			// 名称format
			Company company = iCompanyService.getById(badManangerDto.getCompanyId());
			if (company != null) {
				badManangerDto.setCompanyName(company.getName());
			}
			Person person1 = iPersonService.getById(badManangerDto.getPersonLiable());
			if (person1 != null) {
				badManangerDto.setPersonLiableName(person1.getName());
			}
			map.put("projectName", taskVo.getProjectName());
			map.put("createDate", taskVo.getCreateDate());
			map.put("badText", badManangerDto.getBadText());
			map.put("companyName", badManangerDto.getCompanyName());
			map.put("personLiableName", badManangerDto.getPersonLiableName());
			map.put("nature", badManangerDto.getNature());

			// 审核人
			TaskPerson taskPerson = iTaskPersonService.getOne(new LambdaQueryWrapper<TaskPerson>()
					.eq(TaskPerson::getTaskId, task.getId()).eq(TaskPerson::getType, 12));
			Person auditor = iPersonService.getById(taskPerson.getPersonId());
			map.put("auditor", auditor == null ? "" : auditor.getName());
			// 发起人
			map.put("safetyOfficer", taskVo.getCreatePersonName());
			map.put("badType", badMananger1.getType());
			// 违规人员
			List<BadManagementPerson> badManagementPersonList = ibadManagementPersonService
					.list(new LambdaQueryWrapper<BadManagementPerson>().eq(BadManagementPerson::getTaskId, id));
			map.put("badPerson", StringUtil.isEmpty(badManagementPersonList) ? null : badManagementPersonList);
			// 违规照片
			List<String> badPersonPhoto = new ArrayList<>();
			if (StringUtil.isNotEmpty(fileDtos)) {
				fileDtos.forEach(fileDto -> {
					System.out.println(TaskPersonTypeEnum.CREATEPERSON.getValue().toString());
					System.out.println(fileDto.getPersonType());
					if (TaskPersonTypeEnum.CREATEPERSON.getValue().toString().equals(fileDto.getPersonType())) {
						badPersonPhoto.add(fileServerUrl + fileDto.getFilePath());
					}
				});
				map.put("badPersonPhoto", badPersonPhoto);
			}

			// 导出违规管理的模板
			instance.exportMillCertificateWord(request, response, map, WordTemplateTypeEum.bad_management.getLabel(),
					WordTemplateTypeEum.bad_management.getTemplateFile());
		} else if (Constant.RISK_WORK.equals(task.getType())) {
			// 危险作业
			TaskRiskControl taskRiskControl = iTaskRiskControlService
					.getOne(new LambdaQueryWrapper<TaskRiskControl>().eq(TaskRiskControl::getTaskId, task.getId()));
			TaskRiskControlVo taskRiskControlVo = iTaskRiskControlService.taskDetail(taskRiskControl.getId(), null);
			Integer checkLength = 0;
			checkLength = (taskRiskControlVo.getMeasureResultList() != null
					&& taskRiskControlVo.getMeasureResultList().size() > 0)
							? (taskRiskControlVo.getMeasureResultList().size() * 2)
							: 0;
			for (HazardousWorkVo e : taskRiskControlVo.getHazardWorkList()) {
				if (e.getHazardousWorkResultList() != null && e.getHazardousWorkResultList().size() > 0) {
					checkLength = checkLength + e.getHazardousWorkResultList().size();
				}
			}

			// 项目部安全员
			ArrayList<Object> secImgs = new ArrayList<Object>();
			Integer secImgLength = 0;
			List<TaskPersonAndImageInfo> imageList = taskRiskControlVo.getImageList();
			List<TaskPersonAndImageInfo> projectSafetyOfficerList = imageList.stream()
					.filter(e -> TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue().equals(e.getTaskPersonRoleType()))
					.collect(Collectors.toList());
			int projectSafetyOfficerIndexNum = 0;
			for (TaskPersonAndImageInfo item : projectSafetyOfficerList) {
				for (TaskPersonAndImageInfo e : imageList) {
					if (e.getPersonId().equals(item.getPersonId()) && e.getPersonName() != null) {
						Map<Date, List<TaskFileVo>> timeFilePath = e.getTimeFilePath();
						Iterator entries = timeFilePath.entrySet().iterator();
						int i = 0;
						while (entries.hasNext()) {
							secImgLength = secImgLength + 1;
							Map.Entry entry = (Map.Entry) entries.next();
							Map imgMap = new HashMap();
							imgMap.put("key", i);
							if (i == 0 && projectSafetyOfficerIndexNum == 0) {
								imgMap.put("type", "安全员");
							}
							if (i == 0) {
								imgMap.put("name", e.getPersonName());
							}
							imgMap.put("nameRowSpan", timeFilePath.size());
							imgMap.put("date", entry.getKey());
							// 处理图片
							List<TaskFileVo> imgs = null;
							if (entry.getValue() != null) {
								imgs = (List<TaskFileVo>) entry.getValue();
								for (TaskFileVo img : imgs) {
									img.setFilePath(fileServerUrl + img.getFilePath());
								}
							}
							imgMap.put("imgs", imgs);
							secImgs.add(imgMap);
							i++;
						}
					}
				}
				projectSafetyOfficerIndexNum++;
			}
			// 技术员
			ArrayList<Object> techImgs = new ArrayList<Object>();
			Integer techImgLength = 0;
			List<TaskPersonAndImageInfo> technicianList = imageList.stream()
					.filter(e -> TaskPersonTypeEnum.TECHNICIAN.getValue().equals(e.getTaskPersonRoleType()))
					.collect(Collectors.toList());
			int technicianIndexNum = 0;
			for (TaskPersonAndImageInfo item : technicianList) {
				for (TaskPersonAndImageInfo e : imageList) {
					if (e.getPersonId().equals(item.getPersonId()) && e.getPersonName() != null) {
						Map<Date, List<TaskFileVo>> timeFilePath = e.getTimeFilePath();
						Iterator entries = timeFilePath.entrySet().iterator();
						int i = 0;
						while (entries.hasNext()) {
							techImgLength = techImgLength + 1;
							Map.Entry entry = (Map.Entry) entries.next();
							Map imgMap = new HashMap();
							imgMap.put("key", i);
							if (i == 0 && technicianIndexNum == 0) {
								imgMap.put("type", "安全员");
							}
							if (i == 0) {
								imgMap.put("name", e.getPersonName());
							}
							imgMap.put("nameRowSpan", timeFilePath.size());
							imgMap.put("date", entry.getKey());
							// 处理图片
							List<TaskFileVo> imgs = null;
							if (entry.getValue() != null) {
								imgs = (List<TaskFileVo>) entry.getValue();
								for (TaskFileVo img : imgs) {
									img.setFilePath(fileServerUrl + img.getFilePath());
								}
							}
							imgMap.put("imgs", imgs);
							techImgs.add(imgMap);
							i++;
						}
					}
				}
				technicianIndexNum++;
			}
			map.put("checkLength", checkLength + 2);
			map.put("secImgLength", secImgLength);
			map.put("secImgs", secImgs);
			map.put("techImgLength", techImgLength);
			map.put("techImgs", techImgs);
			map.put("taskRiskControl", taskRiskControlVo);
			// 导出危险作业的模板
			instance.exportMillCertificateWord(request, response, map, WordTemplateTypeEum.risk_work.getLabel(),
					WordTemplateTypeEum.risk_work.getTemplateFile());
		}
		return null;
	}

	private void getTaskPersonAndImage(List<TaskPersonAndImageInfo> object, TaskPersonDto taskPersonDto) {
		TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
		taskPersonAndImageInfo.setTaskId(taskPersonDto.getTaskId());
		taskPersonAndImageInfo.setPersonId(taskPersonDto.getPersonId());
		taskPersonAndImageInfo.setPersonName(taskPersonDto.getPersonName());
		taskPersonAndImageInfo.setType(taskPersonDto.getType());
		taskPersonAndImageInfo.setReadStatus(taskPersonDto.getReadStatus());
		// 根据对应的人查询文件
		TaskPerson taskPersonParam = new TaskPerson();
		taskPersonParam.setType(taskPersonDto.getType());
		taskPersonParam.setPersonId(taskPersonDto.getPersonId());
		getFileByUserId(taskPersonDto.getTaskId(), taskPersonParam, taskPersonAndImageInfo, true);
		object.add(taskPersonAndImageInfo);
	}

	private void getTaskPersonAndImageVo(List<TaskPersonAndImageInfoVo> object, TaskPersonDto taskPersonDto) {
		TaskPersonAndImageInfoVo taskPersonAndImageInfoVo = new TaskPersonAndImageInfoVo();
		taskPersonAndImageInfoVo.setTaskId(taskPersonDto.getTaskId());
		taskPersonAndImageInfoVo.setPersonId(taskPersonDto.getPersonId());
		taskPersonAndImageInfoVo.setPersonName(taskPersonDto.getPersonName());
		taskPersonAndImageInfoVo.setType(taskPersonDto.getType());
		taskPersonAndImageInfoVo.setReadStatus(taskPersonDto.getReadStatus());
		taskPersonAndImageInfoVo.setReadTime(taskPersonDto.getReadTime());
		// 根据对应的人查询文件
		TaskPerson taskPersonParam = new TaskPerson();
		taskPersonParam.setType(taskPersonDto.getType());
		taskPersonParam.setPersonId(taskPersonDto.getPersonId());
		getFileByUserId(taskPersonDto.getTaskId(), taskPersonParam, taskPersonAndImageInfoVo, true);
		object.add(taskPersonAndImageInfoVo);
	}

	private void getTaskPersonVo(List<TaskPersonAndImageInfoVo> object, TaskPersonDto taskPersonDto) {
		TaskPersonAndImageInfoVo taskPersonAndImageInfoVo = new TaskPersonAndImageInfoVo();
		taskPersonAndImageInfoVo.setTaskId(taskPersonDto.getTaskId());
		taskPersonAndImageInfoVo.setPersonId(taskPersonDto.getPersonId());
		taskPersonAndImageInfoVo.setPersonName(taskPersonDto.getPersonName());
		taskPersonAndImageInfoVo.setType(taskPersonDto.getType());
		taskPersonAndImageInfoVo.setReadStatus(taskPersonDto.getReadStatus());
		taskPersonAndImageInfoVo.setReadTime(taskPersonDto.getReadTime());
		// 根据对应的人查询文件
		TaskPerson taskPersonParam = new TaskPerson();
		taskPersonParam.setType(taskPersonDto.getType());
		taskPersonParam.setPersonId(taskPersonDto.getPersonId());
		getFileByUserId(taskPersonDto.getTaskId(), taskPersonParam, taskPersonAndImageInfoVo, false);
		object.add(taskPersonAndImageInfoVo);
	}

	@Override
	public void recommitBadManagement(SingBadManagementDto singBadManagementDto, Person curPerson) {
		Task task = new Task();
		task.setId(singBadManagementDto.getId());
		task.setProjectId(singBadManagementDto.getProjectId());
		Project project = iProjectService.getById(singBadManagementDto.getProjectId());
		if (project == null) {
			throw new BaseException("所选项目不存在");
		}
		task.setProjectName(project.getName());
		task.setCreateDate(new Date());
		task.setStatus(Long.valueOf(TaskStatusEnum.TOAUDIT.getType()));
		iTaskService.updateById(task);

		Long taskId = singBadManagementDto.getId();
		BadManagement badMananger = new BadManagement();
		badMananger.setBody(singBadManagementDto.getBody());
		badMananger.setTaskId(taskId);
		badMananger.setCompanyId(singBadManagementDto.getCompanyId());
		badMananger.setPersonLiable(singBadManagementDto.getPersonLiableId());
		badMananger.setType(singBadManagementDto.getType());
		badMananger.setNature(singBadManagementDto.getNature());
		badMananger.setCreateDate(new Date());
		iBadManagementService.update(badMananger,
				new LambdaQueryWrapper<BadManagement>().eq(BadManagement::getTaskId, taskId));

		// 变更审核人
		TaskPerson auditTaskPerson = new TaskPerson();
		auditTaskPerson.setTaskId(taskId);
		auditTaskPerson.setPersonId(singBadManagementDto.getAuditPersonId());
		Person auditPerson = iPersonService.getById(singBadManagementDto.getAuditPersonId());
		auditTaskPerson.setPersonName(auditPerson.getName());
		auditTaskPerson.setReadStatus(StatusEnum.UNFINISHED.getValue());
		PersonAscription auditPersonAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId,
						singBadManagementDto.getAuditPersonId()));
		auditTaskPerson.setCompanyId(auditPersonAscription.getCompanyId());
		iTaskPersonService.update(auditTaskPerson, new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, taskId).eq(TaskPerson::getType, TaskPersonTypeEnum.REVIEWER.getValue()));

		// 保存分包商负责人
		TaskPerson taskPerson = new TaskPerson();
		taskPerson.setTaskId(taskId);
		taskPerson.setPersonId(singBadManagementDto.getPersonLiableId());
		Person person = iPersonService.getById(singBadManagementDto.getPersonLiableId());
		taskPerson.setPersonName(person.getName());
		taskPerson.setReadStatus(StatusEnum.UNFINISHED.getValue());
		PersonAscription personAscription = iPersonAscriptionService.getOne(new LambdaQueryWrapper<PersonAscription>()
				.eq(PersonAscription::getPersonId, singBadManagementDto.getPersonLiableId()));
		taskPerson.setCompanyId(personAscription.getCompanyId());
		iTaskPersonService.update(taskPerson, new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getTaskId, taskId)
				.eq(TaskPerson::getType, TaskPersonTypeEnum.SUBCONTRACTOR.getValue()));
		// 删除旧附件
		iTaskPersonFileService.remove(new LambdaQueryWrapper<TaskPersonFile>().eq(TaskPersonFile::getTaskId, taskId));
		// 添加新附件
		List<String> filePath = singBadManagementDto.getFilePath();
		if (!filePath.isEmpty()) {
			for (String path : filePath) {
				TaskPersonFile taskPersonFile = new TaskPersonFile();
				taskPersonFile.setTaskId(taskId);
				taskPersonFile.setPersonId(curPerson.getId());
				taskPersonFile.setPersonType(TaskPersonFileEnum.CREATEPERSONFILE.getValue());
				taskPersonFile.setFilePath(path.replace(fileServerUrl, ""));
				iTaskPersonFileService.save(taskPersonFile);
			}
		}
		translateEventPublish.publish(task);

		// 微信服务通知
		List<Person> persons = iPersonService.list(new LambdaQueryWrapper<Person>()
				.in(Person::getId, Arrays.asList(singBadManagementDto.getAuditPersonId()))
				.isNotNull(Person::getOpenId));
		List<String> openIds = persons.stream().map(Person::getOpenId).collect(Collectors.toList());
		List<String> messages = new ArrayList<>();
		messages.add(smallProService.getName());
		messages.add(badMananger.getNature());
		messages.add(badMananger.getType());
		messages.add(DateUtils.getDateNowString());
		smallProService.sendWeChatUpcomingMessage(openIds, WeChatMsgTemplateTypeEum.TODO.getValue(), messages);
	}

	@Override
	public Object list(ReginParams reginInfo, boolean fbsRole, CommonPageableDto pageable, TaskPageDto taskPageDto,
			Long operType, List<Long> ids, HttpServletResponse response) {
		String fileName = UUID.randomUUID().toString() + ".xls";
		taskPageDto.setIds(ids);

		Person person;
		Long companyId = null;
		String roleName = null;
		if (reginInfo != null) {
			person = reginInfo.getPerson();
			if (reginInfo.getCompany() != null) {
				companyId = reginInfo.getCompany().getId();
			}
			if (reginInfo.getRole() != null) {
				roleName = reginInfo.getRole().getRoleName();
			}
		} else {
			// 没有平台角色直接访问
			IPage<TaskPageVo> page = iTaskService.listByPage(pageable, taskPageDto);
			if (operType == 1) {
				List<TaskPageVo> excelList = page.getRecords();
				FileHelper.exportExcel(excelList, "安全作业执行清单", "安全作业执行信息", TaskPageVo.class, fileName, response);
				return null;
			} else {
				return page;
			}
		}
		if (fbsRole) {
			switch (roleName) {
			// 管理员
			case "fbs_admin":
				List<PersonAscription> list = iPersonAscriptionService
						.list(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getCompanyId, companyId));
				// 当前企业的参加的多个项目
				List<Long> projectIds = list.stream().map(personAscription -> personAscription.getProjectId())
						.collect(Collectors.toList());
				taskPageDto.setProjectIds(projectIds);
				taskPageDto.setCompanyId(companyId);
				break;
			// 班长
			case "fbs_monitor":
				taskPolicyByPerson(taskPageDto, person);
				taskPageDto.setUserId(person.getId());
				taskPageDto.setCompanyId(companyId);
				break;
			// 技术员
			case "fbs_technician":
				taskPolicyByPerson(taskPageDto, person);
				taskPageDto.setUserId(person.getId());
				taskPageDto.setCompanyId(companyId);
				break;
			// 安全员
			case "fbs_security":
				taskPolicyByPerson(taskPageDto, person);
				taskPageDto.setUserId(person.getId());
				taskPageDto.setCompanyId(companyId);
				break;
			// 质量员
			case "fbs_qc":
				taskPolicyByPerson(taskPageDto, person);
				taskPageDto.setCompanyId(companyId);
				break;
			// 施工员
			case "fbs_worker":
				taskPageDto.setUserId(person.getId());
				taskPageDto.setCompanyId(companyId);
				break;
			default:
				taskPageDto.setUserId(person.getId());
				taskPageDto.setCompanyId(companyId);
			}
		}
		IPage<TaskPageVo> page = iTaskService.listByPage(pageable, taskPageDto);
		if (operType == 1) {
			List<TaskPageVo> excelList = page.getRecords();
			FileHelper.exportExcel(excelList, "安全作业执行清单", "安全作业执行信息", TaskPageVo.class, fileName, response);
			return null;
		} else {
			return page;
		}
	}

	@Override
	public Object createPersonTask(Person person) {
		// 通过自己的token和信息 去查找三交三查的任务
		Long personId = person.getId();
		List<TaskPersonAndImageInfo> createPersonInfo = taskMapper.createPersonTask(personId);
		for (TaskPersonAndImageInfo taskPersonAndImageInfo : createPersonInfo) {
			if (taskPersonAndImageInfo.getStatus().equals(String.valueOf(TaskStatusEnum.UNCOMPLETED.getType()))) {
				taskPersonAndImageInfo.setStatusName("未完成");
			} else if (taskPersonAndImageInfo.getStatus().equals(String.valueOf(TaskStatusEnum.COMPLETED.getType()))) {
				taskPersonAndImageInfo.setStatusName("已完成");
			} else if (taskPersonAndImageInfo.getStatus().equals(String.valueOf(TaskStatusEnum.TOAUDIT.getType()))) {
				taskPersonAndImageInfo.setStatusName("待审核");
			} else if (taskPersonAndImageInfo.getStatus().equals(String.valueOf(TaskStatusEnum.RETURNED.getType()))) {
				taskPersonAndImageInfo.setStatusName("驳回");
			}
			taskPersonAndImageInfo.setTaskPersonRoleType(taskPersonAndImageInfo.getType());
			taskPersonAndImageInfo.setCreatePersonName(taskPersonAndImageInfo.getPersonName());
		}
		return createPersonInfo;
	}

	@Override
	public Object newSelectById(Long id,Long taskPersonId) {
		Task task = iTaskService.getById(id);
		if (task == null) {
			throw new BaseException("任务不存在");
		}
		Long type = task.getType();
		if (TaskTypeEnum.JOBDISCLOSURE.getValue().equals(type)) {
			return iTaskService.getJobDisclosure(id, taskPersonId);
		}
		if (TaskTypeEnum.TASKPAYCHECK.getValue().equals(type)) {
			return iTaskService.getTaskPayCheck(id,taskPersonId);
		}
		if (TaskTypeEnum.BAD.getValue().equals(type)) {
			return iTaskService.getBadManagement(id, null, taskPersonId);
		}
		return null;
	}

	@Override
	public Object visualTaskPayCheck(Task task) {
		Long taskId = task.getId();
		TaskPaycheck taskPaycheck = iTaskPaycheckService
				.getOne(new LambdaQueryWrapper<TaskPaycheck>().eq(TaskPaycheck::getTaskId, taskId));
		Long riskOperation = taskPaycheck.getRiskOperation();
		TaskPayCheckVisualVo taskPayCheckVisualVo = new TaskPayCheckVisualVo();
		taskPayCheckVisualVo.setTaskId(taskId);
		taskPayCheckVisualVo.setProjectName(task.getProjectName());
		List<TaskPersonAndImageInfoVo> taskPersonAndImageInfoVos = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> builderObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> safetyofficerObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> platFormSafetyofficerObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> technicianObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> engineeringstaffObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> createPersonObject = new ArrayList<>();
		List<TaskProcessInfo> taskProcessInfoList = new LinkedList<>();
		// 风险作业
		List<TaskPersonDto> taskPersonDtoList = new ArrayList<>();
		List<TaskPerson> taskPerson = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, taskId).orderByDesc(TaskPerson::getReadTime));
		if (StringUtil.isNotEmpty(taskPerson)) {
			taskPerson.forEach(t -> {
				TaskPersonDto taskPersonDto = new TaskPersonDto();
				BeanUtils.copyProperties(t, taskPersonDto);
				taskPersonDtoList.add(taskPersonDto);
			});
		}
		if (StringUtil.isNotEmpty(taskPersonDtoList)) {
			taskPersonDtoList.forEach(taskPersonDto -> {
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.BUILDER.getValue())) {
					getTaskPersonAndImageVo(builderObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.SAFETYOFFICER.getValue())) {
					getTaskPersonAndImageVo(safetyofficerObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.PLATFORMSAFETYOFFICER.getValue())) {
					getTaskPersonAndImageVo(platFormSafetyofficerObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.TECHNICIAN.getValue())) {
					getTaskPersonAndImageVo(technicianObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.ENGINEERINGSTAFF.getValue())) {
					getTaskPersonAndImageVo(engineeringstaffObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.CREATEPERSON.getValue())) {
					getTaskPersonAndImageVo(createPersonObject, taskPersonDto);
				}
			});
			taskPersonAndImageInfoVos.addAll(builderObject);
			taskPersonAndImageInfoVos.addAll(safetyofficerObject);
			taskPersonAndImageInfoVos.addAll(platFormSafetyofficerObject);
			taskPersonAndImageInfoVos.addAll(technicianObject);
			taskPersonAndImageInfoVos.addAll(engineeringstaffObject);
			if (StringUtil.isNotEmpty(createPersonObject)) {
				taskPersonAndImageInfoVos.addAll(createPersonObject);
			} else {
				TaskPersonAndImageInfoVo createPersonInfoVo = new TaskPersonAndImageInfoVo();
				createPersonInfoVo.setTaskId(taskId);
				createPersonInfoVo.setPersonId(task.getCreatePersonId());
				Person createPerson = iPersonService.getById(task.getCreatePersonId());
				createPersonInfoVo.setPersonName(createPerson.getName());
				createPersonInfoVo.setType(99L);
				taskPersonAndImageInfoVos.add(createPersonInfoVo);
			}
		}

		getPersonHeadPhoto(taskPersonAndImageInfoVos);
		getPersonRoleName(taskPersonAndImageInfoVos);

		taskPayCheckVisualVo.setTaskPersonAndImageInfo(taskPersonAndImageInfoVos);
		Task curTask = iTaskService.getById(task.getId());
		taskPayCheckVisualVo.setStatus(curTask.getStatus());
		// 施工人员计算
		Long red = 0L;
		if (StringUtil.isNotEmpty(builderObject)) {
			for (TaskPersonAndImageInfoVo taskPersonAndImageInfoVo : builderObject) {
				Long readStatus = taskPersonAndImageInfoVo.getReadStatus();
				if (readStatus.equals(1L)) {
					red++;
				}
			}
		}
		taskPayCheckVisualVo.setBuildPersonNum("施工人员 " + red + "/" + builderObject.size());

		// 过程 0
		TaskProcessInfo taskProcessInfoSend = getTaskProcessInfo("发起任务", 1L);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoSendList = new ArrayList<>();
		TaskPersonProcessInfo taskPersonProcessInfo = new TaskPersonProcessInfo();
		taskPersonProcessInfo.setDate(task.getCreateDate());
		Person person = iPersonService.getById(task.getCreatePersonId());
		taskPersonProcessInfo.setContent(person.getName() + "发起三交三查");
		taskPersonProcessInfo.setStatus(null);
		taskPersonProcessInfoSendList.add(taskPersonProcessInfo);
		taskProcessInfoSend.setTaskPersonProcessInfo(taskPersonProcessInfoSendList);
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoSend);

		// 过程 1
		TaskProcessInfo taskProcessInfoGet = getTaskProcessInfo("接收任务", 1L);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoGetList = new ArrayList<>();
		TaskPersonProcessInfo taskPersonProcessGetInfo = new TaskPersonProcessInfo();
		taskPersonProcessGetInfo.setDate(task.getCreateDate());
		// 判断是否是风险作业，非风险作业只需要施工人员接收任务
		if ("1".equals(taskPaycheck.getRiskOperation() + "")) {
			taskPersonProcessGetInfo.setContent("安全员、技术员、工程人员、施工人员接收任务");
		} else {
			taskPersonProcessGetInfo.setContent("施工人员接收任务");
		}
		taskPersonProcessGetInfo.setStatus(null);
		taskPersonProcessInfoGetList.add(taskPersonProcessGetInfo);
		taskProcessInfoGet.setTaskPersonProcessInfo(taskPersonProcessInfoGetList);
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoGet);

		// 过程 2
		TaskProcessInfo taskProcessInfoConfirm = getTaskProcessInfo("确认任务", 0L);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoConfirmList = proccessConfirmTaskPayCheckPerson(
				createPersonObject, builderObject, safetyofficerObject, platFormSafetyofficerObject, technicianObject,
				engineeringstaffObject);
		// 如果所有人都确认了 则状态改为1L
		taskProcessInfoConfirm.setTaskPersonProcessInfo(taskPersonProcessInfoConfirmList);
		// 是否全部确认
		List<TaskPersonProcessInfo> isAllConfirm = taskPersonProcessInfoConfirmList.stream()
				.filter(taskPersonProcessInfo1 -> taskPersonProcessInfo1.getStatus().equals(0L))
				.collect(Collectors.toList());
		if (StringUtil.isEmpty(isAllConfirm)) {
			taskProcessInfoConfirm.setStatus(1L);
		}

		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoConfirm);

		// 过程 3
		TaskProcessInfo taskProcessInfoEnd = getTaskProcessInfo("结束任务", 2L);
		if (task.getStatus().equals(1L)) {
			taskProcessInfoEnd.setStatus(1L);
		}
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoEnd);

		taskPayCheckVisualVo.setTaskProcessInfo(taskProcessInfoList);
		taskPayCheckVisualVo.setIsRiskType(riskOperation);

		return taskPayCheckVisualVo;
	}

	private void getPersonHeadPhoto(List<TaskPersonAndImageInfoVo> taskPersonAndImageInfoVos) {
		for (TaskPersonAndImageInfoVo taskPersonAndImageInfoVo : taskPersonAndImageInfoVos) {
			Long personId = taskPersonAndImageInfoVo.getPersonId();
			Person person = iPersonService.getById(personId);
			String headPhoto = person != null ? person.getHeadPhoto() : null;
			if (StringUtils.isNotEmpty(headPhoto)) {
				taskPersonAndImageInfoVo.setHeadPhoto(fileServerUrl + headPhoto);
			}
		}
	}

	@Override
	public Object visualJobdisclosure(Task task) {
		Long taskId = task.getId();
		JobDisclosureVisualVo jobDisclosureVisualVo = new JobDisclosureVisualVo();
		jobDisclosureVisualVo.setProjectName(task.getProjectName());
		jobDisclosureVisualVo.setTaskId(taskId);
		List<TaskPersonAndImageInfoVo> taskPersonAndImageInfoVos = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> hostPersonObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> constructiondirectorObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> safetyofficerObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> notetakerObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> participatedisclosureObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> createPersonObject = new ArrayList<>();

		List<TaskProcessInfo> taskProcessInfoList = new LinkedList<>();
		List<TaskPersonDto> taskPersonDtoList = new ArrayList<>();
		List<TaskPerson> taskPerson = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, taskId).orderByDesc(TaskPerson::getReadTime));
		if (StringUtil.isNotEmpty(taskPerson)) {
			taskPerson.forEach(t -> {
				TaskPersonDto taskPersonDto = new TaskPersonDto();
				BeanUtils.copyProperties(t, taskPersonDto);
				taskPersonDtoList.add(taskPersonDto);
			});
		}
		if (StringUtil.isNotEmpty(taskPersonDtoList)) {
			taskPersonDtoList.forEach(taskPersonDto -> {
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.HOSTPERSON.getValue())) {
					getTaskPersonVo(hostPersonObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.CONSTRUCTIONDIRECTOR.getValue())) {
					getTaskPersonVo(constructiondirectorObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.SAFETYOFFICER.getValue())) {
					getTaskPersonVo(safetyofficerObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.NOTETAKER.getValue())) {
					getTaskPersonVo(notetakerObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.PARTICIPATEDISCLOSURE.getValue())) {
					getTaskPersonVo(participatedisclosureObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.CREATEPERSON.getValue())) {
					getTaskPersonVo(createPersonObject, taskPersonDto);
				}
			});
			taskPersonAndImageInfoVos.addAll(hostPersonObject);
			taskPersonAndImageInfoVos.addAll(constructiondirectorObject);
			taskPersonAndImageInfoVos.addAll(safetyofficerObject);
			taskPersonAndImageInfoVos.addAll(notetakerObject);
			taskPersonAndImageInfoVos.addAll(participatedisclosureObject);
			if (StringUtil.isNotEmpty(createPersonObject)) {
				taskPersonAndImageInfoVos.addAll(createPersonObject);
			} else {
				TaskPersonAndImageInfoVo createPersonInfoVo = new TaskPersonAndImageInfoVo();
				createPersonInfoVo.setTaskId(taskId);
				createPersonInfoVo.setPersonId(task.getCreatePersonId());
				Person createPerson = iPersonService.getById(task.getCreatePersonId());
				createPersonInfoVo.setPersonName(createPerson.getName());
				createPersonInfoVo.setType(TaskPersonTypeEnum.CREATEPERSON.getValue());
				taskPersonAndImageInfoVos.add(createPersonInfoVo);
			}
		}
		getPersonHeadPhoto(taskPersonAndImageInfoVos);
		getPersonRoleName(taskPersonAndImageInfoVos);
		// 技术交底任务中的发布人替换为交底人
		taskPersonAndImageInfoVos.stream().forEach(taskPersonAndImageInfoVo -> {
			if (TaskPersonTypeEnum.CREATEPERSON.getValue().equals(taskPersonAndImageInfoVo.getType())) {
				taskPersonAndImageInfoVo.setRoleName(TaskPersonTypeEnum.DISCLOSUREPERSON.getLabel());
			}
		});
		jobDisclosureVisualVo.setTaskPersonAndImageInfo(taskPersonAndImageInfoVos);
		// 当前任务状态 定时任务计算
		Task curTask = iTaskService.getById(task.getId());
		jobDisclosureVisualVo.setStatus(curTask.getStatus());

		// 交底人员计算
		Long job = 0L;
		if (StringUtil.isNotEmpty(participatedisclosureObject)) {
			for (TaskPersonAndImageInfoVo taskPersonAndImageInfoVo : participatedisclosureObject) {
				Long readStatus = taskPersonAndImageInfoVo.getReadStatus();
				if (readStatus.equals(1L)) {
					job++;
				}
			}
		}
		jobDisclosureVisualVo.setJobPersonNum("交底人员 " + job + "/" + participatedisclosureObject.size());

		// 过程 0
		TaskProcessInfo taskProcessInfoSend = getTaskProcessInfo("发起任务", 1L);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoSendList = new ArrayList<>();
		TaskPersonProcessInfo taskPersonProcessInfo = new TaskPersonProcessInfo();
		taskPersonProcessInfo.setDate(task.getCreateDate());
		Person person = iPersonService.getById(task.getCreatePersonId());
		taskPersonProcessInfo.setContent(person.getName() + "发起技术交底");
		taskPersonProcessInfo.setStatus(null);
		taskPersonProcessInfoSendList.add(taskPersonProcessInfo);
		taskProcessInfoSend.setTaskPersonProcessInfo(taskPersonProcessInfoSendList);
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoSend);

		// 过程 1
		TaskProcessInfo taskProcessInfoGet = getTaskProcessInfo("接收任务", 1L);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoGetList = new ArrayList<>();
		TaskPersonProcessInfo taskPersonProcessGetInfo = new TaskPersonProcessInfo();
		taskPersonProcessGetInfo.setDate(task.getCreateDate());
		taskPersonProcessGetInfo.setContent("主持人、施工负责人、安全员、记录人、交底人员接收任务");
		taskPersonProcessGetInfo.setStatus(null);
		taskPersonProcessInfoGetList.add(taskPersonProcessGetInfo);
		taskProcessInfoGet.setTaskPersonProcessInfo(taskPersonProcessInfoGetList);
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoGet);

		// 过程 2
		TaskProcessInfo taskProcessInfoConfirm = getTaskProcessInfo("确认任务", 0L);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoConfirmList = proccessConfirmJobDisclosurePerson(
				hostPersonObject, constructiondirectorObject, safetyofficerObject, notetakerObject,
				participatedisclosureObject);
		// 如果所有人都确认了 则状态改为1L
		taskProcessInfoConfirm.setTaskPersonProcessInfo(taskPersonProcessInfoConfirmList);
		// 是否全部确认
		List<TaskPersonProcessInfo> isAllConfirm = taskPersonProcessInfoConfirmList.stream()
				.filter(taskPersonProcessInfo1 -> taskPersonProcessInfo1.getStatus().equals(0L))
				.collect(Collectors.toList());
		if (StringUtil.isEmpty(isAllConfirm)) {
			taskProcessInfoConfirm.setStatus(1L);
		}
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoConfirm);

		// 过程 3
		TaskProcessInfo taskProcessInfoEnd = getTaskProcessInfo("结束任务", 2L);
		if (task.getStatus().equals(1L)) {
			taskProcessInfoEnd.setStatus(1L);
		}
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoEnd);
		jobDisclosureVisualVo.setTaskProcessInfo(taskProcessInfoList);
		return jobDisclosureVisualVo;
	}

	private void getPersonRoleName(List<TaskPersonAndImageInfoVo> taskPersonAndImageInfoVos) {
		for (TaskPersonAndImageInfoVo taskPersonAndImageInfoVo : taskPersonAndImageInfoVos) {
			Long type = taskPersonAndImageInfoVo.getType();
			String labelByValue = TaskPersonTypeEnum.getLabelByValue(type);
			taskPersonAndImageInfoVo.setRoleName(labelByValue);
		}
	}

	@Override
	public Object visualBad(Task task) {
		Long taskId = task.getId();
		BadVisualVo badVisualVo = new BadVisualVo();
		badVisualVo.setProjectName(task.getProjectName());
		badVisualVo.setTaskId(task.getId());
		List<TaskPersonAndImageInfoVo> taskPersonAndImageInfoVos = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> subcontractorObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> reviewerObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> illegalObject = new ArrayList<>();
		List<TaskPersonAndImageInfoVo> createPersonObject = new ArrayList<>();
		BadManagement badManagement = iBadManagementService
				.getOne(new LambdaQueryWrapper<BadManagement>().eq(BadManagement::getTaskId, taskId));
		badVisualVo.setBadBody(badManagement.getBody());
		List<BadManagementPerson> badManagementPersonList = ibadManagementPersonService
				.list(new LambdaQueryWrapper<BadManagementPerson>().eq(BadManagementPerson::getTaskId, taskId));
		if (StringUtil.isNotEmpty(badManagementPersonList)) {
			for (BadManagementPerson badManagementPerson : badManagementPersonList) {
				TaskPersonAndImageInfoVo taskPersonAndImageInfoVo = new TaskPersonAndImageInfoVo();
				taskPersonAndImageInfoVo.setTaskId(taskId);
				taskPersonAndImageInfoVo.setPersonId(badManagementPerson.getPersonId());
				taskPersonAndImageInfoVo.setPersonName(badManagementPerson.getPersonName());
				taskPersonAndImageInfoVo.setType(9L);
				// 根据对应的人查询文件
				illegalObject.add(taskPersonAndImageInfoVo);
			}
		}
		badVisualVo.setTypeName(badManagement.getType());
		List<TaskProcessInfo> taskProcessInfoList = new LinkedList<>();
		List<TaskPersonDto> taskPersonDtoList = new ArrayList<>();
		List<TaskPerson> taskPerson = iTaskPersonService.list(new LambdaQueryWrapper<TaskPerson>()
				.eq(TaskPerson::getTaskId, taskId).orderByDesc(TaskPerson::getReadTime));
		TaskPerson createPerson = new TaskPerson();
		if (StringUtil.isNotEmpty(taskPerson)) {
			for (TaskPerson t : taskPerson) {
				TaskPersonDto taskPersonDto = new TaskPersonDto();
				BeanUtils.copyProperties(t, taskPersonDto);
				taskPersonDtoList.add(taskPersonDto);
				if (t.getType().equals(TaskPersonTypeEnum.SPONSORVIOLATION.getValue())) {
					createPerson = t;
				}
			}
		}
		if (StringUtil.isNotEmpty(taskPersonDtoList)) {
			taskPersonDtoList.forEach(taskPersonDto -> {
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.SUBCONTRACTOR.getValue())) {
					getTaskPersonAndImageVo(subcontractorObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.REVIEWER.getValue())) {
					getTaskPersonAndImageVo(reviewerObject, taskPersonDto);
				}
				if (taskPersonDto.getType().equals(TaskPersonTypeEnum.SPONSORVIOLATION.getValue())) {
					getTaskPersonAndImageVo(createPersonObject, taskPersonDto);
				}
			});
			// 分包商负责人特殊处理
			if (subcontractorObject.isEmpty()) {
				TaskPersonDto liablePerson = new TaskPersonDto();
				liablePerson.setTaskId(taskId);
				liablePerson.setPersonId(badManagement.getPersonLiable());
				Person person = iPersonService.getById(badManagement.getPersonLiable());
				liablePerson.setPersonName(person.getName());
				liablePerson.setType(TaskPersonTypeEnum.SUBCONTRACTOR.getValue());
				liablePerson.setReadStatus(StatusEnum.UNFINISHED.getValue());
				liablePerson.setCompanyId(badManagement.getCompanyId());
				getTaskPersonAndImageVo(subcontractorObject, liablePerson);
			}
			taskPersonAndImageInfoVos.addAll(subcontractorObject);
			taskPersonAndImageInfoVos.addAll(reviewerObject);
			taskPersonAndImageInfoVos.addAll(illegalObject);
			if (StringUtil.isNotEmpty(createPersonObject)) {
				taskPersonAndImageInfoVos.addAll(createPersonObject);
			} else {
				TaskPersonAndImageInfoVo createPersonInfoVo = new TaskPersonAndImageInfoVo();
				createPersonInfoVo.setTaskId(taskId);
				createPersonInfoVo.setPersonId(task.getCreatePersonId());
				Person createPerson1 = iPersonService.getById(task.getCreatePersonId());
				createPersonInfoVo.setPersonName(createPerson1.getName());
				createPersonInfoVo.setType(99L);
				taskPersonAndImageInfoVos.add(createPersonInfoVo);
			}
		}
		getPersonHeadPhoto(taskPersonAndImageInfoVos);
		getPersonRoleName(taskPersonAndImageInfoVos);
		badVisualVo.setTaskPersonAndImageInfo(taskPersonAndImageInfoVos);
		Task curTask = iTaskService.getById(task.getId());
		badVisualVo.setStatus(curTask.getStatus());

		// 过程 0 ======发起任务============================================
		Long status0 = null;
		if (TaskStatusEnum.TOAUDIT.getLongType() == curTask.getStatus()) {
			status0 = 1L;
		} else if (TaskStatusEnum.UNCOMPLETED.getLongType() == curTask.getStatus()) {
			status0 = 1L;
		} else if (TaskStatusEnum.RETURNED.getLongType() == curTask.getStatus()) {
			status0 = 0L;
		} else {
			status0 = 1L;
		}
		TaskProcessInfo taskProcessInfoSend = getTaskProcessInfo("发起任务", status0);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoSendList = new ArrayList<>();
		TaskPersonProcessInfo taskPersonProcessInfo = new TaskPersonProcessInfo();
		taskPersonProcessInfo.setDate(task.getCreateDate());
		Person person = iPersonService.getById(task.getCreatePersonId());
		String content = person.getName() + "发起违规任务";
		taskPersonProcessInfo.setStatus(null);
		taskPersonProcessInfo.setContent(content);
		taskPersonProcessInfoSendList.add(taskPersonProcessInfo);
		taskProcessInfoSend.setTaskPersonProcessInfo(taskPersonProcessInfoSendList);
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoSend);
		// 过程 0 ======发起任务============================================
		// 过程 1 ============审核任务=====================================
		Long status1 = null;
		String content1 = "审核人员接收任务";
		Date date = null;
		if (TaskStatusEnum.TOAUDIT.getLongType() == curTask.getStatus()) {// 待审核 2
			status1 = 0L;
		} else if (TaskStatusEnum.UNCOMPLETED.getLongType() == curTask.getStatus()) { // 待办里 0
			content1 = "审核人员审核任务";
			date = reviewerObject.get(0).getReadTime();
			status1 = 1L;
		} else if (TaskStatusEnum.RETURNED.getLongType() == curTask.getStatus()) {// 已驳回 3
			content1 = "审核人员驳回任务";
			date = reviewerObject.get(0).getReadTime();
			status1 = 1L;
		} else {
			content1 = "审核人员审核任务";
			date = reviewerObject.get(0).getReadTime();
			status1 = 1L;
		}
		TaskProcessInfo taskProcessInfoGet = getTaskProcessInfo("审核任务", status1);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoGetList = new ArrayList<>();
		TaskPersonProcessInfo taskPersonProcessGetInfo = new TaskPersonProcessInfo();
		taskPersonProcessGetInfo.setDate(date);
		taskPersonProcessGetInfo.setContent(content1);
		taskPersonProcessGetInfo.setStatus(null);
		taskPersonProcessInfoGetList.add(taskPersonProcessGetInfo);
		taskProcessInfoGet.setTaskPersonProcessInfo(taskPersonProcessInfoGetList);
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoGet);
		// 过程 1 ============审核任务=====================================
		// 过程 2 ============处置任务=====================================
		Long status3 = 0L;
		if (TaskStatusEnum.TOAUDIT.getLongType() == curTask.getStatus()) {
			status3 = 2L;
		} else if (TaskStatusEnum.UNCOMPLETED.getLongType() == curTask.getStatus()) {
			status3 = 0L;
		} else if (TaskStatusEnum.RETURNED.getLongType() == curTask.getStatus()) {
			status3 = 2L;
		} else {
			status3 = 1L;
		}
		TaskProcessInfo taskProcessInfoConfirm = getTaskProcessInfo("处置任务", status3);
		// 人员信息
		List<TaskPersonProcessInfo> taskPersonProcessInfoConfirmList = proccessConfirmBadTaskPerson(subcontractorObject,
				null);
		// 如果所有人都确认了 则状态改为1L
		taskProcessInfoConfirm.setTaskPersonProcessInfo(taskPersonProcessInfoConfirmList);
//        // 是否全部确认
//        List<TaskPersonProcessInfo> isAllConfirm = taskPersonProcessInfoConfirmList.stream()
//                .filter(taskPersonProcessInfo1 -> taskPersonProcessInfo1.getStatus().equals(0L))
//                .collect(Collectors.toList());
//        if (StringUtil.isEmpty(isAllConfirm)) {
//            taskProcessInfoConfirm.setStatus(1L);
//        }
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoConfirm);
		// 过程 2 ============处置任务=====================================
		// 过程 3 ================= 结束任务==============================
		TaskProcessInfo taskProcessInfoEnd = getTaskProcessInfo("结束任务", 2L);
		if (task.getStatus().equals(1L)) {
			taskProcessInfoEnd.setStatus(1L);
		}
		// 加入到整体
		taskProcessInfoList.add(taskProcessInfoEnd);
		// 过程 3 ================= 结束任务==============================
		badVisualVo.setTaskProcessInfo(taskProcessInfoList);

		// 加入照片
		TaskPersonAndImageInfo taskPersonAndImageInfo = new TaskPersonAndImageInfo();
		taskPersonAndImageInfo.setTaskId(taskId);
		taskPersonAndImageInfo.setPersonId(createPerson.getPersonId());
		taskPersonAndImageInfo.setPersonName(createPerson.getPersonName());
		taskPersonAndImageInfo.setTaskPersonId(createPerson.getId());
		taskPersonAndImageInfo.setTaskPersonRoleType(createPerson.getType());
		taskPersonAndImageInfo.setTaskPersonRoleTypeName(TaskPersonTypeEnum.SPONSORVIOLATION.getLabel());
		List<TaskPersonFile> taskPersonFiles = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
				.eq(TaskPersonFile::getTaskId, taskId)
				.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.CREATEPERSONFILE.getValue())
				.eq(TaskPersonFile::getPersonId, createPerson.getPersonId()).orderByAsc(TaskPersonFile::getCreateDate));
		Map<Date, List<TaskFileVo>> map = new HashMap<>();
		List<TaskFileVo> taskFileVoList = new ArrayList<>();
		taskPersonFiles.forEach(i -> {
			TaskFileVo taskFileVo = new TaskFileVo();
			if (i != null) {
				BeanUtils.copyProperties(i, taskFileVo);
			}
			taskFileVoList.add(taskFileVo);
			if (map.containsKey(taskFileVo.getCreateDate())) {
				List<TaskFileVo> list = map.get(taskFileVo.getCreateDate());
				list.add(taskFileVo);
			} else {
				List<TaskFileVo> list = new ArrayList<>();
				list.add(taskFileVo);
				map.put(taskFileVo.getCreateDate(), list);
			}
		});
		if (!StringUtil.isEmpty(taskFileVoList)) {
			taskPersonAndImageInfo.setCreateTime(taskFileVoList.get(0).getCreateDate());
		}
		taskPersonAndImageInfo.setTimeFilePath(map);
		taskPersonAndImageInfo.setFilePath(taskFileVoList);
		List<TaskPersonAndImageInfo> imageList = new ArrayList<>();
		imageList.add(taskPersonAndImageInfo);
		badVisualVo.setImageList(imageList);
		return badVisualVo;
	}

	/**
	 * 根据用户信息获取参与项目
	 *
	 * @param taskPageDto
	 * @param curPerson
	 */
	public void taskPolicyByPerson(TaskPageDto taskPageDto, Person curPerson) {
		PersonAscription personAscription = iPersonAscriptionService.getOne(
				new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, curPerson.getId()));
		Long projectId = personAscription.getProjectId();
		taskPageDto.setProjectId(projectId);
	}

	/**
	 * 插入平台和业务安全员的检查项数据方法
	 *
	 * @param singTaskPayCheckDto
	 * @param taskId
	 * @param inputItemDto
	 * @param personId
	 * @param weight
	 */
	private void insertHazardousWorkResult(SingTaskPayCheckDto singTaskPayCheckDto, Long taskId,
			InputItemDto inputItemDto, Long personId, Long weight) {
		HazardousWorkResult hazardousWorkResult = new HazardousWorkResult();
		hazardousWorkResult.setTaskId(taskId);
		// 危险作业的id实际是以前的风险作业id name就是前台传递的名字
		hazardousWorkResult.setHazardousWorkId(singTaskPayCheckDto.getRiskTypeId());
		hazardousWorkResult.setHazardousWorkName(singTaskPayCheckDto.getRiskType());
		hazardousWorkResult.setInputItemId(inputItemDto.getId());
		hazardousWorkResult.setInputItemName(inputItemDto.getName());
		hazardousWorkResult.setValue("");
		hazardousWorkResult.setIsOk(StatusEnum.UNFINISHED.getValue());
		hazardousWorkResult.setReason("");
		hazardousWorkResult.setScore(StatusEnum.UNFINISHED.getValue());
		hazardousWorkResult.setCpersonId(personId);
		hazardousWorkResult.setWeight(weight);
		iHazardousWorkResultService.save(hazardousWorkResult);
	}

	/**
	 * 绑定任务和人的关系
	 *
	 * @param personId
	 * @param type
	 * @param taskId
	 */
	private void saveTaskPersonByType(Long personId, Long type, Long taskId, Long isRead) {
		TaskPerson taskPerson = new TaskPerson();
		taskPerson.setTaskId(taskId);
		taskPerson.setPersonId(personId);
		Person person = iPersonService.getById(personId);
		PersonAscription personAscription = iPersonAscriptionService
				.getOne(new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, personId));
		if (person != null) {
			taskPerson.setPersonName(person.getName());
		}
		taskPerson.setType(type);
		taskPerson.setReadStatus(isRead);
		if (personAscription != null) {
			taskPerson.setCompanyId(personAscription.getCompanyId());
		}
		iTaskPersonService.save(taskPerson);
	}

	/**
	 * 根据任务和人的ID 查询对应的图片文件
	 *
	 * @param taskId
	 * @param taskPerson
	 * @param taskPersonAndImageInfo
	 * @param flag                   是否保留文件服务器前缀
	 */
	private void getFileByUserId(Long taskId, TaskPerson taskPerson, TaskPersonAndImageInfo taskPersonAndImageInfo,
			boolean flag) {
		List<TaskPersonFile> fileList = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
				.eq(TaskPersonFile::getTaskId, taskId).eq(TaskPersonFile::getPersonId, taskPerson.getPersonId())
				.eq(TaskPersonFile::getPersonType, TaskPersonFileEnum.IMAGE.getValue()));
		if (StringUtil.isNotEmpty(fileList)) {
			List<TaskFileVo> datas = new ArrayList<>();
			fileList.forEach(file -> {
				TaskFileVo taskFileVo = new TaskFileVo();
				if (flag) {
					taskFileVo.setFilePath(fileServerUrl + file.getFilePath());
				} else {
					taskFileVo.setFilePath(file.getFilePath().replace(fileServerUrl, ""));
				}
				taskFileVo.setCreateTime(file.getCreateDate());
				datas.add(taskFileVo);
			});
			taskPersonAndImageInfo.setFilePath(datas);
			// 本来为操作人的时间，现在前台要求为图片的时间
			taskPersonAndImageInfo.setCreateTime(datas.get(0).getCreateTime());
		}
	}

	/**
	 * 根据任务和人的ID 查询对应的图片文件
	 *
	 * @param taskId
	 * @param taskPerson
	 * @param taskPersonAndImageInfo
	 * @param flag                   是否保留文件服务器前缀
	 */
	private void getFileByUserId(Long taskId, TaskPerson taskPerson, TaskPersonAndImageInfoVo taskPersonAndImageInfo,
			boolean flag) {
		List<TaskPersonFile> fileList = iTaskPersonFileService.list(new LambdaQueryWrapper<TaskPersonFile>()
				.eq(TaskPersonFile::getTaskId, taskId).eq(TaskPersonFile::getPersonId, taskPerson.getPersonId()));
		if (StringUtil.isNotEmpty(fileList)) {
			List<TaskFileVo> datas = new ArrayList<>();
			fileList.forEach(file -> {
				TaskFileVo taskFileVo = new TaskFileVo();
				if (flag) {
					taskFileVo.setFilePath(fileServerUrl + file.getFilePath());
				} else {
					taskFileVo.setFilePath(file.getFilePath().replace(fileServerUrl, ""));
				}
				taskFileVo.setCreateTime(file.getCreateDate());
				datas.add(taskFileVo);
			});
			if (flag) {
				taskPersonAndImageInfo.setFilePath(datas);
			} else {
				// 如果是技术交底任务，则所有环节都不需要展示图片
				taskPersonAndImageInfo.setFilePath(null);
			}
			// 本来为操作人的时间，现在前台要求为图片的时间
			taskPersonAndImageInfo.setCreateTime(datas.get(0).getCreateTime());
		}
	}

	/**
	 * 保存用户和任务
	 *
	 * @param personIds
	 * @param taskId
	 * @param taskPersonTypeEnum
	 */
	private void savePersonByIds(List<Long> personIds, Long taskId, TaskPersonTypeEnum taskPersonTypeEnum) {
		for (Long personId : personIds) {
			saveTaskPersonByType(personId, taskPersonTypeEnum.getValue(), taskId, StatusEnum.UNFINISHED.getValue());
		}
	}

	/**
	 * 存储任务相关的附件
	 *
	 * @param person
	 * @param taskId
	 * @param attachment
	 * @param taskPersonFileEnum
	 */
	private void saveAttachment(Person person, Long taskId, List<String> attachment,
			TaskPersonFileEnum taskPersonFileEnum) {
		if (StringUtil.isNotEmpty(attachment)) {
			for (String file : attachment) {
				TaskPersonFile taskPersonFile = new TaskPersonFile();
				taskPersonFile.setTaskId(taskId);
				taskPersonFile.setPersonId(person.getId());
				taskPersonFile.setPersonType(taskPersonFileEnum.getValue());
				taskPersonFile.setFilePath(file.replace(fileServerUrl, ""));
				iTaskPersonFileService.save(taskPersonFile);
			}
		}
	}

	private void saveAttachmentFileName(Person person, Long taskId, List<FileDto> attachment) {
		if (StringUtil.isNotEmpty(attachment)) {
			for (FileDto file : attachment) {
				TaskPersonFile taskPersonFile = new TaskPersonFile();
				taskPersonFile.setTaskId(taskId);
				taskPersonFile.setPersonId(person.getId());
				taskPersonFile.setPersonType(converFileType(file.getPersonType()));
				taskPersonFile.setFilePath(file.getFilePath().replace(fileServerUrl, ""));
				taskPersonFile.setFileName(file.getFileName());
				iTaskPersonFileService.save(taskPersonFile);
			}
		}
	}

	/**
	 * 转换文件类型
	 *
	 * @param personType
	 * @return
	 */
	private String converFileType(String personType) {
		switch (personType) {
		case "image":
			return TaskPersonFileEnum.IMAGE.getValue();
		case "file":
			return TaskPersonFileEnum.FILE.getValue();
		default:
			return TaskPersonFileEnum.FILE.getValue();
		}
	}

	private List<TaskPersonProcessInfo> proccessConfirmJobDisclosurePerson(
			List<TaskPersonAndImageInfoVo> hostPersonObject, List<TaskPersonAndImageInfoVo> constructiondirectorObject,
			List<TaskPersonAndImageInfoVo> safetyofficerObject, List<TaskPersonAndImageInfoVo> notetakerObject,
			List<TaskPersonAndImageInfoVo> participatedisclosureObject) {
		List<TaskPersonProcessInfo> data = new ArrayList<>();
		if (StringUtil.isNotEmpty(hostPersonObject)) {
			data.add(processInfoRead(hostPersonObject, "主持人确认任务"));
		}
		if (StringUtil.isNotEmpty(constructiondirectorObject)) {
			data.add(processInfoRead(constructiondirectorObject, "施工负责人确认任务"));
		}
		if (StringUtil.isNotEmpty(safetyofficerObject)) {
			data.add(processInfoRead(safetyofficerObject, "安全员确认任务"));
		}
		if (StringUtil.isNotEmpty(notetakerObject)) {
			data.add(processInfoRead(notetakerObject, "记录人确认任务"));
		}
		if (StringUtil.isNotEmpty(participatedisclosureObject)) {
			data.add(processInfoRead(participatedisclosureObject, "交底人员确认任务"));
		}
		return data;
	}

	/**
	 * 人员过程处理
	 *
	 * @param builderObject
	 * @param safetyofficerObject
	 * @param platFormSafetyofficerObject
	 * @param technicianObject
	 * @param engineeringstaffObject
	 * @return
	 */
	private List<TaskPersonProcessInfo> proccessConfirmTaskPayCheckPerson(List<TaskPersonAndImageInfoVo> creatorObject,
			List<TaskPersonAndImageInfoVo> builderObject, List<TaskPersonAndImageInfoVo> safetyofficerObject,
			List<TaskPersonAndImageInfoVo> platFormSafetyofficerObject, List<TaskPersonAndImageInfoVo> technicianObject,
			List<TaskPersonAndImageInfoVo> engineeringstaffObject) {
		List<TaskPersonProcessInfo> data = new ArrayList<>();
		if (StringUtil.isNotEmpty(creatorObject)) {
			data.add(processInfoRead(creatorObject, "发布人确认任务"));
		}
		if (StringUtil.isNotEmpty(builderObject)) {
			data.add(processInfoRead(builderObject, "施工人员确认任务"));
		}
		if (StringUtil.isNotEmpty(safetyofficerObject)) {
			data.add(processInfoRead(safetyofficerObject, "分包商安全员确认任务"));
		}
		if (StringUtil.isNotEmpty(platFormSafetyofficerObject)) {
			data.add(processInfoRead(platFormSafetyofficerObject, "项目部安全员确认任务"));
		}
		if (StringUtil.isNotEmpty(technicianObject)) {
			data.add(processInfoRead(technicianObject, "技术人员确认任务"));
		}
		if (StringUtil.isNotEmpty(engineeringstaffObject)) {
			data.add(processInfoRead(engineeringstaffObject, "工程人员确认任务"));
		}
		return data;

	}

	private List<TaskPersonProcessInfo> proccessConfirmBadTaskPerson(List<TaskPersonAndImageInfoVo> subcontractorObject,
			List<TaskPersonAndImageInfoVo> reviewerObject) {
		List<TaskPersonProcessInfo> data = new ArrayList<>();
		if (StringUtil.isNotEmpty(subcontractorObject)) {
			data.add(processInfoRead(subcontractorObject, "分包商负责人确认任务"));
		}
		if (StringUtil.isNotEmpty(reviewerObject)) {
			data.add(processInfoRead(reviewerObject, "审核人员确认任务"));
		}
		return data;
	}

	/**
	 * 获得对应的任务的人阅读的情况
	 */
	private TaskPersonProcessInfo processInfoRead(List<TaskPersonAndImageInfoVo> personObject, String title) {
		TaskPersonProcessInfo taskPersonProcessInfo = new TaskPersonProcessInfo();
		if (StringUtil.isNotEmpty(personObject)) {
			taskPersonProcessInfo.setContent(title);
			Set<TaskPersonAndImageInfoVo> isConfirmBuilder = personObject.stream()
					.filter(person -> person.getReadStatus().equals(0L)).collect(Collectors.toSet());
			if (StringUtil.isEmpty(isConfirmBuilder)) {
				List<TaskPersonAndImageInfoVo> builderConfirmPerson = personObject.stream()
						.filter(person -> person.getReadStatus().equals(1L)).collect(Collectors.toList());
				taskPersonProcessInfo.setStatus(1L);
				taskPersonProcessInfo.setDate(builderConfirmPerson.get(0).getReadTime());
			} else {
				taskPersonProcessInfo.setStatus(0L);
			}
		}
		return taskPersonProcessInfo;
	}

	private TaskProcessInfo getTaskProcessInfo(String title, Long status) {
		TaskProcessInfo taskProcessInfoSend = new TaskProcessInfo();
		taskProcessInfoSend.setTitle(title);
		taskProcessInfoSend.setStatus(status);
		return taskProcessInfoSend;
	}

	@Override
	public IPage<TaskPageVo> myListByPage(CommonPageableDto pageable, TaskPageDto taskPageDto) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<TaskPageVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		IPage<TaskPageVo> iPageData = taskMapper.myListByPage(page, taskPageDto);
		return iPageData;
	}

	@Override
	public Long examTemplateTest(CreatExamDto creatExamDto) {
		Person person = iPersonService
				.getOne(new LambdaQueryWrapper<Person>().eq(Person::getUserId, creatExamDto.getUserIds()));
		List<TaskPerson> taskPersons = iTaskPersonService
				.list(new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getPersonId, person.getId())
						.eq(TaskPerson::getExamId, creatExamDto.getExaminationId()));
		ResponseModel<Long> response = examFeign.doTemplateExam(creatExamDto);
		// 获取考试id
		Long examId = response.getResult();
		if (examId == null) {
			throw new BaseException("出题失败");
		}
		// 风险作业考试更新
		if (taskPersons != null && !taskPersons.isEmpty()) {
			creatExamDto.setBusinessKey(taskPersons.get(0) != null ? taskPersons.get(0).getTaskId().toString() : null);
			taskPersons.forEach(i -> i.setExamId(examId));
			iTaskPersonService.updateBatchById(taskPersons);
		}

		// 人员注册发的考试id更新
		PersonCondition personCondition = iPersonConditionService
				.getOne(new LambdaQueryWrapper<PersonCondition>().eq(PersonCondition::getPersonId, person.getId())
						.eq(PersonCondition::getExamId, creatExamDto.getExaminationId()));
		if (personCondition != null) {
			personCondition.setExamId(examId);
			iPersonConditionService.updateById(personCondition);
		}
		return examId;
	}

	@Override
	public IPage<Object> violationRank(CommonPageableDto pageable, String key, String sortType, String orgCode,
			Long projectId) {
		Page<BadCompanyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		if (StringUtils.isBlank(key)) {
			key = "num";
		}
		if (StringUtils.isBlank(sortType)) {
			sortType = "desc";
		}
		return taskMapper.violationRank(page, key, sortType, orgCode, projectId);
	}

	@Override
	public Integer sumTotal(String orgCode, Long projectId) {
		return taskMapper.sumTotal(orgCode, projectId);
	}

	@Override
	public List<Map> riskStatus(String orgCode, Long projectId) {
		List<Map> mapList = taskMapper.riskStatus(orgCode, projectId);
		if (mapList != null && mapList.size() > 0) {
			if (mapList.size() == 2) {
				return mapList;
			} else {
				Map map = mapList.get(0);
				String status = (String) map.get("status");
				if ("未完成".equals(status)) {
					Map mapComplate = new HashMap();
					mapComplate.put("num", "0");
					mapComplate.put("status", "已完成");
					mapList.add(mapComplate);
				} else {
					Map mapNo = new HashMap();
					mapNo.put("num", "0");
					mapNo.put("status", "未完成");
					mapList.add(mapNo);
				}
				return mapList;
			}
		} else {
			mapList = new ArrayList<>();
			Map mapNo = new HashMap();
			mapNo.put("num", "0");
			mapNo.put("status", "未完成");
			mapList.add(mapNo);
			Map mapComplate = new HashMap();
			mapComplate.put("num", "0");
			mapComplate.put("status", "已完成");
			mapList.add(mapComplate);
			return mapList;
		}
	}

	@Override
	public IPage<RewardAndRetributionListVo> violationList(StudioPageableDto pageable,
			RewardAndRetributionListVo rewardVo) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		Page<RewardAndRetributionListVo> rewardAndRetributionListVoPage = new Page<RewardAndRetributionListVo>(
				pageable.getCurrent(), pageable.getSize());
		return taskMapper.violationList(rewardAndRetributionListVoPage, rewardVo);
	}
}
