package com.yeejoin.amos.message.kafka.config;


import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.Arrays;

/**
 * topic初始化
 *
 * @author litw
 * @create 2022/11/1 10:06
 */
@Configuration class KafkaConfig {

    @Value("${init.topics}")
    private String topics;

    /**
     * 创建一个名为topic.test的Topic并设置分区数为8，分区副本数为2
     */
    @Bean    public void initialTopic() {
        String[] split = topics.split(",");
        Arrays.stream(split).forEach(e->{
            new NewTopic(e, 8, (short) 2);
        });
    }


}