package com.yeejoin.amos.boot.module.ymt.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 安全追溯-压力管道
 *
 * @author cpp
 * @date 2023-04-06 15:21:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("idx_biz_jg_tech_params_pipeline")
public class EquipTechParamPipeline extends AbstractEquipBaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * * $column.comments
     */

    @TableField(value = "\"INSTANCE_ID\"")
    private String instanceId;
    /**
     * * $column.comments
     */

    @TableField(value = "\"STATUS\"")
    private String status;
    /**
     * * 工程(装置)名称
     */

    @TableField(value = "\"DEVICE_NAME\"")
    private String deviceName;
    /**
     * * 管道类别
     */

    @TableField(value = "\"PIPELINE_CLASS\"")
    private String pipelineClass;
    /**
     * * 管道名称（登记单元）
     */

    @TableField(value = "\"PIPE_NAME\"")
    private String pipeName;
    /**
     * * 管道编号
     */

    @TableField(value = "\"PIPELINE_NUMBER\"")
    private String pipelineNumber;
    /**
     * * 设备级别
     */

    @TableField(value = "\"DEVICE_LEVEL\"")
    private String deviceLevel;
    /**
     * * 设计标准
     */

    @TableField(value = "\"DESIGN_STANDARD\"")
    private String designStandard;
    /**
     * * 管道图号
     */

    @TableField(value = "\"PIPE_DRAW_NUMBER\"")
    private String pipeDrawNumber;
    /**
     * * 公称直径
     */

    @TableField(value = "\"NOMINAL_DIAMETER\"")
    private String nominalDiameter;
    /**
     * * 公称壁厚
     */

    @TableField(value = "\"WALL_THICKNESS\"")
    private String wallThickness;
    /**
     * * 管道长度 （单位：m）
     */

    @TableField(value = "\"PIPE_LENGTH\"")
    private BigDecimal pipeLength;
    /**
     * * 起始位置起点
     */

    @TableField(value = "\"STARTE_POSITION\"")
    private String startePosition;
    /**
     * * 设计压力
     */

    @TableField(value = "\"PRESSURE\"")
    private String pressure;
    /**
     * * 设计温度
     */

    @TableField(value = "\"TEMPERATURE\"")
    private String temperature;
    /**
     * * 设计介质
     */

    @TableField(value = "\"MEDIUM\"")
    private String medium;
    /**
     * * 设计备注
     */

    @TableField(value = "\"REMARKS\"")
    private String remarks;

    /**
     * 终点位置
     */
    @TableField("\"END_POSITION\"")
    private String endPosition;


    /**
     * 管道信息
     */
    @TableField(value = "\"PIPE_INFO\"")
    private String pipeInfo;

    /**
     * * 工作压力
     */

    @TableField(value = "\"WORK_PRESSURE\"")
    private String workPressure;
    /**
     * * 工作温度
     */

    @TableField(value = "\"WORK_TEMPERATURE\"")
    private String workTemperature;
    /**
     * * 工作介质
     */

    @TableField(value = "\"WORK_MEDIUM\"")
    private String workMedium;
    /**
     * * 工作备注
     */

    @TableField(value = "\"WORK_REMARKS\"")
    private String workRemarks;

}
