package com.yeejoin.amos.boot.module.common.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.common.api.dto.DutyPersonShiftDto;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IDutyCommonService {
    /**
     * 分页查询
     *
     * @param current   当前页
     * @param size      页大小
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> pageList(int current, int size, String beginDate, String endDate) throws ParseException;

    /**
     * 值班明细
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return ResponseModel
     */
    List<Map<String, Object>> statisticsDay(String beginDate, String endDate) throws ParseException;
    /**
     * 新值班月视图
     *
     * @param beginDate
     * @param endDate
     * @param dutyType
     * @return
     * @throws ParseException
     */
     List<Map<String, Object>> newStatisticsDay(String beginDate, String endDate, String fieldCode) throws ParseException;
    /**
     * 不分页查询
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return ResponseModel
     */
    List<Map<String, Object>> list(Long teamId,String beginDate, String endDate) throws ParseException;

    /**
     * 获取表单参数
     *
     * @return String
     */
    String getGroupCode();

    List downloadList(String beginDate, String endDate) throws ParseException;

    /**
     * 值班数据入库
     *
     * @param dataList 数据
     */
    void saveImportData(List<Map<String, Object>> dataList);

    /**
     * 删除值班数据
     *
     * @param instanceId 实例id
     * @return Boolean
     */
    Boolean deleteDutyData(Long instanceId, String startTime, String endTime);

    /**
     * 查询指定条件的值班人信息
     *
     * @param dutyDay  查询条件
     * @param shiftId  班次
     * @param postType 岗位
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> dayDutyPersonList(String dutyDay, Long shiftId, String postType);

    /**
     * 查询当前值班人信息
     *
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> listOnDutyPerson();

    //120系统迁移接口 sql固定查询急救科下值班人员
    List<Map<String, Object>> listOnDutyPersonByAid();


    /**
     * 根据当前时间获取值班班次id列表
     *
     * @return
     */
    List<Long> getDutyShiftIdList();
    /**
     * 添加动态表单数据保存的方法，返回保存数据的instanceid
     * @param userId
     * @param map
     * @param groupCode
     * @return
     */
    public Long excuteDynamicFormInstance( String userId,Map<String, Object> map, String groupCode);
    /**
     * 修改动态表单数据
     * @param groupCode
     * @param instanceId
     * @param map
     */
    public void updateDynamicFormInstance(String groupCode,Long instanceId, Map<String, Object> map) ;
    /**
     * 保存值班人的信息---
     * @param instanceId
     * @param dutyShift
     * @param startTime
     */
    public void saveDutyPersonShiftDetail( Long instanceId ,List<DutyPersonShiftDto> dutyShift ,String startTime) ;
    
    /**
     * 添加值班人的信息 可以保存空信息
     * @param instanceId
     * @param dutyShiftList
     */
    public  void insertPersonShift(Long instanceId, List<DutyPersonShiftDto> dutyShiftList);
    
    public Object getSchedulingDutyForSpecifyDate(String dutyDay, Long shiftId, String postType);
}
