package com.yeejoin.amos.boot.module.common.biz.controller;

import java.text.ParseException;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.DutyFirstAidDto;
import com.yeejoin.amos.boot.module.common.api.service.IDutyFirstAidService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
@RestController
@Api(tags = "120急救站值班接口Api")
@RequestMapping(value = "/common/duty-FirstAid")
public class DutyFirstAidController  extends BaseController{
	 @Autowired
	 IDutyFirstAidService iDutyFirstAidService;


	    /**
	     * 值班列表视图--分页
	     *
	     * @return ResponseModel
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @GetMapping(value = "/page-list")
	    @ApiOperation(httpMethod = "GET", value = "值班列表视图-分页", notes = "值班列表视图-分页")
	    public ResponseModel<IPage<Map<String, Object>>> pageList(
	            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
	            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
	            @ApiParam(value = "当前页", required = true) @RequestParam(value = "current") int current,
	            @ApiParam(value = "页面大小", required = true) @RequestParam(value = "size") int size) throws ParseException {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.pageList(current, size, beginDate, endDate));
	    }

	    /**
	     * 值班列表视图--不分页
	     *
	     * @return ResponseModel
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @GetMapping(value = "/list")
	    @ApiOperation(httpMethod = "GET", value = "值班列表视图-不分页", notes = "值班列表视图-不分页")
	    public ResponseModel list(
	            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
	            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate) throws ParseException {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.list(null,beginDate, endDate));
	    }


	    /**
	     * 值班月视图
	     *
	     * @return ResponseModel
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @GetMapping("/statistics-day")
	    @ApiOperation(httpMethod = "GET", value = "值班月视图", notes = "值班月视图")
	    public ResponseModel<List<Map<String, Object>>> dutyDetail(
	            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
	            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate
	    ) throws ParseException {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.statisticsDay(beginDate, endDate));
	    }
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @GetMapping("/new-statistics-day")
	    @ApiOperation(httpMethod = "GET", value = "新值班月视图", notes = "新值班月视图")
	    public ResponseModel<List<Map<String, Object>>> newDutyDetail(
	            @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
	            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate,
				@ApiParam(value = "属性编码") @RequestParam(required = false) String fieldCode
	    ) throws ParseException {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.newStatisticsDay(beginDate, endDate, fieldCode));
	    }
	    /**
	     * 调班
	     *
	     * @return ResponseModel
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @PostMapping("/duty-adjust")
	    @ApiOperation(httpMethod = "POST", value = "调班保存", notes = "调班保存")
	    public ResponseModel dutyAdjustSave(@RequestBody DutyFirstAidDto dto) {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.save(dto));
	    }

	    /**
	     * 调班
	     *
	     * @param instanceId 实例id
	     * @param dutyCarDto 业务对象
	     * @return DutyCarDto
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @PutMapping("/duty-adjust")
	    @ApiOperation(httpMethod = "PUT", value = "调班更新", notes = "调班更新")
	    public ResponseModel dutyAdjustUpdate(
	            @RequestParam Long instanceId,
	            @RequestBody DutyFirstAidDto dto) {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.update(instanceId, dto));
	    }

	    /**
	     * 微型消防站导出
	     *
	     * @return ResponseModel
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @GetMapping("/exportExcel")
	    @ApiOperation(httpMethod = "GET", value = "120急救站导出", notes = "120急救站导出")
	    public ResponseModel exportExcel(HttpServletResponse response, @ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
	                            @ApiParam(value = "结束日期", required = true) @RequestParam String endDate) throws ParseException {
	        return ResponseHelper.buildResponse(iDutyFirstAidService.downloadList(beginDate, endDate));
	    }

	    /**
	     * 值班数据删除
	     *
	     * @param instanceId 实例id
	     * @param startTime 开始时间
	     * @param endTime 结束时间
	     * @return ResponseModel
	     * @throws Exception 
	     */
	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @DeleteMapping("/{instanceId}/{startTime}/{endTime}")
	    @ApiOperation(httpMethod = "DELETE", value = "值班数据删除", notes = "值班数据删除")
	    public ResponseModel deleteDutyData(@PathVariable Long instanceId,@PathVariable String startTime,@PathVariable String endTime) throws Exception {
	        if (ValidationUtil.isEmpty(instanceId)
	                || ValidationUtil.isEmpty(startTime)
	                || ValidationUtil.isEmpty(endTime)){
	            throw new BadRequest("参数校验失败.");
	        }
	        return ResponseHelper.buildResponse(iDutyFirstAidService.deleteDutyData(instanceId, startTime, endTime));
	    }

	    @TycloudOperation(ApiLevel = UserType.AGENCY)
	    @ApiOperation("查询指定日期值班人信息列表")
	    @GetMapping("/person/{dutyDay}/list")
	    public ResponseModel listDutyPerson(@ApiParam(value = "值班日期",required = true) @PathVariable String dutyDay,
	                                        @ApiParam(value = "班次id") @RequestParam(required = false) Long shiftId,
	                                        @ApiParam(value = "岗位") @RequestParam(required = false) String postType){
	        return ResponseHelper.buildResponse(iDutyFirstAidService.getSchedulingDutyForSpecifyDate(dutyDay,shiftId,postType));
	    }
}
