package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.FormInstance;
import com.yeejoin.equipmanage.common.entity.dto.BuildSearchDTO;
import com.yeejoin.equipmanage.common.entity.vo.BuildingVideoListVO;
import com.yeejoin.equipmanage.common.vo.AreaTreeVo;
import com.yeejoin.equipmanage.common.vo.UnitAreaTreeVo;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface IFormInstanceService extends IService<FormInstance> {

    /**
     * 分页查询
     *
     * @param groupCode 分组编号
     * @param current   当前页
     * @param size      页面大小
     * @return Page
     */
    Page<Map<String, Object>> queryForInstancePage(String groupCode, long current, long size);

    /**
     * 创建
     *
     * @param groupCode   分类
     * @param companyCode 公司编码
     * @param map         字段值对象
     * @return Map<String, Object>
     */
    Map<String, Object> createByMap(String groupCode, String companyCode, Map<String, Object> map);

    /**
     * 更新
     *
     * @param instanceId  id
     * @param companyCode 公司编码
     * @param map         字段值对象
     * @return Map<String, Object>
     */
    Map<String, Object> updateInstance(Long instanceId, String companyCode, Map<String, Object> map);

    /**
     * 不分页查询指定的分类
     *
     * @param groupCode 分类
     * @param params    查询参数
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> queryForMapList(String groupCode, Map<String, String> params);

    /**
     * 删除
     *
     * @param instanceId 实例id
     * @return 是否成功
     */
    Boolean deleteInstanceById(Long instanceId);

    /**
     * 查询指定节点的下降
     *
     * @param parentId 父节点
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> getSpecialChildrenList(String parentId, String bizOrgCode);

    /**
     * 查询指定节点的下降
     *
     * @param parentId 父节点
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> getSpecialChildrenListByBizOrgCode(String parentId, String bizOrgCode);

    /**
     * @Description 分页查询
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page queryPage(Page page, BuildSearchDTO dto);
    /**
     * @Description 不分页
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    List<Map<String,Object>> queryPage(BuildSearchDTO dto);
    /**
     * @Description 分页查询
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page roomPage(Page page, BuildSearchDTO dto);
    /**
     * @Description 楼层分页查询
     * @Description 查询列表
     * @param dto 查询参数
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 11:47
     */
    Page floorPage(Page page, BuildSearchDTO dto);

    List<Map<String,Object>> roomPage(BuildSearchDTO dto);
    /**
     * @Description 根据parentId查询其下资源（楼层、房间）
     * @param instanceId
     * @Return List<Map<String,Object>>
     * @Date 2020/12/19 15:06
     */
    List<Map<String,Object>> queryFloorRoom(List<Long> instanceId);

    /**
     * 查询详情
     * @param instanceId 实例id
     * @return Map<String, Object>
     */
    Map<String, Object> queryForMap(Long instanceId);

    /**
     * 根据instanceId、groupType，获取建筑楼层list
     * @param dto
     * @return
     */
    List<BuildSearchDTO> getBuildFloorList(BuildSearchDTO dto);

    /**
     * 根据instanceId，获取建筑楼层信息
     * @param instanceId
     * @return
     */
    List<LinkedHashMap<String, Object>> findByInstanceId(Long instanceId, String fileCategory, Boolean isDetail);

    Map<String, Object>  getFormInstanceById(Long instanceId);

    /**
     * 消防建筑视屏监控统计树
     * @return
     * @param bizOrgCodeList
     */
    List<Map<String, Object>> getBuildVideoListCount(List<String> bizOrgCodeList);

    /**
     * 安防消防建筑视屏监控统计树
     * @return
     */
    List<Map<String, Object>> getColaBuildVideoListCount(BuildingVideoListVO dto);

    /**
     * 解除建筑与风险区域关系
     * @param instanceId 建筑实例id
     */
    void unbindRegionRelation(Long instanceId);

    List<UnitAreaTreeVo> getValueByColumn(Long instanceId, String bizOrgcode);

    List<Map<String, Long>> getBuildVideoCount();

    /**
     * 查询指定节点的下降
     *
     * @param parentId 父节点
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> getSpecialChildrenListByName(String parentId, String bizOrgCode, String name);
}
