package com.yeejoin.amos.boot.biz.common.controller;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import springfox.documentation.annotations.ApiIgnore;

/**
 * 基础控制器
 *
 * @author
 */
@ApiIgnore
@RestController
@RequestMapping("/base")
public class BaseController {

	@Autowired
	private RedisUtils redisUtils;
	@Autowired
	protected HttpServletRequest request;

	/**
	 * 获取token
	 **/
	protected String getToken() {
		return RequestContext.getToken();
	}
    public String buildKey(String token) {
    	//由于用户id 不是接口携带参数，为了避免，公共字段填充时频繁访问平台，缓存用户信息时，
        //return "region_" + userId + "_" + token;
        return "region_"+ token;
    }
	/**
	 * 用户选择信心redis获取
	 **/
	protected ReginParams getSelectedOrgInfo() {
		return JSONObject.parseObject(redisUtils.get(buildKey(RequestContext.getToken())).toString(), ReginParams.class);
	}

	protected String getOrgCode(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getCompany() != null) {
			return reginParams.getCompany().getOrgCode();
		}

		return null;
	}

	/**
	 * 当前登录用户信息
	 */
	protected AgencyUserModel getUserInfo() {
		ReginParams reginParams = getSelectedOrgInfo();
		return reginParams.getUserModel();
	}

	protected String getProduct() {
		return RequestContext.getProduct();
	}

	protected String getAppKey() {

		return RequestContext.getAppKey();
	}

	protected String getUserId() {
		String userId = null;
		if (getUserInfo() != null) {
			userId = getUserInfo().getUserId();
		}
		return userId;
	}

	protected String getRoleTypeName(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getRole() != null) {
			return reginParams.getRole().getRoleType();
		}
		return null;
	}

	protected String getDepartmentId(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getDepartment().getSequenceNbr() != null) {
			return reginParams.getDepartment().getSequenceNbr().toString();
		}
		return null;
	}

	protected String getDepartmentName(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getDepartment().getDepartmentName() != null) {
			return reginParams.getDepartment().getDepartmentName();
		}
		return null;
	}

	protected String getCompanyId(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getCompany() != null) {
			return reginParams.getCompany().getSequenceNbr().toString();
		}
		return null;
	}

	protected String getCompanyName(ReginParams reginParams) {
		if (reginParams == null) {
			return null;
		}
		if (reginParams.getCompany() != null) {
			return reginParams.getCompany().getCompanyName();
		}
		return null;
	}
}
