package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.jcs.api.dto.*;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransfer;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 力量调派 Mapper 接口
 *
 * @author tb
 * @date 2021-06-17
 */
public interface PowerTransferMapper extends BaseMapper<PowerTransfer> {
    List<PowerTransferCompanyResourcesDto> getPowerTransferList(Long alertCalledId);

    List<PowerTransferCompanyDto> getLastPowerTransferCompany(Long alertCalledId);

    /**
     * 根据警情id获取调派车辆id列表
     *
     * @param alertCalledId
     * @return
     */
    List<String> queryTransferCarIdsByAlertCalledId(@Param("alertCalledId") Long alertCalledId);

    /**
     * 根据起止时间获取力量调派信息
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<PowerTransferDto> getPowerTransferInfo(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    /**
     * 根据起止时间获取力量调派单位信息
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<PowerTransferCompanyDto> getPowerTransferCompanyInfo(@Param("beginDate") String beginDate,
                                                              @Param("endDate") String endDate);

    /**
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    List<PowerTransferCompanyResourcesDto> getPowerTransferCompanyResourcesInfo(@Param("beginDate") String beginDate,
                                                       @Param("endDate") String endDate);

    Map<String, Object> getPowerTransferInfoCount(@Param("beginDate") String beginDate,
                                                        @Param("endDate") String endDate);


    Map<String, Integer> getCarNum(@Param("id") Long id);
    Map<String, Integer> getCompanyNum(@Param("id") Long id);

    List<PowerData> getPowerDataList(@Param("id") Long id);

    /**
     * * @param null
     * @return
     * <PRE>
     * author tw
     * date 2021/7/23
     * </PRE>
     * 力量调派按单位统计
     */
    List<PowerCompanyCountDto> getPowerCompanyCountDtocount(@Param("id") Long id);

    List<PowerCarCountDto> getPowerCarCountDtocount(@Param("alertCalledId") Long alertCalledId,@Param("companyId") Long companyId);
}
