package com.yeejoin.amos.patrol.core.common.response;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.yeejoin.amos.patrol.dao.entity.PointConfig;

@XmlRootElement
public class PointResponse {

	@XmlElement
	private long pointId;
	/**
	 * 点名称
	 */
	@XmlElement
	private String PointName;
	
	/**
	 * 点名称
	 */
	@XmlElement
	private String pointNo;
	
	/**
	 * 点状态：0 未纳入巡检，1 合格；2 不合格；3 漏检
	 */
	@XmlElement
	private String  status;
	
	/**
	 * 	点类型
	 */
	@XmlElement
	private String  isFixed;
	
	/**
	 * 	参考位置
	 */
	@XmlElement
	private String  address;
	
	/**
	 * 	责任区域/部门
	 */
	@XmlElement
	private String  chargeDept;
	
	/**
	 * 	责任人
	 */
	@XmlElement
	private String  chargePerson;
	
	/**
	 * 	联系电话
	 */
	@XmlElement
	private String  phone;
	
	@XmlElement
	@XStreamImplicit(itemFieldName=" pointConfig")
	private List<PointConfig> pointConfigs;

	

	

	public long getPointId() {
		return pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public String getPointName() {
		return PointName;
	}

	public void setPointName(String pointName) {
		PointName = pointName;
	}

	public String getPointNo() {
		return pointNo;
	}

	public void setPointNo(String pointNo) {
		this.pointNo = pointNo;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getIsFixed() {
		return isFixed;
	}

	public void setIsFixed(String isFixed) {
		this.isFixed = isFixed;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getChargeDept() {
		return chargeDept;
	}

	public void setChargeDept(String chargeDept) {
		this.chargeDept = chargeDept;
	}

	public String getChargePerson() {
		return chargePerson;
	}

	public void setChargePerson(String chargePerson) {
		this.chargePerson = chargePerson;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public List<PointConfig> getPointConfigs() {
		return pointConfigs;
	}

	public void setPointConfigs(List<PointConfig> pointConfigs) {
		this.pointConfigs = pointConfigs;
	}
	
	

	
}
