package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.ExcelDto;
import com.yeejoin.amos.boot.module.common.api.dto.FireStationDto;
import com.yeejoin.amos.boot.module.common.api.entity.FireStation;
import com.yeejoin.amos.boot.module.common.api.excel.ExcelUtil;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FireStationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;


/**
 * 微型消防站
 *
 * @author system_generator
 * @date 2021-06-28
 */
@RestController
@Api(tags = "微型消防站Api")
@RequestMapping(value = "/common/fire-station")
public class FireStationController extends BaseController {

    @Autowired
    FireStationServiceImpl fireStationServiceImpl;

    /**
     * 新增微型消防站
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增微型消防站", notes = "新增微型消防站")
    public ResponseModel<FireStationDto> save(@RequestBody FireStationDto model) {
        model = fireStationServiceImpl.add(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新微型消防站", notes = "根据sequenceNbr更新微型消防站")
    public ResponseModel<FireStationDto> updateBySequenceNbrFireStation(@RequestBody FireStationDto model,
                                                                        @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(fireStationServiceImpl.Update(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除微型消防站", notes = "根据sequenceNbr删除微型消防站")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request,
                                                      @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireStationServiceImpl.updateisDelete(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个微型消防站", notes = "根据sequenceNbr查询单个微型消防站")
    public ResponseModel<FireStationDto> seleteOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireStationServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "微型消防站分页查询", notes = "微型消防站分页查询")
    public ResponseModel<Page<FireStationDto>> queryForPage(@RequestParam(value = "current") int current,
                                                            @RequestParam(value = "size") int size) {
        Page<FireStationDto> page = new Page<FireStationDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireStationServiceImpl.queryForFireStationPage(page));
    }

    /**
     * 新列表分页查询
     *
     * @param pageNum 当前页
     * @param pageSize 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/list/page")
    @ApiOperation(httpMethod = "GET", value = "新微型消防站分页查询", notes = "新微型消防站分页查询")
    public ResponseModel<Page<FireStationDto>> getFireStation(@RequestParam(value = "pageNum") int pageNum,
                                                              @RequestParam(value = "pageSize") int pageSize,
                                                              FireStationDto fireStationDto) {
        return ResponseHelper.buildResponse(fireStationServiceImpl.getFirefighters(pageNum, pageSize, fireStationDto));
    }


    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "微型消防站列表全部数据查询", notes = "微型消防站列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireStationDto>> selectForList() {
        return ResponseHelper.buildResponse(fireStationServiceImpl.queryForFireStationList(false));
    }
}
