package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.LinkageUnitDto;
import com.yeejoin.amos.boot.module.common.api.entity.LinkageUnit;
import com.yeejoin.amos.boot.module.common.api.service.ILinkageUnitService;
import com.yeejoin.amos.boot.module.common.biz.service.impl.LinkageUnitServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;


/**
 * 联动单位
 *
 * @author system_generator
 * @date 2021-07-16
 */
@RestController
@Api(tags = "联动单位Api")
@RequestMapping(value = "/common/linkage-unit")
public class LinkageUnitController extends BaseController {

    @Autowired
    LinkageUnitServiceImpl linkageUnitServiceImpl;
    
    @Autowired
    ILinkageUnitService linkageUnitService;

    /**
     * 新增联动单位
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增联动单位", notes = "新增联动单位")
    public ResponseModel<LinkageUnitDto> save(@RequestBody LinkageUnitDto model) {
        model = linkageUnitServiceImpl.saveModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新联动单位", notes = "根据sequenceNbr更新联动单位")
    public ResponseModel<LinkageUnitDto> updateBySequenceNbrLinkageUnit(@RequestBody LinkageUnitDto model,
                                                                        @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.updateById(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除联动单位", notes = "根据sequenceNbr删除联动单位")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.deleteById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbrList 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/batch_delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除联动单位", notes = "根据sequenceNbr删除联动单位")
    public ResponseModel<Boolean> batchDeleteBySequenceNbrList(@RequestParam(value = "sequenceNbrList") List<Long> sequenceNbrList) {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.batchDelete(sequenceNbrList));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个联动单位", notes = "根据sequenceNbr查询单个联动单位")
    public ResponseModel<LinkageUnitDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.queryOne(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "联动单位分页查询", notes = "联动单位分页查询")
    public ResponseModel<Page<LinkageUnitDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size, String unitName, String linkageUnitTypeCode, String inAgreement, String emergencyLinkageUnitCode) {
    	Page<LinkageUnitDto> page = new Page<LinkageUnitDto>();
        page.setCurrent(current);
        page.setSize(size);
    	Page<LinkageUnitDto> linkageUnitDtoPage = linkageUnitServiceImpl.queryForLinkageUnitPage(page, false,
                unitName, linkageUnitTypeCode, emergencyLinkageUnitCode,inAgreement);
        return ResponseHelper.buildResponse(linkageUnitDtoPage);
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "联动单位列表全部数据查询", notes = "联动单位列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<LinkageUnitDto>> selectForList() {
        return ResponseHelper.buildResponse(linkageUnitServiceImpl.queryForLinkageUnitList(false));
    }
    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "联动单位列表树及统计", notes = "联动单位列表树及统计")
    @GetMapping(value = "/getLinkageUnitTree")
    public ResponseModel<Object> getLinkageUnitTree(@RequestParam String type, @RequestParam String rootName) {
        return ResponseHelper.buildResponse(linkageUnitService.getEmergencyLinkageUnitCodeGroupBy(type,rootName));
    }
}
