package com.yeejoin.amos.fas.business.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.google.common.collect.Maps;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipPontService;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@RestController
@RequestMapping(value = "/api/firequment/point")
@Api(tags = "消防设备风险点")
public class FireEquimtPointController extends AbstractBaseController {


    @Autowired
    private IFireEquipPontService fireEquipPontService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "指定消防设备的风险点列表", notes = "指定消防设备的风险点列表")
    @RequestMapping(value = "/fireequipment/{fireEqumtId}/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse pointList(@PathVariable Long fireEqumtId,
                                    @RequestParam(required = false) String name,
                                    @RequestParam int pageNumber,
                                    @RequestParam int pageSize
    ) {
        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
        return CommonResponseUtil.success(fireEquipPontService.queryByFireEquimt(fireEqumtId, name, commonPageable));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "指定消防设备的风险点列表", notes = "指定消防设备的风险点列表")
    @GetMapping(value = "/page")
    public CommonResponse page(@ApiParam(value = "起始记录", required = true) @RequestParam Integer pageNumber,
                               @ApiParam(value = "每页条数", required = true) @RequestParam Integer pageSize,
                               @ApiParam(value = "是否绑定设备（0：否；1：是）") @RequestParam(required = false) Integer isBindDevice,
                               @ApiParam(value = "监测点编号或者监测点名称模糊匹配") @RequestParam(required = false) String searchValue,
                               @ApiParam(value = "类型（模拟量：ANALOGUE；开关量：SWITCH）") @RequestParam(required = false) String type) {
        Map<String, Object> queryMap = Maps.newHashMap();
        ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
        queryMap.put("pageNumber", pageNumber);
        queryMap.put("pageSize", pageSize);
        if (isBindDevice != null && isBindDevice == 0) {
            queryMap.put("fireEquipmentId", 0);
        }
        queryMap.put("searchValue", searchValue);
        queryMap.put("type", type);
        queryMap.put("compCode", compCode);
        return fireEquipPontService.queryByMap(queryMap);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "批量绑定", notes = "批量绑定")
    @GetMapping(value = "/batch/bindToEquipment")
    public CommonResponse batchBindToEquipment(@ApiParam(value = "设备编号", required = true) @RequestParam Long deviceId,
                                               @ApiParam(value = "监测点编号(多个逗号隔开)", required = true) @RequestParam String pointIds) {
        if (StringUtils.isEmpty(pointIds)) {
            return CommonResponseUtil.failure("监测点编号必填");
        }
        List<Long> ids = Arrays.stream(pointIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return fireEquipPontService.batchBindToEquipment(deviceId, ids);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "批量解绑", notes = "批量解绑")
    @GetMapping(value = "/batch/unbindToEquipment")
    public CommonResponse batchUnbindToEquipment(@ApiParam(value = "监测点编号(多个逗号隔开)", required = true) @RequestParam String pointIds) {
        if (StringUtils.isEmpty(pointIds)) {
            return CommonResponseUtil.failure("监测点编号必填");
        }
        List<Long> ids = Arrays.stream(pointIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return fireEquipPontService.batchUnbindToEquipment(ids);
    }
//
//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "添加监测点", notes = "添加监测点")
//    @PostMapping(value = "/save")
//    public CommonResponse save(@ApiParam(value = "监测点对象", required = true) @RequestBody FireEquipmentPointEntity fireEquipmentPointEntity) {
//        if (fireEquipmentPointEntity.getFireEquipmentId() == null) {
//            fireEquipmentPointEntity.setFireEquipmentId(0L);
//        }
//
//
//
//
//        return fireEquipPontService.save(fireEquipmentPointEntity);
//    }

//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "修改监测点", notes = "修改监测点")
//    @PostMapping(value = "/update")
//    public CommonResponse update(@ApiParam(value = "监测点对象", required = true) @RequestBody FireEquipmentPointEntity fireEquipmentPointEntity) {
//    	FireEquipmentPoint old = fireEquipPontService.queryOne(fireEquipmentPointEntity.getId());
//
//    	if(old.getId() != 0 ) {
//    		String[] idArray = new String[] { String.valueOf(old.getId()) };
//            if(fireEquipPontService.countImpEquipment(idArray) > 0) {
//            	String riskSourceNames = fireEquipPontService.findBindRiskSourceStrByPointIds(idArray);
//            	return CommonResponseUtil.failure("该设备已被风险区域 [" + riskSourceNames + "] 绑定，请先删除绑定关系");
//            }
//    	}
//        return fireEquipPontService.update(fireEquipmentPointEntity);
//    }

//    @TycloudOperation(ApiLevel = UserType.AGENCY)
//    @ApiOperation(value = "批量删除监测点", notes = "批量删除监测点")
//    @GetMapping(value = "/batch/delete")
//    public CommonResponse batchDelete(@ApiParam(value = "监测点编号(多个逗号隔开)", required = true) @RequestParam String pointIds) {
//        if (StringUtils.isEmpty(pointIds)) {
//            return CommonResponseUtil.failure("监测点编号必填");
//        }
//        String[] idArray = pointIds.split(",");
//        if(fireEquipPontService.countImpEquipment(idArray) > 0) {
//        	String riskSourceNames = fireEquipPontService.findBindRiskSourceStrByPointIds(idArray);
//        	return CommonResponseUtil.failure("该点位已被风险区域 [" + riskSourceNames + "] 绑定，请先删除绑定关系");
//        }
//        List<Long> ids = Arrays.stream(pointIds.split(",")).map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
//        return fireEquipPontService.batchDelete(ids);
//    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据设备类型查询设备", notes = "批量删除监测点")
    @GetMapping(value = "/listByType")
    public CommonResponse listByType(@ApiParam(value = "装备分类：0-设备类；1-耗材类;2-视频监控;3-灭火器材") @RequestParam(required = false) Integer equipClassify) {
        return fireEquipPontService.listByType(equipClassify);
    }


}
