package com.yeejoin.amos.fas.business.dao.repository;

import java.util.List;
import java.util.Optional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.fas.dao.entity.RiskLevel;

@Repository("iRiskLevelDao")
public interface IRiskLevelDao extends BaseDao<RiskLevel, Long> {

	List<RiskLevel> findByEvaluationModelId(Long id);
	
	@Modifying
	@Transactional
	@Query(value="delete from f_risk_level where id in (?1)", nativeQuery = true)
	void deleteAllByIds(Long[] param);
	
	Optional<RiskLevel> findById(Long id);
}
