package com.yeejoin.amos.knowledgebase.face.service;


import com.yeejoin.amos.knowledgebase.face.model.KnowledgeDynamicsGroupModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.DynamicsGroupMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeDynamicsGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;


/**
 * <p>
 * 知识库系统动态选项配置的分组，用于区分不同功能的字段列表 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class DynamicsGroupService extends BaseService<KnowledgeDynamicsGroupModel, KnowledgeDynamicsGroup, DynamicsGroupMapper> {


//    @Autowired
//    private DynamicsOptionService dynamicsOptionService;


    public KnowledgeDynamicsGroupModel queryByFunctional(String appKey,String functional) {
        return this.queryModelByParamsWithCache(appKey,functional);
    }


    public List<KnowledgeDynamicsGroupModel> queryGroupList(String appKey) {
        return this.queryForList("", false, appKey);
    }


}
