package com.yeejoin.amos.maintenance.business.dao.repository;

import java.util.Date;
import java.util.List;
import java.util.Optional;

import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.yeejoin.amos.maintenance.dao.entity.PlanTask;

@Repository("planTaskDao")
public interface IPlanTaskDao extends BaseDao<PlanTask, Long> {
    @Modifying
    @Transactional
    @Query(value = "delete from p_plan_task where id in (?1)", nativeQuery = true)
    void deleteBatchById(List<Integer> ids);

    /**
     * 根据状态获取计划任务
     *
     * @param status
     * @return
     */
    public List<PlanTask> findAllByFinishStatusIn(List<Integer> statusList);

    /**
     * 根据计划ID和时间参数删除对应计划执行数据
     *
     * @param planId
     * @param date
     */
    @Modifying
    @Transactional
    @Query(value = "delete from p_plan_task where plan_id in (?1) and end_time > (?2)", nativeQuery = true)
    void deletePlanTaskByIdAndDate(List<Long> planId, Date date);

    /**
     * 根据计划ID和时间参数获取对应计划执行数据
     *
     * @param planId
     * @param date
     * @return
     */
    @Query(value = "select pt.id from p_plan_task pt where pt.plan_id in (?1) and pt.end_time > (?2)", nativeQuery = true)
    List<Long> getPlanTaskIdByPlanIdAndDate(List<Long> planId, Date date);


    Optional<PlanTask> findById(Long id);

    @Query(value = "select max(pt.id) from p_plan_task pt where pt.batch_no = (?1)", nativeQuery = true)
    long findMaxIdByBatchNo(long batchNo);

    List<PlanTask> findByPlanId(Long planId);

    PlanTask findByUserIdAndBeginTimeAndEndTimeAndPlanIdAndRouteId(String userId, String startTime, String endTime, long id, long routeId);
}
