package com.yeejoin.amos.patrol.business.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.patrol.business.dao.mapper.InputItemMapper;
import com.yeejoin.amos.patrol.business.dao.repository.IInputItemDao;
import com.yeejoin.amos.patrol.business.dao.repository.IPointClassifyDao;
import com.yeejoin.amos.patrol.business.entity.mybatis.EquipmentInputItemRo;
import com.yeejoin.amos.patrol.business.service.intfc.IEquipmentHandlerService;
import com.yeejoin.amos.patrol.business.util.HttpUtil;
import com.yeejoin.amos.patrol.business.util.StringUtil;
import com.yeejoin.amos.patrol.business.util.Toke;
import com.yeejoin.amos.patrol.common.enums.RuleTypeEnum;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.context.SpringContextHelper;

import java.util.*;

/**
 * @author keyong
 * @title: HandlerMqttMessageImpl
 * <pre>
 * @description: 订阅装备信息系统消息处理类
 * </pre>
 * @date 2020/11/10 18:03
 */
@Component("IEquipmentHandlerService")
public class EquipmentHandlerServiceImpl implements IEquipmentHandlerService {
    private final Logger log = LoggerFactory.getLogger(EquipmentHandlerServiceImpl.class);
    @Value("websoketUrl")
    public String websoketUrl;
    @Autowired
    private RuleTrigger ruleTrigger;
    @Autowired
    private IInputItemDao iInputItemDao;
//    @Autowired
//    private IPointClassifyDao iPointClassifyDao;
//    @Autowired
//    private InputItemMapper inputItemMapper;

    @Async("asyncTaskExecutor")
    @Override
    public void fireEquipRuleMessagePush(HashMap<String,Object> map, Toke toke) {
        EquipmentInputItemRo equipmentInputItemRo = new EquipmentInputItemRo();
        equipmentInputItemRo.setEquipmentName(map.get("name").toString());
        equipmentInputItemRo.setOrgCode(map.get("orgCode").toString());
        equipmentInputItemRo.setRuleType(RuleTypeEnum.GETCONTENT.getCode());
        try {
            RequestContext.setToken(toke.getToke());
            RequestContext.setProduct(toke.getProduct());
            log.info("装备消息规则推送" + JSONObject.toJSONString(equipmentInputItemRo));
            String packageld ="";
            if(StringUtil.isNotEmpty(map.get("inspectionSpecId"))){
                packageld = "消防设备巡查规范/"+map.get("inspectionSpecId").toString();
            }
            log.info("装备消息规则推送参数 equipmentInputItemRo {}，packageld{}" + JSONObject.toJSONString(equipmentInputItemRo) + JSONObject.toJSONString(packageld));
            ruleTrigger.publish(equipmentInputItemRo, packageld, null);
        } catch (Exception e) {
            log.error(e.getMessage(),e);
        }
    }

    @Override
    public List<InputItem>  getEquipmnetRules(String orgCode,String equipmentName) {
        List<InputItem> inputItems =  iInputItemDao.findByOrgCodeAndEquipmentName(orgCode,equipmentName);
        return inputItems;
    }

    @Override
    public List<InputItem>  getEquipmnetRulesByName(String equipmentName) {
        List<InputItem> inputItems =  iInputItemDao.findByEquipmentName(equipmentName);
//        List<InputItem> inputItems =inputItemMapper.queryCustomInputItem(param);
        return inputItems;
    }

    @Override
    public void getRulesCheckResult(List<EquipmentInputItemRo> rulesCheckList, Toke toke) {
            RequestContext.setToken(toke.getToke());
            RequestContext.setProduct(toke.getProduct());
            System.out.println("rulesCheckList"+JSON.toJSONString(rulesCheckList));
            rulesCheckList.forEach(equimentInputItemRo -> {
                try {
                    ruleTrigger.publish(equimentInputItemRo, "消防设备维保规范/YEEJOIN", null);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
    }
//    @Scheduled(fixedRate=5000)
//    private void equipmentTasks() {
//     iInputItemDao.deleteAllByEquipmentNameIsNotNull();
//     iPointClassifyDao.find
//     iInputItemDao
//
//    }

}
