package com.yeejoin.amos.fas.common.enums;

/**
 * @author wjk
 */

public enum ContingencyPlanStatusEnum {
    DRAFT("草稿",1),
    AVAILABLE("可用",2),
    NOAVAILABLE("不可用", 3),
    SIMULATION_START("模拟启动", 4),
    ONGOING("进行中", 5);
    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    private ContingencyPlanStatusEnum(String name, Integer code){
        this.name = name;
        this.code = code;
    }

    public static ContingencyPlanStatusEnum getEnum(Integer code) {
        ContingencyPlanStatusEnum checkStatusEnum = null;
        for(ContingencyPlanStatusEnum type: ContingencyPlanStatusEnum.values()) {
            if (type.getCode().equals(code)) {
                checkStatusEnum = type;
                break;
            }
        }
        return checkStatusEnum;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

}

