package com.yeejoin.amos.latentdanger.dao.entity;

import com.baomidou.mybatisplus.annotation.TableName;

import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 消息
 *
 * @author Administrator
 */
@TableName("p_msg")
public class Msg extends BasicEntity {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 标题
     */
    @Column(name = "title")
    private String title;

    /**
     * 消息
     */
    @Lob
    @Column(name = "body")
    private String body;


    private String pushBody;


    /**
     * 接收人名称
     */
    @Column(name = "reciver_name")
    private String reciverName;
    /**
     * 接收人ID
     */
    @Column(name = "user_id")
    private String userId;

    /**
     * 消息类型：对应MsgTypeEnum类,
     */
    @Column(name = "msg_type")
    private String msgType;

    /**
     * 发送状态0：未发送；1：已发送
     */
    @Column(name = "status")
    private int status = 1;

    /**
     * 发送时间
     */
    @Column(name = "send_time")
    private Date sendTime;

    /**
     * 关联id：巡检点；任务；计划
     */
    @Column(name = "relation_id")
    private Long relationId;

    /**
     * 发送方式true 按用户设置时间发送（主要针对任务提醒和消息发送），false 定时器发送
     */
    @Column(name = "is_immediately")
    private boolean isImmediately = true;

    /**
     * 定点发送时间
     */
    @Column(name = "fixed_time")
    private Date fixedTime;

    /**
     * 组织机构
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 是否已读
     */
    @Column(name = "is_read")
    private boolean isRead = false;

    /**
     * 接收消息电话号码
     */
    @Column(name = "target_tel")
    private String targetTel;

    /**
     * 创建者
     */
    @Column(name = "create_by")
    private Long createBy;

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }


    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public boolean getIsImmediately() {
        return isImmediately;
    }

    public void setIsImmediately(boolean isImmediately) {
        this.isImmediately = isImmediately;
    }

    public Date getFixedTime() {
        return fixedTime;
    }

    public void setFixedTime(Date fixedTime) {
        this.fixedTime = fixedTime;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public boolean getIsRead() {
        return isRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTargetTel() {
        return targetTel;
    }

    public void setTargetTel(String targetTel) {
        this.targetTel = targetTel;
    }

    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Transient
    public String getPushBody() {
        return pushBody;
    }

    public void setPushBody(String pushBody) {
        this.pushBody = pushBody;
    }


    public String getReciverName() {
        return reciverName;
    }

    public void setReciverName(String reciverName) {
        this.reciverName = reciverName;
    }
}
