package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.SourceFile;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IEqSourceFileService;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * @Author: songLei
 * @Description: 所属文件，前端控制器
 * @Date: 2020/12/18 13:54
 */
@Slf4j
@RestController
@RequestMapping("/sourceFile")
public class EquipSourceFileController {
    @Autowired
    private IEqSourceFileService sourceFileService;

    /**
     * @param sourceId 所属者ID
     * @Description 根据所属者ID查询所属文件
     * @Return Map<String, List < SourceFile>>
     * @Date 2020/12/18 14:12
     */
    @GetMapping("/list")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    public List<SourceFile> findBySourceId(@RequestParam Long sourceId) {
        return sourceFileService.findBySourceId(sourceId);
    }

    /**
     * 根据建筑ID获取建筑平面图
     *
     * @param id           实例ID
     * @param fileCategory 文件分类
     * @return
     */
    @GetMapping(value = "/findImgByFileCategory")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据建筑ID获取建筑平面图")
    public ResponseModel findImgByFileCategory(@RequestParam Long id, @RequestParam(required = false) String fileCategory) {
        return CommonResponseUtil.success(sourceFileService.findImgByFileCategory(id, fileCategory));
    }
}
