package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.entity.Scrap;
import com.yeejoin.equipmanage.common.entity.ScrapDetail;
import com.yeejoin.equipmanage.common.entity.SystemDic;

import java.util.List;
import java.util.Map;

/**
 * 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface IScrapService extends IService<Scrap> {

	Scrap create(List<ScrapDetail> list, String type, AgencyUserModel agencyUserModel) throws Exception;

	Scrap exec(Scrap scrap) throws Exception;

	IPage<Scrap> pageList(Page<Scrap> pageBean, QueryWrapper<Scrap> queryWrapper);

	List<SystemDic> reason();

	void scrapOnCar(Long id);

	void scrapOnPerson(Map<String, Object> map, AgencyUserModel agencyUserModel);

	void delPerson(Long id);
}
