package com.yeejoin.amos.supervision.business.dao.mapper;

import com.yeejoin.amos.supervision.business.entity.mybatis.CheckMsgBo;
import com.yeejoin.amos.supervision.business.entity.mybatis.PushTargetBo;
import com.yeejoin.amos.supervision.business.entity.mybatis.TaskMsgBo;
import com.yeejoin.amos.supervision.business.param.MsgConfigParam;
import com.yeejoin.amos.supervision.business.param.MsgInfoPageParam;
import com.yeejoin.amos.supervision.business.vo.MsgVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

public interface MsgMapper extends BaseMapper{
	
	public List<PushTargetBo> getAppPushTargetBo(@Param(value="userId")String userId, @Param(value="checkType")String checkType, 
			@Param(value="routeId")Long routeId);
	
	public List<PushTargetBo> getEmailPushTargetBo(@Param(value="userId")String userId, @Param(value="checkEmail")String checkEmail, 
			@Param(value="routeId")Long routeId);
	
	public List<PushTargetBo> getPushUserBo(@Param(value="type")String type, @Param(value="userIds")String userIds,  
			@Param(value="routeId")Long routeId, @Param(value="checkType")String checkType);
	
	/**
	 * 根据巡检id获取巡检详情
	 * @param checkId
	 * @return
	 */
	public CheckMsgBo getCheckMsgBos(@Param(value="checkId")Long checkId);
	
	/**
	 * 根据任务id获取任务发送消息
	 * @param taskId
	 * @return
	 */
	public TaskMsgBo getTaskMsgBos(@Param(value="taskId")Long taskId);

	/**
	 * 根据参数查询消息提醒列表个数
	 * 
	 * @param param
	 * @return
	 */
	public long countMsgVoData(MsgInfoPageParam param);

	/**
	 * 根据参数查询消息提醒列表
	 * 
	 * @param param
	 * @return
	 */
	public List<MsgVo> getMsgVoData(MsgInfoPageParam param);
	
	/**
	 * 根据计划指派人id获取该用户的消息配置信息
	 * @param userId
	 * @return
	 */
	public List<MsgConfigParam> getPlanTaskMsgConfigByUserIdAndStatus(@Param(value="userIds")String[] userIds, @Param(value="status")String status);
	
	/**
	 * 根据计划id获取即将开始提醒发送消息
	 * @param taskId
	 * @return
	 */
	public TaskMsgBo getPlanTaskWarnMsgBos(@Param(value="planTaskId")Long planTaskId);
	
	/**
	 * 根据计划id获取开始提醒发送消息
	 * @param taskId
	 * @return
	 */
	public TaskMsgBo getPlanTaskBeginMsgBos(@Param(value="planTaskId")Long planTaskId);
	
	/**
	 * 根据计划id获取漏检提醒发送消息
	 * @param taskId
	 * @return
	 */
	public TaskMsgBo getPlanTaskEndMsgBos(@Param(value="planTaskId")Long planTaskId);
	
	/**
	 * 根据巡检记录ID获取对应点和路线的负责人ID
	 * 
	 * @param checkId
	 * @return
	 */
	public Map<String, Object> getChargerId(@Param(value="checkId")Long checkId);
	
	/**
	 * 根据巡检记录ID获取对应点和路线的负责人ID
	 * 
	 * @param checkId
	 * @return
	 */
	public List getChargerIds(@Param(value="checkId")Long checkId);
}
