package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 八大类对应code枚举
 * @author LiuLin
 * @date 2024年01月03日 18:05
 */
@Getter
@AllArgsConstructor
public enum EquipCategoryEnum {
    IDX_BIZ_JG_TECH_PARAMS_BOILER(1000),
    IDX_BIZ_JG_TECH_PARAMS_VESSEL(2000),
    IDX_BIZ_JG_TECH_PARAMS_ELEVATOR(3000),
    IDX_BIZ_JG_TECH_PARAMS_LIFTING(4000),
    IDX_BIZ_JG_TECH_PARAMS_VEHICLE(5000),
    IDX_BIZ_JG_TECH_PARAMS_RIDES(6000),
    IDX_BIZ_JG_TECH_PARAMS_PIPELINE(8000),
    IDX_BIZ_JG_TECH_PARAMS_ROPEWAY(9000);

    private final int equList;

    public static EquipCategoryEnum of(int equList) {
        for (EquipCategoryEnum ec : values()) {
            if (ec.equList == equList) {
                return ec;
            }
        }
        return null;
    }
}
