package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.useRegister;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.backup.DefaultEquipBackupManager;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationEqServiceImpl;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

@Component
public class UseRegisterBackupManager extends DefaultEquipBackupManager {

    private final JgUseRegistrationEqServiceImpl jgUseRegistrationEqService;

    public UseRegisterBackupManager(ApplicationContext applicationContext, JgUseRegistrationEqServiceImpl jgUseRegistrationEqService) {
        super(applicationContext);
        this.jgUseRegistrationEqService = jgUseRegistrationEqService;
    }

    @Override
    public List<String> getRecords(String bizId) {
        List<JgUseRegistrationEq> eqDtoList = jgUseRegistrationEqService.list(new LambdaQueryWrapper<JgUseRegistrationEq>().eq(JgUseRegistrationEq::getEquipTransferId, bizId));
        return eqDtoList.stream().map(JgUseRegistrationEq::getEquId).collect(Collectors.toList());
    }

    @Override
    public String getBizType() {
        return BusinessTypeEnum.JG_USAGE_REGISTRATION.name();
    }
}
