package com.yeejoin.amos.boot.module.tcm.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 风险报送 处置过程表
 *
 * @author system_generator
 * @date 2025-08-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="RiskProcessesDto", description="风险报送 处置过程表")
public class RiskProcessesDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "风险报送主表seq，关联关系")
    private String riskReportSeq;

    @ApiModelProperty(value = "业务单位类型（处置单位/整改单位）")
    private String unitType;

    @ApiModelProperty(value = "业务处置方式code（确认已处置/无需处置/下发整改/整改上报）")
    private String disposalWayCode;

    @ApiModelProperty(value = "业务处置方式name（确认已处置/无需处置/下发整改/整改上报）")
    private String disposalWayName;

    @ApiModelProperty(value = "整改内容,监管下发的整改意见/企业上报的整改情况说明")
    private String disposalContent;

    @ApiModelProperty(value = "附件")
    private String disposalFile;

    @ApiModelProperty(value = "操作单位seq")
    private String operationCompanySeq;

    @ApiModelProperty(value = "操作单位name")
    private String operationCompanyName;

    @ApiModelProperty(value = "操作人userId")
    private String operationUserId;

    @ApiModelProperty(value = "操作人userName")
    private String operationUserName;

    @ApiModelProperty(value = "创建时间（根据此时间排序可获取一条风险的完整处置流程）")
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "风险处置单位/监管单位")
    private String riskDisposalUnit;

    @ApiModelProperty("备注")
    private String remark;

}
