package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.RequestData;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.dto.CountDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author ZeHua Li
 * @date 2020/11/23 15:03
 * @since v2.0
 */
@Mapper
public interface VideoMapper extends BaseMapper<Video> {
    Page<PageVideoVO> pageVideo(@Param("page") IPage<Video> page, @Param("video") Video video);

    Page<BuildingVideoVO> pageBuildingVideo(@Param("page") Page page, @Param("dto") BuildingVideoListVO dto);

    /**
     * 视屏监控绑定的消防设备查询
     *
     * @param videoId
     * @return
     */
    List<BuildingListVO> getFireEquipByVideoId(@Param("videoId") Long videoId);

    /**
     * 视屏监控绑定的电力设备查询
     *
     * @param videoId
     * @return
     */
    List<BuildingListVO> getPowerEquipByVideoId(@Param("videoId") Long videoId);

    /**
     * 获取监控
     *
     * @param id
     * @return
     */
    List<AlamVideoVO> getVideoBySpeId(Long id);

    AlamVideoVO getVideoById(Long id);


    /**
     * 可乐视频列表展示
     *
     * @param page
     * @param dto
     * @return
     */
    Page<BuildingVideoVO> pageColaBuildingVideo(@Param("page") Page page, @Param("dto") BuildingVideoListVO dto);

    Page<BuildingVideoVO> listColaBuildingVideo(@Param("page") Page page, @Param("dto") BuildingVideoListVO dto);

    Long countColaBuildVideo(@Param("dto") BuildingVideoListVO dto);

    List getMenuChildren(Long id);

    List findAllParents();

    /**
     * 视屏监控绑定的安防消防设备查询
     *
     * @param id
     * @return
     */
    BuildingListVO getSecurityOrFireEquipment(@Param("id") Long id);

    List<String> selectBuildList(Long id);

    List<EquipmentSpecificVo> selectImportantEquipment();

    List<VideoListVo> pageVideoList(@Param("pageNum") Integer pageNum,
                                    @Param("pageSize") Integer pageSize,
                                    @Param("longitude") Double longitude,
                                    @Param("latitude") Double latitude,
                                    @Param("distance") Double distance);

    List<VideoListVo> pageVideoListByAlert(@Param("pageNum") Integer pageNum,
                                    @Param("pageSize") Integer pageSize,
                                           @Param("par") RequestData par,@Param("deptId")String deptId);

    int VideoListByAlertCount( @Param("par") RequestData par,@Param("deptId")String deptId);

    List<BuildingVideoVO> pageBuildingVideoList(@Param("current") long current, @Param("size") long size,@Param("dto") BuildingVideoListVO dto,@Param("deptId") String deptId);

    int pageBuildingVideoCount( @Param("dto") BuildingVideoListVO dto,@Param("deptId") String deptId);

    int pageVideoCount(@Param("longitude") Double longitude,
                       @Param("latitude") Double latitude,
                       @Param("distance") Double distance);

    List<VideoListVo> listByType(@Param("type") String type);

    List<Video> listByCode(@Param("code") String code);

    List<Video> selectListBySourceId(Long floorId);

    String getParentSourceIds(String childrenId);

    List<CountDto> getVideoCountMapList();

}
