package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.tzs.api.entity.PageParam;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TzCarcylFillInfoDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TzCarcylInspectDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TzCarcylRegDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.TzCarcylTraceDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.TzCarcylReg;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.TzCarcylMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.ITzCarcylService;
import com.yeejoin.amos.feign.privilege.Privilege;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;


/**
 * 车用气瓶使用登记信息（列表） 服务实现类
 *
 * @author duanwei
 * @date 2022-08-08
 */
@Service
public class TzCarcylServiceImpl extends BaseService<TzCarcylRegDto, TzCarcylReg, TzCarcylMapper> implements ITzCarcylService {

    @Autowired
    private TzCarcylMapper tzCarcylMapper;

    @Override
    public IPage<TzCarcylRegDto> page(PageParam pageParam, TzCarcylRegDto idxBizCarcylUserCompany , String key) {
        Page<TzCarcylRegDto> page = new Page<>(pageParam.getCurrent(), pageParam.getSize());

        if(ValidationUtil.isEmpty(key)){
            System.out.println("key没值");
            Long sequenceNbr = Privilege.agencyUserClient.getme().getResult().getOrgRoleSeqs().keySet().iterator().next();
            String companyCode = Privilege.companyClient.seleteOne(sequenceNbr).getResult().getCompanyCode();
            return tzCarcylMapper.pageByCompanyCode(page, idxBizCarcylUserCompany, companyCode);

        }else{
            System.out.println("key有值："+key);
            String superviseOrgCode = Privilege.companyClient.seleteOne(Long.valueOf(key)).getResult().getOrgCode();
            return tzCarcylMapper.pageByOrgCode(page, idxBizCarcylUserCompany, superviseOrgCode);
        }

    }

    @Override
    public TzCarcylTraceDto getTrace(String sequenceNbr) {
        TzCarcylRegDto tzCarcylRegDto = tzCarcylMapper.getUserInfoger(sequenceNbr);
        String useCode = tzCarcylMapper.getUseNum(sequenceNbr);
        List<TzCarcylFillInfoDto> tzCarcylFillInfoDtoList = tzCarcylMapper.getFillingInfo(useCode);
        List<TzCarcylInspectDto> tzCarcylInspectDtoList = tzCarcylMapper.getCheckingInfo(useCode);
        TzCarcylTraceDto tzCarcylTraceDto = new TzCarcylTraceDto(tzCarcylRegDto,tzCarcylInspectDtoList,tzCarcylFillInfoDtoList);
        return tzCarcylTraceDto;
    }


}
