package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.Enum.ArrivalStateeEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.CodeEnum;
import com.yeejoin.amos.boot.module.hygf.api.Enum.WorkOrderEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.*;
import com.yeejoin.amos.boot.module.hygf.api.entity.*;
import com.yeejoin.amos.boot.module.hygf.api.mapper.*;
import com.yeejoin.amos.boot.module.hygf.api.service.IWorkOrderService;
import com.yeejoin.amos.boot.module.hygf.api.util.BeanDtoUtils;
import com.yeejoin.amos.boot.module.hygf.api.util.NumberUtil;
import com.yeejoin.amos.boot.module.hygf.biz.feign.WorkflowFeignClient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

/**
 * 施工派工工单服务实现类
 *
 * @author system_generator
 * @date 2024-01-02
 */
@Service
public class WorkOrderServiceImpl extends BaseService<WorkOrderDto,WorkOrder,WorkOrderMapper> implements IWorkOrderService {

    @Autowired
    RegionalCompaniesMapper regionalCompaniesMapper;

    @Autowired
    WorkOrderMapper workOrderMapper;
    @Autowired
    WorkOrderPowerStationServiceImpl workOrderPowerStationServiceImpl;

    @Autowired
    WorkOrderPowerStationMapper workOrderPowerStationMapper;
    @Autowired
    DesignInformationMapper designInformationMapper;
    @Autowired
    PowerStationConstructionDataServiceImpl powerStationConstructionDataService;


    @Autowired
    SurveyDetailsServiceImpl surveyDetailsService;

    @Autowired
    InformationServiceImpl informationService;

    @Autowired
    ExtendedInformationServiceImpl extendedInformationService;

    @Autowired
    CommercialServiceImpl commercialService;

    @Autowired
    PeasantHouseholdServiceImpl peasantHouseholdServiceImpl;

    @Autowired
    DesignInformationServiceImpl designInformationService;

    @Autowired
    PersonnelBusinessMapper personnelBusinessMapper;
    @Autowired
    SurveyInformationMapper surveyInformationMapper;
    @Autowired
    PowerStationConstructionDataMapper powerStationConstructionDataMapper;
    @Autowired
    PowerStationEngineeringInfoMapper powerStationEngineeringInfoMapper;
    @Autowired
    PowerStationEngineeringInfoServiceImpl powerStationEngineeringInfoService;

    @Autowired
    HygfOnGridMapper hygfOnGridMapper;
    @Autowired
    ConstructionRecordsServiceImpl constructionRecordsServiceImpl;
    @Autowired
    ConstructionRecordsMapper constructionRecordsMapper;
    @Autowired
    BasicGridAcceptanceMapper  basicGridAcceptanceMapper;

    @Autowired
    WorkflowFeignClient workflowFeignClient;


    @Autowired
    PeasantHouseholdMapper peasantHouseholdMapper;

    /**
     * 分页查询
     */
    public Page<WorkOrderDto> queryForWorkOrderPage(Page<WorkOrderDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<WorkOrderDto> queryForWorkOrderList()   {
        return this.queryForList("" , false);
    }




   @Transactional
    public WorkOrder saveWorkOrder (WorkOrder model, UserUnitInformationDto userUnitInformationDto) {
        //保存派工单
        RegionalCompanies regionalCompanies= regionalCompaniesMapper.selectRegionName(model.getRegionCompanyId());
        String code=  NumberUtil.getCode(CodeEnum.派工单.getCode(),regionalCompanies.getCompanyCode(),regionalCompanies.getRegionalAddress());
        model.setWorkOrderNum(code);
        model.setRegionCompanyName(regionalCompanies.getRegionalCompaniesName());
        model.setRegionCode(regionalCompanies.getRegionalCompaniesCode());
        model.setWorkOrderStatus(WorkOrderEnum.待施工.getCode());
        model.setRegionAddress(regionalCompanies.getRegionalAddress());
        //获取经销商单位信息
        model.setAmosDealerId(userUnitInformationDto.getAmosDealerId());
        model.setAmosDealerName(userUnitInformationDto.getAmosDealerName());
        model.setAmosDealerOrgCode(userUnitInformationDto.getAmosDealerOrgCode());

        workOrderMapper.insert(model);
        //保存派工单 电站信息
        List<PeasantHousehold> peasantHouseholdId=model.getPeasantHouseholdId();

       List<ConstructionRecords> constructionRecordlist=new ArrayList<>();
        List<WorkOrderPowerStation> li=new ArrayList<>();
        for (PeasantHousehold peasantHousehold : peasantHouseholdId) {
            WorkOrderPowerStation workOrderPowerStation=new WorkOrderPowerStation();
            workOrderPowerStation.setPeasantHouseholdId(peasantHousehold.getSequenceNbr());
            workOrderPowerStation.setWorkOrderId(model.getSequenceNbr());
            workOrderPowerStation.setPowerStationConstructionStatus(WorkOrderEnum.待施工.getCode());
            li.add(workOrderPowerStation);

        }
        workOrderPowerStationServiceImpl.saveBatch(li);

       for (WorkOrderPowerStation workOrderPowerStation : li) {
           //增加操作日志
           ConstructionRecords da=new ConstructionRecords(
                   workOrderPowerStation.getRecUserName(),
                   "新建派工单",
                   new Date(),
                   "",
                   workOrderPowerStation.getWorkOrderId(),
                   workOrderPowerStation.getSequenceNbr(),
                   workOrderPowerStation.getPeasantHouseholdId(),
                   "");
           constructionRecordlist.add(da);

       }
       constructionRecordsServiceImpl.saveBatch(constructionRecordlist);


       return model;
    }
    @Transactional
    public WorkOrder updateWorkOrder (WorkOrder model, UserUnitInformationDto userUnitInformationDto) {
        //保存派工单
        RegionalCompanies regionalCompanies= regionalCompaniesMapper.selectRegionName(model.getRegionCompanyId());
        model.setRegionCompanyName(regionalCompanies.getRegionalCompaniesName());
        model.setRegionCode(regionalCompanies.getRegionalCompaniesCode());
        model.setWorkOrderStatus(WorkOrderEnum.待施工.getCode());
        model.setRegionAddress(regionalCompanies.getRegionalAddress());
        //获取经销商单位信息
        model.setAmosDealerId(userUnitInformationDto.getAmosDealerId());
        model.setAmosDealerName(userUnitInformationDto.getAmosDealerName());
        model.setAmosDealerOrgCode(userUnitInformationDto.getAmosDealerOrgCode());
        workOrderMapper.updateById(model);
        LambdaQueryWrapper<WorkOrderPowerStation> up=new LambdaQueryWrapper();
        up.eq(WorkOrderPowerStation::getWorkOrderId,model.getSequenceNbr());
        workOrderPowerStationMapper.delete(up);
        //保存派工单 电站信息
        List<PeasantHousehold> peasantHouseholdId=model.getPeasantHouseholdId();
        List<WorkOrderPowerStation> li=new ArrayList<>();
        for (PeasantHousehold peasantHousehold : peasantHouseholdId) {
            WorkOrderPowerStation workOrderPowerStation=new WorkOrderPowerStation();
            workOrderPowerStation.setPeasantHouseholdId(peasantHousehold.getSequenceNbr());
            workOrderPowerStation.setWorkOrderId(model.getSequenceNbr());
            workOrderPowerStation.setPowerStationConstructionStatus(WorkOrderEnum.待施工.getCode());
            li.add(workOrderPowerStation);
        }
        workOrderPowerStationServiceImpl.saveBatch(li);

        List<ConstructionRecords> constructionRecordlist=new ArrayList<>();
        for (WorkOrderPowerStation workOrderPowerStation : li) {
            //增加操作日志
            ConstructionRecords da=new ConstructionRecords(
                    workOrderPowerStation.getRecUserName(),
                    "编辑派工单",
                    new Date(),
                    "",
                    workOrderPowerStation.getWorkOrderId(),
                    workOrderPowerStation.getSequenceNbr(),
                    workOrderPowerStation.getPeasantHouseholdId(),
                    "");
            constructionRecordlist.add(da);

        }
        constructionRecordsServiceImpl.saveBatch(constructionRecordlist);


        return model;
    }

    public WorkOrder selectOne(Long sequenceNbr) {
        WorkOrder model= workOrderMapper.selectById(sequenceNbr);
        List<PeasantHousehold> li=workOrderPowerStationMapper.selectPeasantHousehold(sequenceNbr,null);
        model.setPeasantHouseholdId(li);
        return model;
    }

    public  Map<String,Object> selectOneall(Long sequenceNbr) {
        WorkOrder model= workOrderMapper.selectById(sequenceNbr);
        List<PeasantHousehold> lih=workOrderPowerStationMapper.selectPeasantHousehold(sequenceNbr,null);



        //获取所有电站Bom，分组合并，暂时不相加
        List<Long> ids=new ArrayList<>();
        for (PeasantHousehold documentStation : lih) {
            ids.add(documentStation.getSequenceNbr());
        }
        QueryWrapper<DesignInformation> designInformationQueryWrapper = new QueryWrapper<>();
        designInformationQueryWrapper.in("peasant_household_id", ids);
        List<DesignInformation> li = designInformationMapper.selectList(designInformationQueryWrapper);
        DesignInformation designInformation=new DesignInformation();
        //组件
        List<Object> assembly=new ArrayList<>();
        //逆变器
        List<Object> inverter=new ArrayList<>();
        //电表箱
        List<Object> electricityMeter=new ArrayList<>();
        //电缆
        List<Object> cable=new ArrayList<>();
        for (DesignInformation des : li) {
            if(des.getAssembly()!=null&&!des.getAssembly().isEmpty()){
                assembly.addAll(des.getAssembly());
            }
            if(des.getInverter()!=null&&!des.getInverter().isEmpty()){
                inverter.addAll(des.getInverter());
            }
            if(des.getElectricityMeter()!=null&&!des.getElectricityMeter().isEmpty()){
                electricityMeter.addAll(des.getElectricityMeter());
            }
            if(des.getCable()!=null&&!des.getCable().isEmpty()){
                cable.addAll(des.getCable());
            }
        }
        List<PeasantHousehold> list=workOrderPowerStationMapper.selectPeasantHousehold(sequenceNbr,null);
        Map<String,Object> map =new HashMap<>();
        designInformation.setAssembly(assembly);
        designInformation.setInverter(inverter);
        designInformation.setElectricityMeter(electricityMeter);
        designInformation.setCable(cable);
        map.put("workOrder",model);
        map.put("designInformation",designInformation);
        map.put("peasantHousehold",list);





        return map;

    }

    @Transactional
    public PowerStationConstructionData  addOrUpdate(PowerStationConstructionData powerStationConstructionData){

//        if(powerStationConstructionData.getSequenceNbr()!=null){
         //修改施工电站状态
            LambdaUpdateWrapper<WorkOrderPowerStation> up=new LambdaUpdateWrapper();
            up.eq(WorkOrderPowerStation::getSequenceNbr,powerStationConstructionData.getWorkOrderPowerStationId());
         if(powerStationConstructionData.getConstructionStatus().equals("未完成")){
             up.set(WorkOrderPowerStation::getPowerStationConstructionStatus,WorkOrderEnum.施工中.getCode());
         }else{
             up.set(WorkOrderPowerStation::getPowerStationConstructionStatus,WorkOrderEnum.待登记.getCode());

             WorkOrderPowerStation basicGridAcceptanc= workOrderPowerStationMapper.selectById(powerStationConstructionData.getWorkOrderPowerStationId());
             //施工完成
             LambdaUpdateWrapper<PeasantHousehold>  up1 =new LambdaUpdateWrapper<>();
             up1.set(PeasantHousehold::getConstructionState, ArrivalStateeEnum.并网完成.getCode());
             long idsk= basicGridAcceptanc.getPeasantHouseholdId();
             up1.eq(PeasantHousehold::getSequenceNbr,idsk);
             peasantHouseholdMapper.update(null,up1);

         }
            workOrderPowerStationMapper.update(null,up);
            //修改派工单状态
            LambdaQueryWrapper<WorkOrderPowerStation> qu=new LambdaQueryWrapper();
            qu.eq(WorkOrderPowerStation::getWorkOrderId,powerStationConstructionData.getWorkOrderId());
            List<String> d=new ArrayList<>();
            d.add(WorkOrderEnum.施工中.getCode());
            d.add(WorkOrderEnum.待施工.getCode());
            qu.in(WorkOrderPowerStation::getPowerStationConstructionStatus,d);
            List<WorkOrderPowerStation> list=workOrderPowerStationMapper.selectList(qu);


            LambdaUpdateWrapper<WorkOrder> upq=new LambdaUpdateWrapper();
            upq.eq(WorkOrder::getSequenceNbr,powerStationConstructionData.getWorkOrderId());
            if(list!=null&&!list.isEmpty()){
                upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.施工中.getCode());
            }else{
                upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.登记中.getCode());
            }
            workOrderMapper.update(null,upq);
            //新增施工信息
            powerStationConstructionDataService.saveOrUpdate(powerStationConstructionData);



        //增加操作日志
        if(powerStationConstructionData.getSequenceNbr()!=null){
            ConstructionRecords da=new ConstructionRecords(
                    powerStationConstructionData.getRecUserName(),
                    "编辑施工资料",
                    new Date(),
                    "",
                    powerStationConstructionData.getWorkOrderId(),
                    powerStationConstructionData.getWorkOrderPowerStationId(),
                    null,
                    "");
            constructionRecordsServiceImpl.save(da);


        }else{
            ConstructionRecords da=new ConstructionRecords(
                    powerStationConstructionData.getRecUserName(),
                    "新增施工资料",
                    new Date(),
                    "",
                    powerStationConstructionData.getWorkOrderId(),
                    powerStationConstructionData.getWorkOrderPowerStationId(),
                    null,
                    "");
            constructionRecordsServiceImpl.save(da);
        }





//        }else{
//           //修改施工电站状态
//            LambdaUpdateWrapper<WorkOrderPowerStation> up=new LambdaUpdateWrapper();
//            up.eq(WorkOrderPowerStation::getSequenceNbr,powerStationConstructionData.getWorkOrderPowerStationId());
//            if(powerStationConstructionData.getConstructionStatus().equals("未完成")){
//                up.set(WorkOrderPowerStation::getPowerStationConstructionStatus,WorkOrderEnum.施工中.getCode());
//            }else{
//                up.set(WorkOrderPowerStation::getPowerStationConstructionStatus,WorkOrderEnum.待登记.getCode());
//            }
//            workOrderPowerStationMapper.update(null,up);
//           //修改派工单状态
//            LambdaQueryWrapper<WorkOrderPowerStation> qu=new LambdaQueryWrapper();
//            qu.eq(WorkOrderPowerStation::getWorkOrderId,powerStationConstructionData.getWorkOrderId());
//            qu.eq(WorkOrderPowerStation::getPowerStationConstructionStatus,WorkOrderEnum.待施工.getCode());
//            List<WorkOrderPowerStation> list=workOrderPowerStationMapper.selectList(qu);
//
//
//            LambdaUpdateWrapper<WorkOrder> upq=new LambdaUpdateWrapper();
//            upq.eq(WorkOrder::getSequenceNbr,powerStationConstructionData.getWorkOrderId());
//            if(list!=null&&!list.isEmpty()){
//                upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.施工中.getCode());
//            }else{
//                upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.登记中.getCode());
//            }
//            workOrderMapper.update(null,upq);
//            //修改施工信息
//
//
//        }


         return powerStationConstructionData;
    }





    public Page<WorkOrder>  selectPage(  int pageNum,int pageSize, WorkOrder  workOrder){
        PageHelper.startPage(pageNum, pageSize);
        List<WorkOrder>  list=workOrderMapper.selectWorkOrderList(workOrder);
        PageInfo<WorkOrder> page = new PageInfo(list);
        Page<WorkOrder> pagenew = new Page<WorkOrder>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }


    public Page<WorkOrderPage>  queryForwgpage(  int pageNum,int pageSize, WorkOrderPage workOrder){
        PageHelper.startPage(pageNum, pageSize);
        List<WorkOrderPage>  list=workOrderMapper.queryForwgpage(workOrder);
        PageInfo<WorkOrderPage> page = new PageInfo(list);
        Page<WorkOrderPage> pagenew = new Page<WorkOrderPage>();
        pagenew.setCurrent(pageNum);
        pagenew.setTotal(page.getTotal());
        pagenew.setSize(pageSize);
        pagenew.setRecords(page.getList());
        return pagenew;
    }


    public SurveyInfoAllDto getsurveyQueryxq(Long peasantHouseholdId,Long workOrderId,Long workOrderPowerStationId)   {

        SurveyInfoAllDto surveyInfoAllDto = new SurveyInfoAllDto();
        PeasantHousehold peasantHousehold = new PeasantHousehold();

        LambdaQueryWrapper<PeasantHousehold> peasantHouseholdWrapper = new LambdaQueryWrapper<>();
        peasantHouseholdWrapper.eq(PeasantHousehold::getSequenceNbr, peasantHouseholdId);
        peasantHousehold = peasantHouseholdServiceImpl.getBaseMapper().selectOne(peasantHouseholdWrapper);
        String  surveyInformationId = String.valueOf(peasantHousehold.getSurveyInformationId());

        //勘察基本信息
        LambdaQueryWrapper<SurveyInformation> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SurveyInformation::getSequenceNbr, surveyInformationId);
        SurveyInformation surveyInformation = surveyInformationMapper.selectOne(queryWrapper);
        surveyInfoAllDto.setSurveyInformation(BeanDtoUtils.convert(surveyInformation, SurveyInformationDto.class));
        //农户信息

        //获取用户所在经销商单位
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto(peasantHousehold.getDeveloperUserId());
        BeanUtils.copyProperties(peasantHousehold, surveyInfoAllDto.getSurveyInformation());
        surveyInfoAllDto.getSurveyInformation().setDeveloperName(userUnitInformationDto.getAmosDealerName());
        surveyInfoAllDto.getSurveyInformation().setDeveloperCode(userUnitInformationDto.getAmosDealerOrgCode());
        surveyInfoAllDto.getSurveyInformation().setDeveloperId(userUnitInformationDto.getAmosDealerId());

        if (!StringUtils.isEmpty(peasantHousehold.getProjectAddressName())) {
            surveyInfoAllDto.getSurveyInformation().setProjectAddressText(Arrays.asList(peasantHousehold.getProjectAddressName().split("/")));
        }
        if(!StringUtils.isEmpty(peasantHousehold.getPermanentAddressName())){
            surveyInfoAllDto.getSurveyInformation().setPermanentAddressText(Arrays.asList(peasantHousehold.getPermanentAddressName().split("/")));
        }
        if(peasantHousehold.getPermanentAddress() ==null){
            surveyInfoAllDto.getSurveyInformation().setPermanentAddress(peasantHousehold.getProjectAddress());
            surveyInfoAllDto.getSurveyInformation().setIsPermanent("1");
        }
        surveyInfoAllDto.getSurveyInformation().setSequenceNbr(surveyInformation.getSequenceNbr());
        surveyInfoAllDto.getSurveyInformation().setCreatorTime(new Date());
        QueryWrapper<SurveyDetails> surveyDetailsQueryWrapper = new QueryWrapper<>();
        surveyDetailsQueryWrapper.eq("survey_information_id", surveyInformationId);
        SurveyDetails surveyDetails = surveyDetailsService.getBaseMapper().selectOne(surveyDetailsQueryWrapper);

        if(surveyDetails == null){
            surveyInfoAllDto.setSurveyDetails(new SurveyDetailsDto());
        }else {
            surveyInfoAllDto.setSurveyDetails(BeanDtoUtils.convert(surveyDetails, SurveyDetailsDto.class));
        }
        QueryWrapper<Information> informationQueryWrapper = new QueryWrapper<>();
        informationQueryWrapper.eq("survey_information_id", surveyInformationId);
        Information information = informationService.getBaseMapper().selectOne(informationQueryWrapper);
        if(information == null){
            surveyInfoAllDto.setInformation(new InformationDto());
        }else {
            surveyInfoAllDto.setInformation(BeanDtoUtils.convert(information, InformationDto.class));
        }
        QueryWrapper<Commercial> commercialQueryWrapper = new QueryWrapper<>();
        commercialQueryWrapper.eq("survey_information_id", surveyInformationId);
        Commercial commercial = commercialService.getBaseMapper().selectOne(commercialQueryWrapper);
        if(commercial==null){
            commercial=new   Commercial();
        }
        commercial.setApplicant(peasantHousehold.getOwnersName());
        commercial.setIdCard(peasantHousehold.getIdCard());
        commercial.setTelephone(peasantHousehold.getTelephone());
        commercial.setProjectAddress(peasantHousehold.getProjectAddress());
        commercial.setProjectAddressName(peasantHousehold.getProjectAddressName());
        commercial.setProjectAddressDetail(peasantHousehold.getProjectAddressDetail());
        commercial.setLegalContactTelephone(peasantHousehold.getTelephone());
        if(information == null){
            CommercialDto commercialDto = BeanDtoUtils.convert(commercial, CommercialDto.class);
            commercialDto.setType("zrr");
            commercialDto.setLegalType("zjdnhw");
            surveyInfoAllDto.setCommercial(commercialDto);
        }else {
            surveyInfoAllDto.setCommercial(BeanDtoUtils.convert(commercial, CommercialDto.class));
            if(commercial !=null && !StringUtils.isEmpty(commercial.getProjectAddressName())){
                surveyInfoAllDto.getCommercial().setProjectAddressText(Arrays.asList(commercial.getProjectAddressName().split("/")));
            }
        }
        QueryWrapper<ExtendedInformation> extendedInformationQueryWrapper = new QueryWrapper<>();
        extendedInformationQueryWrapper.eq("survey_information_id", surveyInformationId);
        ExtendedInformation extendedInformation = extendedInformationService.getBaseMapper().selectOne(extendedInformationQueryWrapper);
        if(information == null){
            surveyInfoAllDto.setExtendedInformation(new ExtendedInformationDto());
        }else {
            surveyInfoAllDto.setExtendedInformation(BeanDtoUtils.convert(extendedInformation, ExtendedInformationDto.class));
        }
        QueryWrapper<DesignInformation> designInformationQueryWrapper = new QueryWrapper<>();
        designInformationQueryWrapper.eq("peasant_household_id", peasantHousehold.getSequenceNbr());
        DesignInformation designInformation = designInformationService.getBaseMapper().selectOne(designInformationQueryWrapper);
        if(designInformation == null){
            surveyInfoAllDto.setDesignInformation(new DesignInformationDto());
        }else {
            surveyInfoAllDto.setDesignInformation(BeanDtoUtils.convert(designInformation, DesignInformationDto.class));
        }

        //派工单信息
        LambdaQueryWrapper<WorkOrder> upl=new LambdaQueryWrapper();
        upl.eq(WorkOrder::getSequenceNbr,workOrderId);
        WorkOrder workOrder= workOrderMapper.selectOne(upl);

        //施工信息
        LambdaQueryWrapper<PowerStationConstructionData> up2=new LambdaQueryWrapper();
        up2.eq(PowerStationConstructionData::getWorkOrderId,workOrderId);
        up2.eq(PowerStationConstructionData::getWorkOrderPowerStationId,workOrderPowerStationId);
        PowerStationConstructionData powerStationConstructionData=powerStationConstructionDataMapper.selectOne(up2);

        //工程信息

        LambdaQueryWrapper<PowerStationEngineeringInfo> up3=new LambdaQueryWrapper();
        up3.eq(PowerStationEngineeringInfo::getWorkOrderId,workOrderId);
        up3.eq(PowerStationEngineeringInfo::getWorkOrderPowerStationId,workOrderPowerStationId);
        PowerStationEngineeringInfo powerStationEngineeringInfo=powerStationEngineeringInfoMapper.selectOne(up3);
        if(powerStationConstructionData!=null){
            powerStationEngineeringInfo=powerStationEngineeringInfo!=null?powerStationEngineeringInfo:new PowerStationEngineeringInfo();
            powerStationEngineeringInfo.setConstructionComponentInfo(powerStationConstructionData.getConstructionComponentInfo());
            powerStationEngineeringInfo.setConstructionInverterInfo(powerStationConstructionData.getConstructionInverterInfo());
            powerStationEngineeringInfo.setConstructionCollectorBoxInfo(powerStationConstructionData.getConstructionCollectorBoxInfo());
            powerStationEngineeringInfo.setConstructionGridBoxInfo(powerStationConstructionData.getConstructionGridBoxInfo());
            powerStationEngineeringInfo.setProjectRegionManager(workOrder.getProjectRegionManager());
            powerStationEngineeringInfo.setProjectRegionManagerPhone(workOrder.getProjectRegionManagerPhone());
            powerStationEngineeringInfo.setConstructionRegionManager(workOrder.getConstructionRegionManager());
            powerStationEngineeringInfo.setConstructionRegionManagerPhone(workOrder.getConstructionRegionManagerPhone());
        }



        //施工自审
        LambdaQueryWrapper<ConstructionRecords> up5=new LambdaQueryWrapper();
        up5.eq(ConstructionRecords::getWorkOrderId,workOrderId);
        up5.eq(ConstructionRecords::getWorkOrderPowerStationId,workOrderPowerStationId);
        up5.orderByAsc(ConstructionRecords::getRecDate);
        List<ConstructionRecords>   li=constructionRecordsMapper.selectList(up5);
        ConstructionRecords data=new ConstructionRecords();
        data.setConstructionRecordsList(li);
        surveyInfoAllDto.setConstructionRecords(data);



        //并网信息
        LambdaQueryWrapper<HygfOnGrid> up4=new LambdaQueryWrapper();
        up4.eq(HygfOnGrid::getWorkOrderId,workOrderId);
        up4.eq(HygfOnGrid::getWorkOrderPowerStationId,workOrderPowerStationId);
        HygfOnGrid hygfOnGrid=hygfOnGridMapper.selectOne(up4);
        surveyInfoAllDto.setHygfOnGrid(hygfOnGrid!=null?hygfOnGrid:new HygfOnGrid());
        surveyInfoAllDto.setPowerStationConstructionData(powerStationConstructionData);
        surveyInfoAllDto.setPowerStationEngineeringInfo(powerStationEngineeringInfo);
        surveyInfoAllDto.setWorkOrder(workOrder);

        return surveyInfoAllDto;
    }

    public PowerStationEngineeringInfoAllDto getPowerStationEngineeringInfo(Long workOrderPowerStationId)   {

        LambdaQueryWrapper<WorkOrderPowerStation> qu=new LambdaQueryWrapper();
        qu.eq(WorkOrderPowerStation::getSequenceNbr,workOrderPowerStationId);
        WorkOrderPowerStation workOrderPowerStation=workOrderPowerStationMapper.selectOne(qu);
        Long peasantHouseholdId=workOrderPowerStation.getPeasantHouseholdId();
        Long workOrderId=workOrderPowerStation.getWorkOrderId();

        PowerStationEngineeringInfoAllDto surveyInfoAllDto = new PowerStationEngineeringInfoAllDto();
        PeasantHousehold peasantHousehold = new PeasantHousehold();

        LambdaQueryWrapper<PeasantHousehold> peasantHouseholdWrapper = new LambdaQueryWrapper<>();
        peasantHouseholdWrapper.eq(PeasantHousehold::getSequenceNbr, peasantHouseholdId);
        peasantHousehold = peasantHouseholdServiceImpl.getBaseMapper().selectOne(peasantHouseholdWrapper);
        String  surveyInformationId = String.valueOf(peasantHousehold.getSurveyInformationId());

        //勘察基本信息
        LambdaQueryWrapper<SurveyInformation> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SurveyInformation::getSequenceNbr, surveyInformationId);
        SurveyInformation surveyInformation = surveyInformationMapper.selectOne(queryWrapper);
        surveyInfoAllDto.setSurveyInformation(BeanDtoUtils.convert(surveyInformation, SurveyInformationDto.class));
        //农户信息

        //获取用户所在经销商单位
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto(peasantHousehold.getDeveloperUserId());
        BeanUtils.copyProperties(peasantHousehold, surveyInfoAllDto.getSurveyInformation());
        surveyInfoAllDto.getSurveyInformation().setDeveloperName(userUnitInformationDto.getAmosDealerName());
        surveyInfoAllDto.getSurveyInformation().setDeveloperCode(userUnitInformationDto.getAmosDealerOrgCode());
        surveyInfoAllDto.getSurveyInformation().setDeveloperId(userUnitInformationDto.getAmosDealerId());

        if (!StringUtils.isEmpty(peasantHousehold.getProjectAddressName())) {
            surveyInfoAllDto.getSurveyInformation().setProjectAddressText(Arrays.asList(peasantHousehold.getProjectAddressName().split("/")));
        }
        if(!StringUtils.isEmpty(peasantHousehold.getPermanentAddressName())){
            surveyInfoAllDto.getSurveyInformation().setPermanentAddressText(Arrays.asList(peasantHousehold.getPermanentAddressName().split("/")));
        }
        if(peasantHousehold.getPermanentAddress() ==null){
            surveyInfoAllDto.getSurveyInformation().setPermanentAddress(peasantHousehold.getProjectAddress());
            surveyInfoAllDto.getSurveyInformation().setIsPermanent("1");
        }
        surveyInfoAllDto.getSurveyInformation().setSequenceNbr(surveyInformation.getSequenceNbr());
        surveyInfoAllDto.getSurveyInformation().setCreatorTime(new Date());
        QueryWrapper<SurveyDetails> surveyDetailsQueryWrapper = new QueryWrapper<>();
        surveyDetailsQueryWrapper.eq("survey_information_id", surveyInformationId);
        SurveyDetails surveyDetails = surveyDetailsService.getBaseMapper().selectOne(surveyDetailsQueryWrapper);

        if(surveyDetails == null){
            surveyInfoAllDto.setSurveyDetails(new SurveyDetailsDto());
        }else {
            surveyInfoAllDto.setSurveyDetails(BeanDtoUtils.convert(surveyDetails, SurveyDetailsDto.class));
        }
        QueryWrapper<Information> informationQueryWrapper = new QueryWrapper<>();
        informationQueryWrapper.eq("survey_information_id", surveyInformationId);
        Information information = informationService.getBaseMapper().selectOne(informationQueryWrapper);
        if(information == null){
            surveyInfoAllDto.setInformation(new InformationDto());
        }else {
            surveyInfoAllDto.setInformation(BeanDtoUtils.convert(information, InformationDto.class));
        }
        QueryWrapper<Commercial> commercialQueryWrapper = new QueryWrapper<>();
        commercialQueryWrapper.eq("survey_information_id", surveyInformationId);
        Commercial commercial = commercialService.getBaseMapper().selectOne(commercialQueryWrapper);
        if(commercial==null){
            commercial=new   Commercial();
        }
        commercial.setApplicant(peasantHousehold.getOwnersName());
        commercial.setIdCard(peasantHousehold.getIdCard());
        commercial.setTelephone(peasantHousehold.getTelephone());
        commercial.setProjectAddress(peasantHousehold.getProjectAddress());
        commercial.setProjectAddressName(peasantHousehold.getProjectAddressName());
        commercial.setProjectAddressDetail(peasantHousehold.getProjectAddressDetail());
        commercial.setLegalContactTelephone(peasantHousehold.getTelephone());
        if(information == null){
            CommercialDto commercialDto = BeanDtoUtils.convert(commercial, CommercialDto.class);
            commercialDto.setType("zrr");
            commercialDto.setLegalType("zjdnhw");
            surveyInfoAllDto.setCommercial(commercialDto);
        }else {
            surveyInfoAllDto.setCommercial(BeanDtoUtils.convert(commercial, CommercialDto.class));
            if(commercial !=null && !StringUtils.isEmpty(commercial.getProjectAddressName())){
                surveyInfoAllDto.getCommercial().setProjectAddressText(Arrays.asList(commercial.getProjectAddressName().split("/")));
            }
        }
        QueryWrapper<ExtendedInformation> extendedInformationQueryWrapper = new QueryWrapper<>();
        extendedInformationQueryWrapper.eq("survey_information_id", surveyInformationId);
        ExtendedInformation extendedInformation = extendedInformationService.getBaseMapper().selectOne(extendedInformationQueryWrapper);
        if(information == null){
            surveyInfoAllDto.setExtendedInformation(new ExtendedInformationDto());
        }else {
            surveyInfoAllDto.setExtendedInformation(BeanDtoUtils.convert(extendedInformation, ExtendedInformationDto.class));
        }
        QueryWrapper<DesignInformation> designInformationQueryWrapper = new QueryWrapper<>();
        designInformationQueryWrapper.eq("peasant_household_id", peasantHousehold.getSequenceNbr());
        DesignInformation designInformation = designInformationService.getBaseMapper().selectOne(designInformationQueryWrapper);
        if(designInformation == null){
            surveyInfoAllDto.setDesignInformation(new DesignInformationDto());
        }else {
            surveyInfoAllDto.setDesignInformation(BeanDtoUtils.convert(designInformation, DesignInformationDto.class));
        }

        //派工单信息
        LambdaQueryWrapper<WorkOrder> upl=new LambdaQueryWrapper();
        upl.eq(WorkOrder::getSequenceNbr,workOrderId);
        WorkOrder workOrder= workOrderMapper.selectOne(upl);

        //施工信息
        LambdaQueryWrapper<PowerStationConstructionData> up2=new LambdaQueryWrapper();
        up2.eq(PowerStationConstructionData::getWorkOrderId,workOrderId);
        up2.eq(PowerStationConstructionData::getWorkOrderPowerStationId,workOrderPowerStationId);
        PowerStationConstructionData powerStationConstructionData=powerStationConstructionDataMapper.selectOne(up2);

        //工程信息

        LambdaQueryWrapper<PowerStationEngineeringInfo> up3=new LambdaQueryWrapper();
        up3.eq(PowerStationEngineeringInfo::getWorkOrderId,workOrderId);
        up3.eq(PowerStationEngineeringInfo::getWorkOrderPowerStationId,workOrderPowerStationId);
        PowerStationEngineeringInfo powerStationEngineeringInfo=powerStationEngineeringInfoMapper.selectOne(up3);
        if(powerStationConstructionData!=null){
            powerStationEngineeringInfo=powerStationEngineeringInfo!=null?powerStationEngineeringInfo:new PowerStationEngineeringInfo();
            powerStationEngineeringInfo.setConstructionComponentInfo(powerStationConstructionData.getConstructionComponentInfo());
            powerStationEngineeringInfo.setConstructionInverterInfo(powerStationConstructionData.getConstructionInverterInfo());
            powerStationEngineeringInfo.setConstructionCollectorBoxInfo(powerStationConstructionData.getConstructionCollectorBoxInfo());
            powerStationEngineeringInfo.setConstructionGridBoxInfo(powerStationConstructionData.getConstructionGridBoxInfo());
            powerStationEngineeringInfo.setProjectRegionManager(workOrder.getProjectRegionManager());
            powerStationEngineeringInfo.setProjectRegionManagerPhone(workOrder.getProjectRegionManagerPhone());
            powerStationEngineeringInfo.setConstructionRegionManager(workOrder.getConstructionRegionManager());
            powerStationEngineeringInfo.setConstructionRegionManagerPhone(workOrder.getConstructionRegionManagerPhone());
        }
        //并网信息
        LambdaQueryWrapper<HygfOnGrid> up4=new LambdaQueryWrapper();
        up4.eq(HygfOnGrid::getWorkOrderId,workOrderId);
        up4.eq(HygfOnGrid::getWorkOrderPowerStationId,workOrderPowerStationId);
        HygfOnGrid hygfOnGrid=hygfOnGridMapper.selectOne(up4);
        surveyInfoAllDto.setHygfOnGrid(hygfOnGrid!=null?hygfOnGrid:new HygfOnGrid());
        surveyInfoAllDto.setPowerStationConstructionData(powerStationConstructionData);
        surveyInfoAllDto.setPowerStationEngineeringInfo(powerStationEngineeringInfo);
        surveyInfoAllDto.setWorkOrder(workOrder);

        //施工自审
        LambdaQueryWrapper<ConstructionRecords> up5=new LambdaQueryWrapper();
        up5.eq(ConstructionRecords::getWorkOrderId,workOrderId);
        up5.eq(ConstructionRecords::getWorkOrderPowerStationId,workOrderPowerStationId);
        up5.orderByAsc(ConstructionRecords::getRecDate);
        List<ConstructionRecords>   li=constructionRecordsMapper.selectList(up5);
        ConstructionRecords data=new ConstructionRecords();
        data.setConstructionRecordsList(li);
        surveyInfoAllDto.setConstructionRecords(data);



        LambdaQueryWrapper<BasicGridAcceptance> quv=new LambdaQueryWrapper();
        quv.eq(BasicGridAcceptance::getPeasantHouseholdId,peasantHouseholdId);
        BasicGridAcceptance basicGridAcceptance=  basicGridAcceptanceMapper.selectOne(quv);

        //审核意见
        if(Objects.nonNull(basicGridAcceptance) && !StringUtils.isEmpty(basicGridAcceptance.getInstanceId())){
            try {
                Map<String, Object> flowLoggerMap = workflowFeignClient.getFlowLogger(basicGridAcceptance.getInstanceId()).getResult();
                List<LinkedHashMap> flowLogger = (List<LinkedHashMap>) flowLoggerMap.get("flowLogger");
                if (flowLogger.size() > 0 ){
                    Collections.reverse(flowLogger);
                }
                List<LinkedHashMap> flowLoggernew =new ArrayList<>();
                for (LinkedHashMap linkedHashMap : flowLogger) {
                    if(linkedHashMap.get("operateDate")!=null&&!linkedHashMap.get("operateDate").toString().isEmpty()){
                        LinkedHashMap linke=new LinkedHashMap();
                        linke.put("approvalStatue",linkedHashMap.get("approvalStatue").toString());
                        //审核意见
                        List<LinkedHashMap> approvalSuggestion = (List<LinkedHashMap>)linkedHashMap.get("approvalSuggestion");
                        if(approvalSuggestion!=null&&!approvalSuggestion.isEmpty()){
                            linke.put("approvalSuggestion",approvalSuggestion.get(0).get("message"));
                        }
                        linke.put("taskName",linkedHashMap.get("taskName").toString());
                        linke.put("operator",linkedHashMap.get("operator").toString());
                        linke.put("operateDate",linkedHashMap.get("operateDate").toString());
                        flowLoggernew.add(linke);
                    }
                }
                LoggerDto loggerDto =new  LoggerDto();
                loggerDto.setLogger(flowLoggernew);
                surveyInfoAllDto.setLoggerDto(loggerDto);
            } catch (Exception e){
                e.printStackTrace();
            }
        }




        return surveyInfoAllDto;
//        LambdaQueryWrapper<PeasantHousehold> peasantHouseholdWrapper = new LambdaQueryWrapper<>();
//        peasantHouseholdWrapper.eq(PeasantHousehold::getSequenceNbr, peasantHouseholdId);
//        peasantHousehold = peasantHouseholdServiceImpl.getBaseMapper().selectOne(peasantHouseholdWrapper);
//        String  surveyInformationId = String.valueOf(peasantHousehold.getSurveyInformationId());
//
//        //勘察基本信息
//        LambdaQueryWrapper<SurveyInformation> queryWrapper = new LambdaQueryWrapper<>();
//        queryWrapper.eq(SurveyInformation::getSequenceNbr, surveyInformationId);
//        SurveyInformation surveyInformation = surveyInformationMapper.selectOne(queryWrapper);
//        surveyInfoAllDto.setSurveyInformation(BeanDtoUtils.convert(surveyInformation, SurveyInformationDto.class));
//
//
//        //获取用户所在经销商单位
//        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto(peasantHousehold.getDeveloperUserId());
//        BeanUtils.copyProperties(peasantHousehold, surveyInfoAllDto.getSurveyInformation());
//        surveyInfoAllDto.getSurveyInformation().setDeveloperName(userUnitInformationDto.getAmosDealerName());
//        surveyInfoAllDto.getSurveyInformation().setDeveloperCode(userUnitInformationDto.getAmosDealerOrgCode());
//        surveyInfoAllDto.getSurveyInformation().setDeveloperId(userUnitInformationDto.getAmosDealerId());
//
//        if (!StringUtils.isEmpty(peasantHousehold.getProjectAddressName())) {
//            surveyInfoAllDto.getSurveyInformation().setProjectAddressText(Arrays.asList(peasantHousehold.getProjectAddressName().split("/")));
//        }
//        if(!StringUtils.isEmpty(peasantHousehold.getPermanentAddressName())){
//            surveyInfoAllDto.getSurveyInformation().setPermanentAddressText(Arrays.asList(peasantHousehold.getPermanentAddressName().split("/")));
//        }
//        if(peasantHousehold.getPermanentAddress() ==null){
//            surveyInfoAllDto.getSurveyInformation().setPermanentAddress(peasantHousehold.getProjectAddress());
//            surveyInfoAllDto.getSurveyInformation().setIsPermanent("1");
//        }
//        surveyInfoAllDto.getSurveyInformation().setSequenceNbr(surveyInformation.getSequenceNbr());
//        surveyInfoAllDto.getSurveyInformation().setCreatorTime(new Date());
//
//        //派工单信息
//        LambdaQueryWrapper<WorkOrder> upl=new LambdaQueryWrapper();
//        upl.eq(WorkOrder::getSequenceNbr,workOrderId);
//        WorkOrder workOrder= workOrderMapper.selectOne(upl);
//
//        //施工信息
//        LambdaQueryWrapper<PowerStationConstructionData> up2=new LambdaQueryWrapper();
//        up2.eq(PowerStationConstructionData::getWorkOrderId,workOrderId);
//        up2.eq(PowerStationConstructionData::getWorkOrderPowerStationId,workOrderPowerStationId);
//        PowerStationConstructionData powerStationConstructionData=powerStationConstructionDataMapper.selectOne(up2);
//
//        //工程信息
//
//        LambdaQueryWrapper<PowerStationEngineeringInfo> up3=new LambdaQueryWrapper();
//        up3.eq(PowerStationEngineeringInfo::getWorkOrderId,workOrderId);
//        up3.eq(PowerStationEngineeringInfo::getWorkOrderPowerStationId,workOrderPowerStationId);
//        PowerStationEngineeringInfo powerStationEngineeringInfo=powerStationEngineeringInfoMapper.selectOne(up3);
//        if(powerStationConstructionData!=null){
//            powerStationEngineeringInfo=powerStationEngineeringInfo!=null?powerStationEngineeringInfo:new PowerStationEngineeringInfo();
//            powerStationEngineeringInfo.setConstructionComponentInfo(powerStationConstructionData.getConstructionComponentInfo());
//            powerStationEngineeringInfo.setConstructionInverterInfo(powerStationConstructionData.getConstructionInverterInfo());
//            powerStationEngineeringInfo.setConstructionCollectorBoxInfo(powerStationConstructionData.getConstructionCollectorBoxInfo());
//            powerStationEngineeringInfo.setConstructionGridBoxInfo(powerStationConstructionData.getConstructionGridBoxInfo());
//            powerStationEngineeringInfo.setProjectRegionManager(workOrder.getProjectRegionManager());
//            powerStationEngineeringInfo.setProjectRegionManagerPhone(workOrder.getProjectRegionManagerPhone());
//            powerStationEngineeringInfo.setConstructionRegionManager(workOrder.getConstructionRegionManager());
//            powerStationEngineeringInfo.setConstructionRegionManagerPhone(workOrder.getConstructionRegionManagerPhone());
//        }
//        powerStationEngineeringInfo.setCompletionDate(new Date());
//        surveyInfoAllDto.setPowerStationConstructionData(powerStationConstructionData);
//        surveyInfoAllDto.setPowerStationEngineeringInfo(powerStationEngineeringInfo);

//        return surveyInfoAllDto;
    }
     @Transactional(isolation = Isolation.REPEATABLE_READ)
    public PowerStationEngineeringInfoAllDto  addPowerStationEngineeringInfo(PowerStationEngineeringInfoAllDto powerStationEngineeringInfoAllDto){

         LambdaQueryWrapper<WorkOrderPowerStation> qu=new LambdaQueryWrapper();
         qu.eq(WorkOrderPowerStation::getSequenceNbr,powerStationEngineeringInfoAllDto.getWorkOrderPowerStationId());
         WorkOrderPowerStation workOrderPowerStation=workOrderPowerStationMapper.selectOne(qu);
        //修改电站状态
         workOrderPowerStation.setPowerStationConstructionStatus(WorkOrderEnum.待审核.getCode());
         workOrderPowerStationMapper.updateById(workOrderPowerStation);
         //修改派工单状态PowerStationEngineeringInfo
         LambdaQueryWrapper<WorkOrderPowerStation> qu1=new LambdaQueryWrapper();
         qu1.eq(WorkOrderPowerStation::getWorkOrderId,workOrderPowerStation.getWorkOrderId());
         List<String> d=new ArrayList<>();
         d.add(WorkOrderEnum.施工中.getCode());
         d.add(WorkOrderEnum.待施工.getCode());
         d.add(WorkOrderEnum.待登记.getCode());
         qu1.in(WorkOrderPowerStation::getPowerStationConstructionStatus,d);
         List<WorkOrderPowerStation> list=workOrderPowerStationMapper.selectList(qu1);
         LambdaUpdateWrapper<WorkOrder> upq=new LambdaUpdateWrapper();
         upq.eq(WorkOrder::getSequenceNbr,workOrderPowerStation.getWorkOrderId());
         if(list==null||list.isEmpty()){
             upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.审核中.getCode());
             workOrderMapper.update(null,upq);
         }
         //新增完工登记
         PowerStationEngineeringInfo powerStationEngineeringInfo= powerStationEngineeringInfoAllDto.getPowerStationEngineeringInfo();
         powerStationEngineeringInfo.setWorkOrderId(workOrderPowerStation.getWorkOrderId());
         powerStationEngineeringInfo.setWorkOrderPowerStationId(powerStationEngineeringInfoAllDto.getWorkOrderPowerStationId());
         powerStationEngineeringInfoService.saveOrUpdate(powerStationEngineeringInfo);
         //增加操作日志
         ConstructionRecords da=new ConstructionRecords(
                 powerStationEngineeringInfo.getRecUserName(),
                 "完工登记",
                 new Date(),
                 "",
                 workOrderPowerStation.getWorkOrderId(),
                 workOrderPowerStation.getSequenceNbr(),
                 workOrderPowerStation.getPeasantHouseholdId(),
                 "");
         constructionRecordsServiceImpl.save(da);
         return powerStationEngineeringInfoAllDto;
    }



    public PowerStationEngineeringInfoAllDto getConstructionRecords(Long workOrderPowerStationId,String rename)   {

        LambdaQueryWrapper<WorkOrderPowerStation> qu=new LambdaQueryWrapper();
        qu.eq(WorkOrderPowerStation::getSequenceNbr,workOrderPowerStationId);
        WorkOrderPowerStation workOrderPowerStation=workOrderPowerStationMapper.selectOne(qu);
        Long peasantHouseholdId=workOrderPowerStation.getPeasantHouseholdId();
        Long workOrderId=workOrderPowerStation.getWorkOrderId();
        PowerStationEngineeringInfoAllDto surveyInfoAllDto = new PowerStationEngineeringInfoAllDto();
        //施工自审
        LambdaQueryWrapper<ConstructionRecords> up5=new LambdaQueryWrapper();
        up5.eq(ConstructionRecords::getWorkOrderId,workOrderId);
        up5.eq(ConstructionRecords::getWorkOrderPowerStationId,workOrderPowerStationId);
        up5.orderByDesc(ConstructionRecords::getRecDate);
        List<ConstructionRecords>   li=constructionRecordsMapper.selectList(up5);
        ConstructionRecords data=new ConstructionRecords();
        data.setConstructionRecordsList(li);
        data.setOperationTime(new Date());
        data.setOperator(rename);
        surveyInfoAllDto.setConstructionRecords(data);
        return surveyInfoAllDto;

    }


    @Transactional(isolation = Isolation.REPEATABLE_READ)
    public ConstructionRecords  addConstructionRecords(ConstructionRecords constructionRecords){


        LambdaQueryWrapper<WorkOrderPowerStation> qu=new LambdaQueryWrapper();
        qu.eq(WorkOrderPowerStation::getSequenceNbr,constructionRecords.getWorkOrderPowerStationId());
        WorkOrderPowerStation workOrderPowerStation=workOrderPowerStationMapper.selectOne(qu);

         if(constructionRecords.getOperationResults().equals("通过")){
             //修改电站状态
             workOrderPowerStation.setPowerStationConstructionStatus(WorkOrderEnum.已完工.getCode());

             //修改完工时间
             LambdaUpdateWrapper<PowerStationEngineeringInfo> upq1=new LambdaUpdateWrapper();
             upq1.eq(PowerStationEngineeringInfo::getWorkOrderPowerStationId,workOrderPowerStation.getSequenceNbr());
             upq1.set(PowerStationEngineeringInfo::getCompletionDate,new Date());
             powerStationEngineeringInfoMapper.update(null,upq1);

             BasicGridAcceptance dat=new BasicGridAcceptance();
             dat.setWorkOrderId(workOrderPowerStation.getWorkOrderId());
             dat.setWorkOrderPowerStationId(workOrderPowerStation.getSequenceNbr());
             dat.setPeasantHouseholdId(workOrderPowerStation.getPeasantHouseholdId());
             dat.setGridStatus("1");
            //新增并网记录
             basicGridAcceptanceMapper.insert(dat);
             workOrderPowerStationMapper.updateById(workOrderPowerStation);
             //修改派工单状态
             LambdaQueryWrapper<WorkOrderPowerStation> qu1=new LambdaQueryWrapper();
             qu1.eq(WorkOrderPowerStation::getWorkOrderId,workOrderPowerStation.getWorkOrderId());
             List<String> d=new ArrayList<>();
             d.add(WorkOrderEnum.施工中.getCode());
             d.add(WorkOrderEnum.待施工.getCode());
             d.add(WorkOrderEnum.待登记.getCode());
             d.add(WorkOrderEnum.待审核.getCode());
             qu1.in(WorkOrderPowerStation::getPowerStationConstructionStatus,d);
             List<WorkOrderPowerStation> list=workOrderPowerStationMapper.selectList(qu1);
             LambdaUpdateWrapper<WorkOrder> upq=new LambdaUpdateWrapper();
             upq.eq(WorkOrder::getSequenceNbr,workOrderPowerStation.getWorkOrderId());
             if(list==null||list.isEmpty()){
                 upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.已完工.getCode());
                 workOrderMapper.update(null,upq);
             }

         }else{
             //修改电站状态
             workOrderPowerStation.setPowerStationConstructionStatus(WorkOrderEnum.未通过.getCode());
             workOrderPowerStationMapper.updateById(workOrderPowerStation);
             LambdaUpdateWrapper<WorkOrder> upq=new LambdaUpdateWrapper();
             upq.eq(WorkOrder::getSequenceNbr,workOrderPowerStation.getWorkOrderId());
             upq.set(WorkOrder::getWorkOrderStatus,WorkOrderEnum.未通过
                     .getCode());
             workOrderMapper.update(null,upq);

         }

        //增加操作日志
        constructionRecords.setWorkOrderId(workOrderPowerStation.getWorkOrderId());
        constructionRecords.setOperationContent("完工自审-"+constructionRecords.getOperationResults());
        constructionRecords.setWorkOrderPowerStationId(workOrderPowerStation.getSequenceNbr());
        constructionRecords.setPeasantHouseholdId(workOrderPowerStation.getPeasantHouseholdId());
        constructionRecordsServiceImpl.save(constructionRecords);
        return constructionRecords;
    }

}