package com.yeejoin.precontrol.common.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import com.yeejoin.amos.component.rule.Label;
import com.yeejoin.amos.component.rule.RuleFact;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @description: 违规管理
 * @author: duanwei
 * @date: 2020-07-17 15:48
 **/
@Data
@RuleFact(project = "施工安全预控", value = "违章对象")
public class SingBadManagementDto extends BaseDto implements Serializable{

    // 人员类型 0主持人 1交底人 2施工负责人 3安全员 4记录人 5交底人员 6技术员 7工程人员 8施工人员 9违章人员 10分包商负责人 99 发布人
    private static final long serialVersionUID = -4597159693050351L;

    @ApiModelProperty(value = "任务ID")
    @Label(value = "任务ID")
    private Long id;

    @ApiModelProperty(value = "项目ID")
    @Label(value = "项目ID")
    private Long projectId;

    @ApiModelProperty(value = "发起人ID")
    @Label(value = "发起人ID")
    private Long createId;

    @ApiModelProperty(value = "违规内容")
    @Label(value = "违规内容")
    private String body;

    @ApiModelProperty(value = "文件路径")
    @Label(value = "文件路径")
    @ImagePrefix
    private List<String> filePath;

    @ApiModelProperty(value = "分包商企业ID")
    @Label(value = "分包商企业ID")
    private Long companyId;

    @ApiModelProperty(value = "分包商负责人")
    @Label(value = "分包商负责人")
    private Long personLiableId;

    @ApiModelProperty(value = "违规人ID")
    @Label(value = "违规人ID")
    private List<Long> badManagementId;

    @ApiModelProperty(value = "违规类型")
    @Label(value = "违规类型")
    private String type;

    @ApiModelProperty(value = "审核人ID")
    @Label(value = "审核人ID")
    private Long auditPersonId;
    
    @ApiModelProperty(value = "违章性质")
    @Label(value = "违章性质")
    private String nature;
    
    @ApiModelProperty(value = "奖励金额")
    @Label(value = "奖励金额")
    private BigDecimal rewardMoney;
    
    @ApiModelProperty(value = "惩罚金额")
    @Label(value = "惩罚金额")
    private BigDecimal punishMoney;
       
}
