package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 风险点变化流水
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_rpn_change_log")
public class FireRpnChangeLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 风险点id
     */
    @TableField("risk_point_mrid")
    private String riskPointMrid;

    /**
     * 风险点名称
     */
    @TableField("risk_point_name")
    private String riskPointName;

    /**
     * 点状态：normal-正常；anomaly-异常；
     */
    @TableField("risk_point_status")
    private String riskPointStatus;

    /**
     * 1-1级；2-2级；3-3级；4-4级
     */
    @TableField("level_code")
    private String levelCode;

    /**
     * 等级名称
     */
    @TableField("level_name")
    private String levelName;

    /**
     * 安全等级变化类型:0-安全等级下降；1-安全等级不变；2-安全等级上升
     */
    @TableField("level_change_type")
    private Integer levelChangeType;
}
