package com.yeejoin.amos.file.dto;

import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel("子目录信息")
public class ChildCatalog {

    @ApiModelProperty("目录Id")
    private String catalogId;

    @ApiModelProperty("目录名称")
    private String catalogName;

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("目录层级")
    private Integer catalogLevel;

    @ApiModelProperty("目录在页面的位置：和页面顶部的距离")
    private double position;

    @ApiModelProperty("当前目录的子目录信息")
    private List<ChildCatalog> childCatalogList = new ArrayList<>();

    public String getCatalogId() {
        return catalogId;
    }

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getCatalogName() {
        return catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getCatalogLevel() {
        return catalogLevel;
    }

    public void setCatalogLevel(Integer catalogLevel) {
        this.catalogLevel = catalogLevel;
    }

    public double getPosition() {
        return position;
    }

    public void setPosition(double position) {
        this.position = position;
    }

    public List<ChildCatalog> getChildCatalogList() {
        return childCatalogList;
    }

    public void setChildCatalogList(List<ChildCatalog> childCatalogList) {
        this.childCatalogList = childCatalogList;
    }
}
