package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.equipmanage.common.entity.BuildingAudit;
import com.yeejoin.equipmanage.common.vo.BuildingAuditVO;

import java.util.List;

public interface IBuildingAuditService extends IService<BuildingAudit> {

    /**
     * 保存审核信息
     */
    boolean saveAudit (BuildingAuditVO buildingAuditVO);

    /**
     * 查询列表
     */
    IPage<BuildingAudit> auditList(Page page, BuildingAuditVO buildingAuditVO);

    /**
     * 根据ids删除
     */
    int deleteAudit (List<Long> ids);

    /**
     * 根据id查询信息
     */
    BuildingAuditVO getAuditById (Long id);

    /**
     * 根据id修改审核信息
     */
    int editAudit (BuildingAuditVO buildingAuditVO);
}
