package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description: 验收状态枚举
 */
@Getter
@AllArgsConstructor
@SuppressWarnings("ALL")
public enum AcceptanceStatusEnum {

    待提交验收("待提交验收", 1),

    待投融验收("待投融验收", 2),

    投融验收不通过("投融验收不通过", 3),

    待法务验收("待法务验收", 4),

    法务验收不通过("法务验收不通过", 5),

    待工程验收("待工程验收", 6),

    工程验收不通过("工程验收不通过", 7),

    待线下验收("待线下验收", 8),

    线下验收不通过("线下验收不通过", 9),

    验收完成("验收完成", 10);


    /**
     * 名称，描述
     */
    private final String name;
    /**
     * 编码
     */
    private final int code;

    public static AcceptanceStatusEnum getNodeByCode(int code) {
        AcceptanceStatusEnum acceptanceStatusEnum = null;
        for (AcceptanceStatusEnum type : AcceptanceStatusEnum.values()) {
            if (type.getCode() == code) {
                acceptanceStatusEnum = type;
                break;
            }
        }
        return acceptanceStatusEnum;
    }

}
