package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;

/**
 * 验收检查项
 */
@Data
public class AcceptanceCheckItemDto extends BaseDto {

    /**
     * 施工单ID
     */
    private Long workOrderId;

    /**
     * 施工电站ID
     */
    private Long workOrderPowerStationId;

    /**
     * 农户ID
     */
    private Long peasantHouseholdId;

    // ------------------------------------------------组件与组串------------------------------------------------
    /**
     * 型号
     */
    private String assemblyModel;

    /**
     * 型号（备注）
     */
    private String assemblyModelRemark;

    /**
     * 功率
     */
    private String assemblyPower;

    /**
     * 功率（备注）
     */
    private String assemblyPowerRemark;

    /**
     * 数量-组件
     */
    private String assemblyQuantity;

    /**
     * 数量-组件（备注）
     */
    private String assemblyQuantityRemark;

    /**
     * 数量-组串
     */
    private String stringQuantity;

    /**
     * 数量-组串（备注）
     */
    private String stringQuantityRemark;

    /**
     * 平整洁净程度
     */
    private String cleanliness;

    /**
     * 平整洁净程度（备注）
     */
    private String cleanlinessRemark;

    /**
     * 完整无破损
     */
    private String intact;

    /**
     * 完整无破损（备注）
     */
    private String intactRemark;

    /**
     * 无阴影遮挡
     */
    private String shadow;

    /**
     * 无阴影遮挡（备注）
     */
    private String shadowRemark;

    /**
     * 组件高差
     */
    private String assemblyHeightDifference;

    /**
     * 组件高差（备注）
     */
    private String assemblyHeightDifferenceRemark;

    /**
     * 组件间间距
     */
    private String assemblySpacing;

    /**
     * 组件间间距（备注）
     */
    private String assemblySpacingRemark;

    /**
     * 同组组串倾角/方位角偏差
     */
    private String stringAngleDifference;

    /**
     * 同组组串倾角/方位角偏差（备注）
     */
    private String stringAngleDifferenceRemark;

    /**
     * 组件固定螺栓力矩值
     */
    private String assemblyBoltForceMoment;

    /**
     * 组件固定螺栓力矩值（备注）
     */
    private String assemblyBoltForceMomentRemark;

    /**
     * 组件序列号检查1
     */
    private String assemblySerialNumberCheckOne;

    /**
     * 组件序列号检查2
     */
    private String assemblySerialNumberCheckTwo;

    /**
     * 其他
     */
    private String assemblyOther;

    // ------------------------------------------------逆变器------------------------------------------------
    /**
     * 型号
     */
    private String inverterModel;

    /**
     * 型号（备注）
     */
    private String inverterModelRemark;

    /**
     * 完整无破损、受潮
     */
    private String inverterIntact;

    /**
     * 完整无破损、受潮（备注）
     */
    private String inverterIntactRemark;

    /**
     * 安装高度
     */
    private String inverterInstallationHeight;

    /**
     * 安装高度（备注）
     */
    private String inverterInstallationHeightRemark;

    /**
     * 交直流电缆绝缘良好
     */
    private String inverterCableInsulation;

    /**
     * 交直流电缆绝缘良好（备注）
     */
    private String inverterCableInsulationRemark;

    /**
     * 电缆相序、极性正确
     */
    private String inverterCableSequence;

    /**
     * 电缆相序、极性正确（备注）
     */
    private String inverterCableSequenceRemark;

    /**
     * 其他
     */
    private String inverterOther;

    // ------------------------------------------------支架基础------------------------------------------------
    /**
     * 规格
     */
    private String zipperSpecification;

    /**
     * 规格（备注）
     */
    private String zipperSpecificationRemark;

    /**
     * 数量（与设计图对比）
     */
    private String zipperQuantity;

    /**
     * 数量（与设计图对比）（备注）
     */
    private String zipperQuantityRemark;

    /**
     * 支架焊接质量
     */
    private String bracketWeldingQuality;

    /**
     * 支架焊接质量（备注）
     */
    private String bracketWeldingQualityRemark;

    /**
     * 不影响原建筑防水
     */
    private String waterproof;

    /**
     * 不影响原建筑水防（备注）
     */
    private String waterproofRemark;

    /**
     * 支架之间螺丝紧固程度
     */
    private String bracketScrewsTightness;

    /**
     * 支架之间螺丝紧固程度（备注）
     */
    private String bracketScrewsTightnessRemark;

    /**
     * 其他
     */
    private String bracketOther;

    // ------------------------------------------------并网箱------------------------------------------------
    /**
     * 型号
     */
    private String gridBoxModel;

    /**
     * 型号（备注）
     */
    private String gridBoxModelRemark;

    /**
     * 外观完整无破损、变形
     */
    private String gridBoxIntact;

    /**
     * 外观完整无破损、变形（备注）
     */
    private String gridBoxIntactRemark;

    /**
     * 警示标识是否齐全
     */
    private String gridBoxWarningMark;

    /**
     * 警示标识是否齐全（备注）
     */
    private String gridBoxWarningMarkRemark;

    /**
     * 箱内走线美观清晰
     */
    private String gridBoxLineNeat;

    /**
     * 箱内走线美观清晰（备注）
     */
    private String gridBoxLineNeatRemark;

    /**
     * 元器件紧固螺栓完好
     */
    private String gridBoxBoltIntact;

    /**
     * 元器件紧固螺栓完好（备注）
     */
    private String gridBoxBoltIntactRemark;

    /**
     * 防火封堵齐全
     */
    private String fireProtectionComplete;

    /**
     * 防火封堵齐全（备注）
     */
    private String fireProtectionCompleteRemark;

    /**
     * 表箱接地线安装
     */
    private String meterBoxGroundWire;

    /**
     * 表箱接地线安装（备注）
     */
    private String meterBoxGroundWireRemark;

    /**
     * 箱内无杂物
     */
    private String boxClean;

    /**
     * 箱内无杂物（备注）
     */
    private String boxCleanRemark;

    /**
     * 安装高度
     */
    private String boxInstallationHeight;

    /**
     * 安装高度（备注）
     */
    private String boxInstallationHeightRemark;

    /**
     * 其他
     */
    private String boxOther;

    // ------------------------------------------------电缆------------------------------------------------
    /**
     * 交、直、地规格
     */
    private String cableSpecification;

    /**
     * 交、直、地规格（备注）
     */
    private String cableSpecificationRemark;

    /**
     * 交直流无同管敷设
     */
    private String cableLaying;

    /**
     * 交直流无同管敷设（备注）
     */
    private String cableLayingRemark;

    /**
     * MC4安装牢固
     */
    private String cableMc4Intact;

    /**
     * MC4安装牢固（备注）
     */
    private String cableMc4IntactRemark;

    /**
     * 电缆绝缘层无破损
     */
    private String cableInsulationIntact;

    /**
     * 电缆绝缘层无破损（备注）
     */
    private String cableInsulationIntactRemark;

    /**
     * 电缆采用穿管或桥架保护
     */
    private String cableProtection;

    /**
     * 电缆采用穿管或桥架保护（备注）
     */
    private String cableProtectionRemark;

    /**
     * 电缆进出箱柜端口有防火泥封堵
     */
    private String cableFirewall;

    /**
     * 电缆进出箱柜端口有防火泥封堵（备注）
     */
    private String cableFirewallRemark;

    /**
     * 走线横平竖直
     */
    private String cableNeat;

    /**
     * 走线横平竖直（备注）
     */
    private String cableNeatRemark;

    /**
     * 管卡间距
     */
    private String cableSpacing;

    /**
     * 管卡间距（备注）
     */
    private String cableSpacingRemark;

    /**
     * 直角转弯间距
     */
    private String cableRightAngleSpacing;

    /**
     * 直角转弯间距（备注）
     */
    private String cableRightAngleSpacingRemark;

    /**
     * 其他
     */
    private String cableOther;

    // ------------------------------------------------接地系统安装------------------------------------------------
    /**
     * 组件之间连接的接地线径
     */
    private String groundWireDiameter;

    /**
     * 组件之间连接的接地线径（备注）
     */
    private String groundWireDiameterRemark;

    /**
     * 逆变器内部表箱接地接电线需要有鼻子
     */
    private String groundWireNose;

    /**
     * 支架和电表箱共用接地极接地电阻小于4欧姆
     */
    private String groundResistanceLessThan4;

    /**
     * 支架接地需小于10欧姆
     */
    private String groundResistanceLessThan10;

    /**
     * 电表箱单独接地符合国家标准，小于4欧姆
     */
    private String groundResistanceStandardCompliant;

    /**
     * 其他
     */
    private String groundOther;

    // ------------------------------------------------电站检查项拍照片保存------------------------------------------------
    /**
     * 逆变器整体图
     */
    private String overallImage;
    /**
     * 电表箱整体图
     */
    private String meterBoxOverallImage;
    /**
     * 组件方阵图
     */
    private String assemblyArrayImage;
    /**
     * 组件方位角测试照片
     */
    private String assemblyAzimuthImage;
    /**
     * 组件倾斜角测试照片
     */
    private String assemblyDipAngleImage;
}
