package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@ApiModel(value = "AcceptanceDto", description = "验收管理DTO")
public class AcceptanceDto extends BaseDto {
    @ApiModelProperty(value = "电站编号")
    private String powerStationCode;

    @ApiModelProperty(value = "业主姓名")
    private String ownersName;

    @ApiModelProperty(value = "项目地址")
    private String projectAddress;

    @ApiModelProperty(value = "服务代理商")
    private String serviceAgent;

    @ApiModelProperty(value = "提交日期")
    private Object submitDate;

    @JsonIgnore
    @ApiModelProperty(value = "开始提交日期-[查询参数使用]")
    private String startSubmitDate;

    @JsonIgnore
    @ApiModelProperty(value = "截至提交日期-[查询参数使用]")
    private Object endSubmitDate;

    @ApiModelProperty(value = "整改单数量")
    private Integer rectificationOrderCount;

    @ApiModelProperty(value = "验收状态")
    private String acceptanceStatus;

    @ApiModelProperty(value = "验收状态描述")
    private String acceptanceStatusDesc;

    @ApiModelProperty(value = "整改状态")
    private String rectificationStatus;

    @ApiModelProperty(value = "整改状态描述")
    private String rectificationStatusDesc;

    @ApiModelProperty(value = "平台经销商单位ID")
    private Long amosDealerId;

    @ApiModelProperty(value = "区域公司ID")
    private Long regionCompanyId;

    @ApiModelProperty(value = "区域公司名称")
    private String regionalCompaniesName;

}
