package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 验收整改单
 *
 * @author system_generator
 * @date 2024-01-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AcceptanceRectificationOrderDto", description="验收整改单")
public class AcceptanceRectificationOrderDto  extends BaseDto {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "整改单号")
    private String rectificationOrderCode;

    @ApiModelProperty(value = "施工单id")
    private Long workOrderId;

    @ApiModelProperty(value = "施工电站id")
    private Long workOrderPowerStationId;

    @ApiModelProperty(value = "农户id")
    private Long peasantHouseholdId;

    @ApiModelProperty(value = "问题描述")
    private String problemDescription;

    @ApiModelProperty(value = "整改状态")
    private String rectificationStatus;

    @ApiModelProperty(value = "整改状态描述")
    private String rectificationStatusDesc;

    @ApiModelProperty(value = "整改描述")
    private String rectificationDescription;

    @ApiModelProperty(value = "完成日期")
    private Date completeDate;

    @ApiModelProperty(value = "负责人ID")
    private Long responsibleUserId;

    @ApiModelProperty(value = "负责人姓名")
    private String responsibleUserName;

    @ApiModelProperty(value = "负责人电话")
    private String responsibleUserPhone;

    @ApiModelProperty(value = "整改照片")
    private String rectificationPhoto;

    @ApiModelProperty(value = "电站编号")
    private String powerStationCode;

    @ApiModelProperty(value = "户主姓名")
    private String ownersName;

    @ApiModelProperty(value = "电站地址")
    private String powerStationAddress;

}
