package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 基础并网验收表
 */
@Data
@ApiModel(value="BasicGridAcceptanceDto", description="基础并网验收DTO")
public class BasicGridAcceptanceDto extends BaseDto {

    @ApiModelProperty(value = "施工单ID")
    private Long workOrderId;

    @ApiModelProperty(value = "施工电站ID")
    private Long workOrderPowerStationId;

    @ApiModelProperty(value = "农户ID")
    private Long peasantHouseholdId;

    @ApiModelProperty(value = "并网状态")
    private String gridStatus;

    @ApiModelProperty(value = "验收状态")
    private String acceptanceStatus;

    @ApiModelProperty(value = "验收时间")
    protected Date acceptanceRecDate;

    /**
     * 工作流实例ID
     */
    private String instanceId;

    ///	下一个节点角色权限
    private String nextExecutorIds;

    //	任务发起人id
    private String promoter;

    //	流程下一节点id
    private String nextTaskId;
    //下一节点可执行人逗号分割	0	0
    private String nextExecuteUserIds;
    //工作流发起人id
    private String createUserId;
    //下个节点名称
    private String nextNodeName;
    //下个节点key
    private String nextNodeKey;



    //电站编号
    private String peasantHouseholdNo;
    //户主姓名
    private String ownersName;
    ///项目地址
    private String projectAddressName;
    //并网日期
    private Date gridConnectionTime;

}
