package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;
import java.util.List;

/**
 * 施工日志
 *
 * @author system_generator
 * @date 2024-01-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_construction_records")
public class ConstructionRecords extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 操作人
     */
	@TableField("operator")
    private String operator;

    /**
     * 操作内容
     */
	@TableField("operation_content")
    private String operationContent;

    /**
     * 操作时间
     */
	@TableField("operation_time")
    private Date operationTime;

    /**
     * 操作结果
     */
	@TableField("operation_results")
    private String operationResults;

    /**
     * 施工单id
     */
	@TableField("work_order_id")
    private Long workOrderId;

    /**
     * 施工电站
     */
	@TableField("work_order_power_station_id")
    private Long workOrderPowerStationId;

    /**
     * 农户id
     */
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;


    @TableField("notes")
    private String  notes;


    public ConstructionRecords(String operator, String operationContent, Date operationTime, String operationResults, Long workOrderId, Long workOrderPowerStationId, Long peasantHouseholdId, String notes) {
        this.operator = operator;
        this.operationContent = operationContent;
        this.operationTime = operationTime;
        this.operationResults = operationResults;
        this.workOrderId = workOrderId;
        this.workOrderPowerStationId = workOrderPowerStationId;
        this.peasantHouseholdId = peasantHouseholdId;
        this.notes = notes;
    }

    public ConstructionRecords() {
    }

    @TableField(exist = false)
    List<ConstructionRecords> constructionRecordsList;



}
