package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.AcceptanceCheckItemServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceCheckItemDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 验收检查项
 *
 * @author system_generator
 * @date 2024-01-16
 */
@RestController
@Api(tags = "验收检查项Api")
@RequestMapping(value = "/acceptance-check-item")
public class AcceptanceCheckItemController extends BaseController {

    @Autowired
    AcceptanceCheckItemServiceImpl acceptanceCheckItemServiceImpl;

    /**
     * 新增验收检查项
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增验收检查项", notes = "新增验收检查项")
	public ResponseModel<AcceptanceCheckItemDto> save(@RequestBody AcceptanceCheckItemDto model) {
	    model = acceptanceCheckItemServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新验收检查项", notes = "根据sequenceNbr更新验收检查项")
	public ResponseModel<AcceptanceCheckItemDto> updateBySequenceNbrAcceptanceCheckItem(@RequestBody AcceptanceCheckItemDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(acceptanceCheckItemServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除验收检查项", notes = "根据sequenceNbr删除验收检查项")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(acceptanceCheckItemServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个验收检查项",  notes = "根据sequenceNbr查询单个验收检查项")
	public ResponseModel<AcceptanceCheckItemDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(acceptanceCheckItemServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "验收检查项分页查询",  notes = "验收检查项分页查询")
	public ResponseModel<Page<AcceptanceCheckItemDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<AcceptanceCheckItemDto> page = new Page<AcceptanceCheckItemDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(acceptanceCheckItemServiceImpl.queryForAcceptanceCheckItemPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "验收检查项列表全部数据查询",   notes = "验收检查项列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<AcceptanceCheckItemDto>> selectForList() {
	    return ResponseHelper.buildResponse(acceptanceCheckItemServiceImpl.queryForAcceptanceCheckItemList());
	}
}
