package com.yeejoin.amos.boot.module.hygf.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.AcceptanceRectificationOrderServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceRectificationOrderDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 验收整改单
 *
 * @author system_generator
 * @date 2024-01-16
 */
@RestController
@Api(tags = "验收整改单Api")
@RequestMapping(value = "/acceptance-rectification-order")
public class AcceptanceRectificationOrderController extends BaseController {

    @Autowired
    AcceptanceRectificationOrderServiceImpl acceptanceRectificationOrderServiceImpl;

    /**
     * 新增验收整改单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增验收整改单", notes = "新增验收整改单")
	public ResponseModel<AcceptanceRectificationOrderDto> save(@RequestBody AcceptanceRectificationOrderDto model) {
	    model = acceptanceRectificationOrderServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新验收整改单", notes = "根据sequenceNbr更新验收整改单")
	public ResponseModel<AcceptanceRectificationOrderDto> updateBySequenceNbrAcceptanceRectificationOrder(@RequestBody AcceptanceRectificationOrderDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(acceptanceRectificationOrderServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除验收整改单", notes = "根据sequenceNbr删除验收整改单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(acceptanceRectificationOrderServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个验收整改单",  notes = "根据sequenceNbr查询单个验收整改单")
	public ResponseModel<AcceptanceRectificationOrderDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(acceptanceRectificationOrderServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "验收整改单分页查询",  notes = "验收整改单分页查询")
	public ResponseModel<Page<AcceptanceRectificationOrderDto>> queryForPage(
			@RequestParam(value = "acceptanceSeqNbr") Long acceptanceSeqNbr,
			@RequestParam(value = "current", required = false, defaultValue = "1") Integer current,
			@RequestParam(value = "size", required = false, defaultValue = "20") Integer size
	) {
	    Page<AcceptanceRectificationOrderDto> page = new Page<>(current, size);
	    return ResponseHelper.buildResponse(acceptanceRectificationOrderServiceImpl.queryForAcceptanceRectificationOrderPage(page, acceptanceSeqNbr));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "验收整改单列表全部数据查询",   notes = "验收整改单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<AcceptanceRectificationOrderDto>> selectForList() {
	    return ResponseHelper.buildResponse(acceptanceRectificationOrderServiceImpl.queryForAcceptanceRectificationOrderList());
	}
}
