package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.Enum.GridStatusEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.ProcessDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.StartProcessDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.UserUnitInformationDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfOnGrid;
import com.yeejoin.amos.boot.module.hygf.api.entity.PeasantHousehold;
import com.yeejoin.amos.boot.module.hygf.api.mapper.BasicGridAcceptanceMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.HygfOnGridMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PersonnelBusinessMapper;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.WorkflowImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.hygf.biz.service.impl.BasicGridAcceptanceServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.BasicGridAcceptanceDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 *
 *
 * @author system_generator
 * @date 2024-01-16
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/basic-grid-acceptance")
public class BasicGridAcceptanceController extends BaseController {

    @Autowired
    BasicGridAcceptanceServiceImpl basicGridAcceptanceServiceImpl;
	@Autowired
	BasicGridAcceptanceMapper basicGridAcceptanceMapper;
	@Autowired
	HygfOnGridMapper onGridMapper;
    @Autowired
    PersonnelBusinessMapper personnelBusinessMapper;
	@Autowired
	WorkflowImpl workflow;

    /**
     * 新增保存
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel save(@RequestBody Map<String, HygfOnGrid> model) {
		HygfOnGrid dto = model.get("HygfOnGridInfo");
	    return ResponseHelper.buildResponse(basicGridAcceptanceServiceImpl.saveEntity(dto));
	}

	/**
	 * 新增保存
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save/commit")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel saveAndCommit(@RequestBody Map<String, HygfOnGrid> model) {
		HygfOnGrid dto = model.get("HygfOnGridInfo");
		return ResponseHelper.buildResponse(basicGridAcceptanceServiceImpl.saveAndCommit(dto));
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel updateBySequenceNbrBasicGridAcceptance(@RequestBody HygfOnGrid model,
																@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(basicGridAcceptanceServiceImpl.modifyEntity(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(@RequestParam("sequenceNbrs") Long[] sequenceNbrs){
        return ResponseHelper.buildResponse(basicGridAcceptanceServiceImpl.deleteForBatch(sequenceNbrs));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<BasicGridAcceptanceDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(basicGridAcceptanceServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 经销商端列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<BasicGridAcceptanceDto>> queryForPage(@RequestParam(value = "current") int current,
																	@RequestParam(value = "size") int size,
																	@RequestParam(required = false,value = "projectAddress") String projectAddress,
																	@RequestParam(required = false,value = "powerStationCode") String powerStationCode,
																	@RequestParam(required = false,value = "ownersName") String ownersName,
																	@RequestParam(required = false,value = "gridStatus") String gridStatus,
																	@RequestParam(required = false,value = "gridConnectionTime") Date gridConnectionTime) {
        //当前登录人所属场站
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());
	    Page<BasicGridAcceptanceDto> page = basicGridAcceptanceServiceImpl.selectPage(userUnitInformationDto.getRegionalCompaniesSeq(),userUnitInformationDto.getAmosDealerId(),current, size, projectAddress, powerStationCode, ownersName, gridStatus, gridConnectionTime, "");
	    return ResponseHelper.buildResponse(page);
	}

	/**
	 * 审核管理端列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/check/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<BasicGridAcceptanceDto>> queryForCheckPage(@RequestParam(value = "current") int current,
																	@RequestParam(value = "size") int size,
																	@RequestParam(value = "projectAddress") String projectAddress,
																	@RequestParam(value = "powerStationCode") String powerStationCode,
																	@RequestParam(value = "ownersName") String ownersName,
																	@RequestParam(value = "gridStatus") String gridStatus,
																	@RequestParam(value = "gridConnectionTime") Date gridConnectionTime) {
        //当前登录人所属场站
        UserUnitInformationDto userUnitInformationDto=personnelBusinessMapper.getUserUnitInformationDto( getUserInfo().getUserId());

        Page<BasicGridAcceptanceDto> page = basicGridAcceptanceServiceImpl.selectPage(userUnitInformationDto.getRegionalCompaniesSeq(),userUnitInformationDto.getAmosDealerId(),current, size, projectAddress, powerStationCode, ownersName, gridStatus, gridConnectionTime, "check");
		return ResponseHelper.buildResponse(page);
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<BasicGridAcceptanceDto>> selectForList() {
	    return ResponseHelper.buildResponse(Collections.emptyList());
	}
}
