package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.AcceptanceRectificationOrder;
import com.yeejoin.amos.boot.module.hygf.api.mapper.AcceptanceRectificationOrderMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IAcceptanceRectificationOrderService;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceRectificationOrderDto;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;

/**
 * 验收整改单服务实现类
 *
 * @author system_generator
 * @date 2024-01-16
 */
@Service
public class AcceptanceRectificationOrderServiceImpl extends BaseService<AcceptanceRectificationOrderDto,AcceptanceRectificationOrder,AcceptanceRectificationOrderMapper> implements IAcceptanceRectificationOrderService {
    @Autowired
    private AcceptanceRectificationOrderMapper acceptanceRectificationOrderMapper;

    /**
     * 分页查询
     */
    public Page<AcceptanceRectificationOrderDto> queryForAcceptanceRectificationOrderPage(Page<AcceptanceRectificationOrderDto> page, Long acceptanceSeqNbr)   {
        Page<AcceptanceRectificationOrderDto> resultPage = acceptanceRectificationOrderMapper.page(page, acceptanceSeqNbr);
        resultPage.getRecords().forEach(v -> v.setRectificationStatusDesc("0".equals(v.getRectificationStatus()) ? "待整改" : "整改完成"));
        return resultPage;
    }

    /**
     * 列表查询 示例
     */
    public List<AcceptanceRectificationOrderDto> queryForAcceptanceRectificationOrderList()   {
        return this.queryForList("" , false);
    }
}