package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.module.hygf.api.Enum.AcceptanceStatusEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceCheckItemDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.AcceptanceDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.AcceptanceCheckItem;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.api.mapper.AcceptanceCheckItemMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.AcceptanceMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.BasicGridAcceptanceMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IAcceptanceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class AcceptanceServiceImpl implements IAcceptanceService {

    @Autowired
    private AcceptanceMapper acceptanceMapper;
    @Autowired
    private BasicGridAcceptanceMapper basicGridAcceptanceMapper;
    @Autowired
    private AcceptanceCheckItemMapper acceptanceCheckItemMapper;

    /**
     * 分页查询验收列表数据
     *
     * @param page          分页对象
     * @param acceptanceDto 查询参数
     * @return 分页结果
     */
    @Override
    public IPage<AcceptanceDto> page(IPage<AcceptanceDto> page, AcceptanceDto acceptanceDto) {
        if (Objects.nonNull(acceptanceDto)) {
            // 处理验收状态
            if (StringUtils.hasText(acceptanceDto.getAcceptanceStatus())) {
                String[] vars = acceptanceDto.getAcceptanceStatus().split(",");
                JSONArray jsonArray = new JSONArray();
                jsonArray.addAll(Arrays.asList(vars));
                acceptanceDto.setAcceptanceStatus(jsonArray.toJSONString());
            }
            // 处理提交日期
            if (Objects.nonNull(acceptanceDto.getSubmitDate()) && acceptanceDto.getSubmitDate() instanceof List) {
                Object submitDate = acceptanceDto.getSubmitDate();
                List<String> dates = ((ArrayList<String>) submitDate).stream().map(String::trim).collect(Collectors.toList());
                if (!dates.isEmpty()) {
                    acceptanceDto.setStartSubmitDate(dates.get(0) + " 00:00:00");
                    acceptanceDto.setEndSubmitDate(dates.get(1) + " 23:59:59");
                }
            }
        }
        IPage<AcceptanceDto> resultPage = acceptanceMapper.page(page, acceptanceDto);
        resultPage.getRecords().forEach(v -> {
            AcceptanceStatusEnum statusEnum = AcceptanceStatusEnum.getNodeByCode(Integer.parseInt(v.getAcceptanceStatus()));
            v.setAcceptanceStatusDesc(statusEnum.getName());
            v.setRectificationStatusDesc("0".equals(v.getAcceptanceStatus()) ? "待整改" : "整改完成");
        });
        return resultPage;
    }

    /**
     * 根据sequenceNbr查询验收详情（线下验收）
     *
     * @param sequenceNbr sequenceNbr
     * @return Map
     */
    @Override
    public Map<String, Object> offlineAcceptanceDetails(Long sequenceNbr) {
        Assert.notNull(sequenceNbr, "sequenceNbr不能为空");

        BasicGridAcceptance basicGridAcceptance = basicGridAcceptanceMapper.selectById(sequenceNbr);
        Assert.notNull(basicGridAcceptance, "查询验收单不存在");

        Map<String, Object> result = new HashMap<>(2);
        // 基本信息

        result.put("basicInfo", new HashMap<>());

        // 检查项信息
        AcceptanceCheckItem acceptanceCheckItem = acceptanceCheckItemMapper.selectOne(
                Wrappers.<AcceptanceCheckItem>lambdaQuery()
                        .eq(AcceptanceCheckItem::getWorkOrderPowerStationId, basicGridAcceptance.getWorkOrderPowerStationId())
        );
        AcceptanceCheckItemDto acceptanceCheckItemDto = new AcceptanceCheckItemDto();
        BeanUtils.copyProperties(acceptanceCheckItem, acceptanceCheckItemDto);
        result.put("checkItem", acceptanceCheckItemDto);

        return result;
    }
}
