package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.Enum.GridStatusEnum;
import com.yeejoin.amos.boot.module.hygf.api.dto.BasicGridAcceptanceDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.ProcessDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.StartProcessDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.api.entity.HygfOnGrid;
import com.yeejoin.amos.boot.module.hygf.api.entity.WorkOrder;
import com.yeejoin.amos.boot.module.hygf.api.mapper.BasicGridAcceptanceMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.HygfOnGridMapper;
import com.yeejoin.amos.boot.module.hygf.api.mapper.PersonnelBusinessMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IBasicGridAcceptanceService;
import com.yeejoin.amos.boot.module.hygf.api.service.IHygfOnGridService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
public class BasicGridAcceptanceServiceImpl extends BaseService<BasicGridAcceptanceDto, BasicGridAcceptance, BasicGridAcceptanceMapper> implements IBasicGridAcceptanceService {

    @Autowired
    BasicGridAcceptanceMapper basicGridAcceptanceMapper;
    @Autowired
    HygfOnGridMapper onGridMapper;
    @Autowired
    PersonnelBusinessMapper personnelBusinessMapper;
    @Autowired
    WorkflowImpl workflow;

    public Page<BasicGridAcceptanceDto> selectPage(Long  regionCompanyId  ,Long amosDealerId ,int current, int size, String projectAddress, String powerStationCode, String ownersName, String gridStatus, Date gridConnectionTime, String formType) {
        PageHelper.startPage(current, size);
        Map<String, Object> map = new HashMap<>();
        map.put("projectAddress", projectAddress);
        map.put("powerStationCode", powerStationCode);
        map.put("ownersName", ownersName);
        map.put("gridStatus", gridStatus);
        map.put("gridConnectionTime", gridConnectionTime);
        map.put("formType", formType);
        map.put("regionCompanyId", regionCompanyId);
        map.put("amosDealerId", amosDealerId);
        List<BasicGridAcceptanceDto> list = basicGridAcceptanceMapper.selectPageList(map);
        PageInfo<BasicGridAcceptanceDto> page = new PageInfo(list);
        Page<BasicGridAcceptanceDto> pageNew = new Page<>();
        pageNew.setCurrent(current);
        pageNew.setTotal(page.getTotal());
        pageNew.setSize(size);
        pageNew.setRecords(page.getList());
        return pageNew;
    }

    public HygfOnGrid saveEntity(HygfOnGrid grid) {
        HygfOnGrid onGrid = new HygfOnGrid();
        BeanUtils.copyProperties(grid, onGrid);
        onGridMapper.insert(onGrid);
        BasicGridAcceptance basicGridAcceptance = basicGridAcceptanceMapper.selectOne(new LambdaQueryWrapper<BasicGridAcceptance>().eq(BasicGridAcceptance::getWorkOrderPowerStationId, grid.getWorkOrderPowerStationId()));
        basicGridAcceptance.setGridStatus(GridStatusEnum.DDJ.getCode());
        basicGridAcceptanceMapper.updateById(basicGridAcceptance);
        return onGrid;
    }

    public HygfOnGrid saveAndCommit(HygfOnGrid grid) {
        HygfOnGrid onGrid = new HygfOnGrid();
        BeanUtils.copyProperties(grid, onGrid);
        onGridMapper.insert(onGrid);
        BasicGridAcceptance basicGridAcceptance = basicGridAcceptanceMapper.selectOne(new LambdaQueryWrapper<BasicGridAcceptance>().eq(BasicGridAcceptance::getWorkOrderPowerStationId, grid.getWorkOrderPowerStationId()));
        basicGridAcceptance.setGridStatus(GridStatusEnum.DSH.getCode());
        // 调用工作流执行第一个节点
        ProcessDto processDto = new ProcessDto();
        processDto.setBusinessKey(String.valueOf(basicGridAcceptance.getSequenceNbr()));
        StartProcessDto startProcessDto = new StartProcessDto();
        startProcessDto.setProcess(processDto);
        BasicGridAcceptance workBasicGridAcceptance = workflow.startProcess(basicGridAcceptance, startProcessDto);
        BeanUtils.copyProperties(workBasicGridAcceptance, basicGridAcceptance);
        basicGridAcceptanceMapper.updateById(basicGridAcceptance);
        return onGrid;
    }

    public HygfOnGrid modifyEntity(HygfOnGrid grid) {
        onGridMapper.updateById(grid);
        return grid;
    }

    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        Boolean bool = Boolean.TRUE;
        Collection<HygfOnGrid> grids = onGridMapper.selectBatchIds(Arrays.asList(sequenceNbrs));
        for (HygfOnGrid x : grids) {
            x.setIsDelete(true);
            int num = onGridMapper.updateById(x);
            if (0 == num) {
                bool = Boolean.FALSE;
                break;
            }
        }
        return bool;
    }


}
