package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.module.hygf.api.dto.StandardDto;
import com.yeejoin.amos.boot.module.hygf.api.dto.StartProcessDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.biz.feign.WorkflowFeignClient;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.jsf.el.SpringBeanFacesELResolver;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: tw
 * @createDate: 2024/1/16
 */
@Service
public class WorkflowImpl {

    @Autowired
    WorkflowFeignClient workflowFeignClient;

   /**
    *
    * 发起工作流，并执行第一节点
    *
    * **/


     public BasicGridAcceptance startProcess(BasicGridAcceptance basicGridAcceptance,StartProcessDto startProcessDto){
        FeignClientResult<ProcessTaskDTO> json=   workflowFeignClient.startProcess(startProcessDto);
         basicGridAcceptance= this.getBasicGridAcceptance(basicGridAcceptance,json);
        return basicGridAcceptance;
    }

    /**
     *
     * 执行工作流
     *
     * */
    public BasicGridAcceptance standard(BasicGridAcceptance basicGridAcceptance,StandardDto standardDto){

        FeignClientResult<ProcessTaskDTO> json= workflowFeignClient.standard(standardDto.getTaskId(),standardDto);

        basicGridAcceptance= this.getBasicGridAcceptance(basicGridAcceptance,json);
        return basicGridAcceptance;
    }

    public BasicGridAcceptance getBasicGridAcceptance(BasicGridAcceptance basicGridAcceptance,FeignClientResult<ProcessTaskDTO> json){

        if (!ObjectUtils.isEmpty(json)) {
            if (json.getStatus() == 200) {
                ProcessTaskDTO  listco = json.getResult();
                if(listco!=null){
                    /**
                     * 工作流实例ID
                     */
                    basicGridAcceptance.setInstanceId(listco.getProcessInstance().getId());

                    //	当前节点执行任务id
                    basicGridAcceptance.setPromoter(listco.getExecutor().getUserId());

                    //	流程下一节点id
                    if(listco.getNextTask()!=null&&!listco.getNextTask().isEmpty()){
                        basicGridAcceptance.setNextTaskId(listco.getNextTask().get(0).getId());
                        //下个节点名称
                        basicGridAcceptance.setNextNodeName(listco.getNextTask().get(0).getName());
                        //下个节点key
                        basicGridAcceptance.setNextNodeKey(listco.getNextTask().get(0).getKey());
                    }
                    ///	下一个节点角色权限
                    if(listco.getNextCandidateGroups()!=null){
                        basicGridAcceptance.setNextExecutorIds(JSON.toJSONString(listco.getNextCandidateGroups().get(basicGridAcceptance.getNextTaskId())));
                    }

                    //下一节点可执行人逗号分割	0	0
                    if(listco.getNextTaskExecutor()!=null){

                        List<AgencyUserModel> li=  listco.getNextTaskExecutor().get(basicGridAcceptance.getNextTaskId());
                        if(li!=null&&!li.isEmpty()){

                                StringBuffer sbf = new StringBuffer();
                                 for(int i=0;i<=li.size()-1;i++){
                                     if(i<li.size()-1){
                                         sbf.append(li.get(i).getUserId() + ",");
                                     }else {
                                         sbf.append(li.get(i).getUserId());
                                     }
                                 }
                            basicGridAcceptance.setNextExecuteUserIds(sbf.toString());
                        }
                    }
                    //工作流发起人id
                    basicGridAcceptance.setCreateUserId(listco.getStartUser().getUserId());

                }
            } else {
                throw new RuntimeException(json.getMessage());
            }
        }
    return basicGridAcceptance;
    }




}
