package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ColModel;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.DataGridMock;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.EquipAlarmEventDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipAlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipDivergenceAlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.EquipAlarmEventMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.EquipDivergenceAlarmEventMapper;

@Service
public class EquipAlarmEventServiceImpl extends BaseService<EquipAlarmEventDto, EquipAlarmEvent, EquipAlarmEventMapper> {

    @Autowired
    EquipAlarmEventMapper equipAlarmEventMapper;
    @Autowired
    StationBasicMapper stationBasicMapper;
    @Autowired
    EquipDivergenceAlarmEventMapper equipDivergenceAlarmEventMapper;

    public ResultsData getEventByEquipIndex(String gatewayId, int current, int size, String equipIndex, String frontModule) {
        List<EquipAlarmEventDto> equipAlarmEvents = new ArrayList<>();
        LambdaQueryWrapper<EquipAlarmEvent> queryWrapper = new LambdaQueryWrapper<>();
        if(equipIndex!=null) 
        {
            queryWrapper.eq(EquipAlarmEvent::getEquipIndex, equipIndex);
        }
        queryWrapper.eq(EquipAlarmEvent::getGatewayId, gatewayId);
        if(frontModule!=null) 
        {
            queryWrapper.eq(EquipAlarmEvent::getFrontModule, frontModule);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_MONTH, -7);
        queryWrapper.gt(EquipAlarmEvent::getCreatedTime, calendar.getTime());
        int count = equipAlarmEventMapper.selectCount(queryWrapper);
        
        IPage<EquipAlarmEvent> p = new Page<>(current, size);
        equipAlarmEvents=  equipAlarmEventMapper.getAlarmEventList(gatewayId, equipIndex, frontModule, (p.getCurrent()-1)*p.getSize(), p.getSize(),calendar.getTime());
        //  equipAlarmEvents = equipAlarmEventMapper.selectList(queryWrapper);
        //  equipAlarmEvents=page.getRecords();
        equipAlarmEvents.forEach(i->{
        	if("true".equals(i.getValue())) 
        	{
        		i.setValue("合");
        	}else 
        	{
        		i.setValue("分");
        	}
        });
        DataGridMock DataGridMock = new DataGridMock(current, count, false, current, equipAlarmEvents);
        ColModel colModelEventMovement = new ColModel("equipName", "equipName", "设备名", "设备名", "dataGrid", "equipName");
        ColModel colModelStationName = new ColModel("alarmDesc", "alarmDesc", "事件描述", "事件描述", "dataGrid", "alarmDesc");
        ColModel colModelEventDesc = new ColModel("createdTime", "createdTime", "告警时间", "告警时间", "dataGrid", "createdTime");
        ColModel colModelValueDesc = new ColModel("value", "value", "动作", "动作", "dataGrid", "value");
        List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc,colModelValueDesc);
        ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
        return resultsData;
    }
    
    public ResultsData getEquipDivergenceEvent(String gatewayId, int current, int size) {
    	PageHelper.startPage(current, size);
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DAY_OF_MONTH, -2);
		
		List<EquipDivergenceAlarmEvent> alarmEventList = equipDivergenceAlarmEventMapper.getEventList(gatewayId, null, null,
				calendar.getTime());

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		Calendar car = Calendar.getInstance();
		alarmEventList.forEach(i -> {
//			if ("true".equals(i.getValue())) {
//				i.setValue("合");
//			} else if ("false".equals(i.getValue())) {
//				i.setValue("分");
//			}
			long mills = i.getCreatedTime() ;
			car.setTimeInMillis(mills);
			// System.out.println(sdf.format(car.getTime()));
			String time = sdf.format(car.getTime());
			if (time.contains("1970")) {
				mills = i.getCreatedTime()/ 1000000;
				car.setTimeInMillis(mills);
				time = sdf.format(car.getTime());
			}
			i.setTime(time);
		});

		PageInfo<EquipAlarmEvent> page = new PageInfo(alarmEventList);

		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current, (int) page.getTotal(), false, current, alarmEventList);
		ColModel colModelEventMovement = new ColModel("equipName", "equipName", "设备名称", "设备名称", "dataGrid",
				"equipName");
		ColModel colModelStationName = new ColModel("eventDesc", "eventDesc", "事件描述", "事件描述", "dataGrid", "eventDesc");
		ColModel colModelAlarmGroupName = new ColModel("alarmGroupName", "alarmGroupName", "事件类型", "事件类型", "dataGrid",
				"alarmGroupName");
		ColModel colModelEventDesc = new ColModel("time", "time", "事件发生时间", "事件发生时间", "dataGrid", "time");
		ColModel colModelValueDesc = new ColModel("value", "value", "事件值", "事件值", "dataGrid", "value");
		List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelAlarmGroupName,
				colModelEventDesc, colModelValueDesc);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
    }
}
