package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.annotation.PostConstruct;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jxiop.api.amosprojectmapper.UserEmpowerMapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StdUserEmpower;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jxiop.api.Enum.AlarmDesc;
import com.yeejoin.amos.boot.module.jxiop.api.Enum.KGName;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.TreeDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MonitorFanIndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper4.EquipmentSpecificIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.ESDto.ESEquipments;
import com.yeejoin.amos.boot.module.jxiop.biz.constants.CommonConstans;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.AlarmEventDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ColModel;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.DataGridMock;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ESEquipmentsDTO;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.ResultsData;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.StationCacheInfoDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SystemEnumDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.AlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipmentSpecificIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IndicatorData;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.SjglZsjZsbtz;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.SystemEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.TemporaryData;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.TpriDmpDatabook;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.AlarmEventMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.EquipAlarmEventMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.SjglZsjZsbtzMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.SwitchPictureMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.SystemEnumMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.TemporaryDataMapper;
//import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IMonitorFanIndicator;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.IndicatorDataMapper;
import com.yeejoin.amos.component.robot.BadRequest;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/7/3
 */
@Service
@EnableScheduling
@Slf4j
public class MonitorFanIndicatorImpl implements IMonitorFanIndicator {
	private final static List<String> fanStatesList = Arrays.asList("报警状态", "停机状态", "故障状态", "待机状态", "维护状态", "正常发电状态");
	@Autowired
	private static Map<String, EquipmentSpecificIndex> map;
	@Autowired
	SystemEnumMapper systemEnumMapper;
	@Autowired
	SjglZsjZsbtzServiceImpl sjglZsjZsbtzServiceImpl;
	@Autowired
	TpriDmpDatabookServiceImpl tpriDmpDatabookServiceImpl;
	@Autowired
	TemporaryDataMapper temporaryDataMapper;
	// @Autowired
//    InfluxDButils influxDButils;
	@Autowired
	AlarmEventMapper alarmEventMapper;
	@Autowired
	AlarmEventServiceImpl alarmEventService;
	@Autowired
	TemporaryDataServiceImpl temporaryDataService;
	@Autowired
	CommonServiceImpl commonServiceImpl;
	@Autowired
	EmqKeeper emqKeeper;
	@Value("${pictureUrl}")
	String pictureUrl;
	@Autowired
	private MonitorFanIndicatorMapper monitorFanIndicatorregionMapper;
	@Autowired
	private StationBasicMapper stationBasicMapper;
	@Autowired
	private SjglZsjZsbtzMapper sjglZsjZsbtzMapper;
	@Autowired
	private RegionMapper regionMapper;
	// 风机状态列表
	@Value("${fan.statuts.stattuspath}")
	private String fanStatusImagePathPrefix;
	@Value("classpath:/json/topic.json")
	private Resource topic;
	@Value("classpath:/json/fanlocation.json")
	private Resource fanlocation;
	@Autowired
	private IndicatorDataMapper indicatorDataMapper;
	@Autowired
	private EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;
	@Autowired
	private UserEmpowerMapper userEmpowerMapper;
	@Override
	public ResultsData getNationWideInfo(int current, int size, String gateway, String equipmentNumber) {
		String table = gateway;
		Map<String, List<String>> queryCodntion = new HashMap<>();
		queryCodntion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gateway));
		queryCodntion.put(CommonConstans.QueryStringIsAlarmKeyword, Arrays.asList("1"));
		List<ESEquipments> alldata = commonServiceImpl.getListDataByCondtionsAndLike(queryCodntion, null,
				ESEquipments.class, null);
		List<ESEquipments> waringData = alldata.stream()
				.filter(esEquipments -> (!esEquipments.getValue().equals("0.0")
						&& !esEquipments.getValue().equals(esEquipments.getValueLabel())
						|| (esEquipments.getValue().equals("true"))))
				.collect(Collectors.toList());
		if (StringUtils.isNotEmpty(equipmentNumber)) {
			waringData = waringData.stream()
					.filter(esEquipments -> esEquipments.getEquipmentNumber().equals(equipmentNumber))
					.collect(Collectors.toList());
		}
		if (CollectionUtils.isNotEmpty(waringData)) {
			Integer newSize = waringData.size() >= size ? size : waringData.size();
			waringData = waringData.stream().sorted(Comparator.comparing(ESEquipments::getCreatedTime).reversed())
					.collect(Collectors.toList()).subList(((current - 1) * newSize), (current * newSize));
			waringData.forEach(i -> {
				if ("true".equals(i.getValue())) {
					i.setValue("合");
					i.setValueLabel(i.getEquipmentIndexName());
				}
			});
		}
		// 对于查询到的告警信息进行按照时间顺序进行排序
		DataGridMock DataGridMock = new DataGridMock(current, !waringData.isEmpty() ? waringData.size() : 0, false,
				current, waringData);
		ColModel colModelequipmentNumber = new ColModel("equipmentNumber", "equipmentNumber", "设备", "设备", "dataGrid",
				"equipmentNumber");
		ColModel colModelvalueLabel = new ColModel("valueLabel", "valueLabel", "事件描述", "事件描述", "dataGrid",
				"valueLabel");
		ColModel colModelcreatedTime = new ColModel("createdTime", "createdTime", "发生时间", "发生时间", "dataGrid",
				"createdTime");
		ColModel colModelvalue = new ColModel("value", "value", "告警值", "告警值", "dataGrid", "value");
		List<ColModel> listColModel = new ArrayList<>();
		listColModel.add(colModelequipmentNumber);
		listColModel.add(colModelvalueLabel);
		listColModel.add(colModelcreatedTime);
		listColModel.add(colModelvalue);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

	@Override
	public ResultsData getLsNationWideInfo(int current, int size, String stationBasicId, String equipmentNumber) {

		StationBasic stationBasic = stationBasicMapper.selectById(stationBasicId);
		String gateway = stationBasic.getFanGatewayId();
		Map<String, List<String>> queryCodntion = new HashMap<>();
		queryCodntion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gateway));
		queryCodntion.put(CommonConstans.QueryStringIsAlarmKeyword, Arrays.asList("1"));
		HashMap<String, String> notMustMap = new HashMap<>();
		notMustMap.put(CommonConstans.QueryStringValueKeyword, "0.0");
		notMustMap.put(CommonConstans.QueryStringValueLabelKeyword, "0.0");
		Integer newSize = size;
		List<ESEquipments> lisSort = new ArrayList<>();
		List<ESEquipments> waringData = commonServiceImpl.getListDataByCondtionsByValueNotEqValueLabel(queryCodntion,
				null, notMustMap, ESEquipments.class);
		if (StringUtils.isNotEmpty(equipmentNumber) && CollectionUtils.isNotEmpty(waringData)) {
			waringData = waringData.stream()
					.filter(esEquipments -> esEquipments.getEquipmentNumber().equals(equipmentNumber)
							&& esEquipments.getEquipmentSpecificName().contains("风机"))
					.collect(Collectors.toList());
			newSize = waringData.size() >= size ? size : waringData.size();
			lisSort = waringData.stream().sorted(Comparator.comparing(ESEquipments::getCreatedTime).reversed())
					.collect(Collectors.toList()).subList(((current - 1) * newSize), (current * newSize));

		}
		// 对于查询到的告警信息进行按照时间顺序进行排序
		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current,
				CollectionUtils.isNotEmpty(waringData) ? waringData.size() : 0, false, current, lisSort);
		ColModel colModelequipmentNumber = new ColModel("equipmentNumber", "equipmentSpecificName", "风机号", "风机号",
				"dataGrid", "equipmentNumber");
		ColModel colModelvalueLabel = new ColModel("valueLabel", "valueLabel", "事件描述", "事件描述", "dataGrid",
				"valueLabel");
		ColModel colModelcreatedTime = new ColModel("createdTime", "createdTime", "发生时间", "发生时间", "dataGrid",
				"createdTime");
		ColModel colModelvalue = new ColModel("value", "value", "告警值", "告警值", "dataGrid", "value");
		List<ColModel> listColModel = new ArrayList<>();
		listColModel.add(colModelequipmentNumber);
		listColModel.add(colModelvalueLabel);
		listColModel.add(colModelcreatedTime);
		listColModel.add(colModelvalue);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

	public IPage<ESEquipments> getFanIdxInfoByPage(String equipNum, String stationId, String frontModule, int current,
			int size, String systemType) {
		StationBasic stationBasic = getOneByStationNumber(stationId);
		Page<ESEquipments> page = new Page<>(current, size);
		String sql = "";
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put("frontModule", frontModule);
		likeMap.put("equipmentNumber", equipNum);
		if (StringUtils.isNotEmpty(systemType)) {
			likeMap.put("systemType", systemType);
		}
		List<ESEquipments> result = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion, null,
				ESEquipments.class, likeMap);
		List<String> powerOther = Arrays.asList("月发电量", "年发电量", "总发电量");
		if (!stationBasic.getStationType().equals("FDZ")) {
			result.forEach(esEquipments -> {
				if (esEquipments.getEquipmentIndexName().equals("日发电量")) {
					esEquipments.setValueF(
							Float.valueOf(String.format(CommonConstans.Fourdecimalplaces, esEquipments.getValueF()
									* CommonConstans.pvGenPoweActor * CommonConstans.pvGenPoweActorDay)));
				}
				if (powerOther.contains(esEquipments.getEquipmentIndexName())) {
					esEquipments.setValueF(Float.valueOf(String.format(CommonConstans.Fourdecimalplaces,
							esEquipments.getValueF() * CommonConstans.pvGenPoweActorCurrentData)));
				}
			});
		}
		result.stream().forEach(e -> {
			if (powerOther.contains(e.getEquipmentIndexName()) || e.getEquipmentIndexName().equals("日发电量")) {
				e.setValue(String.format(CommonConstans.Fourdecimalplaces, e.getValueF()));
			} else {
				e.setValue(String.format(CommonConstans.Twodecimalplaces, e.getValueF()));
			}

		});
		Collator instance = Collator.getInstance(Locale.CHINA);
		Integer traceIdCount = result.stream().filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
				.collect(Collectors.toList()).size();
		if (traceIdCount > 0) {
			result = result.stream().filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
					.collect(Collectors.toList());
			result.sort(Comparator.comparing(ESEquipments::getTraceId, Comparator.comparingInt(Integer::parseInt)));
		} else {
			Collections.sort(result, (e1, e2) -> {
				return instance.compare(e1.getEquipmentIndexName(), e2.getEquipmentIndexName());
			});
		}
		List<ESEquipments> collect = result.stream().skip((long) (current - 1) * size).limit(size)
				.collect(Collectors.toList());

		page.setTotal(result.size());
		page.setRecords(collect);
		return page;
	}

	public TreeDto getTreeInfo(String sequenceNbr, ReginParams reginParams) {
		String userId = reginParams.getUserModel().getUserId();
		String companyLevel ="";
		StdUserEmpower stdUserEmpower = userEmpowerMapper.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
		if (ObjectUtils.isEmpty(stdUserEmpower)) {
//			throw new BadRequest("您当前未配置数据权限！");
		}else{
			String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
			Map<String,String>  companyInfo= userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
			 companyLevel = companyInfo.get("level").toString();
		}
		StationBasic stationBasic = stationBasicMapper.selectById(sequenceNbr);
		List<Integer> integers = JSON.parseArray(stationBasic.getBelongArea(), Integer.class);
		if (CollectionUtils.isEmpty(integers)) {
			throw new BadRequest("所属地区不能为空");
		}
		LambdaQueryWrapper<Region> regionLambda = new LambdaQueryWrapper<>();
		regionLambda.eq(Region::getRegionCode, integers.get(0));
		Region region = regionMapper.selectOne(regionLambda);
		TreeDto treeDto = new TreeDto();
		treeDto.setCode(String.valueOf(region.getRegionCode()));
		treeDto.setName(region.getRegionName());
		treeDto.setId(String.valueOf(region.getSequenceNbr()));
		treeDto.setParentCode("0");
		treeDto.setIsOnClick(0);
		treeDto.setSceneId("987654321");
		List<TreeDto> stationListByRegionCode = stationBasicMapper
				.getStationListByRegionCode(String.valueOf(region.getRegionCode()));

		TreeDto fdzTreeDto = new TreeDto();
		fdzTreeDto.setName("风电站");
		fdzTreeDto.setCode("FDZ");
		fdzTreeDto.setParentCode(String.valueOf(region.getRegionCode()));
		fdzTreeDto.setIsOnClick(0);
		fdzTreeDto.setSceneId("12345678910");
		List<TreeDto> fdz = stationListByRegionCode.stream()
				.filter(t -> t.getParentCode().contains("FDZ") && t.getParentCode().length() < 4)
				.collect(Collectors.toList());
		fdzTreeDto.setChildren(fdz);

		TreeDto gfzTreeDto = new TreeDto();
		gfzTreeDto.setName("光伏站");
		gfzTreeDto.setCode("GFZ");
		gfzTreeDto.setParentCode(String.valueOf(region.getRegionCode()));
		gfzTreeDto.setIsOnClick(0);
		gfzTreeDto.setSceneId("1234567891011");
		List<TreeDto> gfz = stationListByRegionCode.stream().filter(t -> t.getParentCode().contains("GFDZ"))
				.collect(Collectors.toList());
		gfzTreeDto.setChildren(gfz);
		List<TreeDto> treeDtos = Arrays.asList(fdzTreeDto, gfzTreeDto);
		treeDto.setChildren(treeDtos);
		if(companyLevel.equals("station")){
			List<TreeDto> children = stationListByRegionCode.stream().filter(t->t.getCode().equals(sequenceNbr)).collect(Collectors.toList());
			if(stationBasic.getStationType().equals("FDZ")){
				treeDto =  fdzTreeDto;
			}else {
				treeDto = gfzTreeDto;
			}
			treeDto.setChildren(children);
		}
		return treeDto;
	}

	public StationBasic getOneByStationNumber(String stationId) {
		return stationBasicMapper.selectById(stationId);
	}

	public List<ESEquipmentsDTO> getFanStatusList(String stationId) {
		StationBasic stationBasic = getOneByStationNumber(stationId);
		if (stationBasic.getStationType().contains("GFDZ")) {
			return new ArrayList<ESEquipmentsDTO>();
		}
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName,
				Arrays.asList("风机状态", "有功功率", "发电状态", "报警状态", "停机状态", "故障状态", "待机状态", "维护状态", "发电机转速", "正常发电状态","30秒平均风速"));
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		List<ESEquipments> result = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
		Map<String, List<String>> queryCondtion1 = new HashMap<>();
		queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("风机状态"));
		queryCondtion1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		List<ESEquipments> equipNumList = commonServiceImpl.getListDataByCondtions(queryCondtion1, null,
				ESEquipments.class);

		Map<String, String> likeMap = new HashMap<String, String>();
		queryCondtion.remove(CommonConstans.QueryStringEquipmentIndexName);
		likeMap.put(CommonConstans.QueryStringEquipmentIndexName, "实时故障");
		List<ESEquipments> resultWarn = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class, likeMap);

		result.addAll(resultWarn);

		// list测点转风机map并且计算风机状态
		Map<String, List<ESEquipments>> listMap = result.stream()
				.collect(Collectors.groupingBy(po -> po.getEquipmentNumber()));
		Map<String, String> equipMap = new HashMap<>();
		for (Entry<String, List<ESEquipments>> entry : listMap.entrySet()) {
			equipMap.put(entry.getKey(), "正常运行");
			if (entry.getValue() == null) {
				continue;
			}
			Map<String, String> objMap = entry.getValue().stream()
					.collect(Collectors.toMap(ESEquipments::getEquipmentIndexName, ESEquipments::getValue));
			Map<String, Date> timeMap = entry.getValue().stream()
					.collect(Collectors.toMap(ESEquipments::getEquipmentIndexName, ESEquipments::getCreatedTime));
			Map<String, String> warnMap = entry.getValue().stream()
					.filter(i -> i.getEquipmentIndexName().contains("实时故障"))
					.collect(Collectors.toMap(ESEquipments::getEquipmentSpecificName, ESEquipments::getValue));
			String fanStatus = objMap.get("风机状态");
			Double power = Double.valueOf(objMap.get("有功功率"));
			String elecStatus = objMap.get("发电状态") != null ? objMap.get("发电状态") : objMap.get("正常发电状态");
			String fault22 = objMap.get("实时故障22");
			String warnStatus = objMap.get("报警状态");
			String standbyStatus = objMap.get("待机状态");
			String stopStatus = objMap.get("停机状态");
			String faultStatus = objMap.get("故障状态");
			String mainStatus = objMap.get("维护状态");
			Double fSpeed = Double.valueOf(objMap.get("30秒平均风速"));
			boolean isWarn = isWarn(warnMap);
			Double fdjSpeed = Double.valueOf(objMap.get("发电机转速"));
			Date fdjTime = timeMap.get("发电机转速");
			Long min = null;
			if (fdjTime != null) {
				long start = fdjTime.getTime();
				// 获取当前时间毫秒值
				long current = System.currentTimeMillis();

				min = (current - start) / 1000 / 60;
			}
			// 正常运行
			// 1.发电状态=true(遥信)
			// 2.风机状态=8（遥测）
			// 3.有功功率>0（遥测）
			// 4.实时故障：枚举值匹配不上，以及匹配为备留信号的为正常运行
			// 通讯中断>限功率\维护>故障停机>正常停机>待机>告警运行>正常运行
			if (fdjSpeed > 0 && min != null && min >= 10) {
				equipMap.put(entry.getKey(), "通讯中断");
			} else if ("11.0".equals(fanStatus)) {
				equipMap.put(entry.getKey(), "限功率");
			} else if (Boolean.TRUE.toString().equalsIgnoreCase(mainStatus) && "2.0".equals(fanStatus)) {
				equipMap.put(entry.getKey(), "维护状态");
			} else if (Boolean.TRUE.toString().equalsIgnoreCase(stopStatus)
					&& Boolean.TRUE.toString().equalsIgnoreCase(faultStatus) && power.intValue() == 0) {
				equipMap.put(entry.getKey(), "故障状态");
			} else if (Boolean.TRUE.toString().equalsIgnoreCase(stopStatus) && "1.0".equals(fanStatus)) {
				equipMap.put(entry.getKey(), "停机状态");
			} else if (Boolean.TRUE.toString().equalsIgnoreCase(standbyStatus) && "3.0".equals(fanStatus)
					&& fSpeed.intValue() == 0) {
				equipMap.put(entry.getKey(), "待机状态");
			} else if (Boolean.TRUE.toString().equalsIgnoreCase(warnStatus)) {
				equipMap.put(entry.getKey(), "报警运行");
			} else if (Boolean.TRUE.toString().equalsIgnoreCase(elecStatus) && "8.0".equals(fanStatus) && power > 0
					&& !isWarn) {
				equipMap.put(entry.getKey(), "正常运行");
			}
		}

		HashMap<String, String> colorMap = new HashMap<>();
		colorMap.put("正常运行", "#00aa00");
		colorMap.put("报警运行", "#ffc400");
		colorMap.put("停机状态", "#a3f5aa");
		colorMap.put("故障状态", "#ff0000");
		colorMap.put("限功率", "#0055ff");
		colorMap.put("待机状态", "#00aaff");
		colorMap.put("维护状态", "#ff00ff");
		colorMap.put("通讯中断", "#7d8e95");

		List<ESEquipmentsDTO> resultList = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(equipNumList)) {
			equipNumList.forEach(item -> {
				String status = equipMap.get(item.getEquipmentNumber());
				item.setAddress(status);
				ESEquipmentsDTO esEquipmentsDTO = new ESEquipmentsDTO();
				BeanUtil.copyProperties(item, esEquipmentsDTO);
				String color = colorMap.get(status);
				esEquipmentsDTO.setState(status);
				esEquipmentsDTO.setColor(color);
				resultList.add(esEquipmentsDTO);
			});
		}

		return resultList;

	}

	@PostConstruct
	public void init() {
		QueryWrapper<EquipmentSpecificIndex> wrapper = new QueryWrapper<>();
		wrapper.eq("is_alarm", 1);
		List<EquipmentSpecificIndex> list = equipmentSpecificIndexMapper.selectList(wrapper);
		map = list.stream().collect(Collectors.toMap(EquipmentSpecificIndex::getEquipmentSpecificName,
				Function.identity(), (key1, key2) -> key2));
	}

	private boolean isWarn(Map<String, String> warnMap) {
		boolean result = false;
		for (Entry<String, String> entry : warnMap.entrySet()) {
			EquipmentSpecificIndex equipmentSpecificIndex = map.get(entry.getKey());
			if (equipmentSpecificIndex == null || entry.getValue() == null) {
				continue;
			}
			String valueEnum = equipmentSpecificIndex.getValueEnum();
			JSONArray arr = JSONObject.parseArray(valueEnum);
			if (arr == null) {
				continue;
			}
			for (Object o : arr) {
				JSONObject json = JSONObject.parseObject(JSONObject.toJSONString(o));
				if (json.containsKey("key") && entry.getValue().equals(json.get("key"))) {
					String warn = json.getString("label");
					if (warn.indexOf("备留") == -1) {
						result = true;
						break;
					}
				}
			}
			if (result) {
				break;
			}
		}
		return result;
	}

	public List<IndexDto> getFanStatusStatistics(String stationId) {
		List<ESEquipmentsDTO> equipNumList = getFanStatusList(stationId);
		Map<String, Long> countMap = equipNumList.stream()
				.collect(Collectors.groupingBy(ESEquipmentsDTO::getAddress, Collectors.counting()));
		List<IndexDto> resultList = new ArrayList<>();
		List<String> list = Arrays.asList("正常运行", "报警运行", "停机状态", "故障状态", "限功率", "待机状态", "维护状态", "通讯中断");
		HashMap<String, String> colorMap = new HashMap<>();
		colorMap.put("正常运行", "#00aa00");
		colorMap.put("报警运行", "#ffc400");
		colorMap.put("停机状态", "#a3f5aa");
		colorMap.put("故障状态", "#ff0000");
		colorMap.put("限功率", "#0055ff");
		colorMap.put("待机状态", "#00aaff");
		colorMap.put("维护状态", "#ff00ff");
		colorMap.put("通讯中断", "#7d8e95");
		list.forEach(item -> {
			IndexDto indexDto = new IndexDto();
			indexDto.setCountString(countMap.containsKey(item) ? String.valueOf(countMap.get(item)) : "0");
			indexDto.setEquipmentIndexName(item);
			indexDto.setColor(colorMap.get(item));
			resultList.add(indexDto);
		});
		return resultList;
	}

	public IndexDto getFanBasicInfoByEquipNum(String equipNum, String stationId) {
		String json = null;
		try {
			json = IOUtils.toString(fanlocation.getInputStream(), java.lang.String.valueOf(StandardCharsets.UTF_8));
		} catch (IOException e) {
			e.printStackTrace();
		}
		JSONArray jsonArray = JSONObject.parseArray(json);
		JSONObject jsonObject = (JSONObject) jsonArray.get(Integer.valueOf(equipNum) - 1);
		IndexDto indexDto = new IndexDto();
		indexDto.setLongitude(String.valueOf(jsonObject.get("longitude")));
		indexDto.setLatitude(String.valueOf(jsonObject.get("latitude")));
		StationBasic stationBasic = getOneByStationNumber(stationId);
		List<ESEquipmentsDTO> fanStatusList = getFanStatusList(stationId);
		String fanStatus = fanStatusList.stream()
				.filter(esEquipments -> esEquipments.getEquipmentNumber().equals(equipNum)).collect(Collectors.toList())
				.get(0).getAddress();
		indexDto.setEquipmentIndexName(fanStatus);
		List<Map<String, String>> fanConfigPower = monitorFanIndicatorregionMapper
				.getFanConfigPower(stationBasic.getFanGatewayId(), equipNum);
		if (CollectionUtils.isEmpty(fanConfigPower)) {
			throw new BadRequest("fan_config_power表数据未维护该风机");
		}
		String equipmentSpecificName = fanConfigPower.get(0).get("equipmentSpecificName");
		String substring = equipmentSpecificName.substring(0, equipmentSpecificName.indexOf("#"));
		indexDto.setEquipmentSpecificName(substring);
		indexDto.setEquipmentNumber(equipNum);
		return indexDto;
	}

	/**
	 * 根据风机号 场站号 模块获取实时温度
	 *
	 * @param equipNum
	 * @param stationId
	 * @param frontModule
	 * @return 风机的实时温度数据
	 */
	public HashMap<String, List<String>> getRealTimeTemperature(String equipNum, String stationId, String frontModule) {
		HashMap<String, List<String>> realTimeTemperatureResult = new HashMap<>();
		StationBasic stationBasic = getOneByStationNumber(stationId);
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		queryCondtion.put(CommonConstans.QueryStringEquipmentNumberKeyword, Arrays.asList(equipNum));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, frontModule);
		List<ESEquipments> result = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion, null,
				ESEquipments.class, likeMap);
		List<String> xList = new ArrayList<>();
		List<String> yList = new ArrayList<>();
		for (int i = 0; i < result.size(); i++) {
			ESEquipments esEquipments = result.get(i);
			if (esEquipments.getEquipmentIndexName().contains("温度")) {
				xList.add(esEquipments.getEquipmentIndexName());
				yList.add(null == esEquipments.getValueF() ? "0" : esEquipments.getValueF().toString());
			}
		}
		realTimeTemperatureResult.put("axisData", xList);
		realTimeTemperatureResult.put("seriesData", yList);
		return realTimeTemperatureResult;
	}

	public Integer getFanNum(String stationId) {
		StationBasic stationBasic = getOneByStationNumber(stationId);
		Map<String, List<String>> queryCondtion1 = new HashMap<>();
		queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("发电状态"));
		queryCondtion1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		List<ESEquipments> equipNumList = commonServiceImpl.getListDataByCondtions(queryCondtion1, null,
				ESEquipments.class);
		return equipNumList.size();
	}

	public String getFanDataByType(String stationId, String equipNum, String frontModule, String typeName) {
		StationBasic stationBasic = getOneByStationNumber(stationId);
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, frontModule);
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList(typeName));
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		queryCondtion.put(CommonConstans.QueryStringEquipmentNumberKeyword, Arrays.asList(equipNum));
		List<ESEquipments> equipNumList = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion, null,
				ESEquipments.class, likeMap);
		if (ObjectUtils.isEmpty(frontModule)) {
			equipNumList = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
		}
		if (CollectionUtils.isNotEmpty(equipNumList) && !ObjectUtils.isEmpty(equipNumList.get(0).getValueF())) {
			return equipNumList.get(0).getValueF().toString();
		} else {
			return "0";
		}
	}

	public String getEquipCount(String gatewayId, String stationType) {
		Map<String, List<String>> queryCondtion1 = new HashMap<>();
		if (stationType.equals("FDZ")) {
			queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("有功功率"));
		} else {
			queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("运行"));
		}
		queryCondtion1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		List<ESEquipments> equipNumList = commonServiceImpl.getListDataByCondtions(queryCondtion1, null,
				ESEquipments.class);
		if (!CollectionUtils.isEmpty(equipNumList)) {
			return equipNumList.size() + "";
		}
		return "0";
	}

	public void getDetailsWindSpeedAll(StationBasic stationBasic) {
		Map<String, Object> map = new HashMap<>();
		List<String> values = new ArrayList<>();
		List<String> valueList = new ArrayList<>();
		Map<Date, Double> groupMap = new HashMap<>();
		List<String> time = new ArrayList<>();
		Map<String, Object> activePowerInfo = new HashMap<>();
		Map<String, Object> otherInfo = new HashMap<>();
		List<IndicatorData> activePowerList = new ArrayList<>();
		List<IndicatorData> otherList = new ArrayList<>();
		Double installedCapacity = commonServiceImpl.getStationCapactityByStationWerks(stationBasic.getStationNumber());
		if ("FDZ".equals(stationBasic.getStationType())) {
			activePowerList = indicatorDataMapper.selectDataByequipmentIndexNameAndtime(
					CommonConstans.xiazaoActivePowerPoint, stationBasic.getBoosterGatewayId());
			otherList = indicatorDataMapper.selectDataByequipmentIndexNameAndtime(CommonConstans.xiazaoWindSpeedrPoint,
					stationBasic.getFanGatewayId());
			groupMap = otherList.stream().collect(Collectors.groupingBy(IndicatorData::getCreatedTime,
					Collectors.averagingDouble(IndicatorData::getValueF)));
		} else {
			activePowerList = indicatorDataMapper.selectDataByequipmentIndexNameAndtime(
					CommonConstans.taiheActivePowerPoint, stationBasic.getBoosterGatewayId());
			otherList = indicatorDataMapper.selectDataByequipmentIndexNameAndtime(CommonConstans.taiheIrradiationPonit,
					stationBasic.getBoosterGatewayId());
		}
		Integer size = activePowerList.size() > otherList.size() ? otherList.size() : activePowerList.size();
		for (int i = 0; i < size; i++) {
			IndicatorData indicatorData = activePowerList.get(i);
			time.add(DateUtil.format(indicatorData.getCreatedTime(), "HH:mm"));
			if ("FDZ".equals(stationBasic.getStationType())) {
				values.add(String.format(CommonConstans.Twodecimalplaces, indicatorData.getValueF()));
				valueList.add(
						String.format(CommonConstans.Twodecimalplaces, groupMap.get(indicatorData.getCreatedTime())));
			} else {
				values.add(String.format(CommonConstans.Twodecimalplaces,
						indicatorData.getValueF() * CommonConstans.kwToMv));
				valueList.add(String.format(CommonConstans.Twodecimalplaces, otherList.get(i).getValueF()));
			}
		}
		String max = String.format(CommonConstans.Twodecimalplaces,
				values.stream().mapToDouble(Double::parseDouble).max().getAsDouble());
		String min = String.format(CommonConstans.Twodecimalplaces,
				values.stream().mapToDouble(Double::parseDouble).min().getAsDouble());
		String mean = String.format(CommonConstans.Twodecimalplaces,
				values.stream().mapToDouble(Double::parseDouble).average().getAsDouble());
		activePowerInfo.put("mean", mean);
		activePowerInfo.put("max", max);
		activePowerInfo.put("min", min);
		activePowerInfo.put("maxTime", time.get(values.lastIndexOf(max)));
		activePowerInfo.put("minTime", time.get(values.lastIndexOf(min)));
		activePowerInfo.put("load", String.format(CommonConstans.Twodecimalplaces,
				Double.valueOf(values.get(values.size() - 1)) / installedCapacity));

		max = String.format(CommonConstans.Twodecimalplaces,
				valueList.stream().mapToDouble(Double::parseDouble).max().getAsDouble());
		min = String.format(CommonConstans.Twodecimalplaces,
				valueList.stream().mapToDouble(Double::parseDouble).min().getAsDouble());
		mean = String.format(CommonConstans.Twodecimalplaces,
				valueList.stream().mapToDouble(Double::parseDouble).average().getAsDouble());

		otherInfo.put("mean", mean);
		otherInfo.put("max", max);
		otherInfo.put("min", min);
		otherInfo.put("maxTime", time.get(valueList.lastIndexOf(max)));
		otherInfo.put("minTime", time.get(valueList.lastIndexOf(min)));
		otherInfo.put("load", "");

		List<Map<String, Object>> seriesData = new ArrayList<>();
		Map<String, Object> map3 = new HashMap<>();
		Map<String, Object> map1 = new HashMap<>();
		Map<String, Object> map2 = new HashMap<>();
		map1.put("data", values);
		map2.put("data", valueList);
		seriesData.add(map2);
		seriesData.add(map1);
		map.put("seriesData", seriesData);
		map.put("axisData", time);
		try {
			log.info("---------------------推送全站图表信息开始------------------------------");
			emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_activePower_table",
					JSON.toJSON(map).toString().getBytes("UTF-8"), 1, true);
			emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_activePower_info",
					JSON.toJSON(activePowerInfo).toString().getBytes("UTF-8"), 1, true);
			emqKeeper.getMqttClient().publish(stationBasic.getSequenceNbr() + "_other_info",
					JSON.toJSON(otherInfo).toString().getBytes("UTF-8"), 1, true);
			log.info("---------------------推送全站图表信息结束------------------------------");
		} catch (Exception exception) {
			log.info("---------------------推送全站图表信息失败------------------------------");
		}

	}

	public Map<String, Object> getDetailsWindSpeed(String gatewayId, String name) {

		List<IndicatorData> indicatorDataListWindSpeed = new ArrayList<>();
		List<IndicatorData> indicatorDataListActivePower = new ArrayList<>();
		indicatorDataListWindSpeed = indicatorDataMapper.selectDataByequipmentIndexNameAndtimeAndEquipmentNumber("瞬时风速",
				name, gatewayId);
		indicatorDataListActivePower = indicatorDataMapper
				.selectDataByequipmentIndexNameAndtimeAndEquipmentNumber("有功功率", name, gatewayId);
		List<String> windSpeeds = new ArrayList<>();
		List<String> activePowers = new ArrayList<>();
		List<String> axisData = new ArrayList<>();
		Integer size = indicatorDataListWindSpeed.size() > indicatorDataListActivePower.size()
				? indicatorDataListActivePower.size()
				: indicatorDataListWindSpeed.size();
		for (int i = 0; i < size; i++) {
			windSpeeds.add(String.format(CommonConstans.Twodecimalplaces,
					Double.valueOf(indicatorDataListWindSpeed.get(i).getValue())));
			activePowers.add(String.format(CommonConstans.Twodecimalplaces,
					Double.valueOf(indicatorDataListActivePower.get(i).getValue())));
			axisData.add(DateUtil.format(indicatorDataListWindSpeed.get(i).getCreatedTime(), "HH:mm"));
		}
		List<Map<String, Object>> seriesData = new ArrayList<>();
		Map<String, Object> map = new HashMap<>();
		Map<String, Object> map1 = new HashMap<>();
		Map<String, Object> map2 = new HashMap<>();
		map1.put("data", windSpeeds);
		map2.put("data", activePowers);
		seriesData.add(map1);
		seriesData.add(map2);
		map.put("seriesData", seriesData);
		map.put("axisData", axisData);
		return map;
	}

	public Map<String, Object> getDetailsWindSpeeds(String gatewayId, String name) {
		List<IndicatorData> indicatorDataListActivePowers = new ArrayList<>();
		indicatorDataListActivePowers = indicatorDataMapper
				.selectDataByequipmentIndexNameAndtimeAndEquipmentNumber("有功功率", name, gatewayId);
		List<String> axisData = new ArrayList<>();
		List<String> activePowers = new ArrayList<>();
		for (int i = 0; i < indicatorDataListActivePowers.size(); i++) {
			activePowers.add(indicatorDataListActivePowers.get(i).getValue());
			axisData.add(DateUtil.format(indicatorDataListActivePowers.get(i).getCreatedTime(), "HH:mm"));
		}
		List<Map<String, Object>> seriesData = new ArrayList<>();
		Map<String, Object> map = new HashMap<>();
		Map<String, Object> map2 = new HashMap<>();
		map2.put("data", activePowers);
		seriesData.add(map2);
		map.put("seriesData", seriesData);
		map.put("axisData", axisData);
		return map;
	}

	@Scheduled(cron = "${windSpeed.Scheduled.cron}")
	private void schedTaskData() {

		LambdaQueryWrapper<StationBasic> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(BaseEntity::getIsDelete, false);
		List<StationBasic> stationBasics = stationBasicMapper.selectList(wrapper);
		long timeInMillis = new Date().getTime();

		for (StationBasic stationBasic : stationBasics) {
			if (stationBasic.getStationType().equals("FDZ")) {
				timingTemporarysSorageData(stationBasic, timeInMillis);
			}
			if (stationBasic.getStationType().equals("JZSGFDZ")) {
				schedSolarPower(stationBasic, timeInMillis);
			}
		}
	}

	@Scheduled(cron = "0 59 23 * * ?")
	private void deleteSchedData() {
		QueryWrapper<TemporaryData> wrapper = new QueryWrapper<>();
		temporaryDataMapper.delete(wrapper);
		String sort = alarmEventMapper.getLastDataBySort(null);
		LambdaQueryWrapper<AlarmEvent> params = new LambdaQueryWrapper<>();
		params.notIn(AlarmEvent::getSort, sort);
		alarmEventMapper.delete(params);
	}

	@Scheduled(cron = "0 */5 * * * ?")
	private void schedAlarmEventData() {
		LambdaQueryWrapper<StationBasic> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(BaseEntity::getIsDelete, false);
		List<StationBasic> stationBasics = stationBasicMapper.selectList(wrapper);
		long currentsort = new Date().getTime();
		for (StationBasic stationBasic : stationBasics) {
			schedAddAlarmEventData(stationBasic.getBoosterGatewayId(), stationBasic.getSequenceNbr().toString(),
					stationBasic.getStationName(), currentsort);
		}
	}

	public void schedAddAlarmEventData(String gatewayId, String stationId, String stationName, long currentsort) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringSystemTypeKeyword, Arrays.asList("光字牌"));
		queryCondtion.put(CommonConstans.QueryStringValueKeyword, Arrays.asList("false"));
		List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class);
		List<AlarmEvent> newAlarmEvents = new ArrayList<>();
		List<String> alarmsNames = new ArrayList<>();

		for (ESEquipments esEquipments : indicatorsDtoList) {
			AlarmEvent alarmEvent = new AlarmEvent();
			alarmEvent.setEventDesc(esEquipments.getEquipmentIndexName());
			alarmEvent.setEventTime(esEquipments.getCreatedTime());
			alarmEvent.setStationId(stationId);
			alarmEvent.setStationName(stationName);
			alarmEvent.setGatewayId(gatewayId);
			alarmEvent.setCreatedTime(new Date());
			alarmEvent.setAlarmGroupName("运行告警");
			alarmEvent.setEventMovement(esEquipments.getValue());
			alarmEvent.setSort(currentsort);
			newAlarmEvents.add(alarmEvent);
			alarmsNames.add(esEquipments.getEquipmentIndexName());
		}
		alarmsNames.sort(Comparator.naturalOrder());
		String newAlarms = String.join(",", alarmsNames);

		String sort = alarmEventMapper.getLastDataBySort(gatewayId);
		List<String> oldAlarmEvents = alarmEventMapper.getOldAlarmsBySort(gatewayId, sort);
		oldAlarmEvents.sort(Comparator.naturalOrder());
		String oldName = String.join(",", oldAlarmEvents);

		if (!newAlarms.equals(oldName)) {
			for (String oldAlarmEvent : oldAlarmEvents) {
				if (newAlarms.contains(oldAlarmEvent)) {

				} else {
					AlarmEvent alarmEvent = new AlarmEvent();
					alarmEvent.setStationId(stationId);
					alarmEvent.setStationName(stationName);
					alarmEvent.setEventDesc(oldAlarmEvent);
					alarmEvent.setEventTime(new Date());
					alarmEvent.setGatewayId(gatewayId);
					alarmEvent.setAlarmGroupName("运行告警");
					alarmEvent.setCreatedTime(new Date());
					alarmEvent.setEventMovement("false");
					alarmEvent.setSort(currentsort);
					newAlarmEvents.add(alarmEvent);
				}
			}
		}
		alarmEventService.saveBatch(newAlarmEvents);

	}

	public void timingTemporarysSorageData(StationBasic stationBasic, long timeInMillis) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("瞬时风速"));
		List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class);
		Map<String, List<String>> queryCondtion1 = new HashMap<>();
		queryCondtion1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getBoosterGatewayId()));
		queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName,
				Arrays.asList("220kV夏雩线212线路测控装置PCS-9705TA有功功率一次值"));
		List<ESEquipments> indicatorsDtoLists = commonServiceImpl.getListDataByCondtions(queryCondtion1, null,
				ESEquipments.class);
		List<TemporaryData> temporaryDatas = new ArrayList<>();
		List<TemporaryData> temporaryDatass = new ArrayList<>();
		String time = "";
		try {
			time = DateUtils.dateFormat(new Date(), DateUtils.MINUTE_PATTERN);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		// long timeInMillis = new Date().getTime();
		for (ESEquipments indicatorsDto : indicatorsDtoList) {
			try {
				TemporaryData temporaryData = new TemporaryData();
				temporaryData.setBatchNo(timeInMillis);
				temporaryData.setCreatedTime(time.split(" ")[1]);
				temporaryData.setEquipmentIndexName(indicatorsDto.getEquipmentIndexName());
				temporaryData.setGatewayId(stationBasic.getFanGatewayId());
				temporaryData.setValue(null == indicatorsDto.getValueF() ? 0 : indicatorsDto.getValueF());
				temporaryData.setEquipmentNumber(indicatorsDto.getEquipmentNumber());
				temporaryDatas.add(temporaryData);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		for (ESEquipments indicatorsDto : indicatorsDtoLists) {
			try {
				TemporaryData temporaryData = new TemporaryData();
				temporaryData.setBatchNo(timeInMillis);
				temporaryData.setCreatedTime(time.split(" ")[1]);
				temporaryData.setEquipmentIndexName("有功功率");
				temporaryData.setGatewayId(stationBasic.getFanGatewayId());
				temporaryData.setValue(null == indicatorsDto.getValueF() ? 0 : indicatorsDto.getValueF());
				temporaryData.setEquipmentNumber(indicatorsDto.getEquipmentNumber());
				temporaryDatass.add(temporaryData);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		temporaryDataService.saveBatch(temporaryDatas);
		temporaryDataService.saveBatch(temporaryDatass);
	}

	public void schedSolarPower(StationBasic stationBasic, long timeInMillis) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getBoosterGatewayId()));
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("WTX-801_25_WTX-801_总辐射"));
		List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class);
		Map<String, List<String>> queryCondtion1 = new HashMap<>();
		queryCondtion1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getBoosterGatewayId()));
		queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("南瑞光差保护_313P"));
		List<ESEquipments> indicatorsDtoLists = commonServiceImpl.getListDataByCondtions(queryCondtion1, null,
				ESEquipments.class);
		List<TemporaryData> temporaryDatas = new ArrayList<>();
		List<TemporaryData> temporaryDatass = new ArrayList<>();
		String time = "";
		try {
			time = DateUtils.dateFormat(new Date(), DateUtils.MINUTE_PATTERN);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		// long timeInMillis = new Date().getTime();
		for (ESEquipments indicatorsDto : indicatorsDtoList) {
			try {
				TemporaryData temporaryData = new TemporaryData();
				temporaryData.setBatchNo(timeInMillis);
				temporaryData.setCreatedTime(time.split(" ")[1]);
				temporaryData.setGatewayId(indicatorsDto.getGatewayId());
				temporaryData.setValue(Float.valueOf(indicatorsDto.getValue()));
				temporaryData.setEquipmentNumber(indicatorsDto.getEquipmentNumber());
				temporaryData.setEquipmentIndexName("总辐射累计");
				temporaryDatas.add(temporaryData);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		for (ESEquipments indicatorsDto : indicatorsDtoLists) {
			try {
				TemporaryData temporaryData = new TemporaryData();
				temporaryData.setBatchNo(timeInMillis);
				temporaryData.setCreatedTime(time.split(" ")[1]);
				temporaryData.setGatewayId(indicatorsDto.getGatewayId());
				temporaryData.setValue(indicatorsDto.getValueF() / 1000);
				temporaryData.setEquipmentNumber(indicatorsDto.getEquipmentNumber());
				temporaryData.setEquipmentIndexName("有功功率");
				temporaryDatass.add(temporaryData);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		temporaryDataService.saveBatch(temporaryDatas);
		temporaryDataService.saveBatch(temporaryDatass);
	}

	public List<Map<String, Object>> getStatusMonitoring(String gatewayId, String equipNum, String systemName) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringEquipmentNumber, Arrays.asList(equipNum));
		Map<String, String> shouldCondition = new HashMap<>();
		shouldCondition.put(CommonConstans.QueryStringEquipmentIndexName, "实时故障");
		List<ESEquipments> listData = commonServiceImpl.getListDataByCondtions(queryCondtion, shouldCondition,
				ESEquipments.class);
		String type = listData.get(0).getEquipmentSpecificName().substring(0, 5);
		List<SystemEnumDto> statusMonitoring = systemEnumMapper.getStatusMonitoring(type, systemName);
		List<Map<String, Object>> statusMaps = new ArrayList<>();
		for (SystemEnumDto systemEnumDto : statusMonitoring) {
			Map<String, Object> statusMap = new HashMap<>();
			statusMap.put("title1", systemEnumDto.getEnumDesc());
			for (ESEquipments listDatum : listData) {
				if (listDatum.getEquipmentSpecificName().contains(systemEnumDto.getCode())
						&& systemEnumDto.getEunmValue().equals(listDatum.getValue())) {
					statusMap.put("state", "1");
				} else {
					statusMap.put("state", "0");
				}
			}
			statusMaps.add(statusMap);
		}
		return statusMaps;
	}

	public List<Map<String, Object>> getStatusGzp(String gatewayId, String systemType, String frontModule,
			String equipNum, String stationType) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		if (null != equipNum) {
			queryCondtion.put(CommonConstans.QueryStringEquipmentNumberKeyword, Arrays.asList(equipNum));
		}

		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudle, frontModule);

		if (stationType.equals("FDZ")) {
			queryCondtion.put(CommonConstans.QueryStringSystemTypeKeyword, Arrays.asList(systemType));
		} else {
			likeMap.put(CommonConstans.QueryStringSystemTypeKeyword, systemType);
		}
		List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class, likeMap);
		Integer traceIdCount = indicatorsDtoList.stream()
				.filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId())).collect(Collectors.toList())
				.size();
		if (traceIdCount > 0) {
			indicatorsDtoList = indicatorsDtoList.stream()
					.filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
					.collect(Collectors.toList());
		}
		List<Map<String, Object>> statusMaps = new ArrayList<>();
		for (ESEquipments listDatum : indicatorsDtoList) {
			Map<String, Object> statusMap = new HashMap<>();
			statusMap.put("traceId", listDatum.getTraceId());
			String data = listDatum.getDisplayName();
			if (StringUtils.isEmpty(data) || (!ObjectUtils.isEmpty(listDatum.getEquipmentNumber())
					&& data.equals(listDatum.getEquipmentNumber()))) {
				data = listDatum.getEquipmentIndexName();
			}
			statusMap.put("displayName", listDatum.getDisplayName());
			statusMap.put("equipmentIndexName", listDatum.getEquipmentIndexName());
			statusMap.put("unit", listDatum.getUnit());
			statusMap.put("value", listDatum.getValue());
			statusMap.put("addres", listDatum.getAddress());
			statusMap.put("id", listDatum.getId());
			statusMap.put("data", data);
			statusMap.put("state", listDatum.getValue().equals("false") ? 0 : 1);
			statusMap.put("status", listDatum.getValue().equals("false") ? 0 : 1);
			statusMap.put("title", listDatum.getValue().equals("false") ? "断" : "通");
			if (systemType.equals("网络")) {
				statusMap.put("state", listDatum.getValue().equals("false") ? 1 : 0);
			}
			statusMaps.add(statusMap);
		}
//        Collator instance = Collator.getInstance(Local);
		String sortField;
		if (traceIdCount == statusMaps.size()) {
			sortField = "traceId";
		} else {
			sortField = "addres";
		}
//        Collections.sort(statusMaps, (e1, e2) -> {
//            return instance.compare(Integer.valueOf(e1.get(sortField).toString()), Integer.valueOf(e2.get(sortField).toString()));
//        });
		statusMaps.sort(Comparator.comparingInt(o -> Integer.parseInt(o.get(sortField).toString())));
		return statusMaps;
	}

	public List<Map<String, Object>> getAnalogQuantity(String gatewayId, String frontModule, String systemType) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, frontModule);
		likeMap.put(CommonConstans.QueryStringSystemType, systemType);
		List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion, null,
				ESEquipments.class, likeMap);
		List<ESEquipments> listData = esEquipmentsList.stream()
				.filter(esEquipments -> !esEquipments.getDisplayName().equals("")).collect(Collectors.toList());
		List<Map<String, Object>> statusMaps = new ArrayList<>();
		Integer traceIdCount = listData.stream().filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
				.collect(Collectors.toList()).size();
		if (traceIdCount > 0) {
			listData = listData.stream().filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
					.collect(Collectors.toList());
		}
		for (ESEquipments listDatum : listData) {
			Map<String, Object> statusMap = new HashMap<>();
			statusMap.put("traceId", listDatum.getTraceId());
			statusMap.put("displayName", listDatum.getDisplayName());
			statusMap.put("equipmentIndexName", listDatum.getEquipmentIndexName());
			statusMap.put("equipmentIndexName", listDatum.getEquipmentIndexName());
			statusMap.put("unit", listDatum.getUnit());
			statusMap.put("value", listDatum.getValue());
			statusMap.put("id", listDatum.getId());
			if (StringUtils.isEmpty(listDatum.getValue())) {
				statusMap.put("title", 0.00 + (StringUtils.isNotEmpty(listDatum.getUnit()) ? listDatum.getUnit() : ""));
			} else {
				statusMap.put("title", keepTwoDecimalPlaces(listDatum.getValue()) + " "
						+ (StringUtils.isNotEmpty(listDatum.getUnit()) ? listDatum.getUnit() : ""));
			}
			statusMap.put("title1", listDatum.getDisplayName());
			statusMaps.add(statusMap);
		}
		Collator instance = Collator.getInstance(Locale.CHINA);
		String sortField;
		if (traceIdCount == statusMaps.size()) {
			sortField = "traceId";
			statusMaps.sort(Comparator.comparingInt(o -> Integer.parseInt(o.get(sortField).toString())));
		} else {
			sortField = "title1";
			Collections.sort(statusMaps, (e1, e2) -> {
				return instance.compare(e1.get(sortField), e2.get(sortField));
			});
		}

		return statusMaps;
	}

	public void getStatusJDX(String gatewayId, String stationId, String frontModule) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));

		Map<String, String> likeCodtion = new HashMap<>();
		likeCodtion.put(CommonConstans.QueryStringFrontMoudle, frontModule);
		likeCodtion.put(CommonConstans.QueryStringDisplayName + ".keyword", "合位");
		List<ESEquipments> listData = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class,
				likeCodtion);

		Collator instance = Collator.getInstance(Locale.CHINA);
		Collections.sort(listData, (e1, e2) -> {
			return instance.compare(e1.getFrontModule(), e2.getFrontModule());
		});
		List<Map<String, Object>> statusMaps = new ArrayList<>();
		Map<String, List<ESEquipments>> collect = listData.stream()
				.collect(Collectors.groupingBy(ESEquipments::getFrontModule, LinkedHashMap::new, Collectors.toList()));

		for (String s : collect.keySet()) {
			Map<String, Object> statusMap = new HashMap<>();
			if (frontModule.equals("前光")) {
				likeCodtion.remove(CommonConstans.QueryStringDisplayNameKeyword);
				likeCodtion.put(CommonConstans.QueryStringSystemTypeKeyword, "模拟量");
				List<ESEquipments> value = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
						ESEquipments.class, likeCodtion);

				for (ESEquipments indicatorsDto : value) {
					Double aDouble = Double.valueOf(indicatorsDto.getValue());
					statusMap.put(indicatorsDto.getDisplayName().split("\\(")[0] + "Value",
							String.format(CommonConstans.Twodecimalplaces, aDouble));
				}
			}
			List<ESEquipments> indicatorsDtos = collect.get(s);
			for (ESEquipments indicatorsDto : indicatorsDtos) {
				if (indicatorsDto.getDisplayName().contains("断路器_合位")) {
					statusMap.put("type", indicatorsDto.getValue());
					statusMap.put("status", indicatorsDto.getValue().equals("false") ? "0" : "1");
					statusMap.put("position", indicatorsDto.getDisplayName().split("_")[0] + "开关位置");
				}

			}
//            statusMap.put("title", s.substring(3));
			statusMap.put("title", s);
			// 如果是光伏则需要进行数据截取
			if (frontModule.equals("前光")) {
				statusMap.put("title", s.substring(3));
			}
			statusMap.put("power", "有功 (kW)");
			statusMap.put("windSpeed", "风速 (m/s)");
			statusMaps.add(statusMap);
		}

		IPage<Map<String, Object>> result = new Page<>();
		result.setRecords(statusMaps);
		result.setCurrent(1);
		result.setTotal(statusMaps.size());
		try {
			emqKeeper.getMqttClient().publish(stationId + "/fxqTree", JSON.toJSONString(result).getBytes(), 0, false);
		} catch (MqttException e) {
			log.info("消息发送失败");
			e.printStackTrace();
		}
	}

	public void getListByFJ(String gatewayId, String werks, String stationId) {
		HashMap<String, String> fanstatutsHashMap = new HashMap<>();
		StationBasic stationBasic = stationBasicMapper.selectById(stationId);
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("瞬时风速", "有功功率"));
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		List<ESEquipments> listDataAll = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class);
		Map<String, Object> listDataWindSpeed = listDataAll.stream()
				.filter(esEquipments -> esEquipments.getEquipmentIndexName().equals("瞬时风速"))
				.collect(Collectors.toMap(ESEquipments::getEquipmentNumber, ESEquipments::getValueF));
//        queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("有功功率"));
		Map<String, Object> listDataActivePower = listDataAll.stream()
				.filter(esEquipments -> esEquipments.getEquipmentIndexName().equals("有功功率"))
				.collect(Collectors.toMap(ESEquipments::getEquipmentNumber, ESEquipments::getValueF));
		TpriDmpDatabook tpriDmpDatabook = tpriDmpDatabookServiceImpl.getTpriDmpDatabookByDataName("风机");
		List<Map<String, Object>> dataMaps = sjglZsjZsbtzServiceImpl.sjglZsjZsbtzMapper
				.getStationInfoMapByStationWerks(werks, tpriDmpDatabook.getDataid().toString());
		// 获取风机列表
		List<ESEquipmentsDTO> fanStatusList = getFanStatusList(stationId);
		fanStatusList.forEach(equipments -> {
			fanstatutsHashMap.put(equipments.getEquipmentNumber(), equipments.getAddress());
		});
		String prefix = commonServiceImpl.getFanDevicePrefix(stationId);
		int i = 0;
		for (Map<String, Object> dataMap : dataMaps) {
			List<String> numList = Arrays.asList(dataMap.get("equipNum").toString().split(","));
			List<Map<String, Object>> statusMaps = new ArrayList<>();
//            for (ESEquipments listDatum : listData) {
//                if (null == listDatum.getValueF()) {
//                    listDatum.setValueF(0F);
//                }
//                for (ESEquipments indicatorsDto : listData1) {
//                    if (listDatum.getEquipmentNumber().equals(indicatorsDto.getEquipmentNumber())) {
//                        listDatum.setValueLabel(String.valueOf(indicatorsDto.getValueF() == null ? 0 : indicatorsDto.getValueF()));
//                    }
//                }

			for (String num : numList) {
				Map<String, Object> map = new HashMap<>();
				String equipmentNumber = String.format("%02d", Integer.parseInt(num));
				map.put("title", prefix + equipmentNumber);
				// 用于参数传递
				map.put("title1", equipmentNumber);
				map.put("windSpeed", listDataWindSpeed.get(equipmentNumber));
				map.put("power", listDataActivePower.get(equipmentNumber));
				// 获取风机状态如果获取到的状态为空-则默认为正常运行状态
				String fantStatus = ObjectUtils.isEmpty(fanstatutsHashMap.get(equipmentNumber)) ? "通讯中断"
						: fanstatutsHashMap.get(equipmentNumber);
				map.put("url", fanStatusImagePathPrefix + File.separator + "风机-" + fantStatus + ".gif");
				statusMaps.add(map);
			}
			Collator instance = Collator.getInstance(Locale.CHINA);
			Collections.sort(statusMaps, (e1, e2) -> {
				return instance.compare(e1.get("title1"), e2.get("title1"));
			});
			IPage<Map<String, Object>> result = new Page<>();
			result.setRecords(statusMaps);
			result.setCurrent(1);
			result.setTotal(statusMaps.size());
			i += 1;
			try {
				emqKeeper.getMqttClient().publish(stationId + "/fj/group" + i, JSON.toJSONString(result).getBytes(), 1,
						true);
			} catch (MqttException e) {
				log.info("消息发送失败");
				e.printStackTrace();
			}
		}

	}

	public List<Map<String, String>> getBoosterStationInfo(String stationId) {
		StationBasic stationBasic = getOneByStationNumber(stationId);
		List<Map<String, String>> boosterStationInfo = new ArrayList<>();
		if (stationBasic.getStationName().contains("夏造风电站")) {
			boosterStationInfo = monitorFanIndicatorregionMapper
					.getBoosterStationInfo2(stationBasic.getBoosterGatewayId());
		} else {
			boosterStationInfo = monitorFanIndicatorregionMapper
					.getBoosterStationInfoNormal(stationBasic.getBoosterGatewayId());
		}
		return boosterStationInfo;
	}

	public ResultsData runningPageByStationId(int current, int size, String stationId) {
		StationBasic stationBasic = stationBasicMapper.selectById(stationId);
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("风向角", "有功功率", "瞬时风速", "日发电量"));
		List<ESEquipments> allList = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
		List<ESEquipments> windSqlList = new ArrayList<>();
		List<ESEquipments> windSqlSortList = new ArrayList<>();
		List<ESEquipments> powerSqlList = new ArrayList<>();
		List<ESEquipments> windSpeedSqlList = new ArrayList<>();
		List<ESEquipments> electricitySqlList = new ArrayList<>();
		allList.forEach(item -> {
			if ("风向角".equals(item.getEquipmentIndexName())) {
				windSqlList.add(item);
			}
			if ("有功功率".equals(item.getEquipmentIndexName())) {
				if (!ObjectUtils.isEmpty(item.getValue())) {
					item.setValue(
							String.format(CommonConstans.Twodecimalplaces, Double.parseDouble(item.getValue()) / 1000));
				}
				powerSqlList.add(item);
			}
			if ("瞬时风速".equals(item.getEquipmentIndexName())) {
				windSpeedSqlList.add(item);
			}
			if ("日发电量".equals(item.getEquipmentIndexName())) {
				electricitySqlList.add(item);
			}
		});
		Map<String, String> powerSqlMap = powerSqlList.stream()
				.collect(Collectors.toMap(ESEquipments::getEquipmentNumber, ESEquipments::getValue));
		Map<String, String> windSpeedSqlMap = windSpeedSqlList.stream()
				.collect(Collectors.toMap(ESEquipments::getEquipmentNumber, ESEquipments::getValue));
		windSqlSortList = windSqlList.stream()
				.sorted(Comparator.comparing(ESEquipments::getEquipmentNumber, Comparator.comparing(Integer::parseInt)))
				.collect(Collectors.toList());
		Map<String, String> electricitySqlMap = electricitySqlList.stream()
				.collect(Collectors.toMap(ESEquipments::getEquipmentNumber, ESEquipments::getValue));
		ArrayList<Map<String, String>> resultList = new ArrayList<>();
		for (int i = 0; i < windSqlSortList.size(); i++) {
			ESEquipments esEquipments = windSqlSortList.get(i);
			HashMap<String, String> stringStringHashMap = new HashMap<>();
			stringStringHashMap.put("equipmentNumber", esEquipments.getEquipmentNumber());
			stringStringHashMap.put("wind",
					ObjectUtils.isEmpty(esEquipments.getValue()) ? "0.0" : esEquipments.getValue());
			stringStringHashMap.put("power", powerSqlMap.get(esEquipments.getEquipmentNumber()));
			stringStringHashMap.put("windSpeed", windSpeedSqlMap.get(esEquipments.getEquipmentNumber()));
			stringStringHashMap.put("electricity",
					String.format(CommonConstans.Fourdecimalplaces,
							ObjectUtils.isEmpty(electricitySqlMap.get(esEquipments.getEquipmentNumber())) ? 0.0000
									: Double.valueOf(electricitySqlMap.get(esEquipments.getEquipmentNumber()))));
			resultList.add(stringStringHashMap);
		}
		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current, resultList.size(), false, current, resultList);
		ColModel colModelEquipmentNumber = new ColModel("equipmentNumber", "equipmentNumber", "风机编码", "风机编码",
				"dataGrid", "equipmentNumber");
		ColModel colModelPower = new ColModel("power", "power", "有功功率(MW)", "有功功率(MW)", "dataGrid", "power");
		ColModel colModelWindSpeed = new ColModel("windSpeed", "windSpeed", "风速(m/s)", "风速(m/s)", "dataGrid",
				"windSpeed");
		ColModel colModelWind = new ColModel("wind", "wind", "风向(°)", "风向(°)", "dataGrid", "wind");
		ColModel colModelElectricity = new ColModel("electricity", "electricity", "日发电量(万kWh)", "日发电量(万kWh)",
				"dataGrid", "electricity");
		List<ColModel> listColModel = Arrays.asList(colModelEquipmentNumber, colModelPower, colModelWindSpeed,
				colModelWind, colModelElectricity);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

	public ResultsData getAlarmEventList(int current, int size, String stationId) {

		LambdaQueryWrapper<AlarmEvent> queryWrapper = new LambdaQueryWrapper<>();
		if (stationId != null) {
			queryWrapper.eq(AlarmEvent::getStationId, stationId);
		}
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.DAY_OF_MONTH, -7);
		queryWrapper.gt(AlarmEvent::getCreatedTime, calendar.getTime());
		int count = alarmEventMapper.selectCount(queryWrapper);

		List<AlarmEventDto> alarmEventList = alarmEventMapper.getAlarmEventList(null, stationId, (current - 1) * size,
				size, calendar.getTime());

		// List<AlarmEventDto> sorrtedAlarmEventList =
		// alarmEventList.stream().sorted(Comparator.comparing(AlarmEventDto::getCreatedTime).reversed()).collect(Collectors.toList());
//        ArrayList<Map<String, String>> resultList = new ArrayList<>();
//        alarmEventList.forEach(item -> {
//            HashMap<String, String> stringStringHashMap = new HashMap<>();
//            stringStringHashMap.put("stationName", item.getStationName());
//            stringStringHashMap.put("eventDesc", item.getEventDesc());
//            stringStringHashMap.put("alarmGroupName", item.getAlarmGroupName());
//            stringStringHashMap.put("eventTime", item.getEventTime());
//            stringStringHashMap.put("eventMovement", item.getEventMovement());
//            resultList.add(stringStringHashMap);
//        });
		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current, count, false, current, alarmEventList);
		ColModel colModelStationName = new ColModel("stationName", "stationName", "名称", "名称", "dataGrid",
				"stationName");
		ColModel colModelEventDesc = new ColModel("eventDesc", "eventDesc", "事件描述", "事件描述", "dataGrid", "eventDesc");
		ColModel colModelAlarmGroupName = new ColModel("alarmGroupName", "alarmGroupName", "事件告警组", "事件告警组", "dataGrid",
				"alarmGroupName");
		ColModel colModelEventTime = new ColModel("eventTime", "eventTime", "事件发生时间", "事件发生时间", "dataGrid",
				"eventTime");
		ColModel colModelEventMovement = new ColModel("eventMovement", "eventMovement", "事件动作描述", "事件动作描述", "dataGrid",
				"eventMovement");
		List<ColModel> listColModel = Arrays.asList(colModelStationName, colModelEventDesc, colModelAlarmGroupName,
				colModelEventTime, colModelEventMovement);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

	public ResultsData getElectricQuantityList(int current, int size, StationBasic stationBasic) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getBoosterGatewayId()));
//        queryCondtion.put(CommonConstans.QueryStringFrontMoudle, Arrays.asList("电量表计"));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, "电量表计");
		List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion, null,
				ESEquipments.class, likeMap);
		List<ESEquipments> windSqlList = esEquipmentsList.stream()
				.filter(esEquipments -> !esEquipments.getDisplayName().equals("")
						&& !esEquipments.getDisplayName().equals("检修状态"))
				.collect(Collectors.toList());
		ArrayList<Map<String, String>> resultList = new ArrayList<>();
		ArrayList<Map<String, String>> resultList1 = new ArrayList<>();
		List<String> nameList = new ArrayList<>();
		Map<String, String> handleData = new HashMap<>();
		Map<String, List<String>> originalData = new HashMap<>();
		if ("FDZ".equals(stationBasic.getStationType())) {
			handleData = windSqlList.stream().collect(Collectors.toMap(ESEquipments::getEquipmentIndexName,
					esEquipments -> String.format(CommonConstans.Threedecimalplaces, esEquipments.getValueF())));
			nameList = CommonConstans.xiazaoElectricityMeter;
			originalData = CommonConstans.xiazaoElectricityMeterPointSort;
		} else {
			handleData = windSqlList.stream().collect(Collectors.toMap(ESEquipments::getEquipmentIndexName,
					esEquipments -> String.format(CommonConstans.Twodecimalplaces, esEquipments.getValueF() * 0.01)));
			nameList = CommonConstans.taiheElectricityMeter;
			originalData = CommonConstans.taiheElectricityMeterPointSort;
		}
		for (int i = 0; i < nameList.size(); i++) {
			HashMap<String, String> stringStringHashMap = new HashMap<>();
			String name = nameList.get(i);
			stringStringHashMap.put("name", name);
			Double electricityIndicator = 1.0;
			List<String> dataList = originalData.get(name);
			stringStringHashMap.put("zxzyg", handleData.get(dataList.get(0)));
			stringStringHashMap.put("fxzyg", handleData.get(dataList.get(1)));
			stringStringHashMap.put("zxzwg", handleData.get(dataList.get(2)));
			stringStringHashMap.put("fxzwg", handleData.get(dataList.get(3)));
			if (name.equals("夏雩线212主表")) {
				stringStringHashMap.put("zxzyg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(0))) * 0.001));
				stringStringHashMap.put("fxzyg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(1))) * 0.001));
				stringStringHashMap.put("zxzwg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(2))) * 0.001));
				stringStringHashMap.put("fxzwg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(3))) * 0.001));
			}
			if (name.equals("夏雩线212副表")) {
				stringStringHashMap.put("zxzyg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(0))) * 0.01));
				stringStringHashMap.put("fxzyg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(1))) * 0.01));
				stringStringHashMap.put("zxzwg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(2))) * 0.01));
				stringStringHashMap.put("fxzwg", String.format(CommonConstans.Threedecimalplaces,
						Double.valueOf(handleData.get(dataList.get(3))) * 0.01));
			}
			resultList.add(stringStringHashMap);
		}
		resultList.addAll(resultList1);
		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current, resultList.size(), false, current, resultList);
		ColModel colModelEventMovement = new ColModel("name", "name", "测量点", "测量点", "dataGrid", "name");
		ColModel colModelStationName = new ColModel("zxzyg", "zxzyg", "正向总有功", "正向总有功", "dataGrid", "zxzyg");
		ColModel colModelEventDesc = new ColModel("fxzyg", "fxzyg", "反向总有功", "反向总有功", "dataGrid", "fxzyg");
		ColModel colModelAlarmGroupName = new ColModel("zxzwg", "zxzwg", "正向总无功", "正向总无功", "dataGrid", "zxzwg");
		ColModel colModelEventTime = new ColModel("fxzwg", "fxzwg", "反向总无功", "反向总无功", "dataGrid", "fxzwg");
		List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc,
				colModelAlarmGroupName, colModelEventTime);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

	public void getAnalogQuantityInfo(String gatewayId, String stationId, String routeName) {
		if (StringUtils.isNotEmpty(gatewayId)) {
			Map<String, String> map = monitorFanIndicatorregionMapper.getMajorBoosterStationInfoBySort(gatewayId,
					routeName);
			Map<String, List<String>> queryCodtion = new HashMap<>();
			Map<String, String> likeMap = new HashMap<>();
			queryCodtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
//            queryCodtion.put(CommonConstans.QueryStringSystemTypeKeyword, Arrays.asList("模拟量"));
			likeMap.put(CommonConstans.QueryStringFrontMoudle, map.get("boosterName"));
			likeMap.put(CommonConstans.QueryStringSystemTypeKeyword, "模拟量");
			if (CommonConstans.XIAZAO_ZHUBIANGAOYACE.equals(map.get("boosterName"))
					|| CommonConstans.XIAZAO_ZHUBIANDIYACE.equals(map.get("boosterName"))) {
				likeMap.put(CommonConstans.QueryStringFrontMoudle, "压侧");
				List<ESEquipments> listData = commonServiceImpl.getListDataByCondtions(queryCodtion, null,
						ESEquipments.class, likeMap);
				Integer traceIdCount = listData.stream()
						.filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
						.collect(Collectors.toList()).size();
				if (traceIdCount > 0) {
					listData = listData.stream().filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
							.collect(Collectors.toList());
				}
				// 主变高压侧
				Map<String, String> zbGYC = listData.stream()
						.filter(t -> t.getFrontModule().contains(CommonConstans.XIAZAO_ZHUBIANGAOYACE))
						.collect(Collectors.toMap(ESEquipments::getDisplayName, ESEquipments::getValue));
				List<Map<String, String>> zbList = new ArrayList<>();
				listData.stream().filter(t -> t.getFrontModule().contains(CommonConstans.XIAZAO_ZHUBIANDIYACE))
						.forEach(item -> {
							HashMap<String, String> zbMap = new HashMap<>();
							zbMap.put("traceId", item.getTraceId());
							zbMap.put("title", item.getDisplayName());
							zbMap.put("grade1", keepTwoDecimalPlaces(item.getValue()));
							zbMap.put("grade2", keepTwoDecimalPlaces(zbGYC.getOrDefault(item.getDisplayName(), "0.0")));
							zbList.add(zbMap);
						});
				zbList.sort(Comparator.comparingInt(o -> Integer.parseInt(o.get("traceId").toString())));
				IPage<Map<String, String>> zbResult = new Page<>();
				zbResult.setRecords(zbList);
				zbResult.setCurrent(1);
				zbResult.setTotal(zbList.size());
				try {
					log.info("主变消息内容：{}", JSON.toJSONString(zbResult));
					emqKeeper.getMqttClient().publish(String.format("%s/%s/%s", stationId, routeName, "mnl"),
							JSON.toJSONString(zbResult).getBytes(), 1, true);
				} catch (MqttException e) {
					log.info("消息发送失败");
					e.printStackTrace();
				}
			} else {
				List<ESEquipments> listData = commonServiceImpl.getListDataByCondtions(queryCodtion, null,
						ESEquipments.class, likeMap);
				Integer traceIdCount = listData.stream()
						.filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
						.collect(Collectors.toList()).size();
				if (traceIdCount > 0) {
					listData = listData.stream().filter(esEquipments -> !StringUtils.isEmpty(esEquipments.getTraceId()))
							.collect(Collectors.toList());
					listData.sort(
							Comparator.comparing(ESEquipments::getTraceId, Comparator.comparingInt(Integer::parseInt)));
				}
				ArrayList<Map<String, String>> resultList = new ArrayList<>();
				listData.forEach(item -> {
					HashMap<String, String> stringStringHashMap = new HashMap<>();
					stringStringHashMap.put("traceId", item.getTraceId());
					stringStringHashMap.put("title", item.getDisplayName());
					stringStringHashMap.put("value", keepTwoDecimalPlaces(item.getValue()));
					resultList.add(stringStringHashMap);
				});

				IPage<Map<String, String>> result = new Page<>();
				result.setRecords(resultList);
				result.setCurrent(1);
				result.setTotal(resultList.size());
				try {
					log.info("消息内容：{}", JSON.toJSONString(result));
					emqKeeper.getMqttClient().publish(String.format("%s/%s/%s", stationId, routeName, "mnl"),
							JSON.toJSONString(result).getBytes(), 1, true);
				} catch (MqttException e) {
					log.info("消息发送失败");
					e.printStackTrace();
				}
			}
		}
	}

	public void getMajorAnalogQuantityByPage(String gatewayId, String stationId) {
		if (StringUtils.isNotEmpty(gatewayId)) {
			Map<String, List<String>> queryCondition = new HashMap<>();
			queryCondition.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
			queryCondition.put(CommonConstans.QueryStringSystemTypeKeyword, Arrays.asList("模拟量"));
			List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtions(queryCondition, null,
					ESEquipments.class);
			esEquipmentsList.forEach(esEquipments -> {
				if (StringUtils.isEmpty(esEquipments.getEquipmentNumber())) {
					esEquipments.setDisplayName(getDisplayNameNotContainUnit(esEquipments.getDisplayName()));
				}
			});
			List<ESEquipments> xianData = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getFrontModule().equals("220kVⅠ母PT")
							|| esEquipments.getFrontModule().equals("35kVⅠ母PT"))
					.collect(Collectors.toList());
			HashMap<String, Object> resultMap = new HashMap<>();
			xianData.forEach(item -> {
				if ("220kVⅠ母PT".equals(item.getFrontModule())) {
					resultMap.put("220" + item.getDisplayName(),
							item.getValueF() == null ? "0" : keepTwoDecimalPlaces(item.getValueF().toString()));
				} else if ("35kVⅠ母PT".equals(item.getFrontModule())) {
					resultMap.put("35" + item.getDisplayName(),
							item.getValueF() == null ? "0" : keepTwoDecimalPlaces(item.getValueF().toString()));
				}
			});
			List<String> xyxDisplayNameList = Arrays.asList("Ia", "P", "Q", "Ux");
			List<ESEquipments> xyxSqlData = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getFrontModule().equals("夏雩线")
							&& xyxDisplayNameList.contains(esEquipments.getDisplayName()))
					.collect(Collectors.toList());
			xyxSqlData.forEach(
					item -> resultMap.put("xyx" + item.getDisplayName(), keepTwoDecimalPlaces(item.getValue())));
			List<ESEquipments> dlbjSqlData = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getFrontModule().equals("模拟量")).collect(Collectors.toList());
			// 正向总有功正向总无功需要计算
			dlbjSqlData.forEach(item -> {
				if ("正向总有功".equals(item.getDisplayName())) {
					resultMap.put("2000S1",
							item.getValueF() == null ? "0"
									: keepTwoDecimalPlaces(
											String.valueOf((Double.parseDouble(item.getValueF().toString()) / 1000))));
				} else if ("正向总无功".equals(item.getDisplayName())) {
					resultMap.put("2000S2",
							item.getValueF() == null ? "0"
									: keepTwoDecimalPlaces(
											String.valueOf((Double.parseDouble(item.getValueF().toString()) / 1000))));
				}
			});

			List<String> zb1DisplayNameList = Arrays.asList("档位", "油面温1", "油面温2", "绕组温度");
			List<ESEquipments> zb1SqlData = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getFrontModule().equals("1主变")
							&& zb1DisplayNameList.contains(esEquipments.getDisplayName()))
					.collect(Collectors.toList());
			resultMap.put("value1", "0.0");
			resultMap.put("value2", "0.0");
			resultMap.put("value3", "0.0");
			resultMap.put("value4", "0.0");
			zb1SqlData.forEach(item -> {
				if ("档位".equals(item.getDisplayName())) {
					resultMap.put("value4", ObjectUtils.isEmpty(item.getValueF()) ? "0"
							: String.format("%.0f", Double.parseDouble(item.getValueF().toString())));
				} else if ("油面温1".equals(item.getDisplayName())) {
					resultMap.put("value1", ObjectUtils.isEmpty(item.getValueF()) ? "0.0"
							: String.format("%.1f", Double.parseDouble(item.getValueF().toString())));
				} else if ("油面温2".equals(item.getDisplayName())) {
					resultMap.put("value2", ObjectUtils.isEmpty(item.getValueF()) ? "0.0"
							: String.format("%.1f", Double.parseDouble(item.getValueF().toString())));
				} else if ("绕组温度".equals(item.getDisplayName())) {
					resultMap.put("value3", ObjectUtils.isEmpty(item.getValueF()) ? "0.0"
							: String.format("%.1f", Double.parseDouble(item.getValueF().toString())));
				}
			});

			// 主线路图上各个路线名称
			resultMap.put("xyx", "夏雩线");
			resultMap.put("zbgy", "1主变高压侧");
			resultMap.put("220mpt", "220kVⅠ母PT");
			resultMap.put("jd1", "集电Ⅰ线");
			resultMap.put("jd2", "集电Ⅱ线");
			resultMap.put("jd3", "集电Ⅲ线");
			resultMap.put("jd4", "集电Ⅳ线");
			resultMap.put("zbdy", "1主变低压侧");
			resultMap.put("dy1", "待用Ⅰ线");
			resultMap.put("35mpt", "35kVⅠ母PT");
			resultMap.put("1jdb", "1接地变");
			resultMap.put("1svg", "1SVG");
			resultMap.put("2svg", "2SVG");

			resultMap.put("xzsvg", "夏造SVG");
			resultMap.put("xzaggavc", "夏造AGCAVC");
			resultMap.put("xzgyxh", "夏造公用信号");

			resultMap.put("xzjzlp", "夏造交直流屏");

			// 下方重复列表数据
			List<Map<String, String>> boosterStationInfo = monitorFanIndicatorregionMapper
					.getMajorBoosterStationInfo(gatewayId, "ASC", 10);
			ArrayList<Map<String, String>> resultList = new ArrayList<>();
			List<String> boosterDisplayNameList = Arrays.asList("Ia", "P", "Q");
			for (Map<String, String> map : boosterStationInfo) {

				List<ESEquipments> listData = esEquipmentsList.stream()
						.filter(esEquipments -> esEquipments.getFrontModule().contains(map.get("boosterName"))
								&& boosterDisplayNameList.contains(esEquipments.getDisplayName()))
						.collect(Collectors.toList());
				HashMap<String, String> stringStringHashMap = new HashMap<>();
				stringStringHashMap.put("value1", "0.0");
				stringStringHashMap.put("value2", "0.0");
				stringStringHashMap.put("value3", "0.0");
				if (!map.get("boosterName").toString().equals("35kVⅠ母PT")) {
					listData.forEach(item -> {

						if (item.getDisplayName().equals("Ia")) {
							stringStringHashMap.put("value1",
									item.getValueF() == null ? "0" : keepTwoDecimalPlaces(item.getValueF().toString()));
						}
						if (item.getDisplayName().equals("P")) {
							stringStringHashMap.put("value2",
									item.getValueF() == null ? "0" : keepTwoDecimalPlaces(item.getValueF().toString()));
						}
						if (item.getDisplayName().equals("Q")) {
							stringStringHashMap.put("value3",
									item.getValueF() == null ? "0" : keepTwoDecimalPlaces(item.getValueF().toString()));
						}
					});
				} else {
					stringStringHashMap.put("value1", "");
					stringStringHashMap.put("value2", "");
					stringStringHashMap.put("value3", "");
				}

				resultList.add(stringStringHashMap);
			}
			resultMap.put("records", resultList);
			resultMap.put("current", 1);
			resultMap.put("size", resultList.size());

			// 开关信息
			Map<String, Object> switchUrl = getSwitchUrl(gatewayId, null);
			resultMap.putAll(switchUrl);

			List<Map<String, Object>> finallyResultList = Collections.singletonList(resultMap);
			// 主屏下方重复列表数据
			IPage<Map<String, Object>> resultPage = new Page<>();
			resultPage.setRecords(finallyResultList);
			resultPage.setCurrent(1);
			resultPage.setTotal(finallyResultList.size());
			try {
				log.info("消息内容：{}", JSON.toJSONString(resultPage));
				emqKeeper.getMqttClient().publish(String.format("%s/%s/%s", stationId, "major", "data"),
						JSON.toJSONString(resultPage).getBytes(), 0, false);
			} catch (MqttException e) {
				log.info("消息发送失败");
				e.printStackTrace();
			}
		}
	}

	public void getMajorAnalogQuantityByPageByTHGF(String gatewayId, String stationId) {
		if (StringUtils.isNotEmpty(gatewayId)) {
			Map<String, List<String>> queryCondition = new HashMap<>();
			queryCondition.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
			queryCondition.put(CommonConstans.QueryStringSystemTypeKeyword, Arrays.asList("模拟量"));
			List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtions(queryCondition, null,
					ESEquipments.class);
			esEquipmentsList.forEach(esEquipments -> {
				if (StringUtils.isEmpty(esEquipments.getEquipmentNumber())) {
					esEquipments.setDisplayName(getDisplayNameNotContainUnit(esEquipments.getDisplayName()));
				}
			});
			List<String> displayName = Arrays.asList("Ua", "Ub", "Uc");
			// 10kVⅡ段母线数据
			List<ESEquipments> xianData = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getFrontModule().contains("35kVⅠ母PT")
							&& !displayName.contains(esEquipments.getDisplayName()))
					.collect(Collectors.toList());
			HashMap<String, Object> resultMap = new HashMap<>();
			xianData.forEach(
					item -> resultMap.put(item.getDisplayName(), keepTwoDecimalPlaces(item.getValueF().toString())));
			List<ESEquipments> xianData1 = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getEquipmentIndexName().contains("南瑞光差保护_313")
							&& displayName.contains(esEquipments.getDisplayName()))
					.collect(Collectors.toList());
			xianData1.forEach(
					item -> resultMap.put(item.getDisplayName(), keepTwoDecimalPlaces(item.getValueF().toString())));
			List<String> xyxDisplayNameList = Arrays.asList("Ia", "P", "Q");
			List<ESEquipments> xyxSqlData = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getFrontModule().equals("35kV前万线")
							&& xyxDisplayNameList.contains(esEquipments.getDisplayName()))
					.collect(Collectors.toList());
			xyxSqlData.forEach(item -> resultMap.put("35qwx" + item.getDisplayName(),
					keepTwoDecimalPlaces(item.getValueF().toString())));

			// 主线路图上各个路线名称
			resultMap.put("35qwx", "35kV前万线");
			resultMap.put("35qg1x", "35kV前光Ⅰ线");
			resultMap.put("35qg2x", "35kV前光Ⅱ线");
			resultMap.put("1svg", "1SVG");
			resultMap.put("1zyb", "1站用变");
			resultMap.put("35mxpt", "35kV母线PT");

			resultMap.put("thsvg", "泰和SVG");
			resultMap.put("thglyc", "泰和功率预测");
			resultMap.put("thgyxh", "泰和公用信号");
			resultMap.put("thjzlp", "泰和交直流屏");

			// 下方重复列表数据
			List<Map<String, String>> boosterStationInfo = monitorFanIndicatorregionMapper
					.getMajorBoosterStationInfo(gatewayId, "ASC", 5);
			ArrayList<Map<String, String>> resultList = new ArrayList<>();
			for (Map<String, String> map : boosterStationInfo) {
				if (map.get("boosterName").equals("35kVⅠ母PT")) {
					continue;
				}
				List<ESEquipments> listData = esEquipmentsList.stream()
						.filter(esEquipments -> esEquipments.getFrontModule().contains(map.get("boosterName"))
								&& xyxDisplayNameList.contains(esEquipments.getDisplayName()))
						.collect(Collectors.toList());
				HashMap<String, String> stringStringHashMap = new HashMap<>();
				stringStringHashMap.put("value1", "0.0");
				stringStringHashMap.put("value2", "0.0");
				stringStringHashMap.put("value3", "0.0");
				listData.forEach(item -> {
					if (item.getDisplayName().equals("Ia")) {
						stringStringHashMap.put("value1", keepTwoDecimalPlaces(item.getValueF().toString()));
					}
					if (item.getDisplayName().equals("P")) {
						stringStringHashMap.put("value2", keepTwoDecimalPlaces(item.getValueF().toString()));
					}
					if (item.getDisplayName().equals("Q")) {
						stringStringHashMap.put("value3", keepTwoDecimalPlaces(item.getValueF().toString()));
					}
				});
				resultList.add(stringStringHashMap);
			}
			resultMap.put("records", resultList);
			resultMap.put("current", 1);
			resultMap.put("size", resultList.size());

			// 开关信息
			Map<String, Object> switchUrl = getSwitchUrl(gatewayId, null);
			resultMap.putAll(switchUrl);

			List<Map<String, Object>> finallyResultList = Collections.singletonList(resultMap);
			// 主屏下方重复列表数据
			IPage<Map<String, Object>> resultPage = new Page<>();
			resultPage.setRecords(finallyResultList);
			resultPage.setCurrent(1);
			resultPage.setTotal(finallyResultList.size());
			try {
				log.info("消息内容：{}", JSON.toJSONString(resultPage));
				emqKeeper.getMqttClient().publish(String.format("%s/%s/%s", stationId, "major", "data"),
						JSON.toJSONString(resultPage).getBytes(), 0, false);
			} catch (MqttException e) {
				log.info("消息发送失败");
				e.printStackTrace();
			}
		}
	}

	public void getSwitchUrlAll(StationBasic stationBasic) {
		String gatewayId = stationBasic.getBoosterGatewayId();
		Map<String, List<String>> queryCodtion = new HashMap<>();
		queryCodtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCodtion.put(CommonConstans.QueryStringSystemType, Arrays.asList("开关"));
		Map<String, String> shouldqueryCodtion = new HashMap<>();
		shouldqueryCodtion.put(CommonConstans.QueryStringDisplayName, "合位");
		List<ESEquipments> listData = commonServiceImpl.getListDataByCondtions(queryCodtion, shouldqueryCodtion,
				ESEquipments.class);
		Set<String> names = new HashSet<>();

		for (ESEquipments listDatum : listData) {
			names.add(listDatum.getFrontModule());
		}

		for (String name : names) {
			getSwitchUrl(gatewayId, name);
		}

	}

	public Map<String, Object> getSwitchUrl(String gatewayId, String equipName) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringSystemTypeKeyword, "开关");
		List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class, likeMap);
		List<ESEquipments> listData = esEquipmentsList.stream()
				.filter(esEquipments -> esEquipments.getDisplayName().contains("合位")).collect(Collectors.toList());
		List<ESEquipments> listDatas = esEquipmentsList.stream()
				.filter(esEquipments -> esEquipments.getDisplayName().contains("远方就地开关")).collect(Collectors.toList());
		List<ESEquipments> listDatass = esEquipmentsList.stream()
				.filter(esEquipments -> esEquipments.getDisplayName().contains("接地刀位置")).collect(Collectors.toList());
		if (StringUtils.isNotEmpty(equipName)) {
			listData = esEquipmentsList.stream().filter(esEquipments -> esEquipments.getDisplayName().contains("合位")
					&& esEquipments.getFrontModule().equals(equipName)).collect(Collectors.toList());
			listDatas = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getDisplayName().contains("远方就地开关")
							&& esEquipments.getFrontModule().equals(equipName))
					.collect(Collectors.toList());
			listDatass = esEquipmentsList.stream()
					.filter(esEquipments -> esEquipments.getDisplayName().contains("接地刀位置")
							&& esEquipments.getFrontModule().equals(equipName))
					.collect(Collectors.toList());
		}
		Map<String, Object> photoUrls = new HashMap<>();

		for (ESEquipments datass : listDatass) {
			String url = "";
			String[] urls = datass.getPictureName().split(",");
			if (datass.getValue().equals("false")) {
				url = pictureUrl + urls[0];
			} else {
				url = pictureUrl + urls[1];
			}
			photoUrls.put(datass.getDisplayName().split("_")[0] + "jddwz", url);
		}

		for (ESEquipments data : listDatas) {
			String url = "";
			String[] urls = data.getPictureName().split(",");
			if (StringUtils.isNotEmpty(data.getValue()) && data.getValue().equals("false")) {
				url = pictureUrl + urls[1];
			} else {
				url = pictureUrl + urls[0];
			}
			if (data.getDisplayName().split("_").length > 2) {
				photoUrls.put(KGName.getCode(data.getDisplayName().split("_")[1]), url);
			} else {
				photoUrls.put(data.getDisplayName().split("_")[0] + "yfjdkgurl", url);
			}
		}

		for (ESEquipments listDatum : listData) {
			String url = "";
			if (listDatum.getDisplayName().contains("手车工作位置")) {
				String[] split = listDatum.getPictureName().split(":");
				if (listDatum.getValue().equals("false")) {
					String[] split1 = split[0].split(",");
					photoUrls.put(listDatum.getDisplayName().split("_")[0] + "scsurl", pictureUrl + split1[0]);
					photoUrls.put(listDatum.getDisplayName().split("_")[0] + "scxurl", pictureUrl + split1[1]);
				} else {
					String[] split1 = split[1].split(",");
					photoUrls.put(listDatum.getDisplayName().split("_")[0] + "scsurl", pictureUrl + split1[0]);
					photoUrls.put(listDatum.getDisplayName().split("_")[0] + "scxurl", pictureUrl + split1[1]);
				}
			} else {
				if (listDatum.getValue().equals("false")) {
					url = pictureUrl + listDatum.getPictureName();
				} else {
					url = pictureUrl + listDatum.getPictureName().replace("green", "red");
				}
				photoUrls.put(listDatum.getDisplayName().split("_")[0] + "url", url);
			}
		}
		return photoUrls;

	}

	public HashMap<String, Object> getyw(String gatewayId) {
		HashMap<String, Object> resultMap = new HashMap<>();
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringSystemTypeKeyword, Arrays.asList("模拟量"));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudle, "1主变");
		List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class, likeMap);
		// TODO: 2023/7/14 数据未整理 ---> 油面温1 油面温2 绕组温度
		resultMap.put("value1", "0.0");
		resultMap.put("value2", "0.0");
		resultMap.put("value3", "0.0");
		resultMap.put("value4", "0.0");
		esEquipmentsList.forEach(item -> {
			if ("档位".equals(item.getDisplayName())) {
				resultMap.put("value4", String.format("%.0f", item.getValueF()));
			} else if ("油面温1".equals(item.getDisplayName())) {
				resultMap.put("value1", String.format("%.1f", item.getValueF()));
			} else if ("油面温2".equals(item.getDisplayName())) {
				resultMap.put("value2", String.format("%.1f", item.getValueF()));
			} else if ("绕组温度".equals(item.getDisplayName())) {
				resultMap.put("value3", String.format("%.1f", item.getValueF()));
			}
		});
		return resultMap;
	}

	public HashMap<String, Object> getEquipInfoByEquipNum(String gatewayId, String equipmentNumber) {

		HashMap<String, Object> resultMap = new HashMap<>();
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringEquipmentNumberKeyword, Arrays.asList(equipmentNumber));
		List<ESEquipments> list = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class)
				.subList(0, 1);
		if (!ValidationUtil.isEmpty(list)) {
//            resultMap.put("equipmentSpecificName", list.get(0).getEquipmentSpecificName());
//            resultMap.put("equipmentIndexName", list.get(0).getEquipmentSpecificName());
			// 箱变名称与箱变型号去掉区域
			String type = "光伏阵区系统";
			String queryEquipNum = "";
			if (equipmentNumber.contains("-")) {
				String[] equipNames = equipmentNumber.split("-");
				if (equipNames.length > 2) {
					type = "汇流箱系统";
					queryEquipNum = equipNames[0] + equipNames[1] + Integer.parseInt(equipNames[2]);
				} else {
					HashMap<String, String> nbpStatus = getPvNBQStationBy(gatewayId);
					type = "光伏逆变器系统";
					queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName,
							Arrays.asList("待机", "故障停机", "告警运行", "限额运行", "停机", "通讯故障", "降额运行", "运行"));
					queryCondtion.put(CommonConstans.QueryStringValueKeyword, Arrays.asList("true"));
					List<ESEquipments> list1 = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
							ESEquipments.class);
					resultMap.put("status", nbpStatus.get(equipmentNumber));
//                    queryEquipNum = "#" + Integer.parseInt(equipNames[0]);
					queryEquipNum = equipNames[0] + equipNames[1] + 1;
				}
			} else {
				queryEquipNum = "#" + Integer.parseInt(equipmentNumber) + "";
			}
			queryEquipNum = queryEquipNum + type;

			LambdaQueryWrapper<SjglZsjZsbtz> queryWrapper = new LambdaQueryWrapper<>();
			queryWrapper.like(SjglZsjZsbtz::getSbmc, queryEquipNum);
			SjglZsjZsbtz sjglZsjZsbtz = sjglZsjZsbtzMapper.selectOne(queryWrapper);

			resultMap.put("equipmentSpecificName", list.get(0).getEquipmentSpecificName().split("区域/")[1]);
			resultMap.put("equipmentIndexName", null == sjglZsjZsbtz.getGgxh() ? "" : sjglZsjZsbtz.getGgxh());
			resultMap.put("equipmentInfoName", list.get(0).getEquipmentSpecificName().substring(5).replace("/", " "));
		}
		return resultMap;
	}

	public Map<String, Object> getStatisticsInfo(String equipmentIndexName, String stationId) {
		StationCacheInfoDto stationCacheInfoDto = commonServiceImpl.getStationCacheInfoDtoByStationId(stationId);
		String gatewayId = stationCacheInfoDto.getFanGatewayId();
		if (!"FDZ".equals(stationCacheInfoDto.getStationType())) {
			gatewayId = stationCacheInfoDto.getBoosterGatewayId();
		}
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName,
				Arrays.asList("220kV夏雩线212线路测控装置PCS-9705TA有功功率一次值", "南瑞光差保护_313P"));
		queryCondtion.put(CommonConstans.QueryStringGateWayId,
				Arrays.asList(stationCacheInfoDto.getBoosterGatewayId()));
		List<ESEquipments> listData = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
		String load = String.format(CommonConstans.Twodecimalplaces,
				Double.parseDouble(String.valueOf(listData.get(0).getValueF()))
						/ Double.parseDouble(stationCacheInfoDto.getInstalledCapacity()));

		List<Map<String, Object>> list = temporaryDataMapper.timingTemporarysSorageDataByIndexName(gatewayId,
				equipmentIndexName);
		Map<String, Object> map = new HashMap<>();
		List<String> values = new ArrayList<>();
		Set<String> time = new TreeSet<>();
		String v = null == list ? "" : list.get(0).get("value").toString();
		double min = Double.parseDouble(v);
		double max = Double.parseDouble(v);
		double mean = 0.0;
		String minTime = null == list ? "" : list.get(0).get("createdTime").toString();
		String maxTime = null == list ? "" : list.get(0).get("createdTime").toString();

		for (Map<String, Object> stringStringMap : list) {
			double value = Double.parseDouble(stringStringMap.get("value").toString());
			values.add(String.format("%.2f", value));
			if (value < min) {
				min = value;
				minTime = stringStringMap.get("createdTime").toString();
			} else if (value > max) {
				max = value;
				maxTime = stringStringMap.get("createdTime").toString();
			}
			time.add(stringStringMap.get("createdTime").toString());

		}

		for (String value : values) {
			mean += Double.parseDouble(value);
		}
		mean = Double.parseDouble(String.format(CommonConstans.Twodecimalplaces, mean / values.size()));
		max = Double.parseDouble(String.format(CommonConstans.Twodecimalplaces, max));
		min = Double.parseDouble(String.format(CommonConstans.Twodecimalplaces, min));

		List<Map<String, Object>> seriesData = new ArrayList<>();

		map.put("mean", mean);
		map.put("max", max);
		map.put("min", min);
		map.put("maxTime", maxTime);
		map.put("minTime", minTime);
		map.put("load", load);

		return map;

	}

	public List<Map<String, Object>> getEquipmentNum(String gatewayId, String frontModule, String equipmentNumber) {
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringFrontMoudle, Arrays.asList(frontModule));
		List<ESEquipments> esEquipmentsList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class);
		List<ESEquipments> listData = esEquipmentsList.stream()
				.filter(esEquipments -> !esEquipments.getEquipmentNumber().equals(""))
				.sorted(Comparator.comparing(ESEquipments::getEquipmentNumber)).collect(Collectors.toList());
		if (null != equipmentNumber) {
			listData = esEquipmentsList.stream()
					.filter(esEquipments -> !esEquipments.getEquipmentNumber().contains(equipmentNumber))
					.collect(Collectors.toList());
		}
		return listData.stream().map(item -> {
			HashMap<String, Object> map = new HashMap<>();
			map.put("equipmentNumber", item.getEquipmentNumber());
			map.put("equipmentSpecificName", item.getEquipmentSpecificName().substring(5).replace("/", " "));
			return map;
		}).distinct().collect(Collectors.toList());
	}

	public String keepTwoDecimalPlaces(String value) {
		String s = "0.00";
		if (!ObjectUtils.isEmpty(value)) {
			try {
				s = String.format(CommonConstans.Twodecimalplaces, Double.parseDouble(value));
			} catch (Exception ex) {

			}
		}
		return s;
	}

	public String keepFourDecimalPlaces(String value) {
		String s = "0.0000";
		if (!ObjectUtils.isEmpty(value)) {
			try {
				s = String.format(CommonConstans.Fourdecimalplaces, Double.parseDouble(value));
			} catch (Exception ex) {

			}
		}
		return s;
	}

	public HashMap<String, Object> SpeedIndicator(String gatewayId, String equipmentNumber, String equipmentIndexName) {
		HashMap<String, Object> resultMap = new HashMap<>();
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringEquipmentNumberKeyword, Arrays.asList(equipmentNumber));
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList(equipmentIndexName));
		List<ESEquipments> list = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
		if (!ValidationUtil.isEmpty(list)) {
			resultMap.put("value", String.format(CommonConstans.Twodecimalplaces,
					Double.parseDouble(list.get(0).getValueF().toString())));
		}
		return resultMap;
	}

	public void getEquipSwitchStatus(StationBasic stationBasic) {
		String gatewayId = stationBasic.getFanGatewayId();
		Long stationId = stationBasic.getSequenceNbr();
		Map<String, List<String>> queryConditon = new HashMap<>();
		queryConditon.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> shouldConditon = new HashMap<>();
		shouldConditon.put(CommonConstans.QueryStringEquipmentIndexName, "合闸");
		List<ESEquipments> list = commonServiceImpl.getListDataByCondtions(queryConditon, null, ESEquipments.class,
				shouldConditon);
		if (!ValidationUtil.isEmpty(list)) {
			Map<String, List<ESEquipments>> collect = list.stream()
					.filter(e -> StringUtils.isNotBlank(e.getEquipmentNumber()))
					.collect(Collectors.groupingBy(ESEquipments::getEquipmentNumber));
			for (String s : collect.keySet()) {
				HashMap<String, Object> resultMap = new HashMap<>();
				collect.get(s).stream().forEach(e -> {
					String picturl = "";
					if (e.getValue().equals("false")) {
						picturl = pictureUrl + "dlg-h-red.png";
					} else {
						picturl = pictureUrl + "dlg-h-green.png";
					}
					if (e.getEquipmentIndexName().endsWith("断路器合闸")) {
						resultMap.put(e.getEquipmentIndexName().substring(0, 3), picturl);
					} else {
						resultMap.put("gy", picturl);
					}
				});
				IPage<Map<String, Object>> result = new Page<>();
				List<Map<String, Object>> data = new ArrayList<>();
				data.add(resultMap);
				result.setRecords(data);
				result.setCurrent(1);
				result.setTotal(100);
				try {
					emqKeeper.getMqttClient().publish(stationId + "/xbjg/" + s, JSON.toJSONString(result).getBytes(), 0,
							false);
				} catch (MqttException e) {
					e.printStackTrace();
				}

			}
		}

	}

	public ResultsData collectingBox(String gatewayId, int current, int size) {

		ArrayList<Map<String, Object>> resultList = getLSV(gatewayId);

		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(current, resultList.size(), false, current, resultList);
		ColModel colModelEventMovement = new ColModel("zz", "zz", "子阵", "子阵", "dataGrid", "zz");
		ColModel colModelStationName = new ColModel("nbq", "nbq", "逆变器", "逆变器", "dataGrid", "nvq");
		ColModel colModelEventDesc = new ColModel("hlx", "hlx", "汇流箱", "汇流箱", "dataGrid", "hlx");
		ColModel colModelAlarmGroupName = new ColModel("avg", "avg", "支路电流平均值", "支路电流平均值", "dataGrid", "avg");
		ColModel colModelEventTime = new ColModel("lsv", "lsv", "支路电流离散率", "支路电流离散率", "dataGrid", "lsv");
		List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc,
				colModelAlarmGroupName, colModelEventTime);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

	public ArrayList<Map<String, Object>> getLSV(String gatewayId) {

		ArrayList<Map<String, Object>> resultList = new ArrayList<>();
		Map<String, List<String>> queryConditon = new HashMap<>();
		queryConditon.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringEquipmentIndexNameNotKeyword, "路电流");
		List<ESEquipments> list = commonServiceImpl.getListDataByCondtionsAndLike(queryConditon, null,
				ESEquipments.class, likeMap);

		Map<String, List<String>> queryConditon1 = new HashMap<>();
		queryConditon1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap1 = new HashMap<>();
		likeMap1.put(CommonConstans.QueryStringEquipmentIndexNameNotKeyword, "平均电流");
		List<ESEquipments> list1 = commonServiceImpl.getListDataByCondtionsAndLike(queryConditon, null,
				ESEquipments.class, likeMap1);

		if (!ValidationUtil.isEmpty(list)) {
			Map<String, List<ESEquipments>> collect = list.stream()
					.collect(Collectors.groupingBy(ESEquipments::getEquipmentNumber));
			for (String s : collect.keySet()) {
				List<ESEquipments> indicatorsDtos = collect.get(s);
				HashMap<String, Object> resultMap = new HashMap<>();
				Double avageValue = 0.0;
				avageValue = indicatorsDtos.stream().filter(e -> !ObjectUtils.isEmpty(e.getValueF()))
						.mapToDouble(l -> Double.parseDouble(l.getValueF().toString())).average().getAsDouble();
				avageValue = Double.valueOf(String.format(CommonConstans.Twodecimalplaces, avageValue));
				resultMap.put("avg", avageValue);
				String[] name = s.split("-");
				resultMap.put("zz", "#" + name[0] + "子阵");
				resultMap.put("nbq", "逆变器" + name[1]);
				resultMap.put("hlx", "#" + name[2] + "汇流箱");
				double lsv = 0.00;
				if (!ValidationUtil.isEmpty(list1)) {
					List<ESEquipments> dtos = list1.stream().filter(e -> e.getEquipmentNumber().equals(s))
							.collect(Collectors.toList());
					if (!ValidationUtil.isEmpty(dtos)) {
						for (ESEquipments esEquipments : indicatorsDtos) {
							lsv = lsv + Math.pow(esEquipments.getValueF() - avageValue, 2);
						}
					}
					lsv = lsv / indicatorsDtos.size();
					lsv = Math.sqrt(lsv);
				}
				resultMap.put("lsv", String.format(CommonConstans.Twodecimalplaces, lsv));
				resultList.add(resultMap);
			}
		}

		return resultList;
	}

	public List<Map<String, Object>> solarPowerOperation(String gatewayId) {
		HashMap<String, String> pvNBQStatus = getPvNBQStationBy(gatewayId);
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName,
				Arrays.asList("有功功率", "逆变器效率", "总直流功率", "日发电量", "总发电量"));
		List<ESEquipments> list = commonServiceImpl.getListDataByCondtions(queryCondtion, null, ESEquipments.class);
		List<ESEquipments> collect = list.stream().filter(e -> StringUtils.isNotEmpty(e.getEquipmentNumber()))
				.collect(Collectors.toList());
		Map<String, List<ESEquipments>> collects = collect.stream()
				.collect(Collectors.groupingBy(ESEquipments::getEquipmentNumber));
		List<Map<String, Object>> result = new ArrayList();
		for (String s : collects.keySet()) {
			List<ESEquipments> indicatorsDtos = collects.get(s);
			Map<String, Object> map = new HashMap<>();
			map.put("name", s);
			if (s.split("-")[1].equals("A")) {
				map.put("sort", s.split("-")[0] + "1");
			} else {
				map.put("sort", s.split("-")[0] + "2");
			}
			map.put("type", "兆能");// 此处暂时未提供数据 待定 暂写死值
			map.put("status", pvNBQStatus.get(s));// 此处暂时未提供数据 待定 暂写死值
			indicatorsDtos.forEach(e -> {
				switch (e.getEquipmentIndexName()) {
				case "总直流功率":
					map.put("sr", keepTwoDecimalPlaces(e.getValueF().toString()));
					break;
				case "有功功率":
					map.put("sc", keepTwoDecimalPlaces(e.getValueF().toString()));
					break;
				case "逆变器效率":
					map.put("efficiency", keepTwoDecimalPlaces(e.getValueF().toString()));
					break;
				case "日发电量":
					double v = Double.parseDouble(e.getValueF().toString()) * CommonConstans.pvGenPoweActor;
					map.put("dayNum", keepFourDecimalPlaces(String.valueOf(v)));
					break;
				case "总发电量":
					double a = Double.parseDouble(e.getValueF().toString()) * CommonConstans.pvGenPoweActorCurrentData;
					map.put("yearNum", keepFourDecimalPlaces(String.valueOf(a)));
					break;
				}
			});
			result.add(map);
		}
		return result;
	}

	public Map<String, Object> hlWindSpeeds(String gatewayId, String equipNum) {
		List<IndicatorData> originarPVs = indicatorDataMapper
				.selectDataByequipmentIndexNameAndtimeAndEquipmentNumberPv(equipNum, gatewayId);
		originarPVs.size();
		Map<String, Object> resultMap = new HashMap<>();
		Map<String, List<IndicatorData>> data = originarPVs.stream().collect(
				Collectors.groupingBy(IndicatorData::getEquipmentIndexName, TreeMap::new, Collectors.toList()));
		List<String> axisData = new ArrayList<>();
		List<Map<String, Object>> seriesData = new ArrayList<>();
		for (String s : data.keySet()) {
			Map<String, Object> map = new HashMap<>();
			List<String> value = data.get(s).stream().map(indicatorData -> String
					.format(CommonConstans.Twodecimalplaces, Double.valueOf(indicatorData.getValue())))
					.collect(Collectors.toList());
			axisData = data.get(s).stream()
					.map(indicatorData -> DateUtil.format(indicatorData.getCreatedTime(), "HH:mm"))
					.collect(Collectors.toList());
			map.put("data", value);
			seriesData.add(map);
		}
		resultMap.put("axisData", axisData);
		resultMap.put("seriesData", seriesData);
		return resultMap;
	}

	public void getListByNbq(String gatewayId, String werks, String stationId) {
		HashMap<String, String> equipStatesMap = getPvNBQStationBy(gatewayId);
		ArrayList<Map<String, Object>> resultList = new ArrayList<>();
		Map<String, List<String>> queryConditon = new HashMap<>();
		queryConditon.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("总直流功率"));
		queryConditon.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, "逆变器");
		List<ESEquipments> listData = commonServiceImpl.getListDataByCondtionsAndLike(queryConditon, null,
				ESEquipments.class, likeMap);

		Map<String, List<String>> queryConditon1 = new HashMap<>();
		queryConditon1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("有功功率"));
		queryConditon1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap1 = new HashMap<>();
		likeMap1.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, "逆变器");
		List<ESEquipments> listData1 = commonServiceImpl.getListDataByCondtionsAndLike(queryConditon1, null,
				ESEquipments.class, likeMap1);

		// 将两组数据合并成一个集合中 将总直流功率数据 放入 另一个集合的valueLable中
		for (ESEquipments listDatum : listData) {
			for (ESEquipments esEquipments : listData1) {
				if (esEquipments.getEquipmentNumber().equals(listDatum.getEquipmentNumber())) {
					esEquipments.setValueLabel(listDatum.getValueF().toString());
				}
			}
		}
		List<Map<String, String>> maps = new ArrayList<>();
		Set<String> nums = new HashSet<>();
		// 此处组装数据 每一个Map代表一个逆变器
		for (ESEquipments esEquipments : listData1) {
			int num = Integer.parseInt(esEquipments.getEquipmentNumber().substring(0, 2));
			nums.add(String.valueOf(num));
			Map<String, String> map = new HashMap<>();
			String equipNum = esEquipments.getEquipmentNumber();
			String number = equipNum.substring(equipNum.length() - 1);
			map.put("titie", String.valueOf(num));
			map.put("titie" + number, equipNum);
			map.put("value" + number, String.format(CommonConstans.Twodecimalplaces, esEquipments.getValueF()));
			map.put("valueLabel" + number,
					String.format(CommonConstans.Twodecimalplaces, Double.parseDouble(esEquipments.getValueLabel())));
			map.put("state" + number, equipStatesMap.get(esEquipments.getEquipmentNumber()));
			maps.add(map);
		}
		List<Map<String, Object>> dataMaps = sjglZsjZsbtzServiceImpl.sjglZsjZsbtzMapper
				.getStationInfoMapByStationGFWerks(werks, "集电线");
		int i = 0;
		// 逆变器需要根据所属集电线分类组装 下面循环是将同一子阵下的不同逆变器组装为消息数据
		for (Map<String, Object> dataMap : dataMaps) {
			List<Map<String, String>> statusMaps = new ArrayList<>();
			String equipNum = dataMap.get("equipNum").toString();
			for (String num : nums) {
				int intNum = Integer.parseInt(num);
				Map<String, String> map = new HashMap<>();
				map.put("titie", "#" + num);
				for (Map<String, String> stringMap : maps) {
					if (stringMap.get("titie").equals(num)) {
						map.putAll(stringMap);
					}
				}
				List<String> list = Arrays.asList(equipNum.split(","));
				list.forEach(e -> {
					if (Integer.parseInt(e) == intNum) {
						statusMaps.add(map);
					}

				});
			}

			statusMaps.sort(Comparator.comparingInt(o -> Integer.parseInt(o.get("titie").toString())));
			IPage<Map<String, String>> result = new Page<>();
			result.setRecords(statusMaps);
			result.setCurrent(1);
			result.setTotal(statusMaps.size());
			i += 1;
			try {
				emqKeeper.getMqttClient().publish(stationId + "/gf/group/" + i, JSON.toJSONString(result).getBytes(), 0,
						false);
			} catch (MqttException e) {
				log.info("消息发送失败");
				e.printStackTrace();
			}
		}

	}

	@Override
	public Map<String, Object> partofWaring3D(String stationId, String equipNum) {
		Map<String, Object> resultMap = new HashMap<>();
		StationBasic stationBasic = stationBasicMapper.selectById(stationId);
		Map<String, List<String>> queryCondtion = new HashMap<>();
		queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
		queryCondtion.put(CommonConstans.QueryStringEquipmentNumber, Arrays.asList(equipNum));
		Map<String, String> shouldCondtion = new HashMap<>();
		shouldCondtion.put(CommonConstans.QueryStringEquipmentIndexName, "实时故障");
		List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
				ESEquipments.class, shouldCondtion);
		// 获取风机型号
		String type = indicatorsDtoList.get(0).getEquipmentSpecificName().substring(0, 5);
		List<String> sytemNames = Arrays.asList("发电机系统", "机舱与塔筒系统", "变流与主控系统", "偏航与液压系统", "叶轮系统");
		List<SystemEnum> systemEnumListAll = systemEnumMapper
				.selectList(new QueryWrapper<SystemEnum>().isNotNull("system_name"));
		sytemNames.forEach(name -> {
			resultMap.put(name, false);
			List<SystemEnum> systemEnumList = systemEnumListAll.stream()
					.filter(systemEnum -> systemEnum.getSyetemName().equals(name)).collect(Collectors.toList());
			outer: for (SystemEnum systemEnum : systemEnumList) {
				for (ESEquipments indicatorsDto : indicatorsDtoList) {
					if (indicatorsDto.getEquipmentSpecificName().contains(systemEnum.getCode())
							&& indicatorsDto.getValue().equals(systemEnum.getEunmValue())) {
						resultMap.put(name, true);
						break outer;
					}
				}
			}
		});
		return resultMap;
	}

	public Page<Map<String, Object>> nbqStatus(String gatewayId) {
//
//        Map<String, List<String>> queryCondtion = new HashMap<>();
//        queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("运行"));
//        queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
//        Map<String, String> likeMap = new HashMap<>();
//        likeMap.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, "逆变器");
//        List<ESEquipments> result = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion, null, ESEquipments.class, likeMap);
//        // 逆变器总数量
//        Integer totalNumber = result.size();
//        List<String> zcEquipmentNumberList = result.stream().filter(t -> "true".equals(t.getValue())).map(ESEquipments::getEquipmentNumber).collect(Collectors.toList());
//        Map<String, List<String>> queryCondtion1 = new HashMap<>();
//        queryCondtion1.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("待机", "故障停机", "告警运行", "限额运行", "停机", "通讯故障", "降额运行"));
//        queryCondtion1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
//        queryCondtion1.put(CommonConstans.QueryStringValueKeyword, Arrays.asList("true"));
//        Map<String, String> likeMap1 = new HashMap<>();
//        likeMap1.put(CommonConstans.QueryStringFrontMoudleNotKeyWord, "逆变器");
//        List<ESEquipments> result1 = commonServiceImpl.getListDataByCondtionsAndLike(queryCondtion1, null, ESEquipments.class, likeMap1);
//        List<String> equipmentNumberList = result1.stream().map(ESEquipments::getEquipmentNumber).distinct().collect(Collectors.toList());
//        int djNum = 0;
//        int gzNum = 0;
//        int gjNum = 0;
//        int xeNum = 0;
//        int xdNum = 0;
//        int txNum = 0;
//        int tjNum = 0;
//        int zcNum = 0;
//        Set<String> equipNum = new HashSet<>();
//        for (ESEquipments esEquipments : result1) {
//            if (equipmentNumberList.contains(esEquipments.getEquipmentNumber()) && !zcEquipmentNumberList.contains(esEquipments.getEquipmentNumber())) {
//                switch (esEquipments.getEquipmentIndexName()) {
//                    case "待机":
//                        djNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        break;
//                    case "故障停机":
//                        gzNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        break;
//                    case "告警运行":
//                        gjNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        break;
//                    case "限额运行":
//                        xeNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        equipNum.add(esEquipments.getEquipmentNumber());
//                        break;
//                    case "停机":
//                        tjNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        break;
//                    case "通讯故障":
//                        xdNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        break;
//                    case "降额运行":
//                        txNum += 1;
//                        equipmentNumberList.remove(esEquipments.getEquipmentNumber());
//                        break;
//                }
//            }
//        }
//        zcNum = totalNumber - djNum - gzNum - gjNum - xeNum - xdNum - txNum - tjNum;
		HashMap<String, String> nbpstatus = getPvNBQStationBy(gatewayId);
		List<Object> statusList = Arrays.asList(nbpstatus.values().toArray());
		Page<Map<String, Object>> mapPage = new Page<>();
		ArrayList<Map<String, Object>> resultList = new ArrayList<>();
		HashMap<String, Object> map = new HashMap<>();
		map.put("count", statusList.stream().filter(s -> s.toString().contains("正常运行")).count());
		map.put("equipmentIndexName", "正常运行");
		map.put("color", "#00AA00");
		resultList.add(map);
		HashMap<String, Object> map2 = new HashMap<>();
		map2.put("count", statusList.stream().filter(s -> s.toString().contains("正常停机")).count());
		map2.put("equipmentIndexName", "正常停机");
		map2.put("color", "#0055FF");
		resultList.add(map2);
		HashMap<String, Object> map3 = new HashMap<>();
		map3.put("count", statusList.stream().filter(s -> s.toString().contains("限功率")).count());
		map3.put("equipmentIndexName", "限功率");
		map3.put("color", "#A3F5AA");
		resultList.add(map3);
		HashMap<String, Object> map4 = new HashMap<>();
		map4.put("count", statusList.stream().filter(s -> s.toString().contains("限电停机")).count());
		map4.put("equipmentIndexName", "限电停机");
		map4.put("color", "#FF00FF");
		resultList.add(map4);
		HashMap<String, Object> map5 = new HashMap<>();
		map5.put("count", statusList.stream().filter(s -> s.toString().contains("告警运行")).count());
		map5.put("equipmentIndexName", "告警运行");
		map5.put("color", "#F9AD14");
		resultList.add(map5);
		HashMap<String, Object> map6 = new HashMap<>();
		map6.put("count", statusList.stream().filter(s -> s.toString().contains("故障停机")).count());
		map6.put("equipmentIndexName", "故障停机");
		map6.put("color", "#F91414");
		resultList.add(map6);
		HashMap<String, Object> map7 = new HashMap<>();
		map7.put("count", statusList.stream().filter(s -> s.toString().contains("待机状态")).count());
		map7.put("equipmentIndexName", "待机");
		map7.put("color", "#00AAFF");
		resultList.add(map7);
		HashMap<String, Object> map8 = new HashMap<>();
		map8.put("count", statusList.stream().filter(s -> s.toString().contains("通讯中断")).count());
		map8.put("equipmentIndexName", "通讯中断");
		map8.put("color", "#7D8E95");
		resultList.add(map8);
		mapPage.setTotal(8);
		mapPage.setSize(8);
		mapPage.setCurrent(1);
		mapPage.setRecords(resultList);
		return mapPage;
	}

	public void sendMqttByRanking(List<Map<String, Object>> list, String code, String topic) {
		list.stream().sorted((o1, o2) -> {
			double o1Num = Double.parseDouble(o1.get("value").toString());
			double o2Num = Double.parseDouble(o2.get("value").toString());
			if ((o1Num - o2Num) < 0) {
				return -1;
			} else if ((o1Num - o2Num) > 0) {
				return 1;
			} else {
				return 0;
			}
		});

		IPage<Map<String, Object>> result = new Page<>();
		result.setRecords(list);
		result.setCurrent(1);
		result.setTotal(list.size());
		try {
			emqKeeper.getMqttClient().publish(topic + "/" + code, JSON.toJSONString(result).getBytes(), 0, false);
		} catch (MqttException e) {
			e.printStackTrace();
		}

	}

	public Page<Map<String, Object>> getxbdata(String frontModule, String fanGatewayId, String equipmentNumber,
			long current, long size) {
		Map<String, List<String>> queryCodntion = new HashMap<>();
		queryCodntion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(fanGatewayId));
		queryCodntion.put(CommonConstans.QueryStringEquipmentIndexName,
				Arrays.asList("高压开关合闸", "QF1低压断路器合闸", "QF2低压断路器合闸"));
		queryCodntion.put(CommonConstans.QueryStringEquipmentNumber, Arrays.asList(equipmentNumber));
		List<ESEquipments> alldata = commonServiceImpl.getListDataByCondtionsAndLike(queryCodntion, null,
				ESEquipments.class, null);
		Map<String, Object> map = new HashMap<>();
		for (ESEquipments alldatum : alldata) {
			if ("高压开关合闸".equals(alldatum.getEquipmentIndexName())) {
				map.put("gy", "true".equals(alldatum.getValue()) ? true : false);
			} else if ("QF1低压断路器合闸".equals(alldatum.getEquipmentIndexName())) {
				map.put("1_dy", "true".equals(alldatum.getValue()) ? true : false);
			} else if ("QF2低压断路器合闸".equals(alldatum.getEquipmentIndexName())) {
				map.put("2_dy", "true".equals(alldatum.getValue()) ? true : false);
			}
		}
		Page<Map<String, Object>> page = new Page<>(current, size);
		List<Map<String, Object>> collect = new ArrayList();
		collect.add(map);
		page.setTotal(1);
		page.setRecords(collect);
		return page;
	}

	public ResultsData getDeaviAtionRate(String gatewayId, String zz, String nbq, String hlx) {
		ArrayList<Map<String, Object>> resultList = new ArrayList<>();
		Map<String, List<String>> queryConditon = new HashMap<>();
		queryConditon.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> likeMap = new HashMap<>();
		likeMap.put(CommonConstans.QueryStringEquipmentIndexNameNotKeyword, "路电流");
		// hlx=hlx.replace("#0", "#");
		// likeMap.put(CommonConstans.QueryStringEquipmentSpecificNameNotKeyword, hlx);
		String nhlx = zz + "/" + nbq + "/" + hlx.replace("#0", "#");
		List<ESEquipments> list = commonServiceImpl.getListDataByCondtionsAndLike(queryConditon, null,
				ESEquipments.class, likeMap);

//		Map<String, List<String>> queryConditon1 = new HashMap<>();
//		queryConditon1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
//		Map<String, String> likeMap1 = new HashMap<>();
//		likeMap1.put(CommonConstans.QueryStringEquipmentIndexNameNotKeyword, "平均电流");
//		List<ESEquipments> list1 = commonServiceImpl.getListDataByCondtionsAndLike(queryConditon, null,
//				ESEquipments.class, likeMap1);

		if (!ValidationUtil.isEmpty(list)) {
			list = list.stream().filter(i -> i.getEquipmentSpecificName().contains(nhlx)).collect(Collectors.toList());

			Double avageValue = 0.0;
			avageValue = list.stream().filter(e -> !ObjectUtils.isEmpty(e.getValueF()))
					.mapToDouble(l -> Double.parseDouble(l.getValueF().toString())).average().getAsDouble();
			avageValue = Double.valueOf(String.format(CommonConstans.Twodecimalplaces, avageValue));
			for (ESEquipments s : list) {
				HashMap<String, Object> resultMap = new HashMap<>();
				resultMap.put("hlx", s.getEquipmentIndexName());
				double now = Double.valueOf(String.format(CommonConstans.Twodecimalplaces, s.getValueF()));
				resultMap.put("now", now);
				resultMap.put("avg", avageValue);
				double c = now - avageValue;
				if (c < 0) {
					c = -c;
				}
				double pcv = c / avageValue;
				pcv = pcv * 100;
				pcv = Math.round(pcv);
				// pcv = Double.valueOf(String.format(CommonConstans.Twodecimalplaces, pcv));
				resultMap.put("pcv", (int) pcv + "%");
				resultList.add(resultMap);
			}
		}

		Collections.sort(resultList, new Comparator<Map<String, Object>>() {
			public int compare(Map<String, Object> o1, Map<String, Object> o2) {
				String str1 = o1.get("hlx").toString();
				String str2 = o2.get("hlx").toString();
				// str1在前，str2在后，默认升序，这里Integer类型的也可以
				return str1.compareTo(str2);
			}
		});

		// 构建平台数据
		DataGridMock DataGridMock = new DataGridMock(0, resultList.size(), false, 0, resultList);
		ColModel colModelEventMovement = new ColModel("hlx", "hlx", "汇流箱", "汇流箱", "dataGrid", "hlx");
		ColModel colModelStationName = new ColModel("now", "now", "当前值", "当前值", "dataGrid", "now");
		ColModel colModelEventDesc = new ColModel("avg", "avg", "平均值", "平均值", "dataGrid", "avg");
		ColModel colModelAlarmGroupName = new ColModel("pcv", "pcv", "偏差率", "偏差率", "dataGrid", "pcv");
		List<ColModel> listColModel = Arrays.asList(colModelEventMovement, colModelStationName, colModelEventDesc,
				colModelAlarmGroupName);
		ResultsData resultsData = new ResultsData(DataGridMock, listColModel);
		return resultsData;
	}

//    @Scheduled(cron = "0 */10 * * * ?")
//	//@Scheduled(cron = "0/1 * * * * ?") 
//	public void addNbqAlarmEvent() {
//
//		LambdaQueryWrapper<StationBasic> wrapper = new LambdaQueryWrapper<>();
//		wrapper.eq(BaseEntity::getIsDelete, false);
//		wrapper.like(StationBasic::getStationType, "GFDZ");
//		List<StationBasic> stationBasics = stationBasicMapper.selectList(wrapper);
//		for (StationBasic stationBasic : stationBasics) {
//			Map<String, List<String>> queryCondtion = new HashMap<>();
//			Map<String, String> shouldCondtion = new HashMap<>();
//			queryCondtion.put(CommonConstans.QueryStringGateWayId, Arrays.asList(stationBasic.getFanGatewayId()));
//			queryCondtion.put(CommonConstans.QueryStringEquipmentIndexName,
//					Arrays.asList("待机", "停机", "告警运行", "限额运行", "降额运行", "故障停机", "通讯故障", "运行"));
//			queryCondtion.put(CommonConstans.QueryStringValueKeyword, Arrays.asList("true"));
//
//			/**
//			 * 逆变器
//			 */
//			List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondtion, null,
//					ESEquipments.class);
//			Collections.sort(indicatorsDtoList, (a, b) -> (b.getCreatedTime())
//                    .compareTo(a.getCreatedTime()));
//
//			//过滤重复状态
//			List<ESEquipments> nindicatorsDtoList=indicatorsDtoList.stream().collect(Collectors.collectingAndThen(
//	                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(ESEquipments::getDisplayName))), ArrayList::new));
//
//			
//			/**
//			 * 汇流箱
//			 */
//			queryCondtion.remove(CommonConstans.QueryStringEquipmentIndexName);
//			queryCondtion.remove(CommonConstans.QueryStringValueKeyword);
//			queryCondtion.put(CommonConstans.QueryStringDataType, Arrays.asList("state"));
//			shouldCondtion.put(CommonConstans.QueryStringFrontMoudle, "汇流箱");
//			List<ESEquipments> indicatorsDtoListHLX = commonServiceImpl.getListDataByCondtions(queryCondtion,
//					shouldCondtion, ESEquipments.class);
//			/**
//			 * 箱变
//			 */
//			shouldCondtion.put(CommonConstans.QueryStringFrontMoudle, "箱变");
//			List<ESEquipments> indicatorsDtoListXB = commonServiceImpl.getListDataByCondtions(queryCondtion,
//					shouldCondtion, ESEquipments.class);
//			nindicatorsDtoList.addAll(indicatorsDtoListHLX);
//			nindicatorsDtoList.addAll(indicatorsDtoListXB);
//
//			List<EquipAlarmEvent> newEquipAlarmEvents = new ArrayList<>();
//			List<EquipAlarmEvent> newEquipAlarmEvent = new ArrayList<>();
//			long time = new Date().getTime();
//			if (CollectionUtils.isNotEmpty(nindicatorsDtoList)) {
//				for (ESEquipments esEquipments : nindicatorsDtoList) {
//					EquipAlarmEvent equipAlarmEvent = new EquipAlarmEvent();
//					equipAlarmEvent.setEquipIndex(esEquipments.getEquipmentNumber());
//					equipAlarmEvent.setEquipName(esEquipments.getEquipmentSpecificName());
//					equipAlarmEvent.setAlarmDesc(AlarmDesc.getCode(esEquipments.getEquipmentIndexName()));
//					equipAlarmEvent.setAlarmDesc(
//							StringUtils.isEmpty(equipAlarmEvent.getAlarmDesc()) ? esEquipments.getEquipmentIndexName()
//									: equipAlarmEvent.getAlarmDesc());
//					equipAlarmEvent.setCreatedTime(esEquipments.getCreatedTime());
//					equipAlarmEvent.setGatewayId(stationBasic.getFanGatewayId());
//					equipAlarmEvent.setSort(time);
//					equipAlarmEvent.setFrontModule(esEquipments.getFrontModule());
//					equipAlarmEvent.setValue(esEquipments.getValue());
//					newEquipAlarmEvents.add(equipAlarmEvent);
//					newEquipAlarmEvent.add(equipAlarmEvent);
//				}
//			}
//
//			String lastSort = equipAlarmEventMapper.getLastDataBySort(stationBasic.getFanGatewayId());
//			if (null != lastSort) {
//				List<EquipAlarmEvent> oldEquipAlarmEvents = equipAlarmEventMapper.getOldDataBySort(lastSort,
//						stationBasic.getFanGatewayId());
//				for (EquipAlarmEvent oldEquipAlarmEvent : oldEquipAlarmEvents) {
//					for (EquipAlarmEvent equipAlarmEvent : newEquipAlarmEvents) {
//						if (oldEquipAlarmEvent.getEquipIndex().equals(equipAlarmEvent.getEquipIndex())
//								&& oldEquipAlarmEvent.getAlarmDesc().equals(equipAlarmEvent.getAlarmDesc())
//								&& oldEquipAlarmEvent.getValue().equals(equipAlarmEvent.getValue())) {
//							newEquipAlarmEvent.remove(equipAlarmEvent);
//						}
//					}
//				}
//			}
//			equipAlarmEventService.saveBatch(newEquipAlarmEvent);
//
//		}
//	}

	public HashMap<String, String> getPvNBQStationBy(String gatewayId) {
		HashMap<String, String> result = new HashMap<>();
		Map<String, List<String>> queryCondition = new HashMap<>();
		queryCondition.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("运行"));
		queryCondition.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		Map<String, String> shouldCondition = new HashMap<>();
		shouldCondition.put(CommonConstans.QueryStringFrontMoudle, "逆变器");
		List<ESEquipments> totalEquipmentList = commonServiceImpl.getListDataByCondtions(queryCondition, null,
				ESEquipments.class, shouldCondition);
		totalEquipmentList.forEach(indicatorsDto -> result.put(indicatorsDto.getEquipmentNumber(), "正常运行"));
		Map<String, List<String>> queryCondition1 = new HashMap<>();
		queryCondition1.put(CommonConstans.QueryStringEquipmentIndexName,
				Arrays.asList("运行", "待机", "故障停机", "告警运行", "限额运行", "停机", "通讯故障", "'降额运行'"));
		queryCondition1.put(CommonConstans.QueryStringValueKeyword, Arrays.asList("true"));
		queryCondition1.put(CommonConstans.QueryStringGateWayId, Arrays.asList(gatewayId));
		List<ESEquipments> indicatorsDtoList = commonServiceImpl.getListDataByCondtions(queryCondition1, null,
				ESEquipments.class, shouldCondition);
		queryCondition.put(CommonConstans.QueryStringEquipmentIndexName, Arrays.asList("总直流功率"));
		List<ESEquipments> inputPowerData = commonServiceImpl.getListDataByCondtions(queryCondition, null,
				ESEquipments.class, shouldCondition);
		List<String> inputPowerDataResult = inputPowerData.stream()
				.filter(esEquipments -> !(esEquipments.getValueF() > 0)).collect(Collectors.toList()).stream()
				.map(esEquipments -> esEquipments.getEquipmentNumber()).collect(Collectors.toList());
		indicatorsDtoList.forEach(esEquipments -> {
			if (!"运行".equals(esEquipments.getEquipmentIndexName())) {
				result.put(esEquipments.getEquipmentNumber(),
						CommonConstans.pvStatus.get(esEquipments.getEquipmentIndexName()));
			}
		});
		inputPowerDataResult.forEach(s -> result.put(s, "待机状态"));
		return result;
	}

	public String getDisplayNameNotContainUnit(String DisplayName) {
		return DisplayName.split("\\(")[0];
	}
}
